package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Options for binding an S3 Location.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * S3LocationBindOptions s3LocationBindOptions = S3LocationBindOptions.builder()
 *         .forReading(false)
 *         .forWriting(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:26.760Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.S3LocationBindOptions")
@software.amazon.jsii.Jsii.Proxy(S3LocationBindOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3LocationBindOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Allow reading from the S3 Location.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForReading() {
        return null;
    }

    /**
     * Allow writing to the S3 Location.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForWriting() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3LocationBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3LocationBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3LocationBindOptions> {
        java.lang.Boolean forReading;
        java.lang.Boolean forWriting;

        /**
         * Sets the value of {@link S3LocationBindOptions#getForReading}
         * @param forReading Allow reading from the S3 Location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forReading(java.lang.Boolean forReading) {
            this.forReading = forReading;
            return this;
        }

        /**
         * Sets the value of {@link S3LocationBindOptions#getForWriting}
         * @param forWriting Allow writing to the S3 Location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forWriting(java.lang.Boolean forWriting) {
            this.forWriting = forWriting;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3LocationBindOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3LocationBindOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3LocationBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationBindOptions {
        private final java.lang.Boolean forReading;
        private final java.lang.Boolean forWriting;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.forReading = software.amazon.jsii.Kernel.get(this, "forReading", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.forWriting = software.amazon.jsii.Kernel.get(this, "forWriting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.forReading = builder.forReading;
            this.forWriting = builder.forWriting;
        }

        @Override
        public final java.lang.Boolean getForReading() {
            return this.forReading;
        }

        @Override
        public final java.lang.Boolean getForWriting() {
            return this.forWriting;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getForReading() != null) {
                data.set("forReading", om.valueToTree(this.getForReading()));
            }
            if (this.getForWriting() != null) {
                data.set("forWriting", om.valueToTree(this.getForWriting()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.S3LocationBindOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3LocationBindOptions.Jsii$Proxy that = (S3LocationBindOptions.Jsii$Proxy) o;

            if (this.forReading != null ? !this.forReading.equals(that.forReading) : that.forReading != null) return false;
            return this.forWriting != null ? this.forWriting.equals(that.forWriting) : that.forWriting == null;
        }

        @Override
        public final int hashCode() {
            int result = this.forReading != null ? this.forReading.hashCode() : 0;
            result = 31 * result + (this.forWriting != null ? this.forWriting.hashCode() : 0);
            return result;
        }
    }
}
