package software.amazon.awscdk;

/**
 * Use the CDK classic way of referencing assets.
 * <p>
 * This synthesizer will generate CloudFormation parameters for every referenced
 * asset, and use the CLI's current credentials to deploy the stack.
 * <p>
 * <ul>
 * <li>It does not support cross-account deployment (the CLI must have credentials
 * to the account you are trying to deploy to).</li>
 * <li>It cannot be used with <strong>CDK Pipelines</strong>. To deploy using CDK Pipelines,
 * you must use the <code>DefaultStackSynthesizer</code>.</li>
 * <li>Each asset will take up a CloudFormation Parameter in your template. Keep in
 * mind that there is a maximum of 200 parameters in a CloudFormation template.
 * To use deterministic asset locations instead, use <code>CliCredentialsStackSynthesizer</code>.</li>
 * </ul>
 * <p>
 * Be aware that your CLI credentials must be valid for the duration of the
 * entire deployment. If you are using session credentials, make sure the
 * session lifetime is long enough.
 * <p>
 * This is the only StackSynthesizer that supports customizing asset behavior
 * by overriding <code>Stack.addFileAsset()</code> and <code>Stack.addDockerImageAsset()</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * LegacyStackSynthesizer legacyStackSynthesizer = new LegacyStackSynthesizer();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:00.797Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.LegacyStackSynthesizer")
public class LegacyStackSynthesizer extends software.amazon.awscdk.StackSynthesizer implements software.amazon.awscdk.IReusableStackSynthesizer, software.amazon.awscdk.IBoundStackSynthesizer {

    protected LegacyStackSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LegacyStackSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LegacyStackSynthesizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Produce a bound Stack Synthesizer for the given stack.
     * <p>
     * This method may be called more than once on the same object.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IBoundStackSynthesizer reusableBind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        return software.amazon.jsii.Kernel.call(this, "reusableBind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IBoundStackSynthesizer.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }
}
