package software.amazon.awscdk.pipelines;

/**
 * The result of adding actions to the pipeline.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.pipelines.*;
 * Project project;
 * CodePipelineActionFactoryResult codePipelineActionFactoryResult = CodePipelineActionFactoryResult.builder()
 *         .runOrdersConsumed(123)
 *         // the properties below are optional
 *         .project(project)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:17.608Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CodePipelineActionFactoryResult")
@software.amazon.jsii.Jsii.Proxy(CodePipelineActionFactoryResult.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodePipelineActionFactoryResult extends software.amazon.jsii.JsiiSerializable {

    /**
     * How many RunOrders were consumed.
     * <p>
     * If you add 1 action, return the value 1 here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getRunOrdersConsumed();

    /**
     * If a CodeBuild project got created, the project.
     * <p>
     * Default: - This factory did not create a CodeBuild project
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.IProject getProject() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodePipelineActionFactoryResult}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodePipelineActionFactoryResult}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodePipelineActionFactoryResult> {
        java.lang.Number runOrdersConsumed;
        software.amazon.awscdk.services.codebuild.IProject project;

        /**
         * Sets the value of {@link CodePipelineActionFactoryResult#getRunOrdersConsumed}
         * @param runOrdersConsumed How many RunOrders were consumed. This parameter is required.
         *                          If you add 1 action, return the value 1 here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrdersConsumed(java.lang.Number runOrdersConsumed) {
            this.runOrdersConsumed = runOrdersConsumed;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineActionFactoryResult#getProject}
         * @param project If a CodeBuild project got created, the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(software.amazon.awscdk.services.codebuild.IProject project) {
            this.project = project;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodePipelineActionFactoryResult}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodePipelineActionFactoryResult build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodePipelineActionFactoryResult}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodePipelineActionFactoryResult {
        private final java.lang.Number runOrdersConsumed;
        private final software.amazon.awscdk.services.codebuild.IProject project;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.runOrdersConsumed = software.amazon.jsii.Kernel.get(this, "runOrdersConsumed", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IProject.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.runOrdersConsumed = java.util.Objects.requireNonNull(builder.runOrdersConsumed, "runOrdersConsumed is required");
            this.project = builder.project;
        }

        @Override
        public final java.lang.Number getRunOrdersConsumed() {
            return this.runOrdersConsumed;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.IProject getProject() {
            return this.project;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("runOrdersConsumed", om.valueToTree(this.getRunOrdersConsumed()));
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.CodePipelineActionFactoryResult"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodePipelineActionFactoryResult.Jsii$Proxy that = (CodePipelineActionFactoryResult.Jsii$Proxy) o;

            if (!runOrdersConsumed.equals(that.runOrdersConsumed)) return false;
            return this.project != null ? this.project.equals(that.project) : that.project == null;
        }

        @Override
        public final int hashCode() {
            int result = this.runOrdersConsumed.hashCode();
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            return result;
        }
    }
}
