package software.amazon.awscdk.pipelines;

/**
 * A FileSet created from a CodePipeline artifact.
 * <p>
 * You only need to use this if you want to add CDK Pipeline stages
 * add the end of an existing CodePipeline, which should be very rare.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline codePipeline;
 * Artifact sourceArtifact = new Artifact("MySourceArtifact");
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .codePipeline(codePipeline)
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineFileSet.fromArtifact(sourceArtifact))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:17.609Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CodePipelineFileSet")
public class CodePipelineFileSet extends software.amazon.awscdk.pipelines.FileSet {

    protected CodePipelineFileSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodePipelineFileSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Turn a CodePipeline Artifact into a FileSet.
     * <p>
     * @param artifact This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineFileSet fromArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact artifact) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineFileSet.class, "fromArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineFileSet.class), new Object[] { java.util.Objects.requireNonNull(artifact, "artifact is required") });
    }
}
