package software.amazon.awscdk.services.aiops;

/**
 * Properties for defining a <code>CfnInvestigationGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.aiops.*;
 * CfnInvestigationGroupProps cfnInvestigationGroupProps = CfnInvestigationGroupProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .chatbotNotificationChannels(List.of(ChatbotNotificationChannelProperty.builder()
 *                 .chatConfigurationArns(List.of("chatConfigurationArns"))
 *                 .snsTopicArn("snsTopicArn")
 *                 .build()))
 *         .crossAccountConfigurations(List.of(CrossAccountConfigurationProperty.builder()
 *                 .sourceRoleArn("sourceRoleArn")
 *                 .build()))
 *         .encryptionConfig(EncryptionConfigMapProperty.builder()
 *                 .encryptionConfigurationType("encryptionConfigurationType")
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .investigationGroupPolicy("investigationGroupPolicy")
 *         .isCloudTrailEventHistoryEnabled(false)
 *         .retentionInDays(123)
 *         .roleArn("roleArn")
 *         .tagKeyBoundaries(List.of("tagKeyBoundaries"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:00.939Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aiops.CfnInvestigationGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnInvestigationGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInvestigationGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * User friendly name for resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An array of key-value pairs of notification channels to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-chatbotnotificationchannels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-chatbotnotificationchannels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getChatbotNotificationChannels() {
        return null;
    }

    /**
     * An array of cross account configurations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-crossaccountconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-crossaccountconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCrossAccountConfigurations() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-encryptionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-encryptionconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfig() {
        return null;
    }

    /**
     * Investigation Group policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-investigationgrouppolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-investigationgrouppolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInvestigationGroupPolicy() {
        return null;
    }

    /**
     * Flag to enable cloud trail history.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-iscloudtraileventhistoryenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-iscloudtraileventhistoryenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsCloudTrailEventHistoryEnabled() {
        return null;
    }

    /**
     * The number of days to retain the investigation group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-retentionindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-retentionindays</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionInDays() {
        return null;
    }

    /**
     * The Investigation Role's ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-tagkeyboundaries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-tagkeyboundaries</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTagKeyBoundaries() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aiops-investigationgroup.html#cfn-aiops-investigationgroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInvestigationGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInvestigationGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInvestigationGroupProps> {
        java.lang.String name;
        java.lang.Object chatbotNotificationChannels;
        java.lang.Object crossAccountConfigurations;
        java.lang.Object encryptionConfig;
        java.lang.String investigationGroupPolicy;
        java.lang.Object isCloudTrailEventHistoryEnabled;
        java.lang.Number retentionInDays;
        java.lang.String roleArn;
        java.util.List<java.lang.String> tagKeyBoundaries;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getName}
         * @param name User friendly name for resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getChatbotNotificationChannels}
         * @param chatbotNotificationChannels An array of key-value pairs of notification channels to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chatbotNotificationChannels(software.amazon.awscdk.IResolvable chatbotNotificationChannels) {
            this.chatbotNotificationChannels = chatbotNotificationChannels;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getChatbotNotificationChannels}
         * @param chatbotNotificationChannels An array of key-value pairs of notification channels to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chatbotNotificationChannels(java.util.List<? extends java.lang.Object> chatbotNotificationChannels) {
            this.chatbotNotificationChannels = chatbotNotificationChannels;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getCrossAccountConfigurations}
         * @param crossAccountConfigurations An array of cross account configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountConfigurations(software.amazon.awscdk.IResolvable crossAccountConfigurations) {
            this.crossAccountConfigurations = crossAccountConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getCrossAccountConfigurations}
         * @param crossAccountConfigurations An array of cross account configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountConfigurations(java.util.List<? extends java.lang.Object> crossAccountConfigurations) {
            this.crossAccountConfigurations = crossAccountConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getEncryptionConfig}
         * @param encryptionConfig the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfig(software.amazon.awscdk.IResolvable encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getEncryptionConfig}
         * @param encryptionConfig the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfig(software.amazon.awscdk.services.aiops.CfnInvestigationGroup.EncryptionConfigMapProperty encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getInvestigationGroupPolicy}
         * @param investigationGroupPolicy Investigation Group policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder investigationGroupPolicy(java.lang.String investigationGroupPolicy) {
            this.investigationGroupPolicy = investigationGroupPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getIsCloudTrailEventHistoryEnabled}
         * @param isCloudTrailEventHistoryEnabled Flag to enable cloud trail history.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isCloudTrailEventHistoryEnabled(java.lang.Boolean isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getIsCloudTrailEventHistoryEnabled}
         * @param isCloudTrailEventHistoryEnabled Flag to enable cloud trail history.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isCloudTrailEventHistoryEnabled(software.amazon.awscdk.IResolvable isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getRetentionInDays}
         * @param retentionInDays The number of days to retain the investigation group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionInDays(java.lang.Number retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getRoleArn}
         * @param roleArn The Investigation Role's ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getTagKeyBoundaries}
         * @param tagKeyBoundaries the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagKeyBoundaries(java.util.List<java.lang.String> tagKeyBoundaries) {
            this.tagKeyBoundaries = tagKeyBoundaries;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvestigationGroupProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInvestigationGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInvestigationGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInvestigationGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInvestigationGroupProps {
        private final java.lang.String name;
        private final java.lang.Object chatbotNotificationChannels;
        private final java.lang.Object crossAccountConfigurations;
        private final java.lang.Object encryptionConfig;
        private final java.lang.String investigationGroupPolicy;
        private final java.lang.Object isCloudTrailEventHistoryEnabled;
        private final java.lang.Number retentionInDays;
        private final java.lang.String roleArn;
        private final java.util.List<java.lang.String> tagKeyBoundaries;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.chatbotNotificationChannels = software.amazon.jsii.Kernel.get(this, "chatbotNotificationChannels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.crossAccountConfigurations = software.amazon.jsii.Kernel.get(this, "crossAccountConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encryptionConfig = software.amazon.jsii.Kernel.get(this, "encryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.investigationGroupPolicy = software.amazon.jsii.Kernel.get(this, "investigationGroupPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.isCloudTrailEventHistoryEnabled = software.amazon.jsii.Kernel.get(this, "isCloudTrailEventHistoryEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retentionInDays = software.amazon.jsii.Kernel.get(this, "retentionInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagKeyBoundaries = software.amazon.jsii.Kernel.get(this, "tagKeyBoundaries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.chatbotNotificationChannels = builder.chatbotNotificationChannels;
            this.crossAccountConfigurations = builder.crossAccountConfigurations;
            this.encryptionConfig = builder.encryptionConfig;
            this.investigationGroupPolicy = builder.investigationGroupPolicy;
            this.isCloudTrailEventHistoryEnabled = builder.isCloudTrailEventHistoryEnabled;
            this.retentionInDays = builder.retentionInDays;
            this.roleArn = builder.roleArn;
            this.tagKeyBoundaries = builder.tagKeyBoundaries;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getChatbotNotificationChannels() {
            return this.chatbotNotificationChannels;
        }

        @Override
        public final java.lang.Object getCrossAccountConfigurations() {
            return this.crossAccountConfigurations;
        }

        @Override
        public final java.lang.Object getEncryptionConfig() {
            return this.encryptionConfig;
        }

        @Override
        public final java.lang.String getInvestigationGroupPolicy() {
            return this.investigationGroupPolicy;
        }

        @Override
        public final java.lang.Object getIsCloudTrailEventHistoryEnabled() {
            return this.isCloudTrailEventHistoryEnabled;
        }

        @Override
        public final java.lang.Number getRetentionInDays() {
            return this.retentionInDays;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.util.List<java.lang.String> getTagKeyBoundaries() {
            return this.tagKeyBoundaries;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getChatbotNotificationChannels() != null) {
                data.set("chatbotNotificationChannels", om.valueToTree(this.getChatbotNotificationChannels()));
            }
            if (this.getCrossAccountConfigurations() != null) {
                data.set("crossAccountConfigurations", om.valueToTree(this.getCrossAccountConfigurations()));
            }
            if (this.getEncryptionConfig() != null) {
                data.set("encryptionConfig", om.valueToTree(this.getEncryptionConfig()));
            }
            if (this.getInvestigationGroupPolicy() != null) {
                data.set("investigationGroupPolicy", om.valueToTree(this.getInvestigationGroupPolicy()));
            }
            if (this.getIsCloudTrailEventHistoryEnabled() != null) {
                data.set("isCloudTrailEventHistoryEnabled", om.valueToTree(this.getIsCloudTrailEventHistoryEnabled()));
            }
            if (this.getRetentionInDays() != null) {
                data.set("retentionInDays", om.valueToTree(this.getRetentionInDays()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getTagKeyBoundaries() != null) {
                data.set("tagKeyBoundaries", om.valueToTree(this.getTagKeyBoundaries()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aiops.CfnInvestigationGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInvestigationGroupProps.Jsii$Proxy that = (CfnInvestigationGroupProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.chatbotNotificationChannels != null ? !this.chatbotNotificationChannels.equals(that.chatbotNotificationChannels) : that.chatbotNotificationChannels != null) return false;
            if (this.crossAccountConfigurations != null ? !this.crossAccountConfigurations.equals(that.crossAccountConfigurations) : that.crossAccountConfigurations != null) return false;
            if (this.encryptionConfig != null ? !this.encryptionConfig.equals(that.encryptionConfig) : that.encryptionConfig != null) return false;
            if (this.investigationGroupPolicy != null ? !this.investigationGroupPolicy.equals(that.investigationGroupPolicy) : that.investigationGroupPolicy != null) return false;
            if (this.isCloudTrailEventHistoryEnabled != null ? !this.isCloudTrailEventHistoryEnabled.equals(that.isCloudTrailEventHistoryEnabled) : that.isCloudTrailEventHistoryEnabled != null) return false;
            if (this.retentionInDays != null ? !this.retentionInDays.equals(that.retentionInDays) : that.retentionInDays != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.tagKeyBoundaries != null ? !this.tagKeyBoundaries.equals(that.tagKeyBoundaries) : that.tagKeyBoundaries != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.chatbotNotificationChannels != null ? this.chatbotNotificationChannels.hashCode() : 0);
            result = 31 * result + (this.crossAccountConfigurations != null ? this.crossAccountConfigurations.hashCode() : 0);
            result = 31 * result + (this.encryptionConfig != null ? this.encryptionConfig.hashCode() : 0);
            result = 31 * result + (this.investigationGroupPolicy != null ? this.investigationGroupPolicy.hashCode() : 0);
            result = 31 * result + (this.isCloudTrailEventHistoryEnabled != null ? this.isCloudTrailEventHistoryEnabled.hashCode() : 0);
            result = 31 * result + (this.retentionInDays != null ? this.retentionInDays.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.tagKeyBoundaries != null ? this.tagKeyBoundaries.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
