package software.amazon.awscdk.services.apigateway;

/**
 * Options for SageMakerIntegration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigateway.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * VpcLink vpcLink;
 * SagemakerIntegrationOptions sagemakerIntegrationOptions = SagemakerIntegrationOptions.builder()
 *         .cacheKeyParameters(List.of("cacheKeyParameters"))
 *         .cacheNamespace("cacheNamespace")
 *         .connectionType(ConnectionType.INTERNET)
 *         .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *         .credentialsPassthrough(false)
 *         .credentialsRole(role)
 *         .integrationResponses(List.of(IntegrationResponse.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *                 .responseParameters(Map.of(
 *                         "responseParametersKey", "responseParameters"))
 *                 .responseTemplates(Map.of(
 *                         "responseTemplatesKey", "responseTemplates"))
 *                 .selectionPattern("selectionPattern")
 *                 .build()))
 *         .passthroughBehavior(PassthroughBehavior.WHEN_NO_MATCH)
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", "requestParameters"))
 *         .requestTemplates(Map.of(
 *                 "requestTemplatesKey", "requestTemplates"))
 *         .timeout(Duration.minutes(30))
 *         .vpcLink(vpcLink)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:01.264Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.SagemakerIntegrationOptions")
@software.amazon.jsii.Jsii.Proxy(SagemakerIntegrationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SagemakerIntegrationOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.IntegrationOptions {

    /**
     * @return a {@link Builder} of {@link SagemakerIntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SagemakerIntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SagemakerIntegrationOptions> {
        java.util.List<java.lang.String> cacheKeyParameters;
        java.lang.String cacheNamespace;
        software.amazon.awscdk.services.apigateway.ConnectionType connectionType;
        software.amazon.awscdk.services.apigateway.ContentHandling contentHandling;
        java.lang.Boolean credentialsPassthrough;
        software.amazon.awscdk.services.iam.IRole credentialsRole;
        java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses;
        software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior;
        java.util.Map<java.lang.String, java.lang.String> requestParameters;
        java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        software.amazon.awscdk.Duration timeout;
        software.amazon.awscdk.services.apigateway.IVpcLink vpcLink;

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getCacheKeyParameters}
         * @param cacheKeyParameters A list of request parameters whose values are to be cached.
         *                           It determines
         *                           request parameters that will make it into the cache key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheKeyParameters(java.util.List<java.lang.String> cacheKeyParameters) {
            this.cacheKeyParameters = cacheKeyParameters;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getCacheNamespace}
         * @param cacheNamespace An API-specific tag group of related cached parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNamespace(java.lang.String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getConnectionType}
         * @param connectionType The type of network connection to the integration endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(software.amazon.awscdk.services.apigateway.ConnectionType connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getContentHandling}
         * @param contentHandling Specifies how to handle request payload content type conversions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(software.amazon.awscdk.services.apigateway.ContentHandling contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getCredentialsPassthrough}
         * @param credentialsPassthrough Requires that the caller's identity be passed through from the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsPassthrough(java.lang.Boolean credentialsPassthrough) {
            this.credentialsPassthrough = credentialsPassthrough;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getCredentialsRole}
         * @param credentialsRole An IAM role that API Gateway assumes.
         *                        Mutually exclusive with <code>credentialsPassThrough</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.credentialsRole = credentialsRole;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getIntegrationResponses}
         * @param integrationResponses The response that API Gateway provides after a method's backend completes processing a request.
         *                             API Gateway intercepts the response from the
         *                             backend so that you can control how API Gateway surfaces backend
         *                             responses. For example, you can map the backend status codes to codes
         *                             that you define.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder integrationResponses(java.util.List<? extends software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses) {
            this.integrationResponses = (java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse>)integrationResponses;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getPassthroughBehavior}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
         *                            There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         *                            NEVER.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getRequestParameters}
         * @param requestParameters The request parameters that API Gateway sends with the backend request.
         *                          Specify request parameters as key-value pairs (string-to-string
         *                          mappings), with a destination as the key and a source as the value.
         *                          <p>
         *                          Specify the destination by using the following pattern
         *                          integration.request.location.name, where location is querystring, path,
         *                          or header, and name is a valid, unique parameter name.
         *                          <p>
         *                          The source must be an existing method request parameter or a static
         *                          value. You must enclose static values in single quotation marks and
         *                          pre-encode these values based on their destination in the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getRequestTemplates}
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload.
         *                         The template that API Gateway uses is based on the value of the
         *                         Content-Type header that's sent by the client. The content type value is
         *                         the key, and the template is the value (specified as a string), such as
         *                         the following snippet:
         *                         <p>
         *                         <blockquote><pre>
         *                           { "application/json": "{ \"statusCode\": 200 }" }
         *                         </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.requestTemplates = requestTemplates;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getTimeout}
         * @param timeout The maximum amount of time an integration will run before it returns without a response.
         *                By default, the value must be between 50 milliseconds and 29 seconds.
         *                The upper bound can be increased for regional and private Rest APIs only,
         *                via a quota increase request for your acccount.
         *                This increase might require a reduction in your account-level throttle quota limit.
         *                
         *                See {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/limits.html Amazon API Gateway quotas} for more details.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerIntegrationOptions#getVpcLink}
         * @param vpcLink The VpcLink used for the integration.
         *                Required if connectionType is VPC_LINK
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLink(software.amazon.awscdk.services.apigateway.IVpcLink vpcLink) {
            this.vpcLink = vpcLink;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SagemakerIntegrationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SagemakerIntegrationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SagemakerIntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SagemakerIntegrationOptions {
        private final java.util.List<java.lang.String> cacheKeyParameters;
        private final java.lang.String cacheNamespace;
        private final software.amazon.awscdk.services.apigateway.ConnectionType connectionType;
        private final software.amazon.awscdk.services.apigateway.ContentHandling contentHandling;
        private final java.lang.Boolean credentialsPassthrough;
        private final software.amazon.awscdk.services.iam.IRole credentialsRole;
        private final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses;
        private final software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior;
        private final java.util.Map<java.lang.String, java.lang.String> requestParameters;
        private final java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.apigateway.IVpcLink vpcLink;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cacheKeyParameters = software.amazon.jsii.Kernel.get(this, "cacheKeyParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheNamespace = software.amazon.jsii.Kernel.get(this, "cacheNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ConnectionType.class));
            this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ContentHandling.class));
            this.credentialsPassthrough = software.amazon.jsii.Kernel.get(this, "credentialsPassthrough", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.credentialsRole = software.amazon.jsii.Kernel.get(this, "credentialsRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.integrationResponses = software.amazon.jsii.Kernel.get(this, "integrationResponses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationResponse.class)));
            this.passthroughBehavior = software.amazon.jsii.Kernel.get(this, "passthroughBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.PassthroughBehavior.class));
            this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requestTemplates = software.amazon.jsii.Kernel.get(this, "requestTemplates", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpcLink = software.amazon.jsii.Kernel.get(this, "vpcLink", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IVpcLink.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cacheKeyParameters = builder.cacheKeyParameters;
            this.cacheNamespace = builder.cacheNamespace;
            this.connectionType = builder.connectionType;
            this.contentHandling = builder.contentHandling;
            this.credentialsPassthrough = builder.credentialsPassthrough;
            this.credentialsRole = builder.credentialsRole;
            this.integrationResponses = (java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse>)builder.integrationResponses;
            this.passthroughBehavior = builder.passthroughBehavior;
            this.requestParameters = builder.requestParameters;
            this.requestTemplates = builder.requestTemplates;
            this.timeout = builder.timeout;
            this.vpcLink = builder.vpcLink;
        }

        @Override
        public final java.util.List<java.lang.String> getCacheKeyParameters() {
            return this.cacheKeyParameters;
        }

        @Override
        public final java.lang.String getCacheNamespace() {
            return this.cacheNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final java.lang.Boolean getCredentialsPassthrough() {
            return this.credentialsPassthrough;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
            return this.credentialsRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses() {
            return this.integrationResponses;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
            return this.requestTemplates;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IVpcLink getVpcLink() {
            return this.vpcLink;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCacheKeyParameters() != null) {
                data.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
            }
            if (this.getCacheNamespace() != null) {
                data.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
            }
            if (this.getConnectionType() != null) {
                data.set("connectionType", om.valueToTree(this.getConnectionType()));
            }
            if (this.getContentHandling() != null) {
                data.set("contentHandling", om.valueToTree(this.getContentHandling()));
            }
            if (this.getCredentialsPassthrough() != null) {
                data.set("credentialsPassthrough", om.valueToTree(this.getCredentialsPassthrough()));
            }
            if (this.getCredentialsRole() != null) {
                data.set("credentialsRole", om.valueToTree(this.getCredentialsRole()));
            }
            if (this.getIntegrationResponses() != null) {
                data.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
            }
            if (this.getPassthroughBehavior() != null) {
                data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestTemplates() != null) {
                data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVpcLink() != null) {
                data.set("vpcLink", om.valueToTree(this.getVpcLink()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.SagemakerIntegrationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SagemakerIntegrationOptions.Jsii$Proxy that = (SagemakerIntegrationOptions.Jsii$Proxy) o;

            if (this.cacheKeyParameters != null ? !this.cacheKeyParameters.equals(that.cacheKeyParameters) : that.cacheKeyParameters != null) return false;
            if (this.cacheNamespace != null ? !this.cacheNamespace.equals(that.cacheNamespace) : that.cacheNamespace != null) return false;
            if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
            if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
            if (this.credentialsPassthrough != null ? !this.credentialsPassthrough.equals(that.credentialsPassthrough) : that.credentialsPassthrough != null) return false;
            if (this.credentialsRole != null ? !this.credentialsRole.equals(that.credentialsRole) : that.credentialsRole != null) return false;
            if (this.integrationResponses != null ? !this.integrationResponses.equals(that.integrationResponses) : that.integrationResponses != null) return false;
            if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.vpcLink != null ? this.vpcLink.equals(that.vpcLink) : that.vpcLink == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cacheKeyParameters != null ? this.cacheKeyParameters.hashCode() : 0;
            result = 31 * result + (this.cacheNamespace != null ? this.cacheNamespace.hashCode() : 0);
            result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
            result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
            result = 31 * result + (this.credentialsPassthrough != null ? this.credentialsPassthrough.hashCode() : 0);
            result = 31 * result + (this.credentialsRole != null ? this.credentialsRole.hashCode() : 0);
            result = 31 * result + (this.integrationResponses != null ? this.integrationResponses.hashCode() : 0);
            result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.vpcLink != null ? this.vpcLink.hashCode() : 0);
            return result;
        }
    }
}
