package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties to initialize an instance of <code>HttpStage</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * HttpApi api;
 * LogGroup logGroup;
 * HttpStage stage = HttpStage.Builder.create(this, "Stage")
 *         .httpApi(api)
 *         .accessLogSettings(Map.of(
 *                 "destination", new LogGroupLogDestination(logGroup)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:01.408Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpStageProps")
@software.amazon.jsii.Jsii.Proxy(HttpStageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpStageProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.HttpStageOptions {

    /**
     * The HTTP API to which this stage is associated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi();

    /**
     * @return a {@link Builder} of {@link HttpStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpStageProps> {
        software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi;
        java.lang.String stageName;
        software.amazon.awscdk.services.apigatewayv2.IAccessLogSettings accessLogSettings;
        java.lang.Boolean autoDeploy;
        java.lang.String description;
        java.lang.Boolean detailedMetricsEnabled;
        software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions domainMapping;
        java.util.Map<java.lang.String, java.lang.String> stageVariables;
        software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;

        /**
         * Sets the value of {@link HttpStageProps#getHttpApi}
         * @param httpApi The HTTP API to which this stage is associated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpApi(software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi) {
            this.httpApi = httpApi;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageProps#getStageName}
         * @param stageName The name of the stage.
         *                  See <code>StageName</code> class for more details.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageProps#getAccessLogSettings}
         * @param accessLogSettings Settings for access logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSettings(software.amazon.awscdk.services.apigatewayv2.IAccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageProps#getAutoDeploy}
         * @param autoDeploy Whether updates to an API automatically trigger a new deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeploy(java.lang.Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageProps#getDescription}
         * @param description The description for the API stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageProps#getDetailedMetricsEnabled}
         * @param detailedMetricsEnabled Specifies whether detailed metrics are enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailedMetricsEnabled(java.lang.Boolean detailedMetricsEnabled) {
            this.detailedMetricsEnabled = detailedMetricsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageProps#getDomainMapping}
         * @param domainMapping The options for custom domain and api mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainMapping(software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions domainMapping) {
            this.domainMapping = domainMapping;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageProps#getStageVariables}
         * @param stageVariables Stage variables for the stage. These are key-value pairs that you can define and use in your API routes.
         *                       The allowed characters for variable names and the required pattern for variable values are specified here: https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-apigateway-stage.html#cfn-apigateway-stage-variables
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageVariables(java.util.Map<java.lang.String, java.lang.String> stageVariables) {
            this.stageVariables = stageVariables;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageProps#getThrottle}
         * @param throttle Throttle settings for the routes of this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpStageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpStageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpStageProps {
        private final software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi;
        private final java.lang.String stageName;
        private final software.amazon.awscdk.services.apigatewayv2.IAccessLogSettings accessLogSettings;
        private final java.lang.Boolean autoDeploy;
        private final java.lang.String description;
        private final java.lang.Boolean detailedMetricsEnabled;
        private final software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions domainMapping;
        private final java.util.Map<java.lang.String, java.lang.String> stageVariables;
        private final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpApi = software.amazon.jsii.Kernel.get(this, "httpApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpApi.class));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessLogSettings = software.amazon.jsii.Kernel.get(this, "accessLogSettings", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IAccessLogSettings.class));
            this.autoDeploy = software.amazon.jsii.Kernel.get(this, "autoDeploy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detailedMetricsEnabled = software.amazon.jsii.Kernel.get(this, "detailedMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.domainMapping = software.amazon.jsii.Kernel.get(this, "domainMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions.class));
            this.stageVariables = software.amazon.jsii.Kernel.get(this, "stageVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpApi = java.util.Objects.requireNonNull(builder.httpApi, "httpApi is required");
            this.stageName = builder.stageName;
            this.accessLogSettings = builder.accessLogSettings;
            this.autoDeploy = builder.autoDeploy;
            this.description = builder.description;
            this.detailedMetricsEnabled = builder.detailedMetricsEnabled;
            this.domainMapping = builder.domainMapping;
            this.stageVariables = builder.stageVariables;
            this.throttle = builder.throttle;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi() {
            return this.httpApi;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IAccessLogSettings getAccessLogSettings() {
            return this.accessLogSettings;
        }

        @Override
        public final java.lang.Boolean getAutoDeploy() {
            return this.autoDeploy;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getDetailedMetricsEnabled() {
            return this.detailedMetricsEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions getDomainMapping() {
            return this.domainMapping;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getStageVariables() {
            return this.stageVariables;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpApi", om.valueToTree(this.getHttpApi()));
            if (this.getStageName() != null) {
                data.set("stageName", om.valueToTree(this.getStageName()));
            }
            if (this.getAccessLogSettings() != null) {
                data.set("accessLogSettings", om.valueToTree(this.getAccessLogSettings()));
            }
            if (this.getAutoDeploy() != null) {
                data.set("autoDeploy", om.valueToTree(this.getAutoDeploy()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDetailedMetricsEnabled() != null) {
                data.set("detailedMetricsEnabled", om.valueToTree(this.getDetailedMetricsEnabled()));
            }
            if (this.getDomainMapping() != null) {
                data.set("domainMapping", om.valueToTree(this.getDomainMapping()));
            }
            if (this.getStageVariables() != null) {
                data.set("stageVariables", om.valueToTree(this.getStageVariables()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.HttpStageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpStageProps.Jsii$Proxy that = (HttpStageProps.Jsii$Proxy) o;

            if (!httpApi.equals(that.httpApi)) return false;
            if (this.stageName != null ? !this.stageName.equals(that.stageName) : that.stageName != null) return false;
            if (this.accessLogSettings != null ? !this.accessLogSettings.equals(that.accessLogSettings) : that.accessLogSettings != null) return false;
            if (this.autoDeploy != null ? !this.autoDeploy.equals(that.autoDeploy) : that.autoDeploy != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.detailedMetricsEnabled != null ? !this.detailedMetricsEnabled.equals(that.detailedMetricsEnabled) : that.detailedMetricsEnabled != null) return false;
            if (this.domainMapping != null ? !this.domainMapping.equals(that.domainMapping) : that.domainMapping != null) return false;
            if (this.stageVariables != null ? !this.stageVariables.equals(that.stageVariables) : that.stageVariables != null) return false;
            return this.throttle != null ? this.throttle.equals(that.throttle) : that.throttle == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpApi.hashCode();
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            result = 31 * result + (this.accessLogSettings != null ? this.accessLogSettings.hashCode() : 0);
            result = 31 * result + (this.autoDeploy != null ? this.autoDeploy.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.detailedMetricsEnabled != null ? this.detailedMetricsEnabled.hashCode() : 0);
            result = 31 * result + (this.domainMapping != null ? this.domainMapping.hashCode() : 0);
            result = 31 * result + (this.stageVariables != null ? this.stageVariables.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            return result;
        }
    }
}
