package software.amazon.awscdk.services.appmesh;

/**
 * A utility enum defined for the egressFilter type property, the default of DROP_ALL, allows traffic only to other resources inside the mesh, or API calls to amazon resources.
 * <p>
 * Default: DROP_ALL
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh = Mesh.Builder.create(this, "AppMesh")
 *         .meshName("myAwsMesh")
 *         .egressFilter(MeshFilterType.ALLOW_ALL)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:01.969Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.MeshFilterType")
public enum MeshFilterType {
    /**
     * Allows all outbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALLOW_ALL,
    /**
     * Allows traffic only to other resources inside the mesh, or API calls to amazon resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DROP_ALL,
}
