package software.amazon.awscdk.services.appmesh;

/**
 * Unterface with properties necessary to import a reusable VirtualGateway.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * Mesh mesh;
 * VirtualGatewayAttributes virtualGatewayAttributes = VirtualGatewayAttributes.builder()
 *         .mesh(mesh)
 *         .virtualGatewayName("virtualGatewayName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:01.986Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualGatewayAttributes")
@software.amazon.jsii.Jsii.Proxy(VirtualGatewayAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualGatewayAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Mesh that the VirtualGateway belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh();

    /**
     * The name of the VirtualGateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualGatewayName();

    /**
     * @return a {@link Builder} of {@link VirtualGatewayAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualGatewayAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayAttributes> {
        software.amazon.awscdk.services.appmesh.IMesh mesh;
        java.lang.String virtualGatewayName;

        /**
         * Sets the value of {@link VirtualGatewayAttributes#getMesh}
         * @param mesh The Mesh that the VirtualGateway belongs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mesh(software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.mesh = mesh;
            return this;
        }

        /**
         * Sets the value of {@link VirtualGatewayAttributes#getVirtualGatewayName}
         * @param virtualGatewayName The name of the VirtualGateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGatewayName(java.lang.String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualGatewayAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualGatewayAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualGatewayAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayAttributes {
        private final software.amazon.awscdk.services.appmesh.IMesh mesh;
        private final java.lang.String virtualGatewayName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mesh = software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
            this.virtualGatewayName = software.amazon.jsii.Kernel.get(this, "virtualGatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mesh = java.util.Objects.requireNonNull(builder.mesh, "mesh is required");
            this.virtualGatewayName = java.util.Objects.requireNonNull(builder.virtualGatewayName, "virtualGatewayName is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IMesh getMesh() {
            return this.mesh;
        }

        @Override
        public final java.lang.String getVirtualGatewayName() {
            return this.virtualGatewayName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mesh", om.valueToTree(this.getMesh()));
            data.set("virtualGatewayName", om.valueToTree(this.getVirtualGatewayName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualGatewayAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualGatewayAttributes.Jsii$Proxy that = (VirtualGatewayAttributes.Jsii$Proxy) o;

            if (!mesh.equals(that.mesh)) return false;
            return this.virtualGatewayName.equals(that.virtualGatewayName);
        }

        @Override
        public final int hashCode() {
            int result = this.mesh.hashCode();
            result = 31 * result + (this.virtualGatewayName.hashCode());
            return result;
        }
    }
}
