package software.amazon.awscdk.services.apprunner;

/**
 * Properties for defining a <code>CfnObservabilityConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * CfnObservabilityConfigurationProps cfnObservabilityConfigurationProps = CfnObservabilityConfigurationProps.builder()
 *         .observabilityConfigurationName("observabilityConfigurationName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .traceConfiguration(TraceConfigurationProperty.builder()
 *                 .vendor("vendor")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-observabilityconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-observabilityconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:02.013Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnObservabilityConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnObservabilityConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnObservabilityConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the observability configuration.
     * <p>
     * When you use it for the first time in an AWS Region , App Runner creates revision number <code>1</code> of this name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.
     * <p>
     * <blockquote>
     * <p>
     * The name <code>DefaultConfiguration</code> is reserved. You can't use it to create a new observability configuration, and you can't create a revision of it.
     * <p>
     * When you want to use your own observability configuration for your App Runner service, <em>create a configuration with a different name</em> , and then provide it when you create or update your service.
     * <p>
     * </blockquote>
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a name for your observability configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-observabilityconfiguration.html#cfn-apprunner-observabilityconfiguration-observabilityconfigurationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-observabilityconfiguration.html#cfn-apprunner-observabilityconfiguration-observabilityconfigurationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getObservabilityConfigurationName() {
        return null;
    }

    /**
     * A list of metadata items that you can associate with your observability configuration resource.
     * <p>
     * A tag is a key-value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-observabilityconfiguration.html#cfn-apprunner-observabilityconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-observabilityconfiguration.html#cfn-apprunner-observabilityconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The configuration of the tracing feature within this observability configuration.
     * <p>
     * If you don't specify it, App Runner doesn't enable tracing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-observabilityconfiguration.html#cfn-apprunner-observabilityconfiguration-traceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-observabilityconfiguration.html#cfn-apprunner-observabilityconfiguration-traceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTraceConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnObservabilityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnObservabilityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnObservabilityConfigurationProps> {
        java.lang.String observabilityConfigurationName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object traceConfiguration;

        /**
         * Sets the value of {@link CfnObservabilityConfigurationProps#getObservabilityConfigurationName}
         * @param observabilityConfigurationName A name for the observability configuration.
         *                                       When you use it for the first time in an AWS Region , App Runner creates revision number <code>1</code> of this name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.
         *                                       <p>
         *                                       <blockquote>
         *                                       <p>
         *                                       The name <code>DefaultConfiguration</code> is reserved. You can't use it to create a new observability configuration, and you can't create a revision of it.
         *                                       <p>
         *                                       When you want to use your own observability configuration for your App Runner service, <em>create a configuration with a different name</em> , and then provide it when you create or update your service.
         *                                       <p>
         *                                       </blockquote>
         *                                       <p>
         *                                       If you don't specify a name, AWS CloudFormation generates a name for your observability configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder observabilityConfigurationName(java.lang.String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnObservabilityConfigurationProps#getTags}
         * @param tags A list of metadata items that you can associate with your observability configuration resource.
         *             A tag is a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnObservabilityConfigurationProps#getTraceConfiguration}
         * @param traceConfiguration The configuration of the tracing feature within this observability configuration.
         *                           If you don't specify it, App Runner doesn't enable tracing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder traceConfiguration(software.amazon.awscdk.IResolvable traceConfiguration) {
            this.traceConfiguration = traceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnObservabilityConfigurationProps#getTraceConfiguration}
         * @param traceConfiguration The configuration of the tracing feature within this observability configuration.
         *                           If you don't specify it, App Runner doesn't enable tracing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder traceConfiguration(software.amazon.awscdk.services.apprunner.CfnObservabilityConfiguration.TraceConfigurationProperty traceConfiguration) {
            this.traceConfiguration = traceConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnObservabilityConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnObservabilityConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnObservabilityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnObservabilityConfigurationProps {
        private final java.lang.String observabilityConfigurationName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object traceConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.observabilityConfigurationName = software.amazon.jsii.Kernel.get(this, "observabilityConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.traceConfiguration = software.amazon.jsii.Kernel.get(this, "traceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.observabilityConfigurationName = builder.observabilityConfigurationName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.traceConfiguration = builder.traceConfiguration;
        }

        @Override
        public final java.lang.String getObservabilityConfigurationName() {
            return this.observabilityConfigurationName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTraceConfiguration() {
            return this.traceConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getObservabilityConfigurationName() != null) {
                data.set("observabilityConfigurationName", om.valueToTree(this.getObservabilityConfigurationName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTraceConfiguration() != null) {
                data.set("traceConfiguration", om.valueToTree(this.getTraceConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnObservabilityConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnObservabilityConfigurationProps.Jsii$Proxy that = (CfnObservabilityConfigurationProps.Jsii$Proxy) o;

            if (this.observabilityConfigurationName != null ? !this.observabilityConfigurationName.equals(that.observabilityConfigurationName) : that.observabilityConfigurationName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.traceConfiguration != null ? this.traceConfiguration.equals(that.traceConfiguration) : that.traceConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.observabilityConfigurationName != null ? this.observabilityConfigurationName.hashCode() : 0;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.traceConfiguration != null ? this.traceConfiguration.hashCode() : 0);
            return result;
        }
    }
}
