package software.amazon.awscdk.services.appstream;

/**
 * Properties for defining a <code>CfnFleet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnFleet fleet = CfnFleet.Builder.create(this, "Fleet")
 *         .instanceType("stream.standard.small")
 *         .name("Fleet")
 *         .computeCapacity(ComputeCapacityProperty.builder()
 *                 .desiredInstances(1)
 *                 .build())
 *         .imageName("AppStream-AmazonLinux2-09-21-2022")
 *         .build();
 * fleet.getCfnOptions().getCreationPolicy() = CfnCreationPolicy.builder()
 *         .startFleet(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:02.056Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appstream.CfnFleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnFleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The instance type to use when launching fleet instances. The following instance types are available for non-Elastic fleets:.
     * <p>
     * <ul>
     * <li>stream.standard.small</li>
     * <li>stream.standard.medium</li>
     * <li>stream.standard.large</li>
     * <li>stream.compute.large</li>
     * <li>stream.compute.xlarge</li>
     * <li>stream.compute.2xlarge</li>
     * <li>stream.compute.4xlarge</li>
     * <li>stream.compute.8xlarge</li>
     * <li>stream.memory.large</li>
     * <li>stream.memory.xlarge</li>
     * <li>stream.memory.2xlarge</li>
     * <li>stream.memory.4xlarge</li>
     * <li>stream.memory.8xlarge</li>
     * <li>stream.memory.z1d.large</li>
     * <li>stream.memory.z1d.xlarge</li>
     * <li>stream.memory.z1d.2xlarge</li>
     * <li>stream.memory.z1d.3xlarge</li>
     * <li>stream.memory.z1d.6xlarge</li>
     * <li>stream.memory.z1d.12xlarge</li>
     * <li>stream.graphics-design.large</li>
     * <li>stream.graphics-design.xlarge</li>
     * <li>stream.graphics-design.2xlarge</li>
     * <li>stream.graphics-design.4xlarge</li>
     * <li>stream.graphics-desktop.2xlarge</li>
     * <li>stream.graphics.g4dn.xlarge</li>
     * <li>stream.graphics.g4dn.2xlarge</li>
     * <li>stream.graphics.g4dn.4xlarge</li>
     * <li>stream.graphics.g4dn.8xlarge</li>
     * <li>stream.graphics.g4dn.12xlarge</li>
     * <li>stream.graphics.g4dn.16xlarge</li>
     * <li>stream.graphics-pro.4xlarge</li>
     * <li>stream.graphics-pro.8xlarge</li>
     * <li>stream.graphics-pro.16xlarge</li>
     * </ul>
     * <p>
     * The following instance types are available for Elastic fleets:
     * <p>
     * <ul>
     * <li>stream.standard.small</li>
     * <li>stream.standard.medium</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-instancetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * A unique name for the fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The desired capacity for the fleet.
     * <p>
     * This is not allowed for Elastic fleets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-computecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-computecapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getComputeCapacity() {
        return null;
    }

    /**
     * The description to display.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The amount of time that a streaming session remains active after users disconnect.
     * <p>
     * If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.
     * <p>
     * Specify a value between 60 and 36000.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-disconnecttimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-disconnecttimeoutinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDisconnectTimeoutInSeconds() {
        return null;
    }

    /**
     * The fleet name to display.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain.
     * <p>
     * This is not allowed for Elastic fleets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-domainjoininfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-domainjoininfo</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDomainJoinInfo() {
        return null;
    }

    /**
     * Enables or disables default internet access for the fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-enabledefaultinternetaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-enabledefaultinternetaccess</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDefaultInternetAccess() {
        return null;
    }

    /**
     * The fleet type.
     * <p>
     * <ul>
     * <li><strong>ALWAYS_ON</strong> - Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</li>
     * <li><strong>ON_DEMAND</strong> - Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</li>
     * <li><strong>ELASTIC</strong> - The pool of streaming instances is managed by Amazon AppStream 2.0. When a user selects their application or desktop to launch, they will start streaming after the app block has been downloaded and mounted to a streaming instance.</li>
     * </ul>
     * <p>
     * <em>Allowed Values</em> : <code>ALWAYS_ON</code> | <code>ELASTIC</code> | <code>ON_DEMAND</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-fleettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-fleettype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFleetType() {
        return null;
    }

    /**
     * The ARN of the IAM role that is applied to the fleet.
     * <p>
     * To assume a role, the fleet instance calls the AWS Security Token Service <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <em>appstream_machine_role</em> credential profile on the instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <em>Amazon AppStream 2.0 Administration Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-iamrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIamRoleArn() {
        return null;
    }

    /**
     * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins.
     * <p>
     * Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.
     * <p>
     * To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 36000.
     * <p>
     * If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-idledisconnecttimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-idledisconnecttimeoutinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIdleDisconnectTimeoutInSeconds() {
        return null;
    }

    /**
     * The ARN of the public, private, or shared image to use.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageArn() {
        return null;
    }

    /**
     * The name of the image used to create the fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageName() {
        return null;
    }

    /**
     * The maximum number of concurrent sessions that can be run on an Elastic fleet.
     * <p>
     * This setting is required for Elastic fleets, but is not used for other fleet types.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxconcurrentsessions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxconcurrentsessions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentSessions() {
        return null;
    }

    /**
     * Max number of user sessions on an instance.
     * <p>
     * This is applicable only for multi-session fleets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxsessionsperinstance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxsessionsperinstance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSessionsPerInstance() {
        return null;
    }

    /**
     * The maximum amount of time that a streaming session can remain active, in seconds.
     * <p>
     * If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.
     * <p>
     * Specify a value between 600 and 432000.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxuserdurationinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxuserdurationinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxUserDurationInSeconds() {
        return null;
    }

    /**
     * The platform of the fleet.
     * <p>
     * Platform is a required setting for Elastic fleets, and is not used for other fleet types.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-platform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-platform</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlatform() {
        return null;
    }

    /**
     * The S3 location of the session scripts configuration zip file.
     * <p>
     * This only applies to Elastic fleets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-sessionscripts3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-sessionscripts3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSessionScriptS3Location() {
        return null;
    }

    /**
     * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.
     * <p>
     * The default value is <code>APP</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-streamview">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-streamview</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStreamView() {
        return null;
    }

    /**
     * An array of key-value pairs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client.
     * <p>
     * This is allowed but not required for Elastic fleets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-usbdevicefilterstrings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-usbdevicefilterstrings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUsbDeviceFilterStrings() {
        return null;
    }

    /**
     * The VPC configuration for the fleet.
     * <p>
     * This is required for Elastic fleets, but not required for other fleet types.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-vpcconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFleetProps> {
        java.lang.String instanceType;
        java.lang.String name;
        java.lang.Object computeCapacity;
        java.lang.String description;
        java.lang.Number disconnectTimeoutInSeconds;
        java.lang.String displayName;
        java.lang.Object domainJoinInfo;
        java.lang.Object enableDefaultInternetAccess;
        java.lang.String fleetType;
        java.lang.String iamRoleArn;
        java.lang.Number idleDisconnectTimeoutInSeconds;
        java.lang.String imageArn;
        java.lang.String imageName;
        java.lang.Number maxConcurrentSessions;
        java.lang.Number maxSessionsPerInstance;
        java.lang.Number maxUserDurationInSeconds;
        java.lang.String platform;
        java.lang.Object sessionScriptS3Location;
        java.lang.String streamView;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.util.List<java.lang.String> usbDeviceFilterStrings;
        java.lang.Object vpcConfig;

        /**
         * Sets the value of {@link CfnFleetProps#getInstanceType}
         * @param instanceType The instance type to use when launching fleet instances. The following instance types are available for non-Elastic fleets:. This parameter is required.
         *                     <ul>
         *                     <li>stream.standard.small</li>
         *                     <li>stream.standard.medium</li>
         *                     <li>stream.standard.large</li>
         *                     <li>stream.compute.large</li>
         *                     <li>stream.compute.xlarge</li>
         *                     <li>stream.compute.2xlarge</li>
         *                     <li>stream.compute.4xlarge</li>
         *                     <li>stream.compute.8xlarge</li>
         *                     <li>stream.memory.large</li>
         *                     <li>stream.memory.xlarge</li>
         *                     <li>stream.memory.2xlarge</li>
         *                     <li>stream.memory.4xlarge</li>
         *                     <li>stream.memory.8xlarge</li>
         *                     <li>stream.memory.z1d.large</li>
         *                     <li>stream.memory.z1d.xlarge</li>
         *                     <li>stream.memory.z1d.2xlarge</li>
         *                     <li>stream.memory.z1d.3xlarge</li>
         *                     <li>stream.memory.z1d.6xlarge</li>
         *                     <li>stream.memory.z1d.12xlarge</li>
         *                     <li>stream.graphics-design.large</li>
         *                     <li>stream.graphics-design.xlarge</li>
         *                     <li>stream.graphics-design.2xlarge</li>
         *                     <li>stream.graphics-design.4xlarge</li>
         *                     <li>stream.graphics-desktop.2xlarge</li>
         *                     <li>stream.graphics.g4dn.xlarge</li>
         *                     <li>stream.graphics.g4dn.2xlarge</li>
         *                     <li>stream.graphics.g4dn.4xlarge</li>
         *                     <li>stream.graphics.g4dn.8xlarge</li>
         *                     <li>stream.graphics.g4dn.12xlarge</li>
         *                     <li>stream.graphics.g4dn.16xlarge</li>
         *                     <li>stream.graphics-pro.4xlarge</li>
         *                     <li>stream.graphics-pro.8xlarge</li>
         *                     <li>stream.graphics-pro.16xlarge</li>
         *                     </ul>
         *                     <p>
         *                     The following instance types are available for Elastic fleets:
         *                     <p>
         *                     <ul>
         *                     <li>stream.standard.small</li>
         *                     <li>stream.standard.medium</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getName}
         * @param name A unique name for the fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getComputeCapacity}
         * @param computeCapacity The desired capacity for the fleet.
         *                        This is not allowed for Elastic fleets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeCapacity(software.amazon.awscdk.IResolvable computeCapacity) {
            this.computeCapacity = computeCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getComputeCapacity}
         * @param computeCapacity The desired capacity for the fleet.
         *                        This is not allowed for Elastic fleets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeCapacity(software.amazon.awscdk.services.appstream.CfnFleet.ComputeCapacityProperty computeCapacity) {
            this.computeCapacity = computeCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getDescription}
         * @param description The description to display.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getDisconnectTimeoutInSeconds}
         * @param disconnectTimeoutInSeconds The amount of time that a streaming session remains active after users disconnect.
         *                                   If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.
         *                                   <p>
         *                                   Specify a value between 60 and 36000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disconnectTimeoutInSeconds(java.lang.Number disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getDisplayName}
         * @param displayName The fleet name to display.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getDomainJoinInfo}
         * @param domainJoinInfo The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain.
         *                       This is not allowed for Elastic fleets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainJoinInfo(software.amazon.awscdk.IResolvable domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getDomainJoinInfo}
         * @param domainJoinInfo The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain.
         *                       This is not allowed for Elastic fleets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainJoinInfo(software.amazon.awscdk.services.appstream.CfnFleet.DomainJoinInfoProperty domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getEnableDefaultInternetAccess}
         * @param enableDefaultInternetAccess Enables or disables default internet access for the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDefaultInternetAccess(java.lang.Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getEnableDefaultInternetAccess}
         * @param enableDefaultInternetAccess Enables or disables default internet access for the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDefaultInternetAccess(software.amazon.awscdk.IResolvable enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getFleetType}
         * @param fleetType The fleet type.
         *                  <ul>
         *                  <li><strong>ALWAYS_ON</strong> - Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</li>
         *                  <li><strong>ON_DEMAND</strong> - Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</li>
         *                  <li><strong>ELASTIC</strong> - The pool of streaming instances is managed by Amazon AppStream 2.0. When a user selects their application or desktop to launch, they will start streaming after the app block has been downloaded and mounted to a streaming instance.</li>
         *                  </ul>
         *                  <p>
         *                  <em>Allowed Values</em> : <code>ALWAYS_ON</code> | <code>ELASTIC</code> | <code>ON_DEMAND</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetType(java.lang.String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getIamRoleArn}
         * @param iamRoleArn The ARN of the IAM role that is applied to the fleet.
         *                   To assume a role, the fleet instance calls the AWS Security Token Service <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <em>appstream_machine_role</em> credential profile on the instance.
         *                   <p>
         *                   For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <em>Amazon AppStream 2.0 Administration Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoleArn(java.lang.String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getIdleDisconnectTimeoutInSeconds}
         * @param idleDisconnectTimeoutInSeconds The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins.
         *                                       Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.
         *                                       <p>
         *                                       To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 36000.
         *                                       <p>
         *                                       If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleDisconnectTimeoutInSeconds(java.lang.Number idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getImageArn}
         * @param imageArn The ARN of the public, private, or shared image to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageArn(java.lang.String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getImageName}
         * @param imageName The name of the image used to create the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageName(java.lang.String imageName) {
            this.imageName = imageName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getMaxConcurrentSessions}
         * @param maxConcurrentSessions The maximum number of concurrent sessions that can be run on an Elastic fleet.
         *                              This setting is required for Elastic fleets, but is not used for other fleet types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrentSessions(java.lang.Number maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getMaxSessionsPerInstance}
         * @param maxSessionsPerInstance Max number of user sessions on an instance.
         *                               This is applicable only for multi-session fleets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSessionsPerInstance(java.lang.Number maxSessionsPerInstance) {
            this.maxSessionsPerInstance = maxSessionsPerInstance;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getMaxUserDurationInSeconds}
         * @param maxUserDurationInSeconds The maximum amount of time that a streaming session can remain active, in seconds.
         *                                 If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.
         *                                 <p>
         *                                 Specify a value between 600 and 432000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUserDurationInSeconds(java.lang.Number maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getPlatform}
         * @param platform The platform of the fleet.
         *                 Platform is a required setting for Elastic fleets, and is not used for other fleet types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(java.lang.String platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getSessionScriptS3Location}
         * @param sessionScriptS3Location The S3 location of the session scripts configuration zip file.
         *                                This only applies to Elastic fleets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionScriptS3Location(software.amazon.awscdk.IResolvable sessionScriptS3Location) {
            this.sessionScriptS3Location = sessionScriptS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getSessionScriptS3Location}
         * @param sessionScriptS3Location The S3 location of the session scripts configuration zip file.
         *                                This only applies to Elastic fleets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionScriptS3Location(software.amazon.awscdk.services.appstream.CfnFleet.S3LocationProperty sessionScriptS3Location) {
            this.sessionScriptS3Location = sessionScriptS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getStreamView}
         * @param streamView The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.
         *                   The default value is <code>APP</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamView(java.lang.String streamView) {
            this.streamView = streamView;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getTags}
         * @param tags An array of key-value pairs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getUsbDeviceFilterStrings}
         * @param usbDeviceFilterStrings The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client.
         *                               This is allowed but not required for Elastic fleets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usbDeviceFilterStrings(java.util.List<java.lang.String> usbDeviceFilterStrings) {
            this.usbDeviceFilterStrings = usbDeviceFilterStrings;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getVpcConfig}
         * @param vpcConfig The VPC configuration for the fleet.
         *                  This is required for Elastic fleets, but not required for other fleet types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getVpcConfig}
         * @param vpcConfig The VPC configuration for the fleet.
         *                  This is required for Elastic fleets, but not required for other fleet types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.services.appstream.CfnFleet.VpcConfigProperty vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFleetProps {
        private final java.lang.String instanceType;
        private final java.lang.String name;
        private final java.lang.Object computeCapacity;
        private final java.lang.String description;
        private final java.lang.Number disconnectTimeoutInSeconds;
        private final java.lang.String displayName;
        private final java.lang.Object domainJoinInfo;
        private final java.lang.Object enableDefaultInternetAccess;
        private final java.lang.String fleetType;
        private final java.lang.String iamRoleArn;
        private final java.lang.Number idleDisconnectTimeoutInSeconds;
        private final java.lang.String imageArn;
        private final java.lang.String imageName;
        private final java.lang.Number maxConcurrentSessions;
        private final java.lang.Number maxSessionsPerInstance;
        private final java.lang.Number maxUserDurationInSeconds;
        private final java.lang.String platform;
        private final java.lang.Object sessionScriptS3Location;
        private final java.lang.String streamView;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.util.List<java.lang.String> usbDeviceFilterStrings;
        private final java.lang.Object vpcConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computeCapacity = software.amazon.jsii.Kernel.get(this, "computeCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disconnectTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "disconnectTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainJoinInfo = software.amazon.jsii.Kernel.get(this, "domainJoinInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableDefaultInternetAccess = software.amazon.jsii.Kernel.get(this, "enableDefaultInternetAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fleetType = software.amazon.jsii.Kernel.get(this, "fleetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.idleDisconnectTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "idleDisconnectTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.imageArn = software.amazon.jsii.Kernel.get(this, "imageArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageName = software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxConcurrentSessions = software.amazon.jsii.Kernel.get(this, "maxConcurrentSessions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxSessionsPerInstance = software.amazon.jsii.Kernel.get(this, "maxSessionsPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxUserDurationInSeconds = software.amazon.jsii.Kernel.get(this, "maxUserDurationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sessionScriptS3Location = software.amazon.jsii.Kernel.get(this, "sessionScriptS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.streamView = software.amazon.jsii.Kernel.get(this, "streamView", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.usbDeviceFilterStrings = software.amazon.jsii.Kernel.get(this, "usbDeviceFilterStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.computeCapacity = builder.computeCapacity;
            this.description = builder.description;
            this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
            this.displayName = builder.displayName;
            this.domainJoinInfo = builder.domainJoinInfo;
            this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
            this.fleetType = builder.fleetType;
            this.iamRoleArn = builder.iamRoleArn;
            this.idleDisconnectTimeoutInSeconds = builder.idleDisconnectTimeoutInSeconds;
            this.imageArn = builder.imageArn;
            this.imageName = builder.imageName;
            this.maxConcurrentSessions = builder.maxConcurrentSessions;
            this.maxSessionsPerInstance = builder.maxSessionsPerInstance;
            this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
            this.platform = builder.platform;
            this.sessionScriptS3Location = builder.sessionScriptS3Location;
            this.streamView = builder.streamView;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.usbDeviceFilterStrings = builder.usbDeviceFilterStrings;
            this.vpcConfig = builder.vpcConfig;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getComputeCapacity() {
            return this.computeCapacity;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getDisconnectTimeoutInSeconds() {
            return this.disconnectTimeoutInSeconds;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.Object getDomainJoinInfo() {
            return this.domainJoinInfo;
        }

        @Override
        public final java.lang.Object getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final java.lang.String getFleetType() {
            return this.fleetType;
        }

        @Override
        public final java.lang.String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final java.lang.Number getIdleDisconnectTimeoutInSeconds() {
            return this.idleDisconnectTimeoutInSeconds;
        }

        @Override
        public final java.lang.String getImageArn() {
            return this.imageArn;
        }

        @Override
        public final java.lang.String getImageName() {
            return this.imageName;
        }

        @Override
        public final java.lang.Number getMaxConcurrentSessions() {
            return this.maxConcurrentSessions;
        }

        @Override
        public final java.lang.Number getMaxSessionsPerInstance() {
            return this.maxSessionsPerInstance;
        }

        @Override
        public final java.lang.Number getMaxUserDurationInSeconds() {
            return this.maxUserDurationInSeconds;
        }

        @Override
        public final java.lang.String getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.Object getSessionScriptS3Location() {
            return this.sessionScriptS3Location;
        }

        @Override
        public final java.lang.String getStreamView() {
            return this.streamView;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getUsbDeviceFilterStrings() {
            return this.usbDeviceFilterStrings;
        }

        @Override
        public final java.lang.Object getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getComputeCapacity() != null) {
                data.set("computeCapacity", om.valueToTree(this.getComputeCapacity()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisconnectTimeoutInSeconds() != null) {
                data.set("disconnectTimeoutInSeconds", om.valueToTree(this.getDisconnectTimeoutInSeconds()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getDomainJoinInfo() != null) {
                data.set("domainJoinInfo", om.valueToTree(this.getDomainJoinInfo()));
            }
            if (this.getEnableDefaultInternetAccess() != null) {
                data.set("enableDefaultInternetAccess", om.valueToTree(this.getEnableDefaultInternetAccess()));
            }
            if (this.getFleetType() != null) {
                data.set("fleetType", om.valueToTree(this.getFleetType()));
            }
            if (this.getIamRoleArn() != null) {
                data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));
            }
            if (this.getIdleDisconnectTimeoutInSeconds() != null) {
                data.set("idleDisconnectTimeoutInSeconds", om.valueToTree(this.getIdleDisconnectTimeoutInSeconds()));
            }
            if (this.getImageArn() != null) {
                data.set("imageArn", om.valueToTree(this.getImageArn()));
            }
            if (this.getImageName() != null) {
                data.set("imageName", om.valueToTree(this.getImageName()));
            }
            if (this.getMaxConcurrentSessions() != null) {
                data.set("maxConcurrentSessions", om.valueToTree(this.getMaxConcurrentSessions()));
            }
            if (this.getMaxSessionsPerInstance() != null) {
                data.set("maxSessionsPerInstance", om.valueToTree(this.getMaxSessionsPerInstance()));
            }
            if (this.getMaxUserDurationInSeconds() != null) {
                data.set("maxUserDurationInSeconds", om.valueToTree(this.getMaxUserDurationInSeconds()));
            }
            if (this.getPlatform() != null) {
                data.set("platform", om.valueToTree(this.getPlatform()));
            }
            if (this.getSessionScriptS3Location() != null) {
                data.set("sessionScriptS3Location", om.valueToTree(this.getSessionScriptS3Location()));
            }
            if (this.getStreamView() != null) {
                data.set("streamView", om.valueToTree(this.getStreamView()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUsbDeviceFilterStrings() != null) {
                data.set("usbDeviceFilterStrings", om.valueToTree(this.getUsbDeviceFilterStrings()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appstream.CfnFleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFleetProps.Jsii$Proxy that = (CfnFleetProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!name.equals(that.name)) return false;
            if (this.computeCapacity != null ? !this.computeCapacity.equals(that.computeCapacity) : that.computeCapacity != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disconnectTimeoutInSeconds != null ? !this.disconnectTimeoutInSeconds.equals(that.disconnectTimeoutInSeconds) : that.disconnectTimeoutInSeconds != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.domainJoinInfo != null ? !this.domainJoinInfo.equals(that.domainJoinInfo) : that.domainJoinInfo != null) return false;
            if (this.enableDefaultInternetAccess != null ? !this.enableDefaultInternetAccess.equals(that.enableDefaultInternetAccess) : that.enableDefaultInternetAccess != null) return false;
            if (this.fleetType != null ? !this.fleetType.equals(that.fleetType) : that.fleetType != null) return false;
            if (this.iamRoleArn != null ? !this.iamRoleArn.equals(that.iamRoleArn) : that.iamRoleArn != null) return false;
            if (this.idleDisconnectTimeoutInSeconds != null ? !this.idleDisconnectTimeoutInSeconds.equals(that.idleDisconnectTimeoutInSeconds) : that.idleDisconnectTimeoutInSeconds != null) return false;
            if (this.imageArn != null ? !this.imageArn.equals(that.imageArn) : that.imageArn != null) return false;
            if (this.imageName != null ? !this.imageName.equals(that.imageName) : that.imageName != null) return false;
            if (this.maxConcurrentSessions != null ? !this.maxConcurrentSessions.equals(that.maxConcurrentSessions) : that.maxConcurrentSessions != null) return false;
            if (this.maxSessionsPerInstance != null ? !this.maxSessionsPerInstance.equals(that.maxSessionsPerInstance) : that.maxSessionsPerInstance != null) return false;
            if (this.maxUserDurationInSeconds != null ? !this.maxUserDurationInSeconds.equals(that.maxUserDurationInSeconds) : that.maxUserDurationInSeconds != null) return false;
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) return false;
            if (this.sessionScriptS3Location != null ? !this.sessionScriptS3Location.equals(that.sessionScriptS3Location) : that.sessionScriptS3Location != null) return false;
            if (this.streamView != null ? !this.streamView.equals(that.streamView) : that.streamView != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.usbDeviceFilterStrings != null ? !this.usbDeviceFilterStrings.equals(that.usbDeviceFilterStrings) : that.usbDeviceFilterStrings != null) return false;
            return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.computeCapacity != null ? this.computeCapacity.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disconnectTimeoutInSeconds != null ? this.disconnectTimeoutInSeconds.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.domainJoinInfo != null ? this.domainJoinInfo.hashCode() : 0);
            result = 31 * result + (this.enableDefaultInternetAccess != null ? this.enableDefaultInternetAccess.hashCode() : 0);
            result = 31 * result + (this.fleetType != null ? this.fleetType.hashCode() : 0);
            result = 31 * result + (this.iamRoleArn != null ? this.iamRoleArn.hashCode() : 0);
            result = 31 * result + (this.idleDisconnectTimeoutInSeconds != null ? this.idleDisconnectTimeoutInSeconds.hashCode() : 0);
            result = 31 * result + (this.imageArn != null ? this.imageArn.hashCode() : 0);
            result = 31 * result + (this.imageName != null ? this.imageName.hashCode() : 0);
            result = 31 * result + (this.maxConcurrentSessions != null ? this.maxConcurrentSessions.hashCode() : 0);
            result = 31 * result + (this.maxSessionsPerInstance != null ? this.maxSessionsPerInstance.hashCode() : 0);
            result = 31 * result + (this.maxUserDurationInSeconds != null ? this.maxUserDurationInSeconds.hashCode() : 0);
            result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
            result = 31 * result + (this.sessionScriptS3Location != null ? this.sessionScriptS3Location.hashCode() : 0);
            result = 31 * result + (this.streamView != null ? this.streamView.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.usbDeviceFilterStrings != null ? this.usbDeviceFilterStrings.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            return result;
        }
    }
}
