package software.amazon.awscdk.services.autoscaling;

/**
 * Options for applying CloudFormation init to an instance or instance group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * ApplyCloudFormationInitOptions applyCloudFormationInitOptions = ApplyCloudFormationInitOptions.builder()
 *         .configSets(List.of("configSets"))
 *         .embedFingerprint(false)
 *         .ignoreFailures(false)
 *         .includeRole(false)
 *         .includeUrl(false)
 *         .printLog(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:02.376Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.ApplyCloudFormationInitOptions")
@software.amazon.jsii.Jsii.Proxy(ApplyCloudFormationInitOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplyCloudFormationInitOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * ConfigSet to activate.
     * <p>
     * Default: ['default']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getConfigSets() {
        return null;
    }

    /**
     * Force instance replacement by embedding a config fingerprint.
     * <p>
     * If <code>true</code> (the default), a hash of the config will be embedded into the
     * UserData, so that if the config changes, the UserData changes and
     * instances will be replaced (given an UpdatePolicy has been configured on
     * the AutoScalingGroup).
     * <p>
     * If <code>false</code>, no such hash will be embedded, and if the CloudFormation Init
     * config changes nothing will happen to the running instances. If a
     * config update introduces errors, you will not notice until after the
     * CloudFormation deployment successfully finishes and the next instance
     * fails to launch.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmbedFingerprint() {
        return null;
    }

    /**
     * Don't fail the instance creation when cfn-init fails.
     * <p>
     * You can use this to prevent CloudFormation from rolling back when
     * instances fail to start up, to help in debugging.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreFailures() {
        return null;
    }

    /**
     * Include --role argument when running cfn-init and cfn-signal commands.
     * <p>
     * This will be the IAM instance profile attached to the EC2 instance
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeRole() {
        return null;
    }

    /**
     * Include --url argument when running cfn-init and cfn-signal commands.
     * <p>
     * This will be the cloudformation endpoint in the deployed region
     * e.g. https://cloudformation.us-east-1.amazonaws.com
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeUrl() {
        return null;
    }

    /**
     * Print the results of running cfn-init to the Instance System Log.
     * <p>
     * By default, the output of running cfn-init is written to a log file
     * on the instance. Set this to <code>true</code> to print it to the System Log
     * (visible from the EC2 Console), <code>false</code> to not print it.
     * <p>
     * (Be aware that the system log is refreshed at certain points in
     * time of the instance life cycle, and successful execution may
     * not always show up).
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrintLog() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplyCloudFormationInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplyCloudFormationInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplyCloudFormationInitOptions> {
        java.util.List<java.lang.String> configSets;
        java.lang.Boolean embedFingerprint;
        java.lang.Boolean ignoreFailures;
        java.lang.Boolean includeRole;
        java.lang.Boolean includeUrl;
        java.lang.Boolean printLog;

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getConfigSets}
         * @param configSets ConfigSet to activate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configSets(java.util.List<java.lang.String> configSets) {
            this.configSets = configSets;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getEmbedFingerprint}
         * @param embedFingerprint Force instance replacement by embedding a config fingerprint.
         *                         If <code>true</code> (the default), a hash of the config will be embedded into the
         *                         UserData, so that if the config changes, the UserData changes and
         *                         instances will be replaced (given an UpdatePolicy has been configured on
         *                         the AutoScalingGroup).
         *                         <p>
         *                         If <code>false</code>, no such hash will be embedded, and if the CloudFormation Init
         *                         config changes nothing will happen to the running instances. If a
         *                         config update introduces errors, you will not notice until after the
         *                         CloudFormation deployment successfully finishes and the next instance
         *                         fails to launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder embedFingerprint(java.lang.Boolean embedFingerprint) {
            this.embedFingerprint = embedFingerprint;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getIgnoreFailures}
         * @param ignoreFailures Don't fail the instance creation when cfn-init fails.
         *                       You can use this to prevent CloudFormation from rolling back when
         *                       instances fail to start up, to help in debugging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreFailures(java.lang.Boolean ignoreFailures) {
            this.ignoreFailures = ignoreFailures;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getIncludeRole}
         * @param includeRole Include --role argument when running cfn-init and cfn-signal commands.
         *                    This will be the IAM instance profile attached to the EC2 instance
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeRole(java.lang.Boolean includeRole) {
            this.includeRole = includeRole;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getIncludeUrl}
         * @param includeUrl Include --url argument when running cfn-init and cfn-signal commands.
         *                   This will be the cloudformation endpoint in the deployed region
         *                   e.g. https://cloudformation.us-east-1.amazonaws.com
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeUrl(java.lang.Boolean includeUrl) {
            this.includeUrl = includeUrl;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getPrintLog}
         * @param printLog Print the results of running cfn-init to the Instance System Log.
         *                 By default, the output of running cfn-init is written to a log file
         *                 on the instance. Set this to <code>true</code> to print it to the System Log
         *                 (visible from the EC2 Console), <code>false</code> to not print it.
         *                 <p>
         *                 (Be aware that the system log is refreshed at certain points in
         *                 time of the instance life cycle, and successful execution may
         *                 not always show up).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder printLog(java.lang.Boolean printLog) {
            this.printLog = printLog;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplyCloudFormationInitOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplyCloudFormationInitOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplyCloudFormationInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplyCloudFormationInitOptions {
        private final java.util.List<java.lang.String> configSets;
        private final java.lang.Boolean embedFingerprint;
        private final java.lang.Boolean ignoreFailures;
        private final java.lang.Boolean includeRole;
        private final java.lang.Boolean includeUrl;
        private final java.lang.Boolean printLog;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configSets = software.amazon.jsii.Kernel.get(this, "configSets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.embedFingerprint = software.amazon.jsii.Kernel.get(this, "embedFingerprint", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ignoreFailures = software.amazon.jsii.Kernel.get(this, "ignoreFailures", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.includeRole = software.amazon.jsii.Kernel.get(this, "includeRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.includeUrl = software.amazon.jsii.Kernel.get(this, "includeUrl", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.printLog = software.amazon.jsii.Kernel.get(this, "printLog", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configSets = builder.configSets;
            this.embedFingerprint = builder.embedFingerprint;
            this.ignoreFailures = builder.ignoreFailures;
            this.includeRole = builder.includeRole;
            this.includeUrl = builder.includeUrl;
            this.printLog = builder.printLog;
        }

        @Override
        public final java.util.List<java.lang.String> getConfigSets() {
            return this.configSets;
        }

        @Override
        public final java.lang.Boolean getEmbedFingerprint() {
            return this.embedFingerprint;
        }

        @Override
        public final java.lang.Boolean getIgnoreFailures() {
            return this.ignoreFailures;
        }

        @Override
        public final java.lang.Boolean getIncludeRole() {
            return this.includeRole;
        }

        @Override
        public final java.lang.Boolean getIncludeUrl() {
            return this.includeUrl;
        }

        @Override
        public final java.lang.Boolean getPrintLog() {
            return this.printLog;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConfigSets() != null) {
                data.set("configSets", om.valueToTree(this.getConfigSets()));
            }
            if (this.getEmbedFingerprint() != null) {
                data.set("embedFingerprint", om.valueToTree(this.getEmbedFingerprint()));
            }
            if (this.getIgnoreFailures() != null) {
                data.set("ignoreFailures", om.valueToTree(this.getIgnoreFailures()));
            }
            if (this.getIncludeRole() != null) {
                data.set("includeRole", om.valueToTree(this.getIncludeRole()));
            }
            if (this.getIncludeUrl() != null) {
                data.set("includeUrl", om.valueToTree(this.getIncludeUrl()));
            }
            if (this.getPrintLog() != null) {
                data.set("printLog", om.valueToTree(this.getPrintLog()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.ApplyCloudFormationInitOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplyCloudFormationInitOptions.Jsii$Proxy that = (ApplyCloudFormationInitOptions.Jsii$Proxy) o;

            if (this.configSets != null ? !this.configSets.equals(that.configSets) : that.configSets != null) return false;
            if (this.embedFingerprint != null ? !this.embedFingerprint.equals(that.embedFingerprint) : that.embedFingerprint != null) return false;
            if (this.ignoreFailures != null ? !this.ignoreFailures.equals(that.ignoreFailures) : that.ignoreFailures != null) return false;
            if (this.includeRole != null ? !this.includeRole.equals(that.includeRole) : that.includeRole != null) return false;
            if (this.includeUrl != null ? !this.includeUrl.equals(that.includeUrl) : that.includeUrl != null) return false;
            return this.printLog != null ? this.printLog.equals(that.printLog) : that.printLog == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configSets != null ? this.configSets.hashCode() : 0;
            result = 31 * result + (this.embedFingerprint != null ? this.embedFingerprint.hashCode() : 0);
            result = 31 * result + (this.ignoreFailures != null ? this.ignoreFailures.hashCode() : 0);
            result = 31 * result + (this.includeRole != null ? this.includeRole.hashCode() : 0);
            result = 31 * result + (this.includeUrl != null ? this.includeUrl.hashCode() : 0);
            result = 31 * result + (this.printLog != null ? this.printLog.hashCode() : 0);
            return result;
        }
    }
}
