package software.amazon.awscdk.services.autoscaling;

/**
 * Indicates how to allocate instance types to fulfill Spot capacity.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:02.516Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.SpotAllocationStrategy")
public enum SpotAllocationStrategy {
    /**
     * The Auto Scaling group launches instances using the Spot pools with the lowest price, and evenly allocates your instances across the number of Spot pools that you specify.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOWEST_PRICE,
    /**
     * The Auto Scaling group launches instances using Spot pools that are optimally chosen based on the available Spot capacity.
     * <p>
     * Recommended.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CAPACITY_OPTIMIZED,
    /**
     * When you use this strategy, you need to set the order of instance types in the list of launch template overrides from highest to lowest priority (from first to last in the list).
     * <p>
     * Amazon EC2 Auto Scaling
     * honors the instance type priorities on a best-effort basis but optimizes for capacity first.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CAPACITY_OPTIMIZED_PRIORITIZED,
    /**
     * The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRICE_CAPACITY_OPTIMIZED,
}
