package software.amazon.awscdk.services.backup;

/**
 * Properties for defining a <code>CfnFramework</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object controlScope;
 * CfnFrameworkProps cfnFrameworkProps = CfnFrameworkProps.builder()
 *         .frameworkControls(List.of(FrameworkControlProperty.builder()
 *                 .controlName("controlName")
 *                 // the properties below are optional
 *                 .controlInputParameters(List.of(ControlInputParameterProperty.builder()
 *                         .parameterName("parameterName")
 *                         .parameterValue("parameterValue")
 *                         .build()))
 *                 .controlScope(controlScope)
 *                 .build()))
 *         // the properties below are optional
 *         .frameworkDescription("frameworkDescription")
 *         .frameworkName("frameworkName")
 *         .frameworkTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:02.612Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnFrameworkProps")
@software.amazon.jsii.Jsii.Proxy(CfnFrameworkProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFrameworkProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Contains detailed information about all of the controls of a framework.
     * <p>
     * Each framework must contain at least one control.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html#cfn-backup-framework-frameworkcontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html#cfn-backup-framework-frameworkcontrols</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFrameworkControls();

    /**
     * An optional description of the framework with a maximum 1,024 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html#cfn-backup-framework-frameworkdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html#cfn-backup-framework-frameworkdescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFrameworkDescription() {
        return null;
    }

    /**
     * The unique name of a framework.
     * <p>
     * This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html#cfn-backup-framework-frameworkname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html#cfn-backup-framework-frameworkname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFrameworkName() {
        return null;
    }

    /**
     * The tags to assign to your framework.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html#cfn-backup-framework-frameworktags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html#cfn-backup-framework-frameworktags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getFrameworkTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFrameworkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFrameworkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFrameworkProps> {
        java.lang.Object frameworkControls;
        java.lang.String frameworkDescription;
        java.lang.String frameworkName;
        java.util.List<software.amazon.awscdk.CfnTag> frameworkTags;

        /**
         * Sets the value of {@link CfnFrameworkProps#getFrameworkControls}
         * @param frameworkControls Contains detailed information about all of the controls of a framework. This parameter is required.
         *                          Each framework must contain at least one control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkControls(software.amazon.awscdk.IResolvable frameworkControls) {
            this.frameworkControls = frameworkControls;
            return this;
        }

        /**
         * Sets the value of {@link CfnFrameworkProps#getFrameworkControls}
         * @param frameworkControls Contains detailed information about all of the controls of a framework. This parameter is required.
         *                          Each framework must contain at least one control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkControls(java.util.List<? extends java.lang.Object> frameworkControls) {
            this.frameworkControls = frameworkControls;
            return this;
        }

        /**
         * Sets the value of {@link CfnFrameworkProps#getFrameworkDescription}
         * @param frameworkDescription An optional description of the framework with a maximum 1,024 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkDescription(java.lang.String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnFrameworkProps#getFrameworkName}
         * @param frameworkName The unique name of a framework.
         *                      This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkName(java.lang.String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFrameworkProps#getFrameworkTags}
         * @param frameworkTags The tags to assign to your framework.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder frameworkTags(java.util.List<? extends software.amazon.awscdk.CfnTag> frameworkTags) {
            this.frameworkTags = (java.util.List<software.amazon.awscdk.CfnTag>)frameworkTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFrameworkProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFrameworkProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFrameworkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFrameworkProps {
        private final java.lang.Object frameworkControls;
        private final java.lang.String frameworkDescription;
        private final java.lang.String frameworkName;
        private final java.util.List<software.amazon.awscdk.CfnTag> frameworkTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.frameworkControls = software.amazon.jsii.Kernel.get(this, "frameworkControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.frameworkDescription = software.amazon.jsii.Kernel.get(this, "frameworkDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.frameworkName = software.amazon.jsii.Kernel.get(this, "frameworkName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.frameworkTags = software.amazon.jsii.Kernel.get(this, "frameworkTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.frameworkControls = java.util.Objects.requireNonNull(builder.frameworkControls, "frameworkControls is required");
            this.frameworkDescription = builder.frameworkDescription;
            this.frameworkName = builder.frameworkName;
            this.frameworkTags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.frameworkTags;
        }

        @Override
        public final java.lang.Object getFrameworkControls() {
            return this.frameworkControls;
        }

        @Override
        public final java.lang.String getFrameworkDescription() {
            return this.frameworkDescription;
        }

        @Override
        public final java.lang.String getFrameworkName() {
            return this.frameworkName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getFrameworkTags() {
            return this.frameworkTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("frameworkControls", om.valueToTree(this.getFrameworkControls()));
            if (this.getFrameworkDescription() != null) {
                data.set("frameworkDescription", om.valueToTree(this.getFrameworkDescription()));
            }
            if (this.getFrameworkName() != null) {
                data.set("frameworkName", om.valueToTree(this.getFrameworkName()));
            }
            if (this.getFrameworkTags() != null) {
                data.set("frameworkTags", om.valueToTree(this.getFrameworkTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnFrameworkProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFrameworkProps.Jsii$Proxy that = (CfnFrameworkProps.Jsii$Proxy) o;

            if (!frameworkControls.equals(that.frameworkControls)) return false;
            if (this.frameworkDescription != null ? !this.frameworkDescription.equals(that.frameworkDescription) : that.frameworkDescription != null) return false;
            if (this.frameworkName != null ? !this.frameworkName.equals(that.frameworkName) : that.frameworkName != null) return false;
            return this.frameworkTags != null ? this.frameworkTags.equals(that.frameworkTags) : that.frameworkTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.frameworkControls.hashCode();
            result = 31 * result + (this.frameworkDescription != null ? this.frameworkDescription.hashCode() : 0);
            result = 31 * result + (this.frameworkName != null ? this.frameworkName.hashCode() : 0);
            result = 31 * result + (this.frameworkTags != null ? this.frameworkTags.hashCode() : 0);
            return result;
        }
    }
}
