package software.amazon.awscdk.services.batch;

/**
 * A Kubernetes EmptyDir volume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.batch.*;
 * Size size;
 * EmptyDirVolume emptyDirVolume = EmptyDirVolume.Builder.create()
 *         .name("name")
 *         // the properties below are optional
 *         .medium(EmptyDirMediumType.DISK)
 *         .mountPath("mountPath")
 *         .readonly(false)
 *         .sizeLimit(size)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">https://kubernetes.io/docs/concepts/storage/volumes/#emptydir</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:02.776Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EmptyDirVolume")
public class EmptyDirVolume extends software.amazon.awscdk.services.batch.EksVolume {

    protected EmptyDirVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmptyDirVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EmptyDirVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EmptyDirVolumeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Returns <code>true</code> if <code>x</code> is an EmptyDirVolume, <code>false</code> otherwise.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isEmptyDirVolume(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.EmptyDirVolume.class, "isEmptyDirVolume", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * The storage type to use for this Volume.
     * <p>
     * Default: `EmptyDirMediumType.DISK`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.EmptyDirMediumType getMedium() {
        return software.amazon.jsii.Kernel.get(this, "medium", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EmptyDirMediumType.class));
    }

    /**
     * The maximum size for this Volume.
     * <p>
     * Default: - no size limit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getSizeLimit() {
        return software.amazon.jsii.Kernel.get(this, "sizeLimit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.EmptyDirVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.EmptyDirVolume> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.batch.EmptyDirVolumeOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.batch.EmptyDirVolumeOptions.Builder();
        }

        /**
         * The name of this volume.
         * <p>
         * The name must be a valid DNS subdomain name.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names</a>
         * @param name The name of this volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.options.name(name);
            return this;
        }

        /**
         * The path on the container where the volume is mounted.
         * <p>
         * Default: - the volume is not mounted
         * <p>
         * @return {@code this}
         * @param mountPath The path on the container where the volume is mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountPath(final java.lang.String mountPath) {
            this.options.mountPath(mountPath);
            return this;
        }

        /**
         * If specified, the container has readonly access to the volume.
         * <p>
         * Otherwise, the container has read/write access.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readonly If specified, the container has readonly access to the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(final java.lang.Boolean readonly) {
            this.options.readonly(readonly);
            return this;
        }

        /**
         * The storage type to use for this Volume.
         * <p>
         * Default: `EmptyDirMediumType.DISK`
         * <p>
         * @return {@code this}
         * @param medium The storage type to use for this Volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder medium(final software.amazon.awscdk.services.batch.EmptyDirMediumType medium) {
            this.options.medium(medium);
            return this;
        }

        /**
         * The maximum size for this Volume.
         * <p>
         * Default: - no size limit
         * <p>
         * @return {@code this}
         * @param sizeLimit The maximum size for this Volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sizeLimit(final software.amazon.awscdk.Size sizeLimit) {
            this.options.sizeLimit(sizeLimit);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.EmptyDirVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.EmptyDirVolume build() {
            return new software.amazon.awscdk.services.batch.EmptyDirVolume(
                this.options.build()
            );
        }
    }
}
