package software.amazon.awscdk.services.batch;

/**
 * Specifies an action that AWS Batch will take after the job has remained at the head of the queue in the specified state for longer than the specified time.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.batch.*;
 * JobStateTimeLimitAction jobStateTimeLimitAction = JobStateTimeLimitAction.builder()
 *         .maxTime(Duration.minutes(30))
 *         .reason(JobStateTimeLimitActionsReason.INSUFFICIENT_INSTANCE_CAPACITY)
 *         // the properties below are optional
 *         .action(JobStateTimeLimitActionsAction.CANCEL)
 *         .state(JobStateTimeLimitActionsState.RUNNABLE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:02.825Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.JobStateTimeLimitAction")
@software.amazon.jsii.Jsii.Proxy(JobStateTimeLimitAction.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JobStateTimeLimitAction extends software.amazon.jsii.JsiiSerializable {

    /**
     * The approximate amount of time, that must pass with the job in the specified state before the action is taken.
     * <p>
     * The minimum value is 10 minutes and the maximum value is 24 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getMaxTime();

    /**
     * The reason to log for the action being taken.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.JobStateTimeLimitActionsReason getReason();

    /**
     * The action to take when a job is at the head of the job queue in the specified state for the specified period of time.
     * <p>
     * Default: JobStateTimeLimitActionsAction.CANCEL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.JobStateTimeLimitActionsAction getAction() {
        return null;
    }

    /**
     * The state of the job needed to trigger the action.
     * <p>
     * Default: JobStateTimeLimitActionsState.RUNNABLE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.JobStateTimeLimitActionsState getState() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobStateTimeLimitAction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobStateTimeLimitAction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JobStateTimeLimitAction> {
        software.amazon.awscdk.Duration maxTime;
        software.amazon.awscdk.services.batch.JobStateTimeLimitActionsReason reason;
        software.amazon.awscdk.services.batch.JobStateTimeLimitActionsAction action;
        software.amazon.awscdk.services.batch.JobStateTimeLimitActionsState state;

        /**
         * Sets the value of {@link JobStateTimeLimitAction#getMaxTime}
         * @param maxTime The approximate amount of time, that must pass with the job in the specified state before the action is taken. This parameter is required.
         *                The minimum value is 10 minutes and the maximum value is 24 hours.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxTime(software.amazon.awscdk.Duration maxTime) {
            this.maxTime = maxTime;
            return this;
        }

        /**
         * Sets the value of {@link JobStateTimeLimitAction#getReason}
         * @param reason The reason to log for the action being taken. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reason(software.amazon.awscdk.services.batch.JobStateTimeLimitActionsReason reason) {
            this.reason = reason;
            return this;
        }

        /**
         * Sets the value of {@link JobStateTimeLimitAction#getAction}
         * @param action The action to take when a job is at the head of the job queue in the specified state for the specified period of time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(software.amazon.awscdk.services.batch.JobStateTimeLimitActionsAction action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link JobStateTimeLimitAction#getState}
         * @param state The state of the job needed to trigger the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(software.amazon.awscdk.services.batch.JobStateTimeLimitActionsState state) {
            this.state = state;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobStateTimeLimitAction}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JobStateTimeLimitAction build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobStateTimeLimitAction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobStateTimeLimitAction {
        private final software.amazon.awscdk.Duration maxTime;
        private final software.amazon.awscdk.services.batch.JobStateTimeLimitActionsReason reason;
        private final software.amazon.awscdk.services.batch.JobStateTimeLimitActionsAction action;
        private final software.amazon.awscdk.services.batch.JobStateTimeLimitActionsState state;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxTime = software.amazon.jsii.Kernel.get(this, "maxTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.reason = software.amazon.jsii.Kernel.get(this, "reason", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.JobStateTimeLimitActionsReason.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.JobStateTimeLimitActionsAction.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.JobStateTimeLimitActionsState.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxTime = java.util.Objects.requireNonNull(builder.maxTime, "maxTime is required");
            this.reason = java.util.Objects.requireNonNull(builder.reason, "reason is required");
            this.action = builder.action;
            this.state = builder.state;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxTime() {
            return this.maxTime;
        }

        @Override
        public final software.amazon.awscdk.services.batch.JobStateTimeLimitActionsReason getReason() {
            return this.reason;
        }

        @Override
        public final software.amazon.awscdk.services.batch.JobStateTimeLimitActionsAction getAction() {
            return this.action;
        }

        @Override
        public final software.amazon.awscdk.services.batch.JobStateTimeLimitActionsState getState() {
            return this.state;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxTime", om.valueToTree(this.getMaxTime()));
            data.set("reason", om.valueToTree(this.getReason()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.JobStateTimeLimitAction"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobStateTimeLimitAction.Jsii$Proxy that = (JobStateTimeLimitAction.Jsii$Proxy) o;

            if (!maxTime.equals(that.maxTime)) return false;
            if (!reason.equals(that.reason)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            return this.state != null ? this.state.equals(that.state) : that.state == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxTime.hashCode();
            result = 31 * result + (this.reason.hashCode());
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            return result;
        }
    }
}
