package software.amazon.awscdk.services.bedrock;

/**
 * Properties for defining a <code>CfnIntelligentPromptRouter</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnIntelligentPromptRouterProps cfnIntelligentPromptRouterProps = CfnIntelligentPromptRouterProps.builder()
 *         .fallbackModel(PromptRouterTargetModelProperty.builder()
 *                 .modelArn("modelArn")
 *                 .build())
 *         .models(List.of(PromptRouterTargetModelProperty.builder()
 *                 .modelArn("modelArn")
 *                 .build()))
 *         .promptRouterName("promptRouterName")
 *         .routingCriteria(RoutingCriteriaProperty.builder()
 *                 .responseQualityDifference(123)
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.049Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnIntelligentPromptRouterProps")
@software.amazon.jsii.Jsii.Proxy(CfnIntelligentPromptRouterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIntelligentPromptRouterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The default model to use when the routing criteria is not met.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-fallbackmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-fallbackmodel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFallbackModel();

    /**
     * A list of foundation models that the prompt router can route requests to.
     * <p>
     * At least one model must be specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-models">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-models</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModels();

    /**
     * The name of the prompt router.
     * <p>
     * The name must be unique within your AWS account in the current region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-promptroutername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-promptroutername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPromptRouterName();

    /**
     * Routing criteria for a prompt router.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-routingcriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-routingcriteria</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRoutingCriteria();

    /**
     * An optional description of the prompt router to help identify its purpose.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource as tags.
     * <p>
     * You can use tags to categorize and manage your AWS resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-intelligentpromptrouter.html#cfn-bedrock-intelligentpromptrouter-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIntelligentPromptRouterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIntelligentPromptRouterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIntelligentPromptRouterProps> {
        java.lang.Object fallbackModel;
        java.lang.Object models;
        java.lang.String promptRouterName;
        java.lang.Object routingCriteria;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnIntelligentPromptRouterProps#getFallbackModel}
         * @param fallbackModel The default model to use when the routing criteria is not met. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fallbackModel(software.amazon.awscdk.IResolvable fallbackModel) {
            this.fallbackModel = fallbackModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntelligentPromptRouterProps#getFallbackModel}
         * @param fallbackModel The default model to use when the routing criteria is not met. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fallbackModel(software.amazon.awscdk.services.bedrock.CfnIntelligentPromptRouter.PromptRouterTargetModelProperty fallbackModel) {
            this.fallbackModel = fallbackModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntelligentPromptRouterProps#getModels}
         * @param models A list of foundation models that the prompt router can route requests to. This parameter is required.
         *               At least one model must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder models(software.amazon.awscdk.IResolvable models) {
            this.models = models;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntelligentPromptRouterProps#getModels}
         * @param models A list of foundation models that the prompt router can route requests to. This parameter is required.
         *               At least one model must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder models(java.util.List<? extends java.lang.Object> models) {
            this.models = models;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntelligentPromptRouterProps#getPromptRouterName}
         * @param promptRouterName The name of the prompt router. This parameter is required.
         *                         The name must be unique within your AWS account in the current region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder promptRouterName(java.lang.String promptRouterName) {
            this.promptRouterName = promptRouterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntelligentPromptRouterProps#getRoutingCriteria}
         * @param routingCriteria Routing criteria for a prompt router. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingCriteria(software.amazon.awscdk.IResolvable routingCriteria) {
            this.routingCriteria = routingCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntelligentPromptRouterProps#getRoutingCriteria}
         * @param routingCriteria Routing criteria for a prompt router. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingCriteria(software.amazon.awscdk.services.bedrock.CfnIntelligentPromptRouter.RoutingCriteriaProperty routingCriteria) {
            this.routingCriteria = routingCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntelligentPromptRouterProps#getDescription}
         * @param description An optional description of the prompt router to help identify its purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntelligentPromptRouterProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource as tags.
         *             You can use tags to categorize and manage your AWS resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIntelligentPromptRouterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIntelligentPromptRouterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIntelligentPromptRouterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIntelligentPromptRouterProps {
        private final java.lang.Object fallbackModel;
        private final java.lang.Object models;
        private final java.lang.String promptRouterName;
        private final java.lang.Object routingCriteria;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fallbackModel = software.amazon.jsii.Kernel.get(this, "fallbackModel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.models = software.amazon.jsii.Kernel.get(this, "models", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.promptRouterName = software.amazon.jsii.Kernel.get(this, "promptRouterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routingCriteria = software.amazon.jsii.Kernel.get(this, "routingCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fallbackModel = java.util.Objects.requireNonNull(builder.fallbackModel, "fallbackModel is required");
            this.models = java.util.Objects.requireNonNull(builder.models, "models is required");
            this.promptRouterName = java.util.Objects.requireNonNull(builder.promptRouterName, "promptRouterName is required");
            this.routingCriteria = java.util.Objects.requireNonNull(builder.routingCriteria, "routingCriteria is required");
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getFallbackModel() {
            return this.fallbackModel;
        }

        @Override
        public final java.lang.Object getModels() {
            return this.models;
        }

        @Override
        public final java.lang.String getPromptRouterName() {
            return this.promptRouterName;
        }

        @Override
        public final java.lang.Object getRoutingCriteria() {
            return this.routingCriteria;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fallbackModel", om.valueToTree(this.getFallbackModel()));
            data.set("models", om.valueToTree(this.getModels()));
            data.set("promptRouterName", om.valueToTree(this.getPromptRouterName()));
            data.set("routingCriteria", om.valueToTree(this.getRoutingCriteria()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnIntelligentPromptRouterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIntelligentPromptRouterProps.Jsii$Proxy that = (CfnIntelligentPromptRouterProps.Jsii$Proxy) o;

            if (!fallbackModel.equals(that.fallbackModel)) return false;
            if (!models.equals(that.models)) return false;
            if (!promptRouterName.equals(that.promptRouterName)) return false;
            if (!routingCriteria.equals(that.routingCriteria)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fallbackModel.hashCode();
            result = 31 * result + (this.models.hashCode());
            result = 31 * result + (this.promptRouterName.hashCode());
            result = 31 * result + (this.routingCriteria.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
