package software.amazon.awscdk.services.ce;

/**
 * Properties for defining a <code>CfnAnomalyMonitor</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ce.*;
 * CfnAnomalyMonitorProps cfnAnomalyMonitorProps = CfnAnomalyMonitorProps.builder()
 *         .monitorName("monitorName")
 *         .monitorType("monitorType")
 *         // the properties below are optional
 *         .monitorDimension("monitorDimension")
 *         .monitorSpecification("monitorSpecification")
 *         .resourceTags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.181Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ce.CfnAnomalyMonitorProps")
@software.amazon.jsii.Jsii.Proxy(CfnAnomalyMonitorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAnomalyMonitorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the monitor.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-monitorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-monitorname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMonitorName();

    /**
     * The possible type values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-monitortype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-monitortype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMonitorType();

    /**
     * The dimensions to evaluate.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-monitordimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-monitordimension</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMonitorDimension() {
        return null;
    }

    /**
     * The array of <code>MonitorSpecification</code> in JSON array format.
     * <p>
     * For instance, you can use <code>MonitorSpecification</code> to specify a tag, Cost Category, or linked account for your custom anomaly monitor. For further information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#aws-resource-ce-anomalymonitor--examples">Examples</a> section of this page.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-monitorspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-monitorspecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMonitorSpecification() {
        return null;
    }

    /**
     * Tags to assign to monitor.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#cfn-ce-anomalymonitor-resourcetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ce.CfnAnomalyMonitor.ResourceTagProperty> getResourceTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAnomalyMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAnomalyMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAnomalyMonitorProps> {
        java.lang.String monitorName;
        java.lang.String monitorType;
        java.lang.String monitorDimension;
        java.lang.String monitorSpecification;
        java.util.List<software.amazon.awscdk.services.ce.CfnAnomalyMonitor.ResourceTagProperty> resourceTags;

        /**
         * Sets the value of {@link CfnAnomalyMonitorProps#getMonitorName}
         * @param monitorName The name of the monitor. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorName(java.lang.String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyMonitorProps#getMonitorType}
         * @param monitorType The possible type values. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorType(java.lang.String monitorType) {
            this.monitorType = monitorType;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyMonitorProps#getMonitorDimension}
         * @param monitorDimension The dimensions to evaluate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorDimension(java.lang.String monitorDimension) {
            this.monitorDimension = monitorDimension;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyMonitorProps#getMonitorSpecification}
         * @param monitorSpecification The array of <code>MonitorSpecification</code> in JSON array format.
         *                             For instance, you can use <code>MonitorSpecification</code> to specify a tag, Cost Category, or linked account for your custom anomaly monitor. For further information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-anomalymonitor.html#aws-resource-ce-anomalymonitor--examples">Examples</a> section of this page.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorSpecification(java.lang.String monitorSpecification) {
            this.monitorSpecification = monitorSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyMonitorProps#getResourceTags}
         * @param resourceTags Tags to assign to monitor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resourceTags(java.util.List<? extends software.amazon.awscdk.services.ce.CfnAnomalyMonitor.ResourceTagProperty> resourceTags) {
            this.resourceTags = (java.util.List<software.amazon.awscdk.services.ce.CfnAnomalyMonitor.ResourceTagProperty>)resourceTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAnomalyMonitorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAnomalyMonitorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAnomalyMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAnomalyMonitorProps {
        private final java.lang.String monitorName;
        private final java.lang.String monitorType;
        private final java.lang.String monitorDimension;
        private final java.lang.String monitorSpecification;
        private final java.util.List<software.amazon.awscdk.services.ce.CfnAnomalyMonitor.ResourceTagProperty> resourceTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.monitorName = software.amazon.jsii.Kernel.get(this, "monitorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.monitorType = software.amazon.jsii.Kernel.get(this, "monitorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.monitorDimension = software.amazon.jsii.Kernel.get(this, "monitorDimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.monitorSpecification = software.amazon.jsii.Kernel.get(this, "monitorSpecification", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ce.CfnAnomalyMonitor.ResourceTagProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.monitorName = java.util.Objects.requireNonNull(builder.monitorName, "monitorName is required");
            this.monitorType = java.util.Objects.requireNonNull(builder.monitorType, "monitorType is required");
            this.monitorDimension = builder.monitorDimension;
            this.monitorSpecification = builder.monitorSpecification;
            this.resourceTags = (java.util.List<software.amazon.awscdk.services.ce.CfnAnomalyMonitor.ResourceTagProperty>)builder.resourceTags;
        }

        @Override
        public final java.lang.String getMonitorName() {
            return this.monitorName;
        }

        @Override
        public final java.lang.String getMonitorType() {
            return this.monitorType;
        }

        @Override
        public final java.lang.String getMonitorDimension() {
            return this.monitorDimension;
        }

        @Override
        public final java.lang.String getMonitorSpecification() {
            return this.monitorSpecification;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ce.CfnAnomalyMonitor.ResourceTagProperty> getResourceTags() {
            return this.resourceTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("monitorName", om.valueToTree(this.getMonitorName()));
            data.set("monitorType", om.valueToTree(this.getMonitorType()));
            if (this.getMonitorDimension() != null) {
                data.set("monitorDimension", om.valueToTree(this.getMonitorDimension()));
            }
            if (this.getMonitorSpecification() != null) {
                data.set("monitorSpecification", om.valueToTree(this.getMonitorSpecification()));
            }
            if (this.getResourceTags() != null) {
                data.set("resourceTags", om.valueToTree(this.getResourceTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ce.CfnAnomalyMonitorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAnomalyMonitorProps.Jsii$Proxy that = (CfnAnomalyMonitorProps.Jsii$Proxy) o;

            if (!monitorName.equals(that.monitorName)) return false;
            if (!monitorType.equals(that.monitorType)) return false;
            if (this.monitorDimension != null ? !this.monitorDimension.equals(that.monitorDimension) : that.monitorDimension != null) return false;
            if (this.monitorSpecification != null ? !this.monitorSpecification.equals(that.monitorSpecification) : that.monitorSpecification != null) return false;
            return this.resourceTags != null ? this.resourceTags.equals(that.resourceTags) : that.resourceTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.monitorName.hashCode();
            result = 31 * result + (this.monitorType.hashCode());
            result = 31 * result + (this.monitorDimension != null ? this.monitorDimension.hashCode() : 0);
            result = 31 * result + (this.monitorSpecification != null ? this.monitorSpecification.hashCode() : 0);
            result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
            return result;
        }
    }
}
