package software.amazon.awscdk.services.cleanrooms;

/**
 * Properties for defining a <code>CfnConfiguredTableAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnConfiguredTableAssociationProps cfnConfiguredTableAssociationProps = CfnConfiguredTableAssociationProps.builder()
 *         .configuredTableIdentifier("configuredTableIdentifier")
 *         .membershipIdentifier("membershipIdentifier")
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .configuredTableAssociationAnalysisRules(List.of(ConfiguredTableAssociationAnalysisRuleProperty.builder()
 *                 .policy(ConfiguredTableAssociationAnalysisRulePolicyProperty.builder()
 *                         .v1(ConfiguredTableAssociationAnalysisRulePolicyV1Property.builder()
 *                                 .aggregation(ConfiguredTableAssociationAnalysisRuleAggregationProperty.builder()
 *                                         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
 *                                         .allowedResultReceivers(List.of("allowedResultReceivers"))
 *                                         .build())
 *                                 .custom(ConfiguredTableAssociationAnalysisRuleCustomProperty.builder()
 *                                         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
 *                                         .allowedResultReceivers(List.of("allowedResultReceivers"))
 *                                         .build())
 *                                 .list(ConfiguredTableAssociationAnalysisRuleListProperty.builder()
 *                                         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
 *                                         .allowedResultReceivers(List.of("allowedResultReceivers"))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .type("type")
 *                 .build()))
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.263Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfiguredTableAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfiguredTableAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A unique identifier for the configured table to be associated to.
     * <p>
     * Currently accepts a configured table ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfiguredTableIdentifier();

    /**
     * The unique ID for the membership this configured table association belongs to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-membershipidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-membershipidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMembershipIdentifier();

    /**
     * The name of the configured table association, in lowercase.
     * <p>
     * The table is identified by this name when running protected queries against the underlying data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The service will assume this role to access catalog metadata and query the table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * An analysis rule for a configured table association.
     * <p>
     * This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <em>collaboration analysis rule</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguredTableAssociationAnalysisRules() {
        return null;
    }

    /**
     * A description of the configured table association.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfiguredTableAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfiguredTableAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfiguredTableAssociationProps> {
        java.lang.String configuredTableIdentifier;
        java.lang.String membershipIdentifier;
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.Object configuredTableAssociationAnalysisRules;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConfiguredTableAssociationProps#getConfiguredTableIdentifier}
         * @param configuredTableIdentifier A unique identifier for the configured table to be associated to. This parameter is required.
         *                                  Currently accepts a configured table ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableIdentifier(java.lang.String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableAssociationProps#getMembershipIdentifier}
         * @param membershipIdentifier The unique ID for the membership this configured table association belongs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipIdentifier(java.lang.String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableAssociationProps#getName}
         * @param name The name of the configured table association, in lowercase. This parameter is required.
         *             The table is identified by this name when running protected queries against the underlying data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableAssociationProps#getRoleArn}
         * @param roleArn The service will assume this role to access catalog metadata and query the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableAssociationProps#getConfiguredTableAssociationAnalysisRules}
         * @param configuredTableAssociationAnalysisRules An analysis rule for a configured table association.
         *                                                This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <em>collaboration analysis rule</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableAssociationAnalysisRules(software.amazon.awscdk.IResolvable configuredTableAssociationAnalysisRules) {
            this.configuredTableAssociationAnalysisRules = configuredTableAssociationAnalysisRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableAssociationProps#getConfiguredTableAssociationAnalysisRules}
         * @param configuredTableAssociationAnalysisRules An analysis rule for a configured table association.
         *                                                This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <em>collaboration analysis rule</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableAssociationAnalysisRules(java.util.List<? extends java.lang.Object> configuredTableAssociationAnalysisRules) {
            this.configuredTableAssociationAnalysisRules = configuredTableAssociationAnalysisRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableAssociationProps#getDescription}
         * @param description A description of the configured table association.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableAssociationProps#getTags}
         * @param tags An optional label that you can assign to a resource when you create it.
         *             Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfiguredTableAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfiguredTableAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfiguredTableAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfiguredTableAssociationProps {
        private final java.lang.String configuredTableIdentifier;
        private final java.lang.String membershipIdentifier;
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.Object configuredTableAssociationAnalysisRules;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuredTableIdentifier = software.amazon.jsii.Kernel.get(this, "configuredTableIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.membershipIdentifier = software.amazon.jsii.Kernel.get(this, "membershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuredTableAssociationAnalysisRules = software.amazon.jsii.Kernel.get(this, "configuredTableAssociationAnalysisRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuredTableIdentifier = java.util.Objects.requireNonNull(builder.configuredTableIdentifier, "configuredTableIdentifier is required");
            this.membershipIdentifier = java.util.Objects.requireNonNull(builder.membershipIdentifier, "membershipIdentifier is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.configuredTableAssociationAnalysisRules = builder.configuredTableAssociationAnalysisRules;
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getConfiguredTableIdentifier() {
            return this.configuredTableIdentifier;
        }

        @Override
        public final java.lang.String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getConfiguredTableAssociationAnalysisRules() {
            return this.configuredTableAssociationAnalysisRules;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuredTableIdentifier", om.valueToTree(this.getConfiguredTableIdentifier()));
            data.set("membershipIdentifier", om.valueToTree(this.getMembershipIdentifier()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getConfiguredTableAssociationAnalysisRules() != null) {
                data.set("configuredTableAssociationAnalysisRules", om.valueToTree(this.getConfiguredTableAssociationAnalysisRules()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfiguredTableAssociationProps.Jsii$Proxy that = (CfnConfiguredTableAssociationProps.Jsii$Proxy) o;

            if (!configuredTableIdentifier.equals(that.configuredTableIdentifier)) return false;
            if (!membershipIdentifier.equals(that.membershipIdentifier)) return false;
            if (!name.equals(that.name)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.configuredTableAssociationAnalysisRules != null ? !this.configuredTableAssociationAnalysisRules.equals(that.configuredTableAssociationAnalysisRules) : that.configuredTableAssociationAnalysisRules != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configuredTableIdentifier.hashCode();
            result = 31 * result + (this.membershipIdentifier.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.configuredTableAssociationAnalysisRules != null ? this.configuredTableAssociationAnalysisRules.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
