package software.amazon.awscdk.services.cloudfront;

/**
 * This resource is deprecated.
 * <p>
 * Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, <a href="https://docs.aws.amazon.com/ann.jspa?annID=7356">read the announcement</a> on the Amazon CloudFront discussion forum.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnStreamingDistribution cfnStreamingDistribution = CfnStreamingDistribution.Builder.create(this, "MyCfnStreamingDistribution")
 *         .streamingDistributionConfig(StreamingDistributionConfigProperty.builder()
 *                 .comment("comment")
 *                 .enabled(false)
 *                 .s3Origin(S3OriginProperty.builder()
 *                         .domainName("domainName")
 *                         .originAccessIdentity("originAccessIdentity")
 *                         .build())
 *                 .trustedSigners(TrustedSignersProperty.builder()
 *                         .enabled(false)
 *                         // the properties below are optional
 *                         .awsAccountNumbers(List.of("awsAccountNumbers"))
 *                         .build())
 *                 // the properties below are optional
 *                 .aliases(List.of("aliases"))
 *                 .logging(LoggingProperty.builder()
 *                         .bucket("bucket")
 *                         .enabled(false)
 *                         .prefix("prefix")
 *                         .build())
 *                 .priceClass("priceClass")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.515Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution")
public class CfnStreamingDistribution extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnStreamingDistribution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStreamingDistribution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStreamingDistribution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnStreamingDistributionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The domain name of the resource, such as <code>d111111abcdef8.cloudfront.net</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainName() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The current configuration information for the RTMP distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStreamingDistributionConfig() {
        return software.amazon.jsii.Kernel.get(this, "streamingDistributionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The current configuration information for the RTMP distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamingDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "streamingDistributionConfig", java.util.Objects.requireNonNull(value, "streamingDistributionConfig is required"));
    }

    /**
     * The current configuration information for the RTMP distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamingDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "streamingDistributionConfig", java.util.Objects.requireNonNull(value, "streamingDistributionConfig is required"));
    }

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A complex type that controls whether access logs are written for the streaming distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * LoggingProperty loggingProperty = LoggingProperty.builder()
     *         .bucket("bucket")
     *         .enabled(false)
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.LoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket to store the access logs in, for example, <code>amzn-s3-demo-bucket.s3.amazonaws.com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html#cfn-cloudfront-streamingdistribution-logging-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html#cfn-cloudfront-streamingdistribution-logging-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket.
         * <p>
         * If you don't want to enable logging when you create a streaming distribution or if you want to disable logging for an existing streaming distribution, specify <code>false</code> for <code>Enabled</code> , and specify <code>empty Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>Prefix</code> , the values are automatically deleted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html#cfn-cloudfront-streamingdistribution-logging-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html#cfn-cloudfront-streamingdistribution-logging-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example, <code>myprefix/</code> .
         * <p>
         * If you want to enable logging, but you don't want to specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html#cfn-cloudfront-streamingdistribution-logging-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html#cfn-cloudfront-streamingdistribution-logging-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrefix();

        /**
         * @return a {@link Builder} of {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingProperty> {
            java.lang.String bucket;
            java.lang.Object enabled;
            java.lang.String prefix;

            /**
             * Sets the value of {@link LoggingProperty#getBucket}
             * @param bucket The Amazon S3 bucket to store the access logs in, for example, <code>amzn-s3-demo-bucket.s3.amazonaws.com</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getEnabled}
             * @param enabled Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. This parameter is required.
             *                If you don't want to enable logging when you create a streaming distribution or if you want to disable logging for an existing streaming distribution, specify <code>false</code> for <code>Enabled</code> , and specify <code>empty Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>Prefix</code> , the values are automatically deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getEnabled}
             * @param enabled Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. This parameter is required.
             *                If you don't want to enable logging when you create a streaming distribution or if you want to disable logging for an existing streaming distribution, specify <code>false</code> for <code>Enabled</code> , and specify <code>empty Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>Prefix</code> , the values are automatically deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getPrefix}
             * @param prefix An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example, <code>myprefix/</code> . This parameter is required.
             *               If you want to enable logging, but you don't want to specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProperty {
            private final java.lang.String bucket;
            private final java.lang.Object enabled;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.prefix = java.util.Objects.requireNonNull(builder.prefix, "prefix is required");
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("prefix", om.valueToTree(this.getPrefix()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.LoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingProperty.Jsii$Proxy that = (LoggingProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!enabled.equals(that.enabled)) return false;
                return this.prefix.equals(that.prefix);
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                result = 31 * result + (this.prefix.hashCode());
                return result;
            }
        }
    }
    /**
     * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * S3OriginProperty s3OriginProperty = S3OriginProperty.builder()
     *         .domainName("domainName")
     *         .originAccessIdentity("originAccessIdentity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-s3origin.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-s3origin.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.S3OriginProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The DNS name of the Amazon S3 origin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-s3origin.html#cfn-cloudfront-streamingdistribution-s3origin-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-s3origin.html#cfn-cloudfront-streamingdistribution-s3origin-domainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * The CloudFront origin access identity to associate with the distribution.
         * <p>
         * Use an origin access identity to configure the distribution so that end users can only access objects in an Amazon S3 bucket through CloudFront.
         * <p>
         * If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.
         * <p>
         * To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty <code>OriginAccessIdentity</code> element.
         * <p>
         * To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-s3origin.html#cfn-cloudfront-streamingdistribution-s3origin-originaccessidentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-s3origin.html#cfn-cloudfront-streamingdistribution-s3origin-originaccessidentity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginAccessIdentity();

        /**
         * @return a {@link Builder} of {@link S3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OriginProperty> {
            java.lang.String domainName;
            java.lang.String originAccessIdentity;

            /**
             * Sets the value of {@link S3OriginProperty#getDomainName}
             * @param domainName The DNS name of the Amazon S3 origin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link S3OriginProperty#getOriginAccessIdentity}
             * @param originAccessIdentity The CloudFront origin access identity to associate with the distribution. This parameter is required.
             *                             Use an origin access identity to configure the distribution so that end users can only access objects in an Amazon S3 bucket through CloudFront.
             *                             <p>
             *                             If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.
             *                             <p>
             *                             To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty <code>OriginAccessIdentity</code> element.
             *                             <p>
             *                             To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
             *                             <p>
             *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessIdentity(java.lang.String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OriginProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OriginProperty {
            private final java.lang.String domainName;
            private final java.lang.String originAccessIdentity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originAccessIdentity = software.amazon.jsii.Kernel.get(this, "originAccessIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
                this.originAccessIdentity = java.util.Objects.requireNonNull(builder.originAccessIdentity, "originAccessIdentity is required");
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getOriginAccessIdentity() {
                return this.originAccessIdentity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainName", om.valueToTree(this.getDomainName()));
                data.set("originAccessIdentity", om.valueToTree(this.getOriginAccessIdentity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.S3OriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OriginProperty.Jsii$Proxy that = (S3OriginProperty.Jsii$Proxy) o;

                if (!domainName.equals(that.domainName)) return false;
                return this.originAccessIdentity.equals(that.originAccessIdentity);
            }

            @Override
            public final int hashCode() {
                int result = this.domainName.hashCode();
                result = 31 * result + (this.originAccessIdentity.hashCode());
                return result;
            }
        }
    }
    /**
     * The RTMP distribution's configuration information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * StreamingDistributionConfigProperty streamingDistributionConfigProperty = StreamingDistributionConfigProperty.builder()
     *         .comment("comment")
     *         .enabled(false)
     *         .s3Origin(S3OriginProperty.builder()
     *                 .domainName("domainName")
     *                 .originAccessIdentity("originAccessIdentity")
     *                 .build())
     *         .trustedSigners(TrustedSignersProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .awsAccountNumbers(List.of("awsAccountNumbers"))
     *                 .build())
     *         // the properties below are optional
     *         .aliases(List.of("aliases"))
     *         .logging(LoggingProperty.builder()
     *                 .bucket("bucket")
     *                 .enabled(false)
     *                 .prefix("prefix")
     *                 .build())
     *         .priceClass("priceClass")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamingDistributionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamingDistributionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Any comments you want to include about the streaming distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-comment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-comment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComment();

        /**
         * Whether the streaming distribution is enabled to accept user requests for content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-s3origin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-s3origin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Origin();

        /**
         * A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private content.
         * <p>
         * If you want the distribution to use signed URLs, include this element; if you want the distribution to use public URLs, remove this element. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-trustedsigners">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-trustedsigners</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrustedSigners();

        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-aliases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-aliases</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliases() {
            return null;
        }

        /**
         * A complex type that controls whether access logs are written for the streaming distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-logging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
            return null;
        }

        /**
         * A complex type that contains information about price class for this streaming distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-priceclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-priceclass</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPriceClass() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamingDistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamingDistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamingDistributionConfigProperty> {
            java.lang.String comment;
            java.lang.Object enabled;
            java.lang.Object s3Origin;
            java.lang.Object trustedSigners;
            java.util.List<java.lang.String> aliases;
            java.lang.Object logging;
            java.lang.String priceClass;

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getComment}
             * @param comment Any comments you want to include about the streaming distribution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getEnabled}
             * @param enabled Whether the streaming distribution is enabled to accept user requests for content. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getEnabled}
             * @param enabled Whether the streaming distribution is enabled to accept user requests for content. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getS3Origin}
             * @param s3Origin A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Origin(software.amazon.awscdk.IResolvable s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getS3Origin}
             * @param s3Origin A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Origin(software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.S3OriginProperty s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getTrustedSigners}
             * @param trustedSigners A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private content. This parameter is required.
             *                       If you want the distribution to use signed URLs, include this element; if you want the distribution to use public URLs, remove this element. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(software.amazon.awscdk.IResolvable trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getTrustedSigners}
             * @param trustedSigners A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private content. This parameter is required.
             *                       If you want the distribution to use signed URLs, include this element; if you want the distribution to use public URLs, remove this element. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.TrustedSignersProperty trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getAliases}
             * @param aliases A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aliases(java.util.List<java.lang.String> aliases) {
                this.aliases = aliases;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getLogging}
             * @param logging A complex type that controls whether access logs are written for the streaming distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.IResolvable logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getLogging}
             * @param logging A complex type that controls whether access logs are written for the streaming distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.LoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getPriceClass}
             * @param priceClass A complex type that contains information about price class for this streaming distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priceClass(java.lang.String priceClass) {
                this.priceClass = priceClass;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamingDistributionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamingDistributionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamingDistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamingDistributionConfigProperty {
            private final java.lang.String comment;
            private final java.lang.Object enabled;
            private final java.lang.Object s3Origin;
            private final java.lang.Object trustedSigners;
            private final java.util.List<java.lang.String> aliases;
            private final java.lang.Object logging;
            private final java.lang.String priceClass;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Origin = software.amazon.jsii.Kernel.get(this, "s3Origin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trustedSigners = software.amazon.jsii.Kernel.get(this, "trustedSigners", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aliases = software.amazon.jsii.Kernel.get(this, "aliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priceClass = software.amazon.jsii.Kernel.get(this, "priceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comment = java.util.Objects.requireNonNull(builder.comment, "comment is required");
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.s3Origin = java.util.Objects.requireNonNull(builder.s3Origin, "s3Origin is required");
                this.trustedSigners = java.util.Objects.requireNonNull(builder.trustedSigners, "trustedSigners is required");
                this.aliases = builder.aliases;
                this.logging = builder.logging;
                this.priceClass = builder.priceClass;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getS3Origin() {
                return this.s3Origin;
            }

            @Override
            public final java.lang.Object getTrustedSigners() {
                return this.trustedSigners;
            }

            @Override
            public final java.util.List<java.lang.String> getAliases() {
                return this.aliases;
            }

            @Override
            public final java.lang.Object getLogging() {
                return this.logging;
            }

            @Override
            public final java.lang.String getPriceClass() {
                return this.priceClass;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comment", om.valueToTree(this.getComment()));
                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("s3Origin", om.valueToTree(this.getS3Origin()));
                data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
                if (this.getAliases() != null) {
                    data.set("aliases", om.valueToTree(this.getAliases()));
                }
                if (this.getLogging() != null) {
                    data.set("logging", om.valueToTree(this.getLogging()));
                }
                if (this.getPriceClass() != null) {
                    data.set("priceClass", om.valueToTree(this.getPriceClass()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamingDistributionConfigProperty.Jsii$Proxy that = (StreamingDistributionConfigProperty.Jsii$Proxy) o;

                if (!comment.equals(that.comment)) return false;
                if (!enabled.equals(that.enabled)) return false;
                if (!s3Origin.equals(that.s3Origin)) return false;
                if (!trustedSigners.equals(that.trustedSigners)) return false;
                if (this.aliases != null ? !this.aliases.equals(that.aliases) : that.aliases != null) return false;
                if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
                return this.priceClass != null ? this.priceClass.equals(that.priceClass) : that.priceClass == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comment.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                result = 31 * result + (this.s3Origin.hashCode());
                result = 31 * result + (this.trustedSigners.hashCode());
                result = 31 * result + (this.aliases != null ? this.aliases.hashCode() : 0);
                result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
                result = 31 * result + (this.priceClass != null ? this.priceClass.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of AWS accounts whose public keys CloudFront can use to verify the signatures of signed URLs and signed cookies.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * TrustedSignersProperty trustedSignersProperty = TrustedSignersProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .awsAccountNumbers(List.of("awsAccountNumbers"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-trustedsigners.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-trustedsigners.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.TrustedSignersProperty")
    @software.amazon.jsii.Jsii.Proxy(TrustedSignersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrustedSignersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This field is <code>true</code> if any of the AWS accounts in the list are configured as trusted signers.
         * <p>
         * If not, this field is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-trustedsigners.html#cfn-cloudfront-streamingdistribution-trustedsigners-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-trustedsigners.html#cfn-cloudfront-streamingdistribution-trustedsigners-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * An AWS account number that contains active CloudFront key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies.
         * <p>
         * If the AWS account that owns the key pairs is the same account that owns the CloudFront distribution, the value of this field is <code>self</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-trustedsigners.html#cfn-cloudfront-streamingdistribution-trustedsigners-awsaccountnumbers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-trustedsigners.html#cfn-cloudfront-streamingdistribution-trustedsigners-awsaccountnumbers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAwsAccountNumbers() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TrustedSignersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrustedSignersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrustedSignersProperty> {
            java.lang.Object enabled;
            java.util.List<java.lang.String> awsAccountNumbers;

            /**
             * Sets the value of {@link TrustedSignersProperty#getEnabled}
             * @param enabled This field is <code>true</code> if any of the AWS accounts in the list are configured as trusted signers. This parameter is required.
             *                If not, this field is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TrustedSignersProperty#getEnabled}
             * @param enabled This field is <code>true</code> if any of the AWS accounts in the list are configured as trusted signers. This parameter is required.
             *                If not, this field is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TrustedSignersProperty#getAwsAccountNumbers}
             * @param awsAccountNumbers An AWS account number that contains active CloudFront key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies.
             *                          If the AWS account that owns the key pairs is the same account that owns the CloudFront distribution, the value of this field is <code>self</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountNumbers(java.util.List<java.lang.String> awsAccountNumbers) {
                this.awsAccountNumbers = awsAccountNumbers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrustedSignersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrustedSignersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrustedSignersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrustedSignersProperty {
            private final java.lang.Object enabled;
            private final java.util.List<java.lang.String> awsAccountNumbers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsAccountNumbers = software.amazon.jsii.Kernel.get(this, "awsAccountNumbers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.awsAccountNumbers = builder.awsAccountNumbers;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.util.List<java.lang.String> getAwsAccountNumbers() {
                return this.awsAccountNumbers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getAwsAccountNumbers() != null) {
                    data.set("awsAccountNumbers", om.valueToTree(this.getAwsAccountNumbers()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.TrustedSignersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrustedSignersProperty.Jsii$Proxy that = (TrustedSignersProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.awsAccountNumbers != null ? this.awsAccountNumbers.equals(that.awsAccountNumbers) : that.awsAccountNumbers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.awsAccountNumbers != null ? this.awsAccountNumbers.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnStreamingDistributionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnStreamingDistributionProps.Builder();
        }

        /**
         * The current configuration information for the RTMP distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig</a>
         * @param streamingDistributionConfig The current configuration information for the RTMP distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamingDistributionConfig(final software.amazon.awscdk.IResolvable streamingDistributionConfig) {
            this.props.streamingDistributionConfig(streamingDistributionConfig);
            return this;
        }
        /**
         * The current configuration information for the RTMP distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig</a>
         * @param streamingDistributionConfig The current configuration information for the RTMP distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamingDistributionConfig(final software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty streamingDistributionConfig) {
            this.props.streamingDistributionConfig(streamingDistributionConfig);
            return this;
        }

        /**
         * A complex type that contains zero or more <code>Tag</code> elements.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-tags</a>
         * @param tags A complex type that contains zero or more <code>Tag</code> elements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution build() {
            return new software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
