package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for a Distribution.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creates a distribution from an Application Load Balancer
 * Vpc vpc;
 * // Create an application load balancer in a VPC. 'internetFacing' can be 'false'.
 * ApplicationLoadBalancer alb = ApplicationLoadBalancer.Builder.create(this, "ALB")
 *         .vpc(vpc)
 *         .internetFacing(false)
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_ISOLATED).build())
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(VpcOrigin.withApplicationLoadBalancer(alb)).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.538Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.DistributionProps")
@software.amazon.jsii.Jsii.Proxy(DistributionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DistributionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The default behavior for the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.BehaviorOptions getDefaultBehavior();

    /**
     * Additional behaviors for the distribution, mapped by the pathPattern that specifies which requests to apply the behavior to.
     * <p>
     * Default: - no additional behaviors are added.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> getAdditionalBehaviors() {
        return null;
    }

    /**
     * A certificate to associate with the distribution.
     * <p>
     * The certificate must be located in N. Virginia (us-east-1).
     * <p>
     * Default: - the CloudFront wildcard certificate (*.cloudfront.net) will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
        return null;
    }

    /**
     * Any comments you want to include about the distribution.
     * <p>
     * Default: - no comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * The object that you want CloudFront to request from your origin (for example, index.html) when a viewer requests the root URL for your distribution. If no default object is set, the request goes to the origin's root (e.g., example.com/).
     * <p>
     * Default: - no default root object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultRootObject() {
        return null;
    }

    /**
     * Alternative domain names for this distribution.
     * <p>
     * If you want to use your own domain name, such as www.example.com, instead of the cloudfront.net domain name,
     * you can add an alternate domain name to your distribution. If you attach a certificate to the distribution,
     * you should add (at least one of) the domain names of the certificate to this list.
     * <p>
     * When you want to move a domain name between distributions, you can associate a certificate without specifying any domain names.
     * For more information, see the <em>Moving an alternate domain name to a different distribution</em> section in the README.
     * <p>
     * Default: - The distribution will only support the default generated name (e.g., d111111abcdef8.cloudfront.net)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDomainNames() {
        return null;
    }

    /**
     * Enable or disable the distribution.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Whether CloudFront will respond to IPv6 DNS requests with an IPv6 address.
     * <p>
     * If you specify false, CloudFront responds to IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
     * This allows viewers to submit a second request, for an IPv4 address for your distribution.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableIpv6() {
        return null;
    }

    /**
     * Enable access logging for the distribution.
     * <p>
     * Default: - false, unless `logBucket` is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableLogging() {
        return null;
    }

    /**
     * How CloudFront should handle requests that are not successful (e.g., PageNotFound).
     * <p>
     * Default: - No custom error responses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> getErrorResponses() {
        return null;
    }

    /**
     * Controls the countries in which your content is distributed.
     * <p>
     * Default: - No geographic restrictions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.GeoRestriction getGeoRestriction() {
        return null;
    }

    /**
     * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront.
     * <p>
     * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support server name identification (SNI).
     * <p>
     * Default: HttpVersion.HTTP2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.HttpVersion getHttpVersion() {
        return null;
    }

    /**
     * The Amazon S3 bucket to store the access logs in.
     * <p>
     * Make sure to set <code>objectOwnership</code> to <code>s3.ObjectOwnership.OBJECT_WRITER</code> in your custom bucket.
     * <p>
     * Default: - A bucket is created if `enableLogging` is true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getLogBucket() {
        return null;
    }

    /**
     * An optional string that you want CloudFront to prefix to the access log filenames for this distribution.
     * <p>
     * Default: - no prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogFilePrefix() {
        return null;
    }

    /**
     * Specifies whether you want CloudFront to include cookies in access logs.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLogIncludesCookies() {
        return null;
    }

    /**
     * The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
     * <p>
     * CloudFront serves your objects only to browsers or devices that support at
     * least the SSL version that you specify.
     * <p>
     * Default: - SecurityPolicyProtocol.TLS_V1_2_2021 if the '@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021' feature flag is set; otherwise, SecurityPolicyProtocol.TLS_V1_2_2019.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol getMinimumProtocolVersion() {
        return null;
    }

    /**
     * The price class that corresponds with the maximum price that you want to pay for CloudFront service.
     * <p>
     * If you specify PriceClass_All, CloudFront responds to requests for your objects from all CloudFront edge locations.
     * If you specify a price class other than PriceClass_All, CloudFront serves your objects from the CloudFront edge location
     * that has the lowest latency among the edge locations in your price class.
     * <p>
     * Default: PriceClass.PRICE_CLASS_ALL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.PriceClass getPriceClass() {
        return null;
    }

    /**
     * Whether to enable additional CloudWatch metrics.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublishAdditionalMetrics() {
        return null;
    }

    /**
     * The SSL method CloudFront will use for your distribution.
     * <p>
     * Server Name Indication (SNI) - is an extension to the TLS computer networking protocol by which a client indicates
     * which hostname it is attempting to connect to at the start of the handshaking process. This allows a server to present
     * multiple certificates on the same IP address and TCP port number and hence allows multiple secure (HTTPS) websites
     * (or any other service over TLS) to be served by the same IP address without requiring all those sites to use the same certificate.
     * <p>
     * CloudFront can use SNI to host multiple distributions on the same IP - which a large majority of clients will support.
     * <p>
     * If your clients cannot support SNI however - CloudFront can use dedicated IPs for your distribution - but there is a prorated monthly charge for
     * using this feature. By default, we use SNI - but you can optionally enable dedicated IPs (VIP).
     * <p>
     * See the CloudFront SSL for more details about pricing : https://aws.amazon.com/cloudfront/custom-ssl-domains/
     * <p>
     * Default: SSLMethod.SNI
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.SSLMethod getSslSupportMethod() {
        return null;
    }

    /**
     * Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution.
     * <p>
     * To specify a web ACL created using the latest version of AWS WAF, use the ACL ARN, for example
     * <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * <p>
     * Default: - No AWS Web Application Firewall web access control list (web ACL).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html#API_CreateDistribution_RequestParameters.">https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html#API_CreateDistribution_RequestParameters.</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebAclId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DistributionProps> {
        software.amazon.awscdk.services.cloudfront.BehaviorOptions defaultBehavior;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> additionalBehaviors;
        software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        java.lang.String comment;
        java.lang.String defaultRootObject;
        java.util.List<java.lang.String> domainNames;
        java.lang.Boolean enabled;
        java.lang.Boolean enableIpv6;
        java.lang.Boolean enableLogging;
        java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> errorResponses;
        software.amazon.awscdk.services.cloudfront.GeoRestriction geoRestriction;
        software.amazon.awscdk.services.cloudfront.HttpVersion httpVersion;
        software.amazon.awscdk.services.s3.IBucket logBucket;
        java.lang.String logFilePrefix;
        java.lang.Boolean logIncludesCookies;
        software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol minimumProtocolVersion;
        software.amazon.awscdk.services.cloudfront.PriceClass priceClass;
        java.lang.Boolean publishAdditionalMetrics;
        software.amazon.awscdk.services.cloudfront.SSLMethod sslSupportMethod;
        java.lang.String webAclId;

        /**
         * Sets the value of {@link DistributionProps#getDefaultBehavior}
         * @param defaultBehavior The default behavior for the distribution. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBehavior(software.amazon.awscdk.services.cloudfront.BehaviorOptions defaultBehavior) {
            this.defaultBehavior = defaultBehavior;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getAdditionalBehaviors}
         * @param additionalBehaviors Additional behaviors for the distribution, mapped by the pathPattern that specifies which requests to apply the behavior to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder additionalBehaviors(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.cloudfront.BehaviorOptions> additionalBehaviors) {
            this.additionalBehaviors = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions>)additionalBehaviors;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getCertificate}
         * @param certificate A certificate to associate with the distribution.
         *                    The certificate must be located in N. Virginia (us-east-1).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getComment}
         * @param comment Any comments you want to include about the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getDefaultRootObject}
         * @param defaultRootObject The object that you want CloudFront to request from your origin (for example, index.html) when a viewer requests the root URL for your distribution. If no default object is set, the request goes to the origin's root (e.g., example.com/).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRootObject(java.lang.String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getDomainNames}
         * @param domainNames Alternative domain names for this distribution.
         *                    If you want to use your own domain name, such as www.example.com, instead of the cloudfront.net domain name,
         *                    you can add an alternate domain name to your distribution. If you attach a certificate to the distribution,
         *                    you should add (at least one of) the domain names of the certificate to this list.
         *                    <p>
         *                    When you want to move a domain name between distributions, you can associate a certificate without specifying any domain names.
         *                    For more information, see the <em>Moving an alternate domain name to a different distribution</em> section in the README.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNames(java.util.List<java.lang.String> domainNames) {
            this.domainNames = domainNames;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getEnabled}
         * @param enabled Enable or disable the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getEnableIpv6}
         * @param enableIpv6 Whether CloudFront will respond to IPv6 DNS requests with an IPv6 address.
         *                   If you specify false, CloudFront responds to IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
         *                   This allows viewers to submit a second request, for an IPv4 address for your distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIpv6(java.lang.Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getEnableLogging}
         * @param enableLogging Enable access logging for the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogging(java.lang.Boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getErrorResponses}
         * @param errorResponses How CloudFront should handle requests that are not successful (e.g., PageNotFound).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder errorResponses(java.util.List<? extends software.amazon.awscdk.services.cloudfront.ErrorResponse> errorResponses) {
            this.errorResponses = (java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse>)errorResponses;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getGeoRestriction}
         * @param geoRestriction Controls the countries in which your content is distributed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoRestriction(software.amazon.awscdk.services.cloudfront.GeoRestriction geoRestriction) {
            this.geoRestriction = geoRestriction;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getHttpVersion}
         * @param httpVersion Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront.
         *                    For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support server name identification (SNI).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpVersion(software.amazon.awscdk.services.cloudfront.HttpVersion httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getLogBucket}
         * @param logBucket The Amazon S3 bucket to store the access logs in.
         *                  Make sure to set <code>objectOwnership</code> to <code>s3.ObjectOwnership.OBJECT_WRITER</code> in your custom bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logBucket(software.amazon.awscdk.services.s3.IBucket logBucket) {
            this.logBucket = logBucket;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getLogFilePrefix}
         * @param logFilePrefix An optional string that you want CloudFront to prefix to the access log filenames for this distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logFilePrefix(java.lang.String logFilePrefix) {
            this.logFilePrefix = logFilePrefix;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getLogIncludesCookies}
         * @param logIncludesCookies Specifies whether you want CloudFront to include cookies in access logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logIncludesCookies(java.lang.Boolean logIncludesCookies) {
            this.logIncludesCookies = logIncludesCookies;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getMinimumProtocolVersion}
         * @param minimumProtocolVersion The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
         *                               CloudFront serves your objects only to browsers or devices that support at
         *                               least the SSL version that you specify.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumProtocolVersion(software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getPriceClass}
         * @param priceClass The price class that corresponds with the maximum price that you want to pay for CloudFront service.
         *                   If you specify PriceClass_All, CloudFront responds to requests for your objects from all CloudFront edge locations.
         *                   If you specify a price class other than PriceClass_All, CloudFront serves your objects from the CloudFront edge location
         *                   that has the lowest latency among the edge locations in your price class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priceClass(software.amazon.awscdk.services.cloudfront.PriceClass priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getPublishAdditionalMetrics}
         * @param publishAdditionalMetrics Whether to enable additional CloudWatch metrics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishAdditionalMetrics(java.lang.Boolean publishAdditionalMetrics) {
            this.publishAdditionalMetrics = publishAdditionalMetrics;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getSslSupportMethod}
         * @param sslSupportMethod The SSL method CloudFront will use for your distribution.
         *                         Server Name Indication (SNI) - is an extension to the TLS computer networking protocol by which a client indicates
         *                         which hostname it is attempting to connect to at the start of the handshaking process. This allows a server to present
         *                         multiple certificates on the same IP address and TCP port number and hence allows multiple secure (HTTPS) websites
         *                         (or any other service over TLS) to be served by the same IP address without requiring all those sites to use the same certificate.
         *                         <p>
         *                         CloudFront can use SNI to host multiple distributions on the same IP - which a large majority of clients will support.
         *                         <p>
         *                         If your clients cannot support SNI however - CloudFront can use dedicated IPs for your distribution - but there is a prorated monthly charge for
         *                         using this feature. By default, we use SNI - but you can optionally enable dedicated IPs (VIP).
         *                         <p>
         *                         See the CloudFront SSL for more details about pricing : https://aws.amazon.com/cloudfront/custom-ssl-domains/
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslSupportMethod(software.amazon.awscdk.services.cloudfront.SSLMethod sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getWebAclId}
         * @param webAclId Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution.
         *                 To specify a web ACL created using the latest version of AWS WAF, use the ACL ARN, for example
         *                 <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
         *                 To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclId(java.lang.String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DistributionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DistributionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DistributionProps {
        private final software.amazon.awscdk.services.cloudfront.BehaviorOptions defaultBehavior;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> additionalBehaviors;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.String comment;
        private final java.lang.String defaultRootObject;
        private final java.util.List<java.lang.String> domainNames;
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean enableIpv6;
        private final java.lang.Boolean enableLogging;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> errorResponses;
        private final software.amazon.awscdk.services.cloudfront.GeoRestriction geoRestriction;
        private final software.amazon.awscdk.services.cloudfront.HttpVersion httpVersion;
        private final software.amazon.awscdk.services.s3.IBucket logBucket;
        private final java.lang.String logFilePrefix;
        private final java.lang.Boolean logIncludesCookies;
        private final software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol minimumProtocolVersion;
        private final software.amazon.awscdk.services.cloudfront.PriceClass priceClass;
        private final java.lang.Boolean publishAdditionalMetrics;
        private final software.amazon.awscdk.services.cloudfront.SSLMethod sslSupportMethod;
        private final java.lang.String webAclId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultBehavior = software.amazon.jsii.Kernel.get(this, "defaultBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.BehaviorOptions.class));
            this.additionalBehaviors = software.amazon.jsii.Kernel.get(this, "additionalBehaviors", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.BehaviorOptions.class)));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultRootObject = software.amazon.jsii.Kernel.get(this, "defaultRootObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainNames = software.amazon.jsii.Kernel.get(this, "domainNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableIpv6 = software.amazon.jsii.Kernel.get(this, "enableIpv6", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableLogging = software.amazon.jsii.Kernel.get(this, "enableLogging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.errorResponses = software.amazon.jsii.Kernel.get(this, "errorResponses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ErrorResponse.class)));
            this.geoRestriction = software.amazon.jsii.Kernel.get(this, "geoRestriction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.GeoRestriction.class));
            this.httpVersion = software.amazon.jsii.Kernel.get(this, "httpVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.HttpVersion.class));
            this.logBucket = software.amazon.jsii.Kernel.get(this, "logBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.logFilePrefix = software.amazon.jsii.Kernel.get(this, "logFilePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logIncludesCookies = software.amazon.jsii.Kernel.get(this, "logIncludesCookies", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.minimumProtocolVersion = software.amazon.jsii.Kernel.get(this, "minimumProtocolVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol.class));
            this.priceClass = software.amazon.jsii.Kernel.get(this, "priceClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.PriceClass.class));
            this.publishAdditionalMetrics = software.amazon.jsii.Kernel.get(this, "publishAdditionalMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sslSupportMethod = software.amazon.jsii.Kernel.get(this, "sslSupportMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.SSLMethod.class));
            this.webAclId = software.amazon.jsii.Kernel.get(this, "webAclId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultBehavior = java.util.Objects.requireNonNull(builder.defaultBehavior, "defaultBehavior is required");
            this.additionalBehaviors = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions>)builder.additionalBehaviors;
            this.certificate = builder.certificate;
            this.comment = builder.comment;
            this.defaultRootObject = builder.defaultRootObject;
            this.domainNames = builder.domainNames;
            this.enabled = builder.enabled;
            this.enableIpv6 = builder.enableIpv6;
            this.enableLogging = builder.enableLogging;
            this.errorResponses = (java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse>)builder.errorResponses;
            this.geoRestriction = builder.geoRestriction;
            this.httpVersion = builder.httpVersion;
            this.logBucket = builder.logBucket;
            this.logFilePrefix = builder.logFilePrefix;
            this.logIncludesCookies = builder.logIncludesCookies;
            this.minimumProtocolVersion = builder.minimumProtocolVersion;
            this.priceClass = builder.priceClass;
            this.publishAdditionalMetrics = builder.publishAdditionalMetrics;
            this.sslSupportMethod = builder.sslSupportMethod;
            this.webAclId = builder.webAclId;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.BehaviorOptions getDefaultBehavior() {
            return this.defaultBehavior;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> getAdditionalBehaviors() {
            return this.additionalBehaviors;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getDefaultRootObject() {
            return this.defaultRootObject;
        }

        @Override
        public final java.util.List<java.lang.String> getDomainNames() {
            return this.domainNames;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        @Override
        public final java.lang.Boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> getErrorResponses() {
            return this.errorResponses;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.GeoRestriction getGeoRestriction() {
            return this.geoRestriction;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.HttpVersion getHttpVersion() {
            return this.httpVersion;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getLogBucket() {
            return this.logBucket;
        }

        @Override
        public final java.lang.String getLogFilePrefix() {
            return this.logFilePrefix;
        }

        @Override
        public final java.lang.Boolean getLogIncludesCookies() {
            return this.logIncludesCookies;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol getMinimumProtocolVersion() {
            return this.minimumProtocolVersion;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.PriceClass getPriceClass() {
            return this.priceClass;
        }

        @Override
        public final java.lang.Boolean getPublishAdditionalMetrics() {
            return this.publishAdditionalMetrics;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.SSLMethod getSslSupportMethod() {
            return this.sslSupportMethod;
        }

        @Override
        public final java.lang.String getWebAclId() {
            return this.webAclId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultBehavior", om.valueToTree(this.getDefaultBehavior()));
            if (this.getAdditionalBehaviors() != null) {
                data.set("additionalBehaviors", om.valueToTree(this.getAdditionalBehaviors()));
            }
            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getDefaultRootObject() != null) {
                data.set("defaultRootObject", om.valueToTree(this.getDefaultRootObject()));
            }
            if (this.getDomainNames() != null) {
                data.set("domainNames", om.valueToTree(this.getDomainNames()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEnableIpv6() != null) {
                data.set("enableIpv6", om.valueToTree(this.getEnableIpv6()));
            }
            if (this.getEnableLogging() != null) {
                data.set("enableLogging", om.valueToTree(this.getEnableLogging()));
            }
            if (this.getErrorResponses() != null) {
                data.set("errorResponses", om.valueToTree(this.getErrorResponses()));
            }
            if (this.getGeoRestriction() != null) {
                data.set("geoRestriction", om.valueToTree(this.getGeoRestriction()));
            }
            if (this.getHttpVersion() != null) {
                data.set("httpVersion", om.valueToTree(this.getHttpVersion()));
            }
            if (this.getLogBucket() != null) {
                data.set("logBucket", om.valueToTree(this.getLogBucket()));
            }
            if (this.getLogFilePrefix() != null) {
                data.set("logFilePrefix", om.valueToTree(this.getLogFilePrefix()));
            }
            if (this.getLogIncludesCookies() != null) {
                data.set("logIncludesCookies", om.valueToTree(this.getLogIncludesCookies()));
            }
            if (this.getMinimumProtocolVersion() != null) {
                data.set("minimumProtocolVersion", om.valueToTree(this.getMinimumProtocolVersion()));
            }
            if (this.getPriceClass() != null) {
                data.set("priceClass", om.valueToTree(this.getPriceClass()));
            }
            if (this.getPublishAdditionalMetrics() != null) {
                data.set("publishAdditionalMetrics", om.valueToTree(this.getPublishAdditionalMetrics()));
            }
            if (this.getSslSupportMethod() != null) {
                data.set("sslSupportMethod", om.valueToTree(this.getSslSupportMethod()));
            }
            if (this.getWebAclId() != null) {
                data.set("webAclId", om.valueToTree(this.getWebAclId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.DistributionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DistributionProps.Jsii$Proxy that = (DistributionProps.Jsii$Proxy) o;

            if (!defaultBehavior.equals(that.defaultBehavior)) return false;
            if (this.additionalBehaviors != null ? !this.additionalBehaviors.equals(that.additionalBehaviors) : that.additionalBehaviors != null) return false;
            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.defaultRootObject != null ? !this.defaultRootObject.equals(that.defaultRootObject) : that.defaultRootObject != null) return false;
            if (this.domainNames != null ? !this.domainNames.equals(that.domainNames) : that.domainNames != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.enableIpv6 != null ? !this.enableIpv6.equals(that.enableIpv6) : that.enableIpv6 != null) return false;
            if (this.enableLogging != null ? !this.enableLogging.equals(that.enableLogging) : that.enableLogging != null) return false;
            if (this.errorResponses != null ? !this.errorResponses.equals(that.errorResponses) : that.errorResponses != null) return false;
            if (this.geoRestriction != null ? !this.geoRestriction.equals(that.geoRestriction) : that.geoRestriction != null) return false;
            if (this.httpVersion != null ? !this.httpVersion.equals(that.httpVersion) : that.httpVersion != null) return false;
            if (this.logBucket != null ? !this.logBucket.equals(that.logBucket) : that.logBucket != null) return false;
            if (this.logFilePrefix != null ? !this.logFilePrefix.equals(that.logFilePrefix) : that.logFilePrefix != null) return false;
            if (this.logIncludesCookies != null ? !this.logIncludesCookies.equals(that.logIncludesCookies) : that.logIncludesCookies != null) return false;
            if (this.minimumProtocolVersion != null ? !this.minimumProtocolVersion.equals(that.minimumProtocolVersion) : that.minimumProtocolVersion != null) return false;
            if (this.priceClass != null ? !this.priceClass.equals(that.priceClass) : that.priceClass != null) return false;
            if (this.publishAdditionalMetrics != null ? !this.publishAdditionalMetrics.equals(that.publishAdditionalMetrics) : that.publishAdditionalMetrics != null) return false;
            if (this.sslSupportMethod != null ? !this.sslSupportMethod.equals(that.sslSupportMethod) : that.sslSupportMethod != null) return false;
            return this.webAclId != null ? this.webAclId.equals(that.webAclId) : that.webAclId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultBehavior.hashCode();
            result = 31 * result + (this.additionalBehaviors != null ? this.additionalBehaviors.hashCode() : 0);
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.defaultRootObject != null ? this.defaultRootObject.hashCode() : 0);
            result = 31 * result + (this.domainNames != null ? this.domainNames.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.enableIpv6 != null ? this.enableIpv6.hashCode() : 0);
            result = 31 * result + (this.enableLogging != null ? this.enableLogging.hashCode() : 0);
            result = 31 * result + (this.errorResponses != null ? this.errorResponses.hashCode() : 0);
            result = 31 * result + (this.geoRestriction != null ? this.geoRestriction.hashCode() : 0);
            result = 31 * result + (this.httpVersion != null ? this.httpVersion.hashCode() : 0);
            result = 31 * result + (this.logBucket != null ? this.logBucket.hashCode() : 0);
            result = 31 * result + (this.logFilePrefix != null ? this.logFilePrefix.hashCode() : 0);
            result = 31 * result + (this.logIncludesCookies != null ? this.logIncludesCookies.hashCode() : 0);
            result = 31 * result + (this.minimumProtocolVersion != null ? this.minimumProtocolVersion.hashCode() : 0);
            result = 31 * result + (this.priceClass != null ? this.priceClass.hashCode() : 0);
            result = 31 * result + (this.publishAdditionalMetrics != null ? this.publishAdditionalMetrics.hashCode() : 0);
            result = 31 * result + (this.sslSupportMethod != null ? this.sslSupportMethod.hashCode() : 0);
            result = 31 * result + (this.webAclId != null ? this.webAclId.hashCode() : 0);
            return result;
        }
    }
}
