package software.amazon.awscdk.services.cloudfront;

/**
 * Represents a CloudFront function and event type when using CF Functions.
 * <p>
 * The type of the <code>AddBehaviorOptions.functionAssociations</code> property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * Function function_;
 * FunctionAssociation functionAssociation = FunctionAssociation.builder()
 *         .eventType(FunctionEventType.VIEWER_REQUEST)
 *         .function(function_)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.FunctionAssociation")
@software.amazon.jsii.Jsii.Proxy(FunctionAssociation.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionAssociation extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of event which should invoke the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.FunctionEventType getEventType();

    /**
     * The CloudFront function that will be invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IFunction getFunction();

    /**
     * @return a {@link Builder} of {@link FunctionAssociation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionAssociation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionAssociation> {
        software.amazon.awscdk.services.cloudfront.FunctionEventType eventType;
        software.amazon.awscdk.services.cloudfront.IFunction function;

        /**
         * Sets the value of {@link FunctionAssociation#getEventType}
         * @param eventType The type of event which should invoke the function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventType(software.amazon.awscdk.services.cloudfront.FunctionEventType eventType) {
            this.eventType = eventType;
            return this;
        }

        /**
         * Sets the value of {@link FunctionAssociation#getFunction}
         * @param function The CloudFront function that will be invoked. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder function(software.amazon.awscdk.services.cloudfront.IFunction function) {
            this.function = function;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionAssociation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionAssociation build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FunctionAssociation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionAssociation {
        private final software.amazon.awscdk.services.cloudfront.FunctionEventType eventType;
        private final software.amazon.awscdk.services.cloudfront.IFunction function;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionEventType.class));
            this.function = software.amazon.jsii.Kernel.get(this, "function", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IFunction.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventType = java.util.Objects.requireNonNull(builder.eventType, "eventType is required");
            this.function = java.util.Objects.requireNonNull(builder.function, "function is required");
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.FunctionEventType getEventType() {
            return this.eventType;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IFunction getFunction() {
            return this.function;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventType", om.valueToTree(this.getEventType()));
            data.set("function", om.valueToTree(this.getFunction()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.FunctionAssociation"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionAssociation.Jsii$Proxy that = (FunctionAssociation.Jsii$Proxy) o;

            if (!eventType.equals(that.eventType)) return false;
            return this.function.equals(that.function);
        }

        @Override
        public final int hashCode() {
            int result = this.eventType.hashCode();
            result = 31 * result + (this.function.hashCode());
            return result;
        }
    }
}
