package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for creating a CloudFront Function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * KeyValueStore store = new KeyValueStore(this, "KeyValueStore");
 * Function.Builder.create(this, "Function")
 *         .code(FunctionCode.fromInline("function handler(event) { return event.request }"))
 *         // Note that JS_2_0 must be used for Key Value Store support
 *         .runtime(FunctionRuntime.JS_2_0)
 *         .keyValueStore(store)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.544Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.FunctionProps")
@software.amazon.jsii.Jsii.Proxy(FunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The source code of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.FunctionCode getCode();

    /**
     * A flag that determines whether to automatically publish the function to the LIVE stage when it’s created.
     * <p>
     * Default: - true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoPublish() {
        return null;
    }

    /**
     * A comment to describe the function.
     * <p>
     * Default: - same as `functionName`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * A name to identify the function.
     * <p>
     * Default: - generated from the `id`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionName() {
        return null;
    }

    /**
     * The Key Value Store to associate with this function.
     * <p>
     * In order to associate a Key Value Store, the <code>runtime</code> must be
     * <code>cloudfront-js-2.0</code> or newer.
     * <p>
     * Default: - no key value store is associated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IKeyValueStore getKeyValueStore() {
        return null;
    }

    /**
     * The runtime environment for the function.
     * <p>
     * Default: FunctionRuntime.JS_1_0 (unless `keyValueStore` is specified, then `FunctionRuntime.JS_2_0`)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.FunctionRuntime getRuntime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionProps> {
        software.amazon.awscdk.services.cloudfront.FunctionCode code;
        java.lang.Boolean autoPublish;
        java.lang.String comment;
        java.lang.String functionName;
        software.amazon.awscdk.services.cloudfront.IKeyValueStore keyValueStore;
        software.amazon.awscdk.services.cloudfront.FunctionRuntime runtime;

        /**
         * Sets the value of {@link FunctionProps#getCode}
         * @param code The source code of the function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.cloudfront.FunctionCode code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link FunctionProps#getAutoPublish}
         * @param autoPublish A flag that determines whether to automatically publish the function to the LIVE stage when it’s created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPublish(java.lang.Boolean autoPublish) {
            this.autoPublish = autoPublish;
            return this;
        }

        /**
         * Sets the value of {@link FunctionProps#getComment}
         * @param comment A comment to describe the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link FunctionProps#getFunctionName}
         * @param functionName A name to identify the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link FunctionProps#getKeyValueStore}
         * @param keyValueStore The Key Value Store to associate with this function.
         *                      In order to associate a Key Value Store, the <code>runtime</code> must be
         *                      <code>cloudfront-js-2.0</code> or newer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyValueStore(software.amazon.awscdk.services.cloudfront.IKeyValueStore keyValueStore) {
            this.keyValueStore = keyValueStore;
            return this;
        }

        /**
         * Sets the value of {@link FunctionProps#getRuntime}
         * @param runtime The runtime environment for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(software.amazon.awscdk.services.cloudfront.FunctionRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionProps {
        private final software.amazon.awscdk.services.cloudfront.FunctionCode code;
        private final java.lang.Boolean autoPublish;
        private final java.lang.String comment;
        private final java.lang.String functionName;
        private final software.amazon.awscdk.services.cloudfront.IKeyValueStore keyValueStore;
        private final software.amazon.awscdk.services.cloudfront.FunctionRuntime runtime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionCode.class));
            this.autoPublish = software.amazon.jsii.Kernel.get(this, "autoPublish", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyValueStore = software.amazon.jsii.Kernel.get(this, "keyValueStore", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IKeyValueStore.class));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionRuntime.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.code = java.util.Objects.requireNonNull(builder.code, "code is required");
            this.autoPublish = builder.autoPublish;
            this.comment = builder.comment;
            this.functionName = builder.functionName;
            this.keyValueStore = builder.keyValueStore;
            this.runtime = builder.runtime;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.FunctionCode getCode() {
            return this.code;
        }

        @Override
        public final java.lang.Boolean getAutoPublish() {
            return this.autoPublish;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IKeyValueStore getKeyValueStore() {
            return this.keyValueStore;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.FunctionRuntime getRuntime() {
            return this.runtime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("code", om.valueToTree(this.getCode()));
            if (this.getAutoPublish() != null) {
                data.set("autoPublish", om.valueToTree(this.getAutoPublish()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getFunctionName() != null) {
                data.set("functionName", om.valueToTree(this.getFunctionName()));
            }
            if (this.getKeyValueStore() != null) {
                data.set("keyValueStore", om.valueToTree(this.getKeyValueStore()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.FunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionProps.Jsii$Proxy that = (FunctionProps.Jsii$Proxy) o;

            if (!code.equals(that.code)) return false;
            if (this.autoPublish != null ? !this.autoPublish.equals(that.autoPublish) : that.autoPublish != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) return false;
            if (this.keyValueStore != null ? !this.keyValueStore.equals(that.keyValueStore) : that.keyValueStore != null) return false;
            return this.runtime != null ? this.runtime.equals(that.runtime) : that.runtime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.code.hashCode();
            result = 31 * result + (this.autoPublish != null ? this.autoPublish.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
            result = 31 * result + (this.keyValueStore != null ? this.keyValueStore.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            return result;
        }
    }
}
