package software.amazon.awscdk.services.cloudfront;

/**
 * The data to be imported to the key value store.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * KeyValueStore storeAsset = KeyValueStore.Builder.create(this, "KeyValueStoreAsset")
 *         .keyValueStoreName("KeyValueStoreAsset")
 *         .source(ImportSource.fromAsset("path-to-data.json"))
 *         .build();
 * KeyValueStore storeInline = KeyValueStore.Builder.create(this, "KeyValueStoreInline")
 *         .keyValueStoreName("KeyValueStoreInline")
 *         .source(ImportSource.fromInline(JSON.stringify(Map.of(
 *                 "data", List.of(Map.of(
 *                         "key", "key1",
 *                         "value", "value1"), Map.of(
 *                         "key", "key2",
 *                         "value", "value2"))))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.553Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.ImportSource")
public abstract class ImportSource extends software.amazon.jsii.JsiiObject {

    protected ImportSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ImportSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ImportSource() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * An import source that exists as a local file.
     * <p>
     * @param path the path to the local file. This parameter is required.
     * @param options the configuration for the temporarily created S3 file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.ImportSource fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.ImportSource.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ImportSource.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * An import source that exists as a local file.
     * <p>
     * @param path the path to the local file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.ImportSource fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.ImportSource.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ImportSource.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * An import source that exists as an object in an S3 bucket.
     * <p>
     * @param bucket the S3 bucket that contains the data. This parameter is required.
     * @param key the key within the S3 bucket that contains the data. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.ImportSource fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.ImportSource.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ImportSource.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * An import source that uses an inline string.
     * <p>
     * @param data the contents of the KeyValueStore. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.ImportSource fromInline(final @org.jetbrains.annotations.NotNull java.lang.String data) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.ImportSource.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ImportSource.class), new Object[] { java.util.Objects.requireNonNull(data, "data is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cloudfront.ImportSource {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
