package software.amazon.awscdk.services.cloudfront;

/**
 * A Origin Request Policy configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Using an existing origin request policy for a Distribution
 * S3Origin bucketOrigin;
 * Distribution.Builder.create(this, "myDistManagedPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .originRequestPolicy(OriginRequestPolicy.CORS_S3_ORIGIN)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.575Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginRequestPolicy")
public class OriginRequestPolicy extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy {

    protected OriginRequestPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OriginRequestPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL_VIEWER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.OriginRequestPolicy.class, "ALL_VIEWER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
        ALL_VIEWER_AND_CLOUDFRONT_2022 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.OriginRequestPolicy.class, "ALL_VIEWER_AND_CLOUDFRONT_2022", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
        ALL_VIEWER_EXCEPT_HOST_HEADER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.OriginRequestPolicy.class, "ALL_VIEWER_EXCEPT_HOST_HEADER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
        CORS_CUSTOM_ORIGIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.OriginRequestPolicy.class, "CORS_CUSTOM_ORIGIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
        CORS_S3_ORIGIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.OriginRequestPolicy.class, "CORS_S3_ORIGIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
        ELEMENTAL_MEDIA_TAILOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.OriginRequestPolicy.class, "ELEMENTAL_MEDIA_TAILOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.OriginRequestPolicy.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        USER_AGENT_REFERER_HEADERS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.OriginRequestPolicy.class, "USER_AGENT_REFERER_HEADERS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OriginRequestPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginRequestPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OriginRequestPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a Origin Request Policy from its id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param originRequestPolicyId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy fromOriginRequestPolicyId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String originRequestPolicyId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginRequestPolicy.class, "fromOriginRequestPolicyId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(originRequestPolicyId, "originRequestPolicyId is required") });
    }

    /**
     * This policy includes all values (query strings, headers, and cookies) in the viewer request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy ALL_VIEWER;

    /**
     * This policy includes all values (headers, cookies, and query strings) in the viewer request, and all CloudFront headers that were released through June 2022 (CloudFront headers released after June 2022 are not included).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy ALL_VIEWER_AND_CLOUDFRONT_2022;

    /**
     * This policy includes all values (query strings, and cookies) except the header in the viewer request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy ALL_VIEWER_EXCEPT_HOST_HEADER;

    /**
     * This policy includes the header that enables cross-origin resource sharing (CORS) requests when the origin is a custom origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy CORS_CUSTOM_ORIGIN;

    /**
     * This policy includes the headers that enable cross-origin resource sharing (CORS) requests when the origin is an Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy CORS_S3_ORIGIN;

    /**
     * This policy is designed for use with an origin that is an AWS Elemental MediaTailor endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy ELEMENTAL_MEDIA_TAILOR;

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * This policy includes only the User-Agent and Referer headers.
     * <p>
     * It doesn’t include any query strings or cookies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy USER_AGENT_REFERER_HEADERS;

    /**
     * The ID of the origin request policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOriginRequestPolicyId() {
        return software.amazon.jsii.Kernel.get(this, "originRequestPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.OriginRequestPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.OriginRequestPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudfront.OriginRequestPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A comment to describe the origin request policy.
         * <p>
         * Default: - no comment
         * <p>
         * @return {@code this}
         * @param comment A comment to describe the origin request policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * The cookies from viewer requests to include in origin requests.
         * <p>
         * Default: OriginRequestCookieBehavior.none()
         * <p>
         * @return {@code this}
         * @param cookieBehavior The cookies from viewer requests to include in origin requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cookieBehavior(final software.amazon.awscdk.services.cloudfront.OriginRequestCookieBehavior cookieBehavior) {
            this.props().cookieBehavior(cookieBehavior);
            return this;
        }

        /**
         * The HTTP headers to include in origin requests.
         * <p>
         * These can include headers from viewer requests and additional headers added by CloudFront.
         * <p>
         * Default: OriginRequestHeaderBehavior.none()
         * <p>
         * @return {@code this}
         * @param headerBehavior The HTTP headers to include in origin requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerBehavior(final software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior headerBehavior) {
            this.props().headerBehavior(headerBehavior);
            return this;
        }

        /**
         * A unique name to identify the origin request policy.
         * <p>
         * The name must only include '-', '_', or alphanumeric characters.
         * <p>
         * Default: - generated from the `id`
         * <p>
         * @return {@code this}
         * @param originRequestPolicyName A unique name to identify the origin request policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originRequestPolicyName(final java.lang.String originRequestPolicyName) {
            this.props().originRequestPolicyName(originRequestPolicyName);
            return this;
        }

        /**
         * The URL query strings from viewer requests to include in origin requests.
         * <p>
         * Default: OriginRequestQueryStringBehavior.none()
         * <p>
         * @return {@code this}
         * @param queryStringBehavior The URL query strings from viewer requests to include in origin requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryStringBehavior(final software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior queryStringBehavior) {
            this.props().queryStringBehavior(queryStringBehavior);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.OriginRequestPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.OriginRequestPolicy build() {
            return new software.amazon.awscdk.services.cloudfront.OriginRequestPolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.OriginRequestPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.OriginRequestPolicyProps.Builder();
            }
            return this.props;
        }
    }
}
