package software.amazon.awscdk.services.cloudtrail;

/**
 * Properties for an AWS CloudTrail trail.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Trail trail = Trail.Builder.create(this, "CloudTrail")
 *         // ...
 *         .managementEvents(ReadWriteType.READ_ONLY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.699Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.TrailProps")
@software.amazon.jsii.Jsii.Proxy(TrailProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TrailProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon S3 bucket.
     * <p>
     * Default: - if not supplied a bucket will be created with all the correct permisions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getBucket() {
        return null;
    }

    /**
     * Log Group to which CloudTrail to push logs to.
     * <p>
     * Ignored if sendToCloudWatchLogs is set to false.
     * <p>
     * Default: - a new log group is created and used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getCloudWatchLogGroup() {
        return null;
    }

    /**
     * How long to retain logs in CloudWatchLogs.
     * <p>
     * Ignored if sendToCloudWatchLogs is false or if cloudWatchLogGroup is set.
     * <p>
     * Default: logs.RetentionDays.ONE_YEAR
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getCloudWatchLogsRetention() {
        return null;
    }

    /**
     * To determine whether a log file was modified, deleted, or unchanged after CloudTrail delivered it, you can use CloudTrail log file integrity validation.
     * <p>
     * This feature is built using industry standard algorithms: SHA-256 for hashing and SHA-256 with RSA for digital signing.
     * This makes it computationally infeasible to modify, delete or forge CloudTrail log files without detection.
     * You can use the AWS CLI to validate the files in the location where CloudTrail delivered them.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableFileValidation() {
        return null;
    }

    /**
     * The AWS Key Management Service (AWS KMS) key ID that you want to use to encrypt CloudTrail logs.
     * <p>
     * Default: - No encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * For most services, events are recorded in the region where the action occurred.
     * <p>
     * For global services such as AWS Identity and Access Management (IAM), AWS STS, Amazon CloudFront, and Route 53,
     * events are delivered to any trail that includes global services, and are logged as occurring in US East (N. Virginia) Region.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeGlobalServiceEvents() {
        return null;
    }

    /**
     * A JSON string that contains the insight types you want to log on a trail.
     * <p>
     * Default: - No Value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudtrail.InsightType> getInsightTypes() {
        return null;
    }

    /**
     * Whether or not this trail delivers log files from multiple regions to a single S3 bucket for a single account.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsMultiRegionTrail() {
        return null;
    }

    /**
     * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations, or only for the current AWS account.
     * <p>
     * If this is set to true then the current account <em>must</em> be the management account. If it is not, then CloudFormation will throw an error.
     * <p>
     * If this is set to true and the current account is a management account for an organization in AWS Organizations, the trail will be created in all AWS accounts that belong to the organization.
     * If this is set to false, the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsOrganizationTrail() {
        return null;
    }

    /**
     * When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     * <p>
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     * <p>
     * This method sets the management configuration for this trail.
     * <p>
     * Management events provide insight into management operations that are performed on resources in your AWS account.
     * These are also known as control plane operations.
     * Management events can also include non-API events that occur in your account.
     * For example, when a user logs in to your account, CloudTrail logs the ConsoleLogin event.
     * <p>
     * Default: ReadWriteType.ALL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.ReadWriteType getManagementEvents() {
        return null;
    }

    /**
     * The orgId.
     * <p>
     * Required when <code>isOrganizationTrail</code> is set to true to attach the necessary permissions.
     * <p>
     * Default: - No orgId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOrgId() {
        return null;
    }

    /**
     * An Amazon S3 object key prefix that precedes the name of all log files.
     * <p>
     * Default: - No prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
        return null;
    }

    /**
     * If CloudTrail pushes logs to CloudWatch Logs in addition to S3.
     * <p>
     * Disabled for cost out of the box.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSendToCloudWatchLogs() {
        return null;
    }

    /**
     * SNS topic that is notified when new log files are published.
     * <p>
     * Default: - No notifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getSnsTopic() {
        return null;
    }

    /**
     * The name of the trail.
     * <p>
     * We recommend customers do not set an explicit name.
     * <p>
     * Default: - AWS CloudFormation generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTrailName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TrailProps> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        software.amazon.awscdk.services.logs.ILogGroup cloudWatchLogGroup;
        software.amazon.awscdk.services.logs.RetentionDays cloudWatchLogsRetention;
        java.lang.Boolean enableFileValidation;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.Boolean includeGlobalServiceEvents;
        java.util.List<software.amazon.awscdk.services.cloudtrail.InsightType> insightTypes;
        java.lang.Boolean isMultiRegionTrail;
        java.lang.Boolean isOrganizationTrail;
        software.amazon.awscdk.services.cloudtrail.ReadWriteType managementEvents;
        java.lang.String orgId;
        java.lang.String s3KeyPrefix;
        java.lang.Boolean sendToCloudWatchLogs;
        software.amazon.awscdk.services.sns.ITopic snsTopic;
        java.lang.String trailName;

        /**
         * Sets the value of {@link TrailProps#getBucket}
         * @param bucket The Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getCloudWatchLogGroup}
         * @param cloudWatchLogGroup Log Group to which CloudTrail to push logs to.
         *                           Ignored if sendToCloudWatchLogs is set to false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogGroup(software.amazon.awscdk.services.logs.ILogGroup cloudWatchLogGroup) {
            this.cloudWatchLogGroup = cloudWatchLogGroup;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getCloudWatchLogsRetention}
         * @param cloudWatchLogsRetention How long to retain logs in CloudWatchLogs.
         *                                Ignored if sendToCloudWatchLogs is false or if cloudWatchLogGroup is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsRetention(software.amazon.awscdk.services.logs.RetentionDays cloudWatchLogsRetention) {
            this.cloudWatchLogsRetention = cloudWatchLogsRetention;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getEnableFileValidation}
         * @param enableFileValidation To determine whether a log file was modified, deleted, or unchanged after CloudTrail delivered it, you can use CloudTrail log file integrity validation.
         *                             This feature is built using industry standard algorithms: SHA-256 for hashing and SHA-256 with RSA for digital signing.
         *                             This makes it computationally infeasible to modify, delete or forge CloudTrail log files without detection.
         *                             You can use the AWS CLI to validate the files in the location where CloudTrail delivered them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableFileValidation(java.lang.Boolean enableFileValidation) {
            this.enableFileValidation = enableFileValidation;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getEncryptionKey}
         * @param encryptionKey The AWS Key Management Service (AWS KMS) key ID that you want to use to encrypt CloudTrail logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getIncludeGlobalServiceEvents}
         * @param includeGlobalServiceEvents For most services, events are recorded in the region where the action occurred.
         *                                   For global services such as AWS Identity and Access Management (IAM), AWS STS, Amazon CloudFront, and Route 53,
         *                                   events are delivered to any trail that includes global services, and are logged as occurring in US East (N. Virginia) Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeGlobalServiceEvents(java.lang.Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getInsightTypes}
         * @param insightTypes A JSON string that contains the insight types you want to log on a trail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder insightTypes(java.util.List<? extends software.amazon.awscdk.services.cloudtrail.InsightType> insightTypes) {
            this.insightTypes = (java.util.List<software.amazon.awscdk.services.cloudtrail.InsightType>)insightTypes;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getIsMultiRegionTrail}
         * @param isMultiRegionTrail Whether or not this trail delivers log files from multiple regions to a single S3 bucket for a single account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMultiRegionTrail(java.lang.Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getIsOrganizationTrail}
         * @param isOrganizationTrail Specifies whether the trail is applied to all accounts in an organization in AWS Organizations, or only for the current AWS account.
         *                            If this is set to true then the current account <em>must</em> be the management account. If it is not, then CloudFormation will throw an error.
         *                            <p>
         *                            If this is set to true and the current account is a management account for an organization in AWS Organizations, the trail will be created in all AWS accounts that belong to the organization.
         *                            If this is set to false, the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isOrganizationTrail(java.lang.Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getManagementEvents}
         * @param managementEvents When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
         *                         Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
         *                         <p>
         *                         This method sets the management configuration for this trail.
         *                         <p>
         *                         Management events provide insight into management operations that are performed on resources in your AWS account.
         *                         These are also known as control plane operations.
         *                         Management events can also include non-API events that occur in your account.
         *                         For example, when a user logs in to your account, CloudTrail logs the ConsoleLogin event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managementEvents(software.amazon.awscdk.services.cloudtrail.ReadWriteType managementEvents) {
            this.managementEvents = managementEvents;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getOrgId}
         * @param orgId The orgId.
         *              Required when <code>isOrganizationTrail</code> is set to true to attach the necessary permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder orgId(java.lang.String orgId) {
            this.orgId = orgId;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getS3KeyPrefix}
         * @param s3KeyPrefix An Amazon S3 object key prefix that precedes the name of all log files.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3KeyPrefix(java.lang.String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getSendToCloudWatchLogs}
         * @param sendToCloudWatchLogs If CloudTrail pushes logs to CloudWatch Logs in addition to S3.
         *                             Disabled for cost out of the box.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendToCloudWatchLogs(java.lang.Boolean sendToCloudWatchLogs) {
            this.sendToCloudWatchLogs = sendToCloudWatchLogs;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getSnsTopic}
         * @param snsTopic SNS topic that is notified when new log files are published.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopic(software.amazon.awscdk.services.sns.ITopic snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        /**
         * Sets the value of {@link TrailProps#getTrailName}
         * @param trailName The name of the trail.
         *                  We recommend customers do not set an explicit name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trailName(java.lang.String trailName) {
            this.trailName = trailName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TrailProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TrailProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrailProps {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final software.amazon.awscdk.services.logs.ILogGroup cloudWatchLogGroup;
        private final software.amazon.awscdk.services.logs.RetentionDays cloudWatchLogsRetention;
        private final java.lang.Boolean enableFileValidation;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.Boolean includeGlobalServiceEvents;
        private final java.util.List<software.amazon.awscdk.services.cloudtrail.InsightType> insightTypes;
        private final java.lang.Boolean isMultiRegionTrail;
        private final java.lang.Boolean isOrganizationTrail;
        private final software.amazon.awscdk.services.cloudtrail.ReadWriteType managementEvents;
        private final java.lang.String orgId;
        private final java.lang.String s3KeyPrefix;
        private final java.lang.Boolean sendToCloudWatchLogs;
        private final software.amazon.awscdk.services.sns.ITopic snsTopic;
        private final java.lang.String trailName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.cloudWatchLogGroup = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.cloudWatchLogsRetention = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.enableFileValidation = software.amazon.jsii.Kernel.get(this, "enableFileValidation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.includeGlobalServiceEvents = software.amazon.jsii.Kernel.get(this, "includeGlobalServiceEvents", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.insightTypes = software.amazon.jsii.Kernel.get(this, "insightTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudtrail.InsightType.class)));
            this.isMultiRegionTrail = software.amazon.jsii.Kernel.get(this, "isMultiRegionTrail", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.isOrganizationTrail = software.amazon.jsii.Kernel.get(this, "isOrganizationTrail", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.managementEvents = software.amazon.jsii.Kernel.get(this, "managementEvents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudtrail.ReadWriteType.class));
            this.orgId = software.amazon.jsii.Kernel.get(this, "orgId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3KeyPrefix = software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sendToCloudWatchLogs = software.amazon.jsii.Kernel.get(this, "sendToCloudWatchLogs", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.snsTopic = software.amazon.jsii.Kernel.get(this, "snsTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
            this.trailName = software.amazon.jsii.Kernel.get(this, "trailName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = builder.bucket;
            this.cloudWatchLogGroup = builder.cloudWatchLogGroup;
            this.cloudWatchLogsRetention = builder.cloudWatchLogsRetention;
            this.enableFileValidation = builder.enableFileValidation;
            this.encryptionKey = builder.encryptionKey;
            this.includeGlobalServiceEvents = builder.includeGlobalServiceEvents;
            this.insightTypes = (java.util.List<software.amazon.awscdk.services.cloudtrail.InsightType>)builder.insightTypes;
            this.isMultiRegionTrail = builder.isMultiRegionTrail;
            this.isOrganizationTrail = builder.isOrganizationTrail;
            this.managementEvents = builder.managementEvents;
            this.orgId = builder.orgId;
            this.s3KeyPrefix = builder.s3KeyPrefix;
            this.sendToCloudWatchLogs = builder.sendToCloudWatchLogs;
            this.snsTopic = builder.snsTopic;
            this.trailName = builder.trailName;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getCloudWatchLogGroup() {
            return this.cloudWatchLogGroup;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getCloudWatchLogsRetention() {
            return this.cloudWatchLogsRetention;
        }

        @Override
        public final java.lang.Boolean getEnableFileValidation() {
            return this.enableFileValidation;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.Boolean getIncludeGlobalServiceEvents() {
            return this.includeGlobalServiceEvents;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudtrail.InsightType> getInsightTypes() {
            return this.insightTypes;
        }

        @Override
        public final java.lang.Boolean getIsMultiRegionTrail() {
            return this.isMultiRegionTrail;
        }

        @Override
        public final java.lang.Boolean getIsOrganizationTrail() {
            return this.isOrganizationTrail;
        }

        @Override
        public final software.amazon.awscdk.services.cloudtrail.ReadWriteType getManagementEvents() {
            return this.managementEvents;
        }

        @Override
        public final java.lang.String getOrgId() {
            return this.orgId;
        }

        @Override
        public final java.lang.String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final java.lang.Boolean getSendToCloudWatchLogs() {
            return this.sendToCloudWatchLogs;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getSnsTopic() {
            return this.snsTopic;
        }

        @Override
        public final java.lang.String getTrailName() {
            return this.trailName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucket() != null) {
                data.set("bucket", om.valueToTree(this.getBucket()));
            }
            if (this.getCloudWatchLogGroup() != null) {
                data.set("cloudWatchLogGroup", om.valueToTree(this.getCloudWatchLogGroup()));
            }
            if (this.getCloudWatchLogsRetention() != null) {
                data.set("cloudWatchLogsRetention", om.valueToTree(this.getCloudWatchLogsRetention()));
            }
            if (this.getEnableFileValidation() != null) {
                data.set("enableFileValidation", om.valueToTree(this.getEnableFileValidation()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getIncludeGlobalServiceEvents() != null) {
                data.set("includeGlobalServiceEvents", om.valueToTree(this.getIncludeGlobalServiceEvents()));
            }
            if (this.getInsightTypes() != null) {
                data.set("insightTypes", om.valueToTree(this.getInsightTypes()));
            }
            if (this.getIsMultiRegionTrail() != null) {
                data.set("isMultiRegionTrail", om.valueToTree(this.getIsMultiRegionTrail()));
            }
            if (this.getIsOrganizationTrail() != null) {
                data.set("isOrganizationTrail", om.valueToTree(this.getIsOrganizationTrail()));
            }
            if (this.getManagementEvents() != null) {
                data.set("managementEvents", om.valueToTree(this.getManagementEvents()));
            }
            if (this.getOrgId() != null) {
                data.set("orgId", om.valueToTree(this.getOrgId()));
            }
            if (this.getS3KeyPrefix() != null) {
                data.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
            }
            if (this.getSendToCloudWatchLogs() != null) {
                data.set("sendToCloudWatchLogs", om.valueToTree(this.getSendToCloudWatchLogs()));
            }
            if (this.getSnsTopic() != null) {
                data.set("snsTopic", om.valueToTree(this.getSnsTopic()));
            }
            if (this.getTrailName() != null) {
                data.set("trailName", om.valueToTree(this.getTrailName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.TrailProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TrailProps.Jsii$Proxy that = (TrailProps.Jsii$Proxy) o;

            if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
            if (this.cloudWatchLogGroup != null ? !this.cloudWatchLogGroup.equals(that.cloudWatchLogGroup) : that.cloudWatchLogGroup != null) return false;
            if (this.cloudWatchLogsRetention != null ? !this.cloudWatchLogsRetention.equals(that.cloudWatchLogsRetention) : that.cloudWatchLogsRetention != null) return false;
            if (this.enableFileValidation != null ? !this.enableFileValidation.equals(that.enableFileValidation) : that.enableFileValidation != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.includeGlobalServiceEvents != null ? !this.includeGlobalServiceEvents.equals(that.includeGlobalServiceEvents) : that.includeGlobalServiceEvents != null) return false;
            if (this.insightTypes != null ? !this.insightTypes.equals(that.insightTypes) : that.insightTypes != null) return false;
            if (this.isMultiRegionTrail != null ? !this.isMultiRegionTrail.equals(that.isMultiRegionTrail) : that.isMultiRegionTrail != null) return false;
            if (this.isOrganizationTrail != null ? !this.isOrganizationTrail.equals(that.isOrganizationTrail) : that.isOrganizationTrail != null) return false;
            if (this.managementEvents != null ? !this.managementEvents.equals(that.managementEvents) : that.managementEvents != null) return false;
            if (this.orgId != null ? !this.orgId.equals(that.orgId) : that.orgId != null) return false;
            if (this.s3KeyPrefix != null ? !this.s3KeyPrefix.equals(that.s3KeyPrefix) : that.s3KeyPrefix != null) return false;
            if (this.sendToCloudWatchLogs != null ? !this.sendToCloudWatchLogs.equals(that.sendToCloudWatchLogs) : that.sendToCloudWatchLogs != null) return false;
            if (this.snsTopic != null ? !this.snsTopic.equals(that.snsTopic) : that.snsTopic != null) return false;
            return this.trailName != null ? this.trailName.equals(that.trailName) : that.trailName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket != null ? this.bucket.hashCode() : 0;
            result = 31 * result + (this.cloudWatchLogGroup != null ? this.cloudWatchLogGroup.hashCode() : 0);
            result = 31 * result + (this.cloudWatchLogsRetention != null ? this.cloudWatchLogsRetention.hashCode() : 0);
            result = 31 * result + (this.enableFileValidation != null ? this.enableFileValidation.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.includeGlobalServiceEvents != null ? this.includeGlobalServiceEvents.hashCode() : 0);
            result = 31 * result + (this.insightTypes != null ? this.insightTypes.hashCode() : 0);
            result = 31 * result + (this.isMultiRegionTrail != null ? this.isMultiRegionTrail.hashCode() : 0);
            result = 31 * result + (this.isOrganizationTrail != null ? this.isOrganizationTrail.hashCode() : 0);
            result = 31 * result + (this.managementEvents != null ? this.managementEvents.hashCode() : 0);
            result = 31 * result + (this.orgId != null ? this.orgId.hashCode() : 0);
            result = 31 * result + (this.s3KeyPrefix != null ? this.s3KeyPrefix.hashCode() : 0);
            result = 31 * result + (this.sendToCloudWatchLogs != null ? this.sendToCloudWatchLogs.hashCode() : 0);
            result = 31 * result + (this.snsTopic != null ? this.snsTopic.hashCode() : 0);
            result = 31 * result + (this.trailName != null ? this.trailName.hashCode() : 0);
            return result;
        }
    }
}
