package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for defining a <code>CfnAnomalyDetector</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * CfnAnomalyDetectorProps cfnAnomalyDetectorProps = CfnAnomalyDetectorProps.builder()
 *         .configuration(ConfigurationProperty.builder()
 *                 .excludedTimeRanges(List.of(RangeProperty.builder()
 *                         .endTime("endTime")
 *                         .startTime("startTime")
 *                         .build()))
 *                 .metricTimeZone("metricTimeZone")
 *                 .build())
 *         .dimensions(List.of(DimensionProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .metricCharacteristics(MetricCharacteristicsProperty.builder()
 *                 .periodicSpikes(false)
 *                 .build())
 *         .metricMathAnomalyDetector(MetricMathAnomalyDetectorProperty.builder()
 *                 .metricDataQueries(List.of(MetricDataQueryProperty.builder()
 *                         .id("id")
 *                         // the properties below are optional
 *                         .accountId("accountId")
 *                         .expression("expression")
 *                         .label("label")
 *                         .metricStat(MetricStatProperty.builder()
 *                                 .metric(MetricProperty.builder()
 *                                         .metricName("metricName")
 *                                         .namespace("namespace")
 *                                         // the properties below are optional
 *                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .period(123)
 *                                 .stat("stat")
 *                                 // the properties below are optional
 *                                 .unit("unit")
 *                                 .build())
 *                         .period(123)
 *                         .returnData(false)
 *                         .build()))
 *                 .build())
 *         .metricName("metricName")
 *         .namespace("namespace")
 *         .singleMetricAnomalyDetector(SingleMetricAnomalyDetectorProperty.builder()
 *                 .accountId("accountId")
 *                 .dimensions(List.of(DimensionProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .metricName("metricName")
 *                 .namespace("namespace")
 *                 .stat("stat")
 *                 .build())
 *         .stat("stat")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.745Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetectorProps")
@software.amazon.jsii.Jsii.Proxy(CfnAnomalyDetectorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAnomalyDetectorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model.
     * <p>
     * The configuration can also include the time zone to use for the metric.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return null;
    }

    /**
     * The dimensions of the metric associated with the anomaly detection band.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-dimensions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
        return null;
    }

    /**
     * Use this object to include parameters to provide information about your metric to CloudWatch to help it build more accurate anomaly detection models.
     * <p>
     * Currently, it includes the <code>PeriodicSpikes</code> parameter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metriccharacteristics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metriccharacteristics</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetricCharacteristics() {
        return null;
    }

    /**
     * The CloudWatch metric math expression for this anomaly detector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricmathanomalydetector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricmathanomalydetector</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetricMathAnomalyDetector() {
        return null;
    }

    /**
     * The name of the metric associated with the anomaly detection band.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
        return null;
    }

    /**
     * The namespace of the metric associated with the anomaly detection band.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-namespace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
        return null;
    }

    /**
     * The CloudWatch metric and statistic for this anomaly detector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-singlemetricanomalydetector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-singlemetricanomalydetector</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSingleMetricAnomalyDetector() {
        return null;
    }

    /**
     * The statistic of the metric associated with the anomaly detection band.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-stat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-stat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStat() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAnomalyDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAnomalyDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAnomalyDetectorProps> {
        java.lang.Object configuration;
        java.lang.Object dimensions;
        java.lang.Object metricCharacteristics;
        java.lang.Object metricMathAnomalyDetector;
        java.lang.String metricName;
        java.lang.String namespace;
        java.lang.Object singleMetricAnomalyDetector;
        java.lang.String stat;

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getConfiguration}
         * @param configuration Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model.
         *                      The configuration can also include the time zone to use for the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getConfiguration}
         * @param configuration Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model.
         *                      The configuration can also include the time zone to use for the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.ConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getDimensions}
         * @param dimensions The dimensions of the metric associated with the anomaly detection band.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getDimensions}
         * @param dimensions The dimensions of the metric associated with the anomaly detection band.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getMetricCharacteristics}
         * @param metricCharacteristics Use this object to include parameters to provide information about your metric to CloudWatch to help it build more accurate anomaly detection models.
         *                              Currently, it includes the <code>PeriodicSpikes</code> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricCharacteristics(software.amazon.awscdk.IResolvable metricCharacteristics) {
            this.metricCharacteristics = metricCharacteristics;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getMetricCharacteristics}
         * @param metricCharacteristics Use this object to include parameters to provide information about your metric to CloudWatch to help it build more accurate anomaly detection models.
         *                              Currently, it includes the <code>PeriodicSpikes</code> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricCharacteristics(software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.MetricCharacteristicsProperty metricCharacteristics) {
            this.metricCharacteristics = metricCharacteristics;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getMetricMathAnomalyDetector}
         * @param metricMathAnomalyDetector The CloudWatch metric math expression for this anomaly detector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricMathAnomalyDetector(software.amazon.awscdk.IResolvable metricMathAnomalyDetector) {
            this.metricMathAnomalyDetector = metricMathAnomalyDetector;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getMetricMathAnomalyDetector}
         * @param metricMathAnomalyDetector The CloudWatch metric math expression for this anomaly detector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricMathAnomalyDetector(software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.MetricMathAnomalyDetectorProperty metricMathAnomalyDetector) {
            this.metricMathAnomalyDetector = metricMathAnomalyDetector;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getMetricName}
         * @param metricName The name of the metric associated with the anomaly detection band.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getNamespace}
         * @param namespace The namespace of the metric associated with the anomaly detection band.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getSingleMetricAnomalyDetector}
         * @param singleMetricAnomalyDetector The CloudWatch metric and statistic for this anomaly detector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder singleMetricAnomalyDetector(software.amazon.awscdk.IResolvable singleMetricAnomalyDetector) {
            this.singleMetricAnomalyDetector = singleMetricAnomalyDetector;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getSingleMetricAnomalyDetector}
         * @param singleMetricAnomalyDetector The CloudWatch metric and statistic for this anomaly detector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder singleMetricAnomalyDetector(software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.SingleMetricAnomalyDetectorProperty singleMetricAnomalyDetector) {
            this.singleMetricAnomalyDetector = singleMetricAnomalyDetector;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getStat}
         * @param stat The statistic of the metric associated with the anomaly detection band.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stat(java.lang.String stat) {
            this.stat = stat;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAnomalyDetectorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAnomalyDetectorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAnomalyDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAnomalyDetectorProps {
        private final java.lang.Object configuration;
        private final java.lang.Object dimensions;
        private final java.lang.Object metricCharacteristics;
        private final java.lang.Object metricMathAnomalyDetector;
        private final java.lang.String metricName;
        private final java.lang.String namespace;
        private final java.lang.Object singleMetricAnomalyDetector;
        private final java.lang.String stat;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.metricCharacteristics = software.amazon.jsii.Kernel.get(this, "metricCharacteristics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.metricMathAnomalyDetector = software.amazon.jsii.Kernel.get(this, "metricMathAnomalyDetector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.singleMetricAnomalyDetector = software.amazon.jsii.Kernel.get(this, "singleMetricAnomalyDetector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stat = software.amazon.jsii.Kernel.get(this, "stat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuration = builder.configuration;
            this.dimensions = builder.dimensions;
            this.metricCharacteristics = builder.metricCharacteristics;
            this.metricMathAnomalyDetector = builder.metricMathAnomalyDetector;
            this.metricName = builder.metricName;
            this.namespace = builder.namespace;
            this.singleMetricAnomalyDetector = builder.singleMetricAnomalyDetector;
            this.stat = builder.stat;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.Object getDimensions() {
            return this.dimensions;
        }

        @Override
        public final java.lang.Object getMetricCharacteristics() {
            return this.metricCharacteristics;
        }

        @Override
        public final java.lang.Object getMetricMathAnomalyDetector() {
            return this.metricMathAnomalyDetector;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.lang.Object getSingleMetricAnomalyDetector() {
            return this.singleMetricAnomalyDetector;
        }

        @Override
        public final java.lang.String getStat() {
            return this.stat;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getDimensions() != null) {
                data.set("dimensions", om.valueToTree(this.getDimensions()));
            }
            if (this.getMetricCharacteristics() != null) {
                data.set("metricCharacteristics", om.valueToTree(this.getMetricCharacteristics()));
            }
            if (this.getMetricMathAnomalyDetector() != null) {
                data.set("metricMathAnomalyDetector", om.valueToTree(this.getMetricMathAnomalyDetector()));
            }
            if (this.getMetricName() != null) {
                data.set("metricName", om.valueToTree(this.getMetricName()));
            }
            if (this.getNamespace() != null) {
                data.set("namespace", om.valueToTree(this.getNamespace()));
            }
            if (this.getSingleMetricAnomalyDetector() != null) {
                data.set("singleMetricAnomalyDetector", om.valueToTree(this.getSingleMetricAnomalyDetector()));
            }
            if (this.getStat() != null) {
                data.set("stat", om.valueToTree(this.getStat()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetectorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAnomalyDetectorProps.Jsii$Proxy that = (CfnAnomalyDetectorProps.Jsii$Proxy) o;

            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
            if (this.metricCharacteristics != null ? !this.metricCharacteristics.equals(that.metricCharacteristics) : that.metricCharacteristics != null) return false;
            if (this.metricMathAnomalyDetector != null ? !this.metricMathAnomalyDetector.equals(that.metricMathAnomalyDetector) : that.metricMathAnomalyDetector != null) return false;
            if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
            if (this.singleMetricAnomalyDetector != null ? !this.singleMetricAnomalyDetector.equals(that.singleMetricAnomalyDetector) : that.singleMetricAnomalyDetector != null) return false;
            return this.stat != null ? this.stat.equals(that.stat) : that.stat == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configuration != null ? this.configuration.hashCode() : 0;
            result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
            result = 31 * result + (this.metricCharacteristics != null ? this.metricCharacteristics.hashCode() : 0);
            result = 31 * result + (this.metricMathAnomalyDetector != null ? this.metricMathAnomalyDetector.hashCode() : 0);
            result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.singleMetricAnomalyDetector != null ? this.singleMetricAnomalyDetector.hashCode() : 0);
            result = 31 * result + (this.stat != null ? this.stat.hashCode() : 0);
            return result;
        }
    }
}
