package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a concrete metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Metric metric;
 * MetricExpressionConfig metricExpressionConfig = MetricExpressionConfig.builder()
 *         .expression("expression")
 *         .period(123)
 *         .usingMetrics(Map.of(
 *                 "usingMetricsKey", metric))
 *         // the properties below are optional
 *         .searchAccount("searchAccount")
 *         .searchRegion("searchRegion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.801Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.MetricExpressionConfig")
@software.amazon.jsii.Jsii.Proxy(MetricExpressionConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MetricExpressionConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Math expression for the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExpression();

    /**
     * How many seconds to aggregate over.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPeriod();

    /**
     * Metrics used in the math expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics();

    /**
     * Account to evaluate search expressions within.
     * <p>
     * Default: - Deployment account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSearchAccount() {
        return null;
    }

    /**
     * Region to evaluate search expressions within.
     * <p>
     * Default: - Deployment region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSearchRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MetricExpressionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricExpressionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MetricExpressionConfig> {
        java.lang.String expression;
        java.lang.Number period;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics;
        java.lang.String searchAccount;
        java.lang.String searchRegion;

        /**
         * Sets the value of {@link MetricExpressionConfig#getExpression}
         * @param expression Math expression for the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expression(java.lang.String expression) {
            this.expression = expression;
            return this;
        }

        /**
         * Sets the value of {@link MetricExpressionConfig#getPeriod}
         * @param period How many seconds to aggregate over. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(java.lang.Number period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link MetricExpressionConfig#getUsingMetrics}
         * @param usingMetrics Metrics used in the math expression. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder usingMetrics(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics) {
            this.usingMetrics = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric>)usingMetrics;
            return this;
        }

        /**
         * Sets the value of {@link MetricExpressionConfig#getSearchAccount}
         * @param searchAccount Account to evaluate search expressions within.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchAccount(java.lang.String searchAccount) {
            this.searchAccount = searchAccount;
            return this;
        }

        /**
         * Sets the value of {@link MetricExpressionConfig#getSearchRegion}
         * @param searchRegion Region to evaluate search expressions within.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchRegion(java.lang.String searchRegion) {
            this.searchRegion = searchRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricExpressionConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MetricExpressionConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MetricExpressionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricExpressionConfig {
        private final java.lang.String expression;
        private final java.lang.Number period;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics;
        private final java.lang.String searchAccount;
        private final java.lang.String searchRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.usingMetrics = software.amazon.jsii.Kernel.get(this, "usingMetrics", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
            this.searchAccount = software.amazon.jsii.Kernel.get(this, "searchAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.searchRegion = software.amazon.jsii.Kernel.get(this, "searchRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
            this.period = java.util.Objects.requireNonNull(builder.period, "period is required");
            this.usingMetrics = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric>)java.util.Objects.requireNonNull(builder.usingMetrics, "usingMetrics is required");
            this.searchAccount = builder.searchAccount;
            this.searchRegion = builder.searchRegion;
        }

        @Override
        public final java.lang.String getExpression() {
            return this.expression;
        }

        @Override
        public final java.lang.Number getPeriod() {
            return this.period;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics() {
            return this.usingMetrics;
        }

        @Override
        public final java.lang.String getSearchAccount() {
            return this.searchAccount;
        }

        @Override
        public final java.lang.String getSearchRegion() {
            return this.searchRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("expression", om.valueToTree(this.getExpression()));
            data.set("period", om.valueToTree(this.getPeriod()));
            data.set("usingMetrics", om.valueToTree(this.getUsingMetrics()));
            if (this.getSearchAccount() != null) {
                data.set("searchAccount", om.valueToTree(this.getSearchAccount()));
            }
            if (this.getSearchRegion() != null) {
                data.set("searchRegion", om.valueToTree(this.getSearchRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.MetricExpressionConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricExpressionConfig.Jsii$Proxy that = (MetricExpressionConfig.Jsii$Proxy) o;

            if (!expression.equals(that.expression)) return false;
            if (!period.equals(that.period)) return false;
            if (!usingMetrics.equals(that.usingMetrics)) return false;
            if (this.searchAccount != null ? !this.searchAccount.equals(that.searchAccount) : that.searchAccount != null) return false;
            return this.searchRegion != null ? this.searchRegion.equals(that.searchRegion) : that.searchRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.expression.hashCode();
            result = 31 * result + (this.period.hashCode());
            result = 31 * result + (this.usingMetrics.hashCode());
            result = 31 * result + (this.searchAccount != null ? this.searchAccount.hashCode() : 0);
            result = 31 * result + (this.searchRegion != null ? this.searchRegion.hashCode() : 0);
            return result;
        }
    }
}
