package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Use an SSM Incident Response Plan as an Alarm action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Alarm alarm;
 * // Create an Incident Manager incident based on a specific response plan
 * alarm.addAlarmAction(
 * new SsmIncidentAction("ResponsePlanName"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.820Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch_actions.SsmIncidentAction")
public class SsmIncidentAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IAlarmAction {

    protected SsmIncidentAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SsmIncidentAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param responsePlanName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SsmIncidentAction(final @org.jetbrains.annotations.NotNull java.lang.String responsePlanName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(responsePlanName, "responsePlanName is required") });
    }

    /**
     * Returns an alarm action configuration to use an SSM Incident as an alarm action based on an Incident Manager Response Plan.
     * <p>
     * @param _scope This parameter is required.
     * @param _alarm This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AlarmActionConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm _alarm) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.AlarmActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_alarm, "_alarm is required") });
    }
}
