package software.amazon.awscdk.services.codebuild;

/**
 * A CodeBuild image running x86-64 Linux.
 * <p>
 * This class has a bunch of public constants that represent the most popular images.
 * <p>
 * You can also specify a custom image using one of the static methods:
 * <p>
 * <ul>
 * <li>LinuxBuildImage.fromDockerRegistry(image[, { secretsManagerCredentials }])</li>
 * <li>LinuxBuildImage.fromEcrRepository(repo[, tag])</li>
 * <li>LinuxBuildImage.fromAsset(parent, id, props)</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineSource.connection("my-org/my-app", "main", ConnectionSourceOptions.builder()
 *                         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
 *                         .build()))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         // Turn this on because the pipeline uses Docker image assets
 *         .dockerEnabledForSelfMutation(true)
 *         .build();
 * pipeline.addWave("MyWave", WaveOptions.builder()
 *         .post(List.of(
 *             CodeBuildStep.Builder.create("RunApproval")
 *                     .commands(List.of("command-from-image"))
 *                     .buildEnvironment(BuildEnvironment.builder()
 *                             // The user of a Docker image asset in the pipeline requires turning on
 *                             // 'dockerEnabledForSelfMutation'.
 *                             .buildImage(LinuxBuildImage.fromAsset(this, "Image", DockerImageAssetProps.builder()
 *                                     .directory("./docker-image")
 *                                     .build()))
 *                             .build())
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:03.953Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.LinuxBuildImage")
public class LinuxBuildImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage {

    protected LinuxBuildImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LinuxBuildImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON_LINUX_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_ARM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_ARM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_ARM_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_ARM_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_ARM_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_ARM_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_CORETTO_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_CORETTO_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_CORETTO_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_CORETTO_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2023_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2023_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_CORETTO_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2023_CORETTO_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_CORETTO_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2023_CORETTO_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_4_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_4_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_5_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_5_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_6_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_6_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_7_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_7_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
    }

    /**
     * Uses an Docker image asset as a x86-64 Linux build image.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uses a Docker image provided by CodeBuild.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "aws/codebuild/standard:4.0";
     * </pre></blockquote>
     * <p>
     * @return A Docker image provided by CodeBuild.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
     * @param id The image identifier. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromCodeBuildImageId(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromCodeBuildImageId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @return a x86-64 Linux build image from a Docker Hub image.
     * @param name This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.DockerImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromDockerRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), options });
    }

    /**
     * @return a x86-64 Linux build image from a Docker Hub image.
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromDockerRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * @return A x86-64 Linux build image from an ECR repository.
     * <p>
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html</a>
     * @param repository The ECR repository. This parameter is required.
     * @param tagOrDigest Image tag or digest (default "latest", digests must start with <code>sha256:</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable java.lang.String tagOrDigest) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), tagOrDigest });
    }

    /**
     * @return A x86-64 Linux build image from an ECR repository.
     * <p>
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html</a>
     * @param repository The ECR repository. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Make a buildspec to run the indicated script.
     * <p>
     * @param entrypoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint) {
        return software.amazon.jsii.Kernel.call(this, "runScriptBuildspec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required") });
    }

    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     * <p>
     * @param env This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment env) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(env, "env is required") }));
    }

    /**
     * @deprecated Use {@link LinuxBuildImage.AMAZON_LINUX_2_5 } instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2;

    /**
     * @deprecated Use {@link LinuxBuildImage.AMAZON_LINUX_2_5 } instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_2;

    /**
     * (deprecated) The Amazon Linux 2 x86_64 standard image, version <code>3.0</code>.
     * <p>
     * @deprecated Use {@link LinuxBuildImage.AMAZON_LINUX_2_5 } instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_3;

    /**
     * The Amazon Linux 2 x86_64 standard image, version <code>4.0</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_4;

    /**
     * The Amazon Linux 2023 x86_64 standard image, version <code>5.0</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_5;

    /**
     * (deprecated) Image "aws/codebuild/amazonlinux2-aarch64-standard:1.0".
     * <p>
     * @see <a href="{LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_1_0}">{LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_1_0}</a>
     * @deprecated Use {@link LinuxArmBuildImage.AMAZON_LINUX_2_ARM_3 } instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_ARM;

    /**
     * Image "aws/codebuild/amazonlinux2-aarch64-standard:2.0".
     * <p>
     * @see <a href="{LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_2_0}">{LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_2_0}</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_ARM_2;

    /**
     * Image "aws/codebuild/amazonlinux2-aarch64-standard:3.0".
     * <p>
     * @see <a href="{LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_3_0}">{LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_3_0}</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_ARM_3;

    /**
     * The Amazon Coretto 11 image x86_64, based on Amazon Linux 2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_CORETTO_11;

    /**
     * The Amazon Coretto 8 image x86_64, based on Amazon Linux 2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_CORETTO_8;

    /**
     * The Amazon Linux 2023 x86_64 standard image, version <code>4.0</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_4;

    /**
     * The Amazon Linux 2023 x86_64 standard image, version <code>5.0</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_5;

    /**
     * The Amazon Coretto 11 image x86_64, based on Amazon Linux 2023.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_CORETTO_11;

    /**
     * The Amazon Coretto 8 image x86_64, based on Amazon Linux 2023.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_CORETTO_8;

    /**
     * @deprecated Use {@link LinuxBuildImage.STANDARD_7_0 } instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_1_0;

    /**
     * @deprecated Use {@link LinuxBuildImage.STANDARD_7_0 } instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_2_0;

    /**
     * @deprecated Use {@link LinuxBuildImage.STANDARD_7_0 } instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_3_0;

    /**
     * (deprecated) The <code>aws/codebuild/standard:4.0</code> build image.
     * <p>
     * @deprecated Use {@link LinuxBuildImage.STANDARD_7_0 } instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_4_0;

    /**
     * The <code>aws/codebuild/standard:5.0</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_5_0;

    /**
     * The <code>aws/codebuild/standard:6.0</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_6_0;

    /**
     * The <code>aws/codebuild/standard:7.0</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_7_0;

    /**
     * The default <code>ComputeType</code> to use with this image, if one was not specified in <code>BuildEnvironment#computeType</code> explicitly.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
        return software.amazon.jsii.Kernel.get(this, "defaultComputeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ComputeType.class));
    }

    /**
     * The Docker image identifier that the build environment uses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
        return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of build environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of principal that CodeBuild will use to pull this build Docker image.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ImagePullPrincipalType getImagePullPrincipalType() {
        return software.amazon.jsii.Kernel.get(this, "imagePullPrincipalType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ImagePullPrincipalType.class));
    }

    /**
     * An optional ECR repository that the image is hosted in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
    }

    /**
     * The secretsManagerCredentials for access to a private registry.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
        return software.amazon.jsii.Kernel.get(this, "secretsManagerCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
    }
}
