package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Base construction properties of the <code>InspectorScanActionBase</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * import software.amazon.awscdk.services.iam.*;
 * Artifact artifact;
 * Role role;
 * InspectorScanActionBaseProps inspectorScanActionBaseProps = InspectorScanActionBaseProps.builder()
 *         .actionName("actionName")
 *         .output(artifact)
 *         // the properties below are optional
 *         .criticalThreshold(123)
 *         .highThreshold(123)
 *         .lowThreshold(123)
 *         .mediumThreshold(123)
 *         .role(role)
 *         .runOrder(123)
 *         .variablesNamespace("variablesNamespace")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:04.289Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.InspectorScanActionBaseProps")
@software.amazon.jsii.Jsii.Proxy(InspectorScanActionBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InspectorScanActionBaseProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * Vulnerability details of your source in the form of a Software Bill of Materials (SBOM) file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getOutput();

    /**
     * The number of critical severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
     * <p>
     * Default: - no threshold
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCriticalThreshold() {
        return null;
    }

    /**
     * The number of high severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
     * <p>
     * Default: - no threshold
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHighThreshold() {
        return null;
    }

    /**
     * The number of low severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
     * <p>
     * Default: - no threshold
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLowThreshold() {
        return null;
    }

    /**
     * The number of medium severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
     * <p>
     * Default: - no threshold
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMediumThreshold() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InspectorScanActionBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InspectorScanActionBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InspectorScanActionBaseProps> {
        software.amazon.awscdk.services.codepipeline.Artifact output;
        java.lang.Number criticalThreshold;
        java.lang.Number highThreshold;
        java.lang.Number lowThreshold;
        java.lang.Number mediumThreshold;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link InspectorScanActionBaseProps#getOutput}
         * @param output Vulnerability details of your source in the form of a Software Bill of Materials (SBOM) file. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link InspectorScanActionBaseProps#getCriticalThreshold}
         * @param criticalThreshold The number of critical severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criticalThreshold(java.lang.Number criticalThreshold) {
            this.criticalThreshold = criticalThreshold;
            return this;
        }

        /**
         * Sets the value of {@link InspectorScanActionBaseProps#getHighThreshold}
         * @param highThreshold The number of high severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder highThreshold(java.lang.Number highThreshold) {
            this.highThreshold = highThreshold;
            return this;
        }

        /**
         * Sets the value of {@link InspectorScanActionBaseProps#getLowThreshold}
         * @param lowThreshold The number of low severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowThreshold(java.lang.Number lowThreshold) {
            this.lowThreshold = lowThreshold;
            return this;
        }

        /**
         * Sets the value of {@link InspectorScanActionBaseProps#getMediumThreshold}
         * @param mediumThreshold The number of medium severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediumThreshold(java.lang.Number mediumThreshold) {
            this.mediumThreshold = mediumThreshold;
            return this;
        }

        /**
         * Sets the value of {@link InspectorScanActionBaseProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link InspectorScanActionBaseProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link InspectorScanActionBaseProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link InspectorScanActionBaseProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InspectorScanActionBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InspectorScanActionBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InspectorScanActionBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InspectorScanActionBaseProps {
        private final software.amazon.awscdk.services.codepipeline.Artifact output;
        private final java.lang.Number criticalThreshold;
        private final java.lang.Number highThreshold;
        private final java.lang.Number lowThreshold;
        private final java.lang.Number mediumThreshold;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.criticalThreshold = software.amazon.jsii.Kernel.get(this, "criticalThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.highThreshold = software.amazon.jsii.Kernel.get(this, "highThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.lowThreshold = software.amazon.jsii.Kernel.get(this, "lowThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mediumThreshold = software.amazon.jsii.Kernel.get(this, "mediumThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.output = java.util.Objects.requireNonNull(builder.output, "output is required");
            this.criticalThreshold = builder.criticalThreshold;
            this.highThreshold = builder.highThreshold;
            this.lowThreshold = builder.lowThreshold;
            this.mediumThreshold = builder.mediumThreshold;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
            return this.output;
        }

        @Override
        public final java.lang.Number getCriticalThreshold() {
            return this.criticalThreshold;
        }

        @Override
        public final java.lang.Number getHighThreshold() {
            return this.highThreshold;
        }

        @Override
        public final java.lang.Number getLowThreshold() {
            return this.lowThreshold;
        }

        @Override
        public final java.lang.Number getMediumThreshold() {
            return this.mediumThreshold;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("output", om.valueToTree(this.getOutput()));
            if (this.getCriticalThreshold() != null) {
                data.set("criticalThreshold", om.valueToTree(this.getCriticalThreshold()));
            }
            if (this.getHighThreshold() != null) {
                data.set("highThreshold", om.valueToTree(this.getHighThreshold()));
            }
            if (this.getLowThreshold() != null) {
                data.set("lowThreshold", om.valueToTree(this.getLowThreshold()));
            }
            if (this.getMediumThreshold() != null) {
                data.set("mediumThreshold", om.valueToTree(this.getMediumThreshold()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.InspectorScanActionBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InspectorScanActionBaseProps.Jsii$Proxy that = (InspectorScanActionBaseProps.Jsii$Proxy) o;

            if (!output.equals(that.output)) return false;
            if (this.criticalThreshold != null ? !this.criticalThreshold.equals(that.criticalThreshold) : that.criticalThreshold != null) return false;
            if (this.highThreshold != null ? !this.highThreshold.equals(that.highThreshold) : that.highThreshold != null) return false;
            if (this.lowThreshold != null ? !this.lowThreshold.equals(that.lowThreshold) : that.lowThreshold != null) return false;
            if (this.mediumThreshold != null ? !this.mediumThreshold.equals(that.mediumThreshold) : that.mediumThreshold != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.output.hashCode();
            result = 31 * result + (this.criticalThreshold != null ? this.criticalThreshold.hashCode() : 0);
            result = 31 * result + (this.highThreshold != null ? this.highThreshold.hashCode() : 0);
            result = 31 * result + (this.lowThreshold != null ? this.lowThreshold.hashCode() : 0);
            result = 31 * result + (this.mediumThreshold != null ? this.mediumThreshold.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
