package software.amazon.awscdk.services.codepipeline.actions;

/**
 * A list that allows you to specify, or override, the source revision for a pipeline execution that's being started.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * SourceRevision sourceRevision = SourceRevision.builder()
 *         .actionName("actionName")
 *         .revisionType(RevisionType.COMMIT_ID)
 *         .revisionValue("revisionValue")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:04.322Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.SourceRevision")
@software.amazon.jsii.Jsii.Proxy(SourceRevision.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SourceRevision extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the action where the override will be applied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getActionName();

    /**
     * The type of source revision, based on the source provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.RevisionType getRevisionType();

    /**
     * The source revision, or version of your source artifact, with the changes that you want to run in the pipeline execution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRevisionValue();

    /**
     * @return a {@link Builder} of {@link SourceRevision}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceRevision}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SourceRevision> {
        java.lang.String actionName;
        software.amazon.awscdk.services.codepipeline.actions.RevisionType revisionType;
        java.lang.String revisionValue;

        /**
         * Sets the value of {@link SourceRevision#getActionName}
         * @param actionName The name of the action where the override will be applied. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link SourceRevision#getRevisionType}
         * @param revisionType The type of source revision, based on the source provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revisionType(software.amazon.awscdk.services.codepipeline.actions.RevisionType revisionType) {
            this.revisionType = revisionType;
            return this;
        }

        /**
         * Sets the value of {@link SourceRevision#getRevisionValue}
         * @param revisionValue The source revision, or version of your source artifact, with the changes that you want to run in the pipeline execution. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revisionValue(java.lang.String revisionValue) {
            this.revisionValue = revisionValue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceRevision}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SourceRevision build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SourceRevision}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceRevision {
        private final java.lang.String actionName;
        private final software.amazon.awscdk.services.codepipeline.actions.RevisionType revisionType;
        private final java.lang.String revisionValue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.revisionType = software.amazon.jsii.Kernel.get(this, "revisionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.RevisionType.class));
            this.revisionValue = software.amazon.jsii.Kernel.get(this, "revisionValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.revisionType = java.util.Objects.requireNonNull(builder.revisionType, "revisionType is required");
            this.revisionValue = java.util.Objects.requireNonNull(builder.revisionValue, "revisionValue is required");
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.RevisionType getRevisionType() {
            return this.revisionType;
        }

        @Override
        public final java.lang.String getRevisionValue() {
            return this.revisionValue;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionName", om.valueToTree(this.getActionName()));
            data.set("revisionType", om.valueToTree(this.getRevisionType()));
            data.set("revisionValue", om.valueToTree(this.getRevisionValue()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.SourceRevision"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceRevision.Jsii$Proxy that = (SourceRevision.Jsii$Proxy) o;

            if (!actionName.equals(that.actionName)) return false;
            if (!revisionType.equals(that.revisionType)) return false;
            return this.revisionValue.equals(that.revisionValue);
        }

        @Override
        public final int hashCode() {
            int result = this.actionName.hashCode();
            result = 31 * result + (this.revisionType.hashCode());
            result = 31 * result + (this.revisionValue.hashCode());
            return result;
        }
    }
}
