package software.amazon.awscdk.services.codestarnotifications;

/**
 * The level of detail to include in the notifications for this resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codestarnotifications.*;
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.sns.*;
 * import software.amazon.awscdk.services.chatbot.*;
 * PipelineProject project = new PipelineProject(this, "MyProject");
 * Topic topic = new Topic(this, "MyTopic1");
 * SlackChannelConfiguration slack = SlackChannelConfiguration.Builder.create(this, "MySlackChannel")
 *         .slackChannelConfigurationName("YOUR_CHANNEL_NAME")
 *         .slackWorkspaceId("YOUR_SLACK_WORKSPACE_ID")
 *         .slackChannelId("YOUR_SLACK_CHANNEL_ID")
 *         .build();
 * NotificationRule rule = NotificationRule.Builder.create(this, "NotificationRule")
 *         .source(project)
 *         .events(List.of("codebuild-project-build-state-succeeded", "codebuild-project-build-state-failed"))
 *         .targets(List.of(topic))
 *         .notificationRuleName("MyNotificationRuleName")
 *         .enabled(true) // The default is true
 *         .detailType(DetailType.FULL) // The default is FULL
 *         .createdBy("Jone Doe")
 *         .build();
 * rule.addTarget(slack);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:04.339Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codestarnotifications.DetailType")
public enum DetailType {
    /**
     * BASIC will include only the contents of the event as it would appear in AWS CloudWatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BASIC,
    /**
     * FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FULL,
}
