package software.amazon.awscdk.services.cognito;

/**
 * The user-pool treatment for MFA with a passkey.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         .signInPolicy(SignInPolicy.builder()
 *                 .allowedFirstAuthFactors(AllowedFirstAuthFactors.builder().password(true).passkey(true).build())
 *                 .build())
 *         .passkeyRelyingPartyId("auth.example.com")
 *         .passkeyUserVerification(PasskeyUserVerification.REQUIRED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html#amazon-cognito-user-pools-authentication-flow-methods-passkey">https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html#amazon-cognito-user-pools-authentication-flow-methods-passkey</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:04.479Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.PasskeyUserVerification")
public enum PasskeyUserVerification {
    /**
     * Passkey MFA is preferred.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PREFERRED,
    /**
     * Passkey MFA is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRED,
}
