package software.amazon.awscdk.services.cognito;

/**
 * Password policy for User Pools.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .passwordPolicy(PasswordPolicy.builder()
 *                 .minLength(12)
 *                 .requireLowercase(true)
 *                 .requireUppercase(true)
 *                 .requireDigits(true)
 *                 .requireSymbols(true)
 *                 .tempPasswordValidity(Duration.days(3))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:04.490Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.PasswordPolicy")
@software.amazon.jsii.Jsii.Proxy(PasswordPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PasswordPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * Minimum length required for a user's password.
     * <p>
     * Default: 8
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinLength() {
        return null;
    }

    /**
     * The number of previous passwords that you want Amazon Cognito to restrict each user from reusing.
     * <p>
     * <code>passwordHistorySize</code> can not be set when <code>featurePlan</code> is <code>FeaturePlan.LITE</code>.
     * <p>
     * Default: undefined - Cognito default setting is no restriction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPasswordHistorySize() {
        return null;
    }

    /**
     * Whether the user is required to have digits in their password.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireDigits() {
        return null;
    }

    /**
     * Whether the user is required to have lowercase characters in their password.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireLowercase() {
        return null;
    }

    /**
     * Whether the user is required to have symbols in their password.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireSymbols() {
        return null;
    }

    /**
     * Whether the user is required to have uppercase characters in their password.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireUppercase() {
        return null;
    }

    /**
     * The length of time the temporary password generated by an admin is valid.
     * <p>
     * This must be provided as whole days, like Duration.days(3) or Duration.hours(48).
     * Fractional days, such as Duration.hours(20), will generate an error.
     * <p>
     * Default: Duration.days(7)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTempPasswordValidity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PasswordPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PasswordPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PasswordPolicy> {
        java.lang.Number minLength;
        java.lang.Number passwordHistorySize;
        java.lang.Boolean requireDigits;
        java.lang.Boolean requireLowercase;
        java.lang.Boolean requireSymbols;
        java.lang.Boolean requireUppercase;
        software.amazon.awscdk.Duration tempPasswordValidity;

        /**
         * Sets the value of {@link PasswordPolicy#getMinLength}
         * @param minLength Minimum length required for a user's password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minLength(java.lang.Number minLength) {
            this.minLength = minLength;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getPasswordHistorySize}
         * @param passwordHistorySize The number of previous passwords that you want Amazon Cognito to restrict each user from reusing.
         *                            <code>passwordHistorySize</code> can not be set when <code>featurePlan</code> is <code>FeaturePlan.LITE</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passwordHistorySize(java.lang.Number passwordHistorySize) {
            this.passwordHistorySize = passwordHistorySize;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getRequireDigits}
         * @param requireDigits Whether the user is required to have digits in their password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireDigits(java.lang.Boolean requireDigits) {
            this.requireDigits = requireDigits;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getRequireLowercase}
         * @param requireLowercase Whether the user is required to have lowercase characters in their password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireLowercase(java.lang.Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getRequireSymbols}
         * @param requireSymbols Whether the user is required to have symbols in their password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireSymbols(java.lang.Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getRequireUppercase}
         * @param requireUppercase Whether the user is required to have uppercase characters in their password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireUppercase(java.lang.Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getTempPasswordValidity}
         * @param tempPasswordValidity The length of time the temporary password generated by an admin is valid.
         *                             This must be provided as whole days, like Duration.days(3) or Duration.hours(48).
         *                             Fractional days, such as Duration.hours(20), will generate an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tempPasswordValidity(software.amazon.awscdk.Duration tempPasswordValidity) {
            this.tempPasswordValidity = tempPasswordValidity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PasswordPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PasswordPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PasswordPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PasswordPolicy {
        private final java.lang.Number minLength;
        private final java.lang.Number passwordHistorySize;
        private final java.lang.Boolean requireDigits;
        private final java.lang.Boolean requireLowercase;
        private final java.lang.Boolean requireSymbols;
        private final java.lang.Boolean requireUppercase;
        private final software.amazon.awscdk.Duration tempPasswordValidity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.minLength = software.amazon.jsii.Kernel.get(this, "minLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.passwordHistorySize = software.amazon.jsii.Kernel.get(this, "passwordHistorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.requireDigits = software.amazon.jsii.Kernel.get(this, "requireDigits", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.requireLowercase = software.amazon.jsii.Kernel.get(this, "requireLowercase", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.requireSymbols = software.amazon.jsii.Kernel.get(this, "requireSymbols", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.requireUppercase = software.amazon.jsii.Kernel.get(this, "requireUppercase", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.tempPasswordValidity = software.amazon.jsii.Kernel.get(this, "tempPasswordValidity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minLength = builder.minLength;
            this.passwordHistorySize = builder.passwordHistorySize;
            this.requireDigits = builder.requireDigits;
            this.requireLowercase = builder.requireLowercase;
            this.requireSymbols = builder.requireSymbols;
            this.requireUppercase = builder.requireUppercase;
            this.tempPasswordValidity = builder.tempPasswordValidity;
        }

        @Override
        public final java.lang.Number getMinLength() {
            return this.minLength;
        }

        @Override
        public final java.lang.Number getPasswordHistorySize() {
            return this.passwordHistorySize;
        }

        @Override
        public final java.lang.Boolean getRequireDigits() {
            return this.requireDigits;
        }

        @Override
        public final java.lang.Boolean getRequireLowercase() {
            return this.requireLowercase;
        }

        @Override
        public final java.lang.Boolean getRequireSymbols() {
            return this.requireSymbols;
        }

        @Override
        public final java.lang.Boolean getRequireUppercase() {
            return this.requireUppercase;
        }

        @Override
        public final software.amazon.awscdk.Duration getTempPasswordValidity() {
            return this.tempPasswordValidity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMinLength() != null) {
                data.set("minLength", om.valueToTree(this.getMinLength()));
            }
            if (this.getPasswordHistorySize() != null) {
                data.set("passwordHistorySize", om.valueToTree(this.getPasswordHistorySize()));
            }
            if (this.getRequireDigits() != null) {
                data.set("requireDigits", om.valueToTree(this.getRequireDigits()));
            }
            if (this.getRequireLowercase() != null) {
                data.set("requireLowercase", om.valueToTree(this.getRequireLowercase()));
            }
            if (this.getRequireSymbols() != null) {
                data.set("requireSymbols", om.valueToTree(this.getRequireSymbols()));
            }
            if (this.getRequireUppercase() != null) {
                data.set("requireUppercase", om.valueToTree(this.getRequireUppercase()));
            }
            if (this.getTempPasswordValidity() != null) {
                data.set("tempPasswordValidity", om.valueToTree(this.getTempPasswordValidity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.PasswordPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PasswordPolicy.Jsii$Proxy that = (PasswordPolicy.Jsii$Proxy) o;

            if (this.minLength != null ? !this.minLength.equals(that.minLength) : that.minLength != null) return false;
            if (this.passwordHistorySize != null ? !this.passwordHistorySize.equals(that.passwordHistorySize) : that.passwordHistorySize != null) return false;
            if (this.requireDigits != null ? !this.requireDigits.equals(that.requireDigits) : that.requireDigits != null) return false;
            if (this.requireLowercase != null ? !this.requireLowercase.equals(that.requireLowercase) : that.requireLowercase != null) return false;
            if (this.requireSymbols != null ? !this.requireSymbols.equals(that.requireSymbols) : that.requireSymbols != null) return false;
            if (this.requireUppercase != null ? !this.requireUppercase.equals(that.requireUppercase) : that.requireUppercase != null) return false;
            return this.tempPasswordValidity != null ? this.tempPasswordValidity.equals(that.tempPasswordValidity) : that.tempPasswordValidity == null;
        }

        @Override
        public final int hashCode() {
            int result = this.minLength != null ? this.minLength.hashCode() : 0;
            result = 31 * result + (this.passwordHistorySize != null ? this.passwordHistorySize.hashCode() : 0);
            result = 31 * result + (this.requireDigits != null ? this.requireDigits.hashCode() : 0);
            result = 31 * result + (this.requireLowercase != null ? this.requireLowercase.hashCode() : 0);
            result = 31 * result + (this.requireSymbols != null ? this.requireSymbols.hashCode() : 0);
            result = 31 * result + (this.requireUppercase != null ? this.requireUppercase.hashCode() : 0);
            result = 31 * result + (this.tempPasswordValidity != null ? this.tempPasswordValidity.hashCode() : 0);
            return result;
        }
    }
}
