package software.amazon.awscdk.services.cognito;

/**
 * Configure how Cognito sends emails.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         .email(UserPoolEmail.withSES(UserPoolSESOptions.builder()
 *                 .fromEmail("noreply&#64;myawesomeapp.com")
 *                 .fromName("Awesome App")
 *                 .replyTo("support&#64;myawesomeapp.com")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:04.505Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolEmail")
public abstract class UserPoolEmail extends software.amazon.jsii.JsiiObject {

    protected UserPoolEmail(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolEmail(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected UserPoolEmail() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Send email using Cognito.
     * <p>
     * @param replyTo
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolEmail withCognito(final @org.jetbrains.annotations.Nullable java.lang.String replyTo) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolEmail.class, "withCognito", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolEmail.class), new Object[] { replyTo });
    }

    /**
     * Send email using Cognito.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolEmail withCognito() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolEmail.class, "withCognito", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolEmail.class));
    }

    /**
     * Send email using SES.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolEmail withSES(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolSESOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolEmail.class, "withSES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolEmail.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cognito.UserPoolEmail {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
