package software.amazon.awscdk.services.cognito;

/**
 * Options to create a UserPoolGroup.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userPool;
 * Role role;
 * UserPoolGroup.Builder.create(this, "UserPoolGroup")
 *         .userPool(userPool)
 *         .groupName("my-group-name")
 *         .precedence(1)
 *         .role(role)
 *         .build();
 * // You can also add a group by using addGroup method.
 * userPool.addGroup("AnotherUserPoolGroup", UserPoolGroupOptions.builder()
 *         .groupName("another-group-name")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:04.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolGroupOptions")
@software.amazon.jsii.Jsii.Proxy(UserPoolGroupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolGroupOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * A string containing the description of the group.
     * <p>
     * Default: - no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the group.
     * <p>
     * Must be unique.
     * <p>
     * Default: - auto generate a name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return null;
    }

    /**
     * A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool.
     * <p>
     * Zero is the highest precedence value.
     * <p>
     * Groups with lower Precedence values take precedence over groups with higher or null Precedence values.
     * If a user belongs to two or more groups, it is the group with the lowest precedence value
     * whose role ARN is given in the user's tokens for the cognito:roles and cognito:preferred_role claims.
     * <p>
     * Two groups can have the same Precedence value. If this happens, neither group takes precedence over the other.
     * If two groups with the same Precedence have the same role ARN, that role is used in the cognito:preferred_role
     * claim in tokens for users in each group.
     * If the two groups have different role ARNs, the cognito:preferred_role claim isn't set in users' tokens.
     * <p>
     * Default: - null
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPrecedence() {
        return null;
    }

    /**
     * The role for the group.
     * <p>
     * Default: - no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolGroupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolGroupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolGroupOptions> {
        java.lang.String description;
        java.lang.String groupName;
        java.lang.Number precedence;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link UserPoolGroupOptions#getDescription}
         * @param description A string containing the description of the group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolGroupOptions#getGroupName}
         * @param groupName The name of the group.
         *                  Must be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(java.lang.String groupName) {
            this.groupName = groupName;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolGroupOptions#getPrecedence}
         * @param precedence A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool.
         *                   Zero is the highest precedence value.
         *                   <p>
         *                   Groups with lower Precedence values take precedence over groups with higher or null Precedence values.
         *                   If a user belongs to two or more groups, it is the group with the lowest precedence value
         *                   whose role ARN is given in the user's tokens for the cognito:roles and cognito:preferred_role claims.
         *                   <p>
         *                   Two groups can have the same Precedence value. If this happens, neither group takes precedence over the other.
         *                   If two groups with the same Precedence have the same role ARN, that role is used in the cognito:preferred_role
         *                   claim in tokens for users in each group.
         *                   If the two groups have different role ARNs, the cognito:preferred_role claim isn't set in users' tokens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder precedence(java.lang.Number precedence) {
            this.precedence = precedence;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolGroupOptions#getRole}
         * @param role The role for the group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolGroupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolGroupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolGroupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolGroupOptions {
        private final java.lang.String description;
        private final java.lang.String groupName;
        private final java.lang.Number precedence;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.precedence = software.amazon.jsii.Kernel.get(this, "precedence", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.groupName = builder.groupName;
            this.precedence = builder.precedence;
            this.role = builder.role;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getGroupName() {
            return this.groupName;
        }

        @Override
        public final java.lang.Number getPrecedence() {
            return this.precedence;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGroupName() != null) {
                data.set("groupName", om.valueToTree(this.getGroupName()));
            }
            if (this.getPrecedence() != null) {
                data.set("precedence", om.valueToTree(this.getPrecedence()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolGroupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolGroupOptions.Jsii$Proxy that = (UserPoolGroupOptions.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
            if (this.precedence != null ? !this.precedence.equals(that.precedence) : that.precedence != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
            result = 31 * result + (this.precedence != null ? this.precedence.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
