package software.amazon.awscdk.services.customerprofiles;

/**
 * Properties for defining a <code>CfnObjectType</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.customerprofiles.*;
 * CfnObjectTypeProps cfnObjectTypeProps = CfnObjectTypeProps.builder()
 *         .description("description")
 *         .domainName("domainName")
 *         .objectTypeName("objectTypeName")
 *         // the properties below are optional
 *         .allowProfileCreation(false)
 *         .encryptionKey("encryptionKey")
 *         .expirationDays(123)
 *         .fields(List.of(FieldMapProperty.builder()
 *                 .name("name")
 *                 .objectTypeField(ObjectTypeFieldProperty.builder()
 *                         .contentType("contentType")
 *                         .source("source")
 *                         .target("target")
 *                         .build())
 *                 .build()))
 *         .keys(List.of(KeyMapProperty.builder()
 *                 .name("name")
 *                 .objectTypeKeyList(List.of(ObjectTypeKeyProperty.builder()
 *                         .fieldNames(List.of("fieldNames"))
 *                         .standardIdentifiers(List.of("standardIdentifiers"))
 *                         .build()))
 *                 .build()))
 *         .maxProfileObjectCount(123)
 *         .sourceLastUpdatedTimestampFormat("sourceLastUpdatedTimestampFormat")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .templateId("templateId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:04.855Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnObjectTypeProps")
@software.amazon.jsii.Jsii.Proxy(CfnObjectTypeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnObjectTypeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The description of the profile object type mapping.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The unique name of the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The name of the profile object type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-objecttypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-objecttypename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectTypeName();

    /**
     * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type.
     * <p>
     * The default is <code>FALSE</code> . If the AllowProfileCreation flag is set to <code>FALSE</code> , then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code> , and if no match is found, then the service creates a new standard profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-allowprofilecreation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-allowprofilecreation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowProfileCreation() {
        return null;
    }

    /**
     * The customer-provided key to encrypt the profile object that will be created in this profile object type mapping.
     * <p>
     * If not specified the system will use the encryption key of the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-encryptionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-encryptionkey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKey() {
        return null;
    }

    /**
     * The number of days until the data of this type expires.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-expirationdays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-expirationdays</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getExpirationDays() {
        return null;
    }

    /**
     * A list of field definitions for the object type mapping.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-fields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-fields</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFields() {
        return null;
    }

    /**
     * A list of keys that can be used to map data to the profile or search for the profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-keys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-keys</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKeys() {
        return null;
    }

    /**
     * The amount of profile object max count assigned to the object type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-maxprofileobjectcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-maxprofileobjectcount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxProfileObjectCount() {
        return null;
    }

    /**
     * The format of your sourceLastUpdatedTimestamp that was previously set up.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-sourcelastupdatedtimestampformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-sourcelastupdatedtimestampformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceLastUpdatedTimestampFormat() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A unique identifier for the template mapping.
     * <p>
     * This can be used instead of specifying the Keys and Fields properties directly.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-templateid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-templateid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnObjectTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnObjectTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnObjectTypeProps> {
        java.lang.String description;
        java.lang.String domainName;
        java.lang.String objectTypeName;
        java.lang.Object allowProfileCreation;
        java.lang.String encryptionKey;
        java.lang.Number expirationDays;
        java.lang.Object fields;
        java.lang.Object keys;
        java.lang.Number maxProfileObjectCount;
        java.lang.String sourceLastUpdatedTimestampFormat;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String templateId;

        /**
         * Sets the value of {@link CfnObjectTypeProps#getDescription}
         * @param description The description of the profile object type mapping. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getDomainName}
         * @param domainName The unique name of the domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getObjectTypeName}
         * @param objectTypeName The name of the profile object type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectTypeName(java.lang.String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getAllowProfileCreation}
         * @param allowProfileCreation Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type.
         *                             The default is <code>FALSE</code> . If the AllowProfileCreation flag is set to <code>FALSE</code> , then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code> , and if no match is found, then the service creates a new standard profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowProfileCreation(java.lang.Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getAllowProfileCreation}
         * @param allowProfileCreation Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type.
         *                             The default is <code>FALSE</code> . If the AllowProfileCreation flag is set to <code>FALSE</code> , then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code> , and if no match is found, then the service creates a new standard profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowProfileCreation(software.amazon.awscdk.IResolvable allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getEncryptionKey}
         * @param encryptionKey The customer-provided key to encrypt the profile object that will be created in this profile object type mapping.
         *                      If not specified the system will use the encryption key of the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(java.lang.String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getExpirationDays}
         * @param expirationDays The number of days until the data of this type expires.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expirationDays(java.lang.Number expirationDays) {
            this.expirationDays = expirationDays;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getFields}
         * @param fields A list of field definitions for the object type mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(software.amazon.awscdk.IResolvable fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getFields}
         * @param fields A list of field definitions for the object type mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(java.util.List<? extends java.lang.Object> fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getKeys}
         * @param keys A list of keys that can be used to map data to the profile or search for the profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keys(software.amazon.awscdk.IResolvable keys) {
            this.keys = keys;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getKeys}
         * @param keys A list of keys that can be used to map data to the profile or search for the profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keys(java.util.List<? extends java.lang.Object> keys) {
            this.keys = keys;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getMaxProfileObjectCount}
         * @param maxProfileObjectCount The amount of profile object max count assigned to the object type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxProfileObjectCount(java.lang.Number maxProfileObjectCount) {
            this.maxProfileObjectCount = maxProfileObjectCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getSourceLastUpdatedTimestampFormat}
         * @param sourceLastUpdatedTimestampFormat The format of your sourceLastUpdatedTimestamp that was previously set up.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLastUpdatedTimestampFormat(java.lang.String sourceLastUpdatedTimestampFormat) {
            this.sourceLastUpdatedTimestampFormat = sourceLastUpdatedTimestampFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnObjectTypeProps#getTemplateId}
         * @param templateId A unique identifier for the template mapping.
         *                   This can be used instead of specifying the Keys and Fields properties directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateId(java.lang.String templateId) {
            this.templateId = templateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnObjectTypeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnObjectTypeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnObjectTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnObjectTypeProps {
        private final java.lang.String description;
        private final java.lang.String domainName;
        private final java.lang.String objectTypeName;
        private final java.lang.Object allowProfileCreation;
        private final java.lang.String encryptionKey;
        private final java.lang.Number expirationDays;
        private final java.lang.Object fields;
        private final java.lang.Object keys;
        private final java.lang.Number maxProfileObjectCount;
        private final java.lang.String sourceLastUpdatedTimestampFormat;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String templateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.objectTypeName = software.amazon.jsii.Kernel.get(this, "objectTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowProfileCreation = software.amazon.jsii.Kernel.get(this, "allowProfileCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.expirationDays = software.amazon.jsii.Kernel.get(this, "expirationDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.fields = software.amazon.jsii.Kernel.get(this, "fields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.keys = software.amazon.jsii.Kernel.get(this, "keys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maxProfileObjectCount = software.amazon.jsii.Kernel.get(this, "maxProfileObjectCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.sourceLastUpdatedTimestampFormat = software.amazon.jsii.Kernel.get(this, "sourceLastUpdatedTimestampFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.templateId = software.amazon.jsii.Kernel.get(this, "templateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.objectTypeName = java.util.Objects.requireNonNull(builder.objectTypeName, "objectTypeName is required");
            this.allowProfileCreation = builder.allowProfileCreation;
            this.encryptionKey = builder.encryptionKey;
            this.expirationDays = builder.expirationDays;
            this.fields = builder.fields;
            this.keys = builder.keys;
            this.maxProfileObjectCount = builder.maxProfileObjectCount;
            this.sourceLastUpdatedTimestampFormat = builder.sourceLastUpdatedTimestampFormat;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.templateId = builder.templateId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getObjectTypeName() {
            return this.objectTypeName;
        }

        @Override
        public final java.lang.Object getAllowProfileCreation() {
            return this.allowProfileCreation;
        }

        @Override
        public final java.lang.String getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.Number getExpirationDays() {
            return this.expirationDays;
        }

        @Override
        public final java.lang.Object getFields() {
            return this.fields;
        }

        @Override
        public final java.lang.Object getKeys() {
            return this.keys;
        }

        @Override
        public final java.lang.Number getMaxProfileObjectCount() {
            return this.maxProfileObjectCount;
        }

        @Override
        public final java.lang.String getSourceLastUpdatedTimestampFormat() {
            return this.sourceLastUpdatedTimestampFormat;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTemplateId() {
            return this.templateId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("description", om.valueToTree(this.getDescription()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("objectTypeName", om.valueToTree(this.getObjectTypeName()));
            if (this.getAllowProfileCreation() != null) {
                data.set("allowProfileCreation", om.valueToTree(this.getAllowProfileCreation()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getExpirationDays() != null) {
                data.set("expirationDays", om.valueToTree(this.getExpirationDays()));
            }
            if (this.getFields() != null) {
                data.set("fields", om.valueToTree(this.getFields()));
            }
            if (this.getKeys() != null) {
                data.set("keys", om.valueToTree(this.getKeys()));
            }
            if (this.getMaxProfileObjectCount() != null) {
                data.set("maxProfileObjectCount", om.valueToTree(this.getMaxProfileObjectCount()));
            }
            if (this.getSourceLastUpdatedTimestampFormat() != null) {
                data.set("sourceLastUpdatedTimestampFormat", om.valueToTree(this.getSourceLastUpdatedTimestampFormat()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTemplateId() != null) {
                data.set("templateId", om.valueToTree(this.getTemplateId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnObjectTypeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnObjectTypeProps.Jsii$Proxy that = (CfnObjectTypeProps.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (!objectTypeName.equals(that.objectTypeName)) return false;
            if (this.allowProfileCreation != null ? !this.allowProfileCreation.equals(that.allowProfileCreation) : that.allowProfileCreation != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.expirationDays != null ? !this.expirationDays.equals(that.expirationDays) : that.expirationDays != null) return false;
            if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) return false;
            if (this.keys != null ? !this.keys.equals(that.keys) : that.keys != null) return false;
            if (this.maxProfileObjectCount != null ? !this.maxProfileObjectCount.equals(that.maxProfileObjectCount) : that.maxProfileObjectCount != null) return false;
            if (this.sourceLastUpdatedTimestampFormat != null ? !this.sourceLastUpdatedTimestampFormat.equals(that.sourceLastUpdatedTimestampFormat) : that.sourceLastUpdatedTimestampFormat != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.templateId != null ? this.templateId.equals(that.templateId) : that.templateId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.objectTypeName.hashCode());
            result = 31 * result + (this.allowProfileCreation != null ? this.allowProfileCreation.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.expirationDays != null ? this.expirationDays.hashCode() : 0);
            result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
            result = 31 * result + (this.keys != null ? this.keys.hashCode() : 0);
            result = 31 * result + (this.maxProfileObjectCount != null ? this.maxProfileObjectCount.hashCode() : 0);
            result = 31 * result + (this.sourceLastUpdatedTimestampFormat != null ? this.sourceLastUpdatedTimestampFormat.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.templateId != null ? this.templateId.hashCode() : 0);
            return result;
        }
    }
}
