package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnEnvironment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnEnvironmentProps cfnEnvironmentProps = CfnEnvironmentProps.builder()
 *         .domainIdentifier("domainIdentifier")
 *         .name("name")
 *         .projectIdentifier("projectIdentifier")
 *         // the properties below are optional
 *         .description("description")
 *         .environmentAccountIdentifier("environmentAccountIdentifier")
 *         .environmentAccountRegion("environmentAccountRegion")
 *         .environmentProfileIdentifier("environmentProfileIdentifier")
 *         .environmentRoleArn("environmentRoleArn")
 *         .glossaryTerms(List.of("glossaryTerms"))
 *         .userParameters(List.of(EnvironmentParameterProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:05.062Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Amazon DataZone domain in which the environment is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The name of the Amazon DataZone environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The identifier of the Amazon DataZone project in which this environment is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-projectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-projectidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectIdentifier();

    /**
     * The description of the environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The identifier of the AWS account in which an environment exists.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-environmentaccountidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-environmentaccountidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentAccountIdentifier() {
        return null;
    }

    /**
     * The AWS Region in which an environment exists.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-environmentaccountregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-environmentaccountregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentAccountRegion() {
        return null;
    }

    /**
     * The identifier of the environment profile that is used to create this Amazon DataZone environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-environmentprofileidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-environmentprofileidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentProfileIdentifier() {
        return null;
    }

    /**
     * The ARN of the environment role.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-environmentrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-environmentrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentRoleArn() {
        return null;
    }

    /**
     * The glossary terms that can be used in this Amazon DataZone environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-glossaryterms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-glossaryterms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGlossaryTerms() {
        return null;
    }

    /**
     * The user parameters of this Amazon DataZone environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-userparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-userparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentProps> {
        java.lang.String domainIdentifier;
        java.lang.String name;
        java.lang.String projectIdentifier;
        java.lang.String description;
        java.lang.String environmentAccountIdentifier;
        java.lang.String environmentAccountRegion;
        java.lang.String environmentProfileIdentifier;
        java.lang.String environmentRoleArn;
        java.util.List<java.lang.String> glossaryTerms;
        java.lang.Object userParameters;

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDomainIdentifier}
         * @param domainIdentifier The identifier of the Amazon DataZone domain in which the environment is created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getName}
         * @param name The name of the Amazon DataZone environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getProjectIdentifier}
         * @param projectIdentifier The identifier of the Amazon DataZone project in which this environment is created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectIdentifier(java.lang.String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDescription}
         * @param description The description of the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getEnvironmentAccountIdentifier}
         * @param environmentAccountIdentifier The identifier of the AWS account in which an environment exists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentAccountIdentifier(java.lang.String environmentAccountIdentifier) {
            this.environmentAccountIdentifier = environmentAccountIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getEnvironmentAccountRegion}
         * @param environmentAccountRegion The AWS Region in which an environment exists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentAccountRegion(java.lang.String environmentAccountRegion) {
            this.environmentAccountRegion = environmentAccountRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getEnvironmentProfileIdentifier}
         * @param environmentProfileIdentifier The identifier of the environment profile that is used to create this Amazon DataZone environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentProfileIdentifier(java.lang.String environmentProfileIdentifier) {
            this.environmentProfileIdentifier = environmentProfileIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getEnvironmentRoleArn}
         * @param environmentRoleArn The ARN of the environment role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentRoleArn(java.lang.String environmentRoleArn) {
            this.environmentRoleArn = environmentRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getGlossaryTerms}
         * @param glossaryTerms The glossary terms that can be used in this Amazon DataZone environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder glossaryTerms(java.util.List<java.lang.String> glossaryTerms) {
            this.glossaryTerms = glossaryTerms;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getUserParameters}
         * @param userParameters The user parameters of this Amazon DataZone environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userParameters(software.amazon.awscdk.IResolvable userParameters) {
            this.userParameters = userParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getUserParameters}
         * @param userParameters The user parameters of this Amazon DataZone environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userParameters(java.util.List<? extends java.lang.Object> userParameters) {
            this.userParameters = userParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentProps {
        private final java.lang.String domainIdentifier;
        private final java.lang.String name;
        private final java.lang.String projectIdentifier;
        private final java.lang.String description;
        private final java.lang.String environmentAccountIdentifier;
        private final java.lang.String environmentAccountRegion;
        private final java.lang.String environmentProfileIdentifier;
        private final java.lang.String environmentRoleArn;
        private final java.util.List<java.lang.String> glossaryTerms;
        private final java.lang.Object userParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectIdentifier = software.amazon.jsii.Kernel.get(this, "projectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentAccountIdentifier = software.amazon.jsii.Kernel.get(this, "environmentAccountIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentAccountRegion = software.amazon.jsii.Kernel.get(this, "environmentAccountRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentProfileIdentifier = software.amazon.jsii.Kernel.get(this, "environmentProfileIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentRoleArn = software.amazon.jsii.Kernel.get(this, "environmentRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.glossaryTerms = software.amazon.jsii.Kernel.get(this, "glossaryTerms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.userParameters = software.amazon.jsii.Kernel.get(this, "userParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.projectIdentifier = java.util.Objects.requireNonNull(builder.projectIdentifier, "projectIdentifier is required");
            this.description = builder.description;
            this.environmentAccountIdentifier = builder.environmentAccountIdentifier;
            this.environmentAccountRegion = builder.environmentAccountRegion;
            this.environmentProfileIdentifier = builder.environmentProfileIdentifier;
            this.environmentRoleArn = builder.environmentRoleArn;
            this.glossaryTerms = builder.glossaryTerms;
            this.userParameters = builder.userParameters;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEnvironmentAccountIdentifier() {
            return this.environmentAccountIdentifier;
        }

        @Override
        public final java.lang.String getEnvironmentAccountRegion() {
            return this.environmentAccountRegion;
        }

        @Override
        public final java.lang.String getEnvironmentProfileIdentifier() {
            return this.environmentProfileIdentifier;
        }

        @Override
        public final java.lang.String getEnvironmentRoleArn() {
            return this.environmentRoleArn;
        }

        @Override
        public final java.util.List<java.lang.String> getGlossaryTerms() {
            return this.glossaryTerms;
        }

        @Override
        public final java.lang.Object getUserParameters() {
            return this.userParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("projectIdentifier", om.valueToTree(this.getProjectIdentifier()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironmentAccountIdentifier() != null) {
                data.set("environmentAccountIdentifier", om.valueToTree(this.getEnvironmentAccountIdentifier()));
            }
            if (this.getEnvironmentAccountRegion() != null) {
                data.set("environmentAccountRegion", om.valueToTree(this.getEnvironmentAccountRegion()));
            }
            if (this.getEnvironmentProfileIdentifier() != null) {
                data.set("environmentProfileIdentifier", om.valueToTree(this.getEnvironmentProfileIdentifier()));
            }
            if (this.getEnvironmentRoleArn() != null) {
                data.set("environmentRoleArn", om.valueToTree(this.getEnvironmentRoleArn()));
            }
            if (this.getGlossaryTerms() != null) {
                data.set("glossaryTerms", om.valueToTree(this.getGlossaryTerms()));
            }
            if (this.getUserParameters() != null) {
                data.set("userParameters", om.valueToTree(this.getUserParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentProps.Jsii$Proxy that = (CfnEnvironmentProps.Jsii$Proxy) o;

            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!name.equals(that.name)) return false;
            if (!projectIdentifier.equals(that.projectIdentifier)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environmentAccountIdentifier != null ? !this.environmentAccountIdentifier.equals(that.environmentAccountIdentifier) : that.environmentAccountIdentifier != null) return false;
            if (this.environmentAccountRegion != null ? !this.environmentAccountRegion.equals(that.environmentAccountRegion) : that.environmentAccountRegion != null) return false;
            if (this.environmentProfileIdentifier != null ? !this.environmentProfileIdentifier.equals(that.environmentProfileIdentifier) : that.environmentProfileIdentifier != null) return false;
            if (this.environmentRoleArn != null ? !this.environmentRoleArn.equals(that.environmentRoleArn) : that.environmentRoleArn != null) return false;
            if (this.glossaryTerms != null ? !this.glossaryTerms.equals(that.glossaryTerms) : that.glossaryTerms != null) return false;
            return this.userParameters != null ? this.userParameters.equals(that.userParameters) : that.userParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainIdentifier.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.projectIdentifier.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environmentAccountIdentifier != null ? this.environmentAccountIdentifier.hashCode() : 0);
            result = 31 * result + (this.environmentAccountRegion != null ? this.environmentAccountRegion.hashCode() : 0);
            result = 31 * result + (this.environmentProfileIdentifier != null ? this.environmentProfileIdentifier.hashCode() : 0);
            result = 31 * result + (this.environmentRoleArn != null ? this.environmentRoleArn.hashCode() : 0);
            result = 31 * result + (this.glossaryTerms != null ? this.glossaryTerms.hashCode() : 0);
            result = 31 * result + (this.userParameters != null ? this.userParameters.hashCode() : 0);
            return result;
        }
    }
}
