package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnProjectProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnProjectProfileProps cfnProjectProfileProps = CfnProjectProfileProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .domainIdentifier("domainIdentifier")
 *         .domainUnitIdentifier("domainUnitIdentifier")
 *         .environmentConfigurations(List.of(EnvironmentConfigurationProperty.builder()
 *                 .awsRegion(RegionProperty.builder()
 *                         .regionName("regionName")
 *                         .build())
 *                 .environmentBlueprintId("environmentBlueprintId")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .awsAccount(AwsAccountProperty.builder()
 *                         .awsAccountId("awsAccountId")
 *                         .build())
 *                 .configurationParameters(EnvironmentConfigurationParametersDetailsProperty.builder()
 *                         .parameterOverrides(List.of(EnvironmentConfigurationParameterProperty.builder()
 *                                 .isEditable(false)
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .resolvedParameters(List.of(EnvironmentConfigurationParameterProperty.builder()
 *                                 .isEditable(false)
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .ssmPath("ssmPath")
 *                         .build())
 *                 .deploymentMode("deploymentMode")
 *                 .deploymentOrder(123)
 *                 .description("description")
 *                 .id("id")
 *                 .build()))
 *         .status("status")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:05.084Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnProjectProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnProjectProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProjectProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of a project profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The description of the project profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainIdentifier() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-domainunitidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-domainunitidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainUnitIdentifier() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-environmentconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-environmentconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentConfigurations() {
        return null;
    }

    /**
     * The status of a project profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectprofile.html#cfn-datazone-projectprofile-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnProjectProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProjectProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProjectProfileProps> {
        java.lang.String name;
        java.lang.String description;
        java.lang.String domainIdentifier;
        java.lang.String domainUnitIdentifier;
        java.lang.Object environmentConfigurations;
        java.lang.String status;

        /**
         * Sets the value of {@link CfnProjectProfileProps#getName}
         * @param name The name of a project profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProfileProps#getDescription}
         * @param description The description of the project profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProfileProps#getDomainIdentifier}
         * @param domainIdentifier the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProfileProps#getDomainUnitIdentifier}
         * @param domainUnitIdentifier the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainUnitIdentifier(java.lang.String domainUnitIdentifier) {
            this.domainUnitIdentifier = domainUnitIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProfileProps#getEnvironmentConfigurations}
         * @param environmentConfigurations the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentConfigurations(software.amazon.awscdk.IResolvable environmentConfigurations) {
            this.environmentConfigurations = environmentConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProfileProps#getEnvironmentConfigurations}
         * @param environmentConfigurations the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentConfigurations(java.util.List<? extends java.lang.Object> environmentConfigurations) {
            this.environmentConfigurations = environmentConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProfileProps#getStatus}
         * @param status The status of a project profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProjectProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProjectProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProjectProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProjectProfileProps {
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.lang.String domainIdentifier;
        private final java.lang.String domainUnitIdentifier;
        private final java.lang.Object environmentConfigurations;
        private final java.lang.String status;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainUnitIdentifier = software.amazon.jsii.Kernel.get(this, "domainUnitIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentConfigurations = software.amazon.jsii.Kernel.get(this, "environmentConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.domainIdentifier = builder.domainIdentifier;
            this.domainUnitIdentifier = builder.domainUnitIdentifier;
            this.environmentConfigurations = builder.environmentConfigurations;
            this.status = builder.status;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getDomainUnitIdentifier() {
            return this.domainUnitIdentifier;
        }

        @Override
        public final java.lang.Object getEnvironmentConfigurations() {
            return this.environmentConfigurations;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDomainIdentifier() != null) {
                data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            }
            if (this.getDomainUnitIdentifier() != null) {
                data.set("domainUnitIdentifier", om.valueToTree(this.getDomainUnitIdentifier()));
            }
            if (this.getEnvironmentConfigurations() != null) {
                data.set("environmentConfigurations", om.valueToTree(this.getEnvironmentConfigurations()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnProjectProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProjectProfileProps.Jsii$Proxy that = (CfnProjectProfileProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.domainIdentifier != null ? !this.domainIdentifier.equals(that.domainIdentifier) : that.domainIdentifier != null) return false;
            if (this.domainUnitIdentifier != null ? !this.domainUnitIdentifier.equals(that.domainUnitIdentifier) : that.domainUnitIdentifier != null) return false;
            if (this.environmentConfigurations != null ? !this.environmentConfigurations.equals(that.environmentConfigurations) : that.environmentConfigurations != null) return false;
            return this.status != null ? this.status.equals(that.status) : that.status == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.domainIdentifier != null ? this.domainIdentifier.hashCode() : 0);
            result = 31 * result + (this.domainUnitIdentifier != null ? this.domainUnitIdentifier.hashCode() : 0);
            result = 31 * result + (this.environmentConfigurations != null ? this.environmentConfigurations.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            return result;
        }
    }
}
