package software.amazon.awscdk.services.ec2;

/**
 * A SSM Parameter that contains the AMI ID for Amazon Linux 2.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * AmazonLinux2Kernel amazonLinux2Kernel;
 * UserData userData;
 * AmazonLinux2ImageSsmParameter amazonLinux2ImageSsmParameter = AmazonLinux2ImageSsmParameter.Builder.create()
 *         .additionalCacheKey("additionalCacheKey")
 *         .cachedInContext(false)
 *         .cpuType(AmazonLinuxCpuType.ARM_64)
 *         .edition(AmazonLinuxEdition.STANDARD)
 *         .kernel(amazonLinux2Kernel)
 *         .storage(AmazonLinuxStorage.EBS)
 *         .userData(userData)
 *         .virtualization(AmazonLinuxVirt.HVM)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:05.542Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AmazonLinux2ImageSsmParameter")
public class AmazonLinux2ImageSsmParameter extends software.amazon.awscdk.services.ec2.AmazonLinuxImageSsmParameterBase {

    protected AmazonLinux2ImageSsmParameter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AmazonLinux2ImageSsmParameter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AmazonLinux2ImageSsmParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Generates a SSM Parameter name for a specific amazon linux 2 AMI.
     * <p>
     * Example values:
     * <p>
     * <blockquote><pre>
     * "/aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-x86_64-ebs",
     * "/aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-x86_64-gp2",
     * "/aws/service/ami-amazon-linux-latest/amzn2-ami-kernel-5.10-hvm-x86_64-ebs",
     * "/aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-arm64-gp2",
     * "/aws/service/ami-amazon-linux-latest/amzn2-ami-minimal-hvm-arm64-ebs",
     * "/aws/service/ami-amazon-linux-latest/amzn2-ami-kernel-5.10-hvm-arm64-gp2",
     * "/aws/service/ami-amazon-linux-latest/amzn2-ami-kernel-5.10-hvm-x86_64-gp2",
     * "/aws/service/ami-amazon-linux-latest/amzn2-ami-minimal-hvm-x86_64-ebs"
     * </pre></blockquote>
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String ssmParameterName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameterProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameter.class, "ssmParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameter> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameterProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameterProps.Builder();
        }

        /**
         * Adds an additional discriminator to the <code>cdk.context.json</code> cache key.
         * <p>
         * Default: - no additional cache key
         * <p>
         * @return {@code this}
         * @param additionalCacheKey Adds an additional discriminator to the <code>cdk.context.json</code> cache key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalCacheKey(final java.lang.String additionalCacheKey) {
            this.props.additionalCacheKey(additionalCacheKey);
            return this;
        }

        /**
         * Whether the AMI ID is cached to be stable between deployments.
         * <p>
         * By default, the newest image is used on each deployment. This will cause
         * instances to be replaced whenever a new version is released, and may cause
         * downtime if there aren't enough running instances in the AutoScalingGroup
         * to reschedule the tasks on.
         * <p>
         * If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
         * same value will be used on future runs. Your instances will not be replaced
         * but your AMI version will grow old over time. To refresh the AMI lookup,
         * you will have to evict the value from the cache using the <code>cdk context</code>
         * command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
         * more information.
         * <p>
         * Can not be set to <code>true</code> in environment-agnostic stacks.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param cachedInContext Whether the AMI ID is cached to be stable between deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedInContext(final java.lang.Boolean cachedInContext) {
            this.props.cachedInContext(cachedInContext);
            return this;
        }

        /**
         * Initial user data.
         * <p>
         * Default: - Empty UserData for Linux machines
         * <p>
         * @return {@code this}
         * @param userData Initial user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * CPU Type.
         * <p>
         * Default: AmazonLinuxCpuType.X86_64
         * <p>
         * @return {@code this}
         * @param cpuType CPU Type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuType(final software.amazon.awscdk.services.ec2.AmazonLinuxCpuType cpuType) {
            this.props.cpuType(cpuType);
            return this;
        }

        /**
         * What edition of Amazon Linux to use.
         * <p>
         * Default: AmazonLinuxEdition.Standard
         * <p>
         * @return {@code this}
         * @param edition What edition of Amazon Linux to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edition(final software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition) {
            this.props.edition(edition);
            return this;
        }

        /**
         * What kernel version of Amazon Linux to use.
         * <p>
         * Default: -
         * <p>
         * @return {@code this}
         * @param kernel What kernel version of Amazon Linux to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernel(final software.amazon.awscdk.services.ec2.AmazonLinux2Kernel kernel) {
            this.props.kernel(kernel);
            return this;
        }

        /**
         * What storage backed image to use.
         * <p>
         * Default: GeneralPurpose
         * <p>
         * @return {@code this}
         * @param storage What storage backed image to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storage(final software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage) {
            this.props.storage(storage);
            return this;
        }

        /**
         * Virtualization type.
         * <p>
         * Default: HVM
         * <p>
         * @return {@code this}
         * @param virtualization Virtualization type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualization(final software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization) {
            this.props.virtualization(virtualization);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameter build() {
            return new software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameter(
                this.props.build()
            );
        }
    }
}
