package software.amazon.awscdk.services.ec2;

/**
 * Options for InitCommand.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * InitServiceRestartHandle handle = new InitServiceRestartHandle();
 * CloudFormationInit.fromElements(InitCommand.shellCommand("/usr/bin/custom-nginx-install.sh", InitCommandOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitService.enable("nginx", InitServiceOptions.builder().serviceRestartHandle(handle).build()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:06.105Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InitCommandOptions")
@software.amazon.jsii.Jsii.Proxy(InitCommandOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InitCommandOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The working directory.
     * <p>
     * Default: - Use default working directory
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCwd() {
        return null;
    }

    /**
     * Sets environment variables for the command.
     * <p>
     * This property overwrites, rather than appends, the existing environment.
     * <p>
     * Default: - Use current environment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return null;
    }

    /**
     * Continue running if this command fails.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreErrors() {
        return null;
    }

    /**
     * Identifier key for this command.
     * <p>
     * Commands are executed in lexicographical order of their key names.
     * <p>
     * Default: - Automatically generated based on index
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return null;
    }

    /**
     * Restart the given service(s) after this command has run.
     * <p>
     * Default: - Do not restart any service
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> getServiceRestartHandles() {
        return null;
    }

    /**
     * Command to determine whether this command should be run.
     * <p>
     * If the test passes (exits with error code of 0), the command is run.
     * <p>
     * Default: - Always run the command
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTestCmd() {
        return null;
    }

    /**
     * The duration to wait after a command has finished in case the command causes a reboot.
     * <p>
     * Set this value to <code>InitCommandWaitDuration.none()</code> if you do not want to wait for every command;
     * <code>InitCommandWaitDuration.forever()</code> directs cfn-init to exit and resume only after the reboot is complete.
     * <p>
     * For Windows systems only.
     * <p>
     * Default: - 60 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitCommandWaitDuration getWaitAfterCompletion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InitCommandOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InitCommandOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InitCommandOptions> {
        java.lang.String cwd;
        java.util.Map<java.lang.String, java.lang.String> env;
        java.lang.Boolean ignoreErrors;
        java.lang.String key;
        java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        java.lang.String testCmd;
        software.amazon.awscdk.services.ec2.InitCommandWaitDuration waitAfterCompletion;

        /**
         * Sets the value of {@link InitCommandOptions#getCwd}
         * @param cwd The working directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwd(java.lang.String cwd) {
            this.cwd = cwd;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getEnv}
         * @param env Sets environment variables for the command.
         *            This property overwrites, rather than appends, the existing environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(java.util.Map<java.lang.String, java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getIgnoreErrors}
         * @param ignoreErrors Continue running if this command fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreErrors(java.lang.Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getKey}
         * @param key Identifier key for this command.
         *            Commands are executed in lexicographical order of their key names.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getServiceRestartHandles}
         * @param serviceRestartHandles Restart the given service(s) after this command has run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder serviceRestartHandles(java.util.List<? extends software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles) {
            this.serviceRestartHandles = (java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle>)serviceRestartHandles;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getTestCmd}
         * @param testCmd Command to determine whether this command should be run.
         *                If the test passes (exits with error code of 0), the command is run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testCmd(java.lang.String testCmd) {
            this.testCmd = testCmd;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getWaitAfterCompletion}
         * @param waitAfterCompletion The duration to wait after a command has finished in case the command causes a reboot.
         *                            Set this value to <code>InitCommandWaitDuration.none()</code> if you do not want to wait for every command;
         *                            <code>InitCommandWaitDuration.forever()</code> directs cfn-init to exit and resume only after the reboot is complete.
         *                            <p>
         *                            For Windows systems only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitAfterCompletion(software.amazon.awscdk.services.ec2.InitCommandWaitDuration waitAfterCompletion) {
            this.waitAfterCompletion = waitAfterCompletion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InitCommandOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InitCommandOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InitCommandOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitCommandOptions {
        private final java.lang.String cwd;
        private final java.util.Map<java.lang.String, java.lang.String> env;
        private final java.lang.Boolean ignoreErrors;
        private final java.lang.String key;
        private final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        private final java.lang.String testCmd;
        private final software.amazon.awscdk.services.ec2.InitCommandWaitDuration waitAfterCompletion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cwd = software.amazon.jsii.Kernel.get(this, "cwd", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ignoreErrors = software.amazon.jsii.Kernel.get(this, "ignoreErrors", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRestartHandles = software.amazon.jsii.Kernel.get(this, "serviceRestartHandles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitServiceRestartHandle.class)));
            this.testCmd = software.amazon.jsii.Kernel.get(this, "testCmd", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.waitAfterCompletion = software.amazon.jsii.Kernel.get(this, "waitAfterCompletion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitCommandWaitDuration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cwd = builder.cwd;
            this.env = builder.env;
            this.ignoreErrors = builder.ignoreErrors;
            this.key = builder.key;
            this.serviceRestartHandles = (java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle>)builder.serviceRestartHandles;
            this.testCmd = builder.testCmd;
            this.waitAfterCompletion = builder.waitAfterCompletion;
        }

        @Override
        public final java.lang.String getCwd() {
            return this.cwd;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.Boolean getIgnoreErrors() {
            return this.ignoreErrors;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> getServiceRestartHandles() {
            return this.serviceRestartHandles;
        }

        @Override
        public final java.lang.String getTestCmd() {
            return this.testCmd;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InitCommandWaitDuration getWaitAfterCompletion() {
            return this.waitAfterCompletion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCwd() != null) {
                data.set("cwd", om.valueToTree(this.getCwd()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getIgnoreErrors() != null) {
                data.set("ignoreErrors", om.valueToTree(this.getIgnoreErrors()));
            }
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }
            if (this.getServiceRestartHandles() != null) {
                data.set("serviceRestartHandles", om.valueToTree(this.getServiceRestartHandles()));
            }
            if (this.getTestCmd() != null) {
                data.set("testCmd", om.valueToTree(this.getTestCmd()));
            }
            if (this.getWaitAfterCompletion() != null) {
                data.set("waitAfterCompletion", om.valueToTree(this.getWaitAfterCompletion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.InitCommandOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InitCommandOptions.Jsii$Proxy that = (InitCommandOptions.Jsii$Proxy) o;

            if (this.cwd != null ? !this.cwd.equals(that.cwd) : that.cwd != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.ignoreErrors != null ? !this.ignoreErrors.equals(that.ignoreErrors) : that.ignoreErrors != null) return false;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
            if (this.serviceRestartHandles != null ? !this.serviceRestartHandles.equals(that.serviceRestartHandles) : that.serviceRestartHandles != null) return false;
            if (this.testCmd != null ? !this.testCmd.equals(that.testCmd) : that.testCmd != null) return false;
            return this.waitAfterCompletion != null ? this.waitAfterCompletion.equals(that.waitAfterCompletion) : that.waitAfterCompletion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cwd != null ? this.cwd.hashCode() : 0;
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.ignoreErrors != null ? this.ignoreErrors.hashCode() : 0);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.serviceRestartHandles != null ? this.serviceRestartHandles.hashCode() : 0);
            result = 31 * result + (this.testCmd != null ? this.testCmd.hashCode() : 0);
            result = 31 * result + (this.waitAfterCompletion != null ? this.waitAfterCompletion.hashCode() : 0);
            return result;
        }
    }
}
