package software.amazon.awscdk.services.ecs;

/**
 * A log driver that sends log information to journald Logs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.ecs.*;
 * FluentdLogDriver fluentdLogDriver = FluentdLogDriver.Builder.create()
 *         .address("address")
 *         .async(false)
 *         .asyncConnect(false)
 *         .bufferLimit(123)
 *         .env(List.of("env"))
 *         .envRegex("envRegex")
 *         .labels(List.of("labels"))
 *         .maxRetries(123)
 *         .retryWait(Duration.minutes(30))
 *         .subSecondPrecision(false)
 *         .tag("tag")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:06.576Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.FluentdLogDriver")
public class FluentdLogDriver extends software.amazon.awscdk.services.ecs.LogDriver {

    protected FluentdLogDriver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FluentdLogDriver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the FluentdLogDriver class.
     * <p>
     * @param props the fluentd log driver configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FluentdLogDriver(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FluentdLogDriverProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     * Constructs a new instance of the FluentdLogDriver class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FluentdLogDriver() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Called when the log driver is configured on a container.
     * <p>
     * @param _scope This parameter is required.
     * @param _containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriverConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition _containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_containerDefinition, "_containerDefinition is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.FluentdLogDriver}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.FluentdLogDriver> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ecs.FluentdLogDriverProps.Builder props;

        private Builder() {
        }

        /**
         * The env option takes an array of keys.
         * <p>
         * If there is collision between
         * label and env keys, the value of the env takes precedence. Adds additional fields
         * to the extra attributes of a logging message.
         * <p>
         * Default: - No env
         * <p>
         * @return {@code this}
         * @param env The env option takes an array of keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(final java.util.List<java.lang.String> env) {
            this.props().env(env);
            return this;
        }

        /**
         * The env-regex option is similar to and compatible with env.
         * <p>
         * Its value is a regular
         * expression to match logging-related environment variables. It is used for advanced
         * log tag options.
         * <p>
         * Default: - No envRegex
         * <p>
         * @return {@code this}
         * @param envRegex The env-regex option is similar to and compatible with env. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder envRegex(final java.lang.String envRegex) {
            this.props().envRegex(envRegex);
            return this;
        }

        /**
         * The labels option takes an array of keys.
         * <p>
         * If there is collision
         * between label and env keys, the value of the env takes precedence. Adds additional
         * fields to the extra attributes of a logging message.
         * <p>
         * Default: - No labels
         * <p>
         * @return {@code this}
         * @param labels The labels option takes an array of keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(final java.util.List<java.lang.String> labels) {
            this.props().labels(labels);
            return this;
        }

        /**
         * By default, Docker uses the first 12 characters of the container ID to tag log messages.
         * <p>
         * Refer to the log tag option documentation for customizing the
         * log tag format.
         * <p>
         * Default: - The first 12 characters of the container ID
         * <p>
         * @return {@code this}
         * @param tag By default, Docker uses the first 12 characters of the container ID to tag log messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tag(final java.lang.String tag) {
            this.props().tag(tag);
            return this;
        }

        /**
         * By default, the logging driver connects to localhost:24224.
         * <p>
         * Supply the
         * address option to connect to a different address. tcp(default) and unix
         * sockets are supported.
         * <p>
         * Default: - address not set.
         * <p>
         * @return {@code this}
         * @param address By default, the logging driver connects to localhost:24224. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder address(final java.lang.String address) {
            this.props().address(address);
            return this;
        }

        /**
         * Docker connects to Fluentd in the background.
         * <p>
         * Messages are buffered until
         * the connection is established.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param async Docker connects to Fluentd in the background. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder async(final java.lang.Boolean async) {
            this.props().async(async);
            return this;
        }

        /**
         * (deprecated) Docker connects to Fluentd in the background.
         * <p>
         * Messages are buffered until
         * the connection is established.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @deprecated use <code>async</code> instead
         * @param asyncConnect Docker connects to Fluentd in the background. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder asyncConnect(final java.lang.Boolean asyncConnect) {
            this.props().asyncConnect(asyncConnect);
            return this;
        }

        /**
         * The amount of data to buffer before flushing to disk.
         * <p>
         * Default: - The amount of RAM available to the container.
         * <p>
         * @return {@code this}
         * @param bufferLimit The amount of data to buffer before flushing to disk. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferLimit(final java.lang.Number bufferLimit) {
            this.props().bufferLimit(bufferLimit);
            return this;
        }

        /**
         * The maximum number of retries.
         * <p>
         * Default: - 4294967295 (2**32 - 1).
         * <p>
         * @return {@code this}
         * @param maxRetries The maximum number of retries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetries(final java.lang.Number maxRetries) {
            this.props().maxRetries(maxRetries);
            return this;
        }

        /**
         * How long to wait between retries.
         * <p>
         * Default: - 1 second
         * <p>
         * @return {@code this}
         * @param retryWait How long to wait between retries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryWait(final software.amazon.awscdk.Duration retryWait) {
            this.props().retryWait(retryWait);
            return this;
        }

        /**
         * Generates event logs in nanosecond resolution.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param subSecondPrecision Generates event logs in nanosecond resolution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subSecondPrecision(final java.lang.Boolean subSecondPrecision) {
            this.props().subSecondPrecision(subSecondPrecision);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.FluentdLogDriver}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.FluentdLogDriver build() {
            return new software.amazon.awscdk.services.ecs.FluentdLogDriver(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.FluentdLogDriverProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.FluentdLogDriverProps.Builder();
            }
            return this.props;
        }
    }
}
