package software.amazon.awscdk.services.elasticache;

/**
 * Properties for defining a <code>CfnGlobalReplicationGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * CfnGlobalReplicationGroupProps cfnGlobalReplicationGroupProps = CfnGlobalReplicationGroupProps.builder()
 *         .members(List.of(GlobalReplicationGroupMemberProperty.builder()
 *                 .replicationGroupId("replicationGroupId")
 *                 .replicationGroupRegion("replicationGroupRegion")
 *                 .role("role")
 *                 .build()))
 *         // the properties below are optional
 *         .automaticFailoverEnabled(false)
 *         .cacheNodeType("cacheNodeType")
 *         .cacheParameterGroupName("cacheParameterGroupName")
 *         .engine("engine")
 *         .engineVersion("engineVersion")
 *         .globalNodeGroupCount(123)
 *         .globalReplicationGroupDescription("globalReplicationGroupDescription")
 *         .globalReplicationGroupIdSuffix("globalReplicationGroupIdSuffix")
 *         .regionalConfigurations(List.of(RegionalConfigurationProperty.builder()
 *                 .replicationGroupId("replicationGroupId")
 *                 .replicationGroupRegion("replicationGroupRegion")
 *                 .reshardingConfigurations(List.of(ReshardingConfigurationProperty.builder()
 *                         .nodeGroupId("nodeGroupId")
 *                         .preferredAvailabilityZones(List.of("preferredAvailabilityZones"))
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:06.995Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnGlobalReplicationGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnGlobalReplicationGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGlobalReplicationGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The replication groups that comprise the Global datastore.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-members">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-members</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMembers();

    /**
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Valkey or Redis OSS (cluster mode enabled) replication groups.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-automaticfailoverenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-automaticfailoverenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFailoverEnabled() {
        return null;
    }

    /**
     * The cache node type of the Global datastore.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-cachenodetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-cachenodetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheNodeType() {
        return null;
    }

    /**
     * The name of the cache parameter group to use with the Global datastore.
     * <p>
     * It must be compatible with the major engine version used by the Global datastore.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-cacheparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-cacheparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheParameterGroupName() {
        return null;
    }

    /**
     * The ElastiCache engine.
     * <p>
     * For Valkey or Redis OSS only.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return null;
    }

    /**
     * The Elasticache Valkey or Redis OSS engine version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * The number of node groups that comprise the Global Datastore.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalnodegroupcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalnodegroupcount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGlobalNodeGroupCount() {
        return null;
    }

    /**
     * The optional description of the Global datastore.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupdescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGlobalReplicationGroupDescription() {
        return null;
    }

    /**
     * The suffix name of a Global Datastore.
     * <p>
     * The suffix guarantees uniqueness of the Global Datastore name across multiple regions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupidsuffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupidsuffix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGlobalReplicationGroupIdSuffix() {
        return null;
    }

    /**
     * The Regions that comprise the Global Datastore.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-regionalconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-regionalconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRegionalConfigurations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGlobalReplicationGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGlobalReplicationGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGlobalReplicationGroupProps> {
        java.lang.Object members;
        java.lang.Object automaticFailoverEnabled;
        java.lang.String cacheNodeType;
        java.lang.String cacheParameterGroupName;
        java.lang.String engine;
        java.lang.String engineVersion;
        java.lang.Number globalNodeGroupCount;
        java.lang.String globalReplicationGroupDescription;
        java.lang.String globalReplicationGroupIdSuffix;
        java.lang.Object regionalConfigurations;

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getMembers}
         * @param members The replication groups that comprise the Global datastore. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(software.amazon.awscdk.IResolvable members) {
            this.members = members;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getMembers}
         * @param members The replication groups that comprise the Global datastore. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(java.util.List<? extends java.lang.Object> members) {
            this.members = members;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getAutomaticFailoverEnabled}
         * @param automaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
         *                                 <code>AutomaticFailoverEnabled</code> must be enabled for Valkey or Redis OSS (cluster mode enabled) replication groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticFailoverEnabled(java.lang.Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getAutomaticFailoverEnabled}
         * @param automaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
         *                                 <code>AutomaticFailoverEnabled</code> must be enabled for Valkey or Redis OSS (cluster mode enabled) replication groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticFailoverEnabled(software.amazon.awscdk.IResolvable automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getCacheNodeType}
         * @param cacheNodeType The cache node type of the Global datastore.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNodeType(java.lang.String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getCacheParameterGroupName}
         * @param cacheParameterGroupName The name of the cache parameter group to use with the Global datastore.
         *                                It must be compatible with the major engine version used by the Global datastore.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheParameterGroupName(java.lang.String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getEngine}
         * @param engine The ElastiCache engine.
         *               For Valkey or Redis OSS only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getEngineVersion}
         * @param engineVersion The Elasticache Valkey or Redis OSS engine version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getGlobalNodeGroupCount}
         * @param globalNodeGroupCount The number of node groups that comprise the Global Datastore.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNodeGroupCount(java.lang.Number globalNodeGroupCount) {
            this.globalNodeGroupCount = globalNodeGroupCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getGlobalReplicationGroupDescription}
         * @param globalReplicationGroupDescription The optional description of the Global datastore.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalReplicationGroupDescription(java.lang.String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getGlobalReplicationGroupIdSuffix}
         * @param globalReplicationGroupIdSuffix The suffix name of a Global Datastore.
         *                                       The suffix guarantees uniqueness of the Global Datastore name across multiple regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalReplicationGroupIdSuffix(java.lang.String globalReplicationGroupIdSuffix) {
            this.globalReplicationGroupIdSuffix = globalReplicationGroupIdSuffix;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getRegionalConfigurations}
         * @param regionalConfigurations The Regions that comprise the Global Datastore.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionalConfigurations(software.amazon.awscdk.IResolvable regionalConfigurations) {
            this.regionalConfigurations = regionalConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalReplicationGroupProps#getRegionalConfigurations}
         * @param regionalConfigurations The Regions that comprise the Global Datastore.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionalConfigurations(java.util.List<? extends java.lang.Object> regionalConfigurations) {
            this.regionalConfigurations = regionalConfigurations;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGlobalReplicationGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGlobalReplicationGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGlobalReplicationGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGlobalReplicationGroupProps {
        private final java.lang.Object members;
        private final java.lang.Object automaticFailoverEnabled;
        private final java.lang.String cacheNodeType;
        private final java.lang.String cacheParameterGroupName;
        private final java.lang.String engine;
        private final java.lang.String engineVersion;
        private final java.lang.Number globalNodeGroupCount;
        private final java.lang.String globalReplicationGroupDescription;
        private final java.lang.String globalReplicationGroupIdSuffix;
        private final java.lang.Object regionalConfigurations;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.members = software.amazon.jsii.Kernel.get(this, "members", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.automaticFailoverEnabled = software.amazon.jsii.Kernel.get(this, "automaticFailoverEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cacheNodeType = software.amazon.jsii.Kernel.get(this, "cacheNodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheParameterGroupName = software.amazon.jsii.Kernel.get(this, "cacheParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalNodeGroupCount = software.amazon.jsii.Kernel.get(this, "globalNodeGroupCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.globalReplicationGroupDescription = software.amazon.jsii.Kernel.get(this, "globalReplicationGroupDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalReplicationGroupIdSuffix = software.amazon.jsii.Kernel.get(this, "globalReplicationGroupIdSuffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regionalConfigurations = software.amazon.jsii.Kernel.get(this, "regionalConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.members = java.util.Objects.requireNonNull(builder.members, "members is required");
            this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
            this.cacheNodeType = builder.cacheNodeType;
            this.cacheParameterGroupName = builder.cacheParameterGroupName;
            this.engine = builder.engine;
            this.engineVersion = builder.engineVersion;
            this.globalNodeGroupCount = builder.globalNodeGroupCount;
            this.globalReplicationGroupDescription = builder.globalReplicationGroupDescription;
            this.globalReplicationGroupIdSuffix = builder.globalReplicationGroupIdSuffix;
            this.regionalConfigurations = builder.regionalConfigurations;
        }

        @Override
        public final java.lang.Object getMembers() {
            return this.members;
        }

        @Override
        public final java.lang.Object getAutomaticFailoverEnabled() {
            return this.automaticFailoverEnabled;
        }

        @Override
        public final java.lang.String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final java.lang.String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.Number getGlobalNodeGroupCount() {
            return this.globalNodeGroupCount;
        }

        @Override
        public final java.lang.String getGlobalReplicationGroupDescription() {
            return this.globalReplicationGroupDescription;
        }

        @Override
        public final java.lang.String getGlobalReplicationGroupIdSuffix() {
            return this.globalReplicationGroupIdSuffix;
        }

        @Override
        public final java.lang.Object getRegionalConfigurations() {
            return this.regionalConfigurations;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("members", om.valueToTree(this.getMembers()));
            if (this.getAutomaticFailoverEnabled() != null) {
                data.set("automaticFailoverEnabled", om.valueToTree(this.getAutomaticFailoverEnabled()));
            }
            if (this.getCacheNodeType() != null) {
                data.set("cacheNodeType", om.valueToTree(this.getCacheNodeType()));
            }
            if (this.getCacheParameterGroupName() != null) {
                data.set("cacheParameterGroupName", om.valueToTree(this.getCacheParameterGroupName()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getGlobalNodeGroupCount() != null) {
                data.set("globalNodeGroupCount", om.valueToTree(this.getGlobalNodeGroupCount()));
            }
            if (this.getGlobalReplicationGroupDescription() != null) {
                data.set("globalReplicationGroupDescription", om.valueToTree(this.getGlobalReplicationGroupDescription()));
            }
            if (this.getGlobalReplicationGroupIdSuffix() != null) {
                data.set("globalReplicationGroupIdSuffix", om.valueToTree(this.getGlobalReplicationGroupIdSuffix()));
            }
            if (this.getRegionalConfigurations() != null) {
                data.set("regionalConfigurations", om.valueToTree(this.getRegionalConfigurations()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnGlobalReplicationGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGlobalReplicationGroupProps.Jsii$Proxy that = (CfnGlobalReplicationGroupProps.Jsii$Proxy) o;

            if (!members.equals(that.members)) return false;
            if (this.automaticFailoverEnabled != null ? !this.automaticFailoverEnabled.equals(that.automaticFailoverEnabled) : that.automaticFailoverEnabled != null) return false;
            if (this.cacheNodeType != null ? !this.cacheNodeType.equals(that.cacheNodeType) : that.cacheNodeType != null) return false;
            if (this.cacheParameterGroupName != null ? !this.cacheParameterGroupName.equals(that.cacheParameterGroupName) : that.cacheParameterGroupName != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.globalNodeGroupCount != null ? !this.globalNodeGroupCount.equals(that.globalNodeGroupCount) : that.globalNodeGroupCount != null) return false;
            if (this.globalReplicationGroupDescription != null ? !this.globalReplicationGroupDescription.equals(that.globalReplicationGroupDescription) : that.globalReplicationGroupDescription != null) return false;
            if (this.globalReplicationGroupIdSuffix != null ? !this.globalReplicationGroupIdSuffix.equals(that.globalReplicationGroupIdSuffix) : that.globalReplicationGroupIdSuffix != null) return false;
            return this.regionalConfigurations != null ? this.regionalConfigurations.equals(that.regionalConfigurations) : that.regionalConfigurations == null;
        }

        @Override
        public final int hashCode() {
            int result = this.members.hashCode();
            result = 31 * result + (this.automaticFailoverEnabled != null ? this.automaticFailoverEnabled.hashCode() : 0);
            result = 31 * result + (this.cacheNodeType != null ? this.cacheNodeType.hashCode() : 0);
            result = 31 * result + (this.cacheParameterGroupName != null ? this.cacheParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.globalNodeGroupCount != null ? this.globalNodeGroupCount.hashCode() : 0);
            result = 31 * result + (this.globalReplicationGroupDescription != null ? this.globalReplicationGroupDescription.hashCode() : 0);
            result = 31 * result + (this.globalReplicationGroupIdSuffix != null ? this.globalReplicationGroupIdSuffix.hashCode() : 0);
            result = 31 * result + (this.regionalConfigurations != null ? this.regionalConfigurations.hashCode() : 0);
            return result;
        }
    }
}
