package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a <code>CfnTrustStoreRevocation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnTrustStoreRevocationProps cfnTrustStoreRevocationProps = CfnTrustStoreRevocationProps.builder()
 *         .revocationContents(List.of(RevocationContentProperty.builder()
 *                 .revocationType("revocationType")
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .build()))
 *         .trustStoreArn("trustStoreArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststorerevocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststorerevocation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:07.182Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnTrustStoreRevocationProps")
@software.amazon.jsii.Jsii.Proxy(CfnTrustStoreRevocationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrustStoreRevocationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The revocation file to add.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststorerevocation.html#cfn-elasticloadbalancingv2-truststorerevocation-revocationcontents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststorerevocation.html#cfn-elasticloadbalancingv2-truststorerevocation-revocationcontents</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRevocationContents() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the trust store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststorerevocation.html#cfn-elasticloadbalancingv2-truststorerevocation-truststorearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststorerevocation.html#cfn-elasticloadbalancingv2-truststorerevocation-truststorearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTrustStoreArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrustStoreRevocationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrustStoreRevocationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrustStoreRevocationProps> {
        java.lang.Object revocationContents;
        java.lang.String trustStoreArn;

        /**
         * Sets the value of {@link CfnTrustStoreRevocationProps#getRevocationContents}
         * @param revocationContents The revocation file to add.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revocationContents(software.amazon.awscdk.IResolvable revocationContents) {
            this.revocationContents = revocationContents;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrustStoreRevocationProps#getRevocationContents}
         * @param revocationContents The revocation file to add.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revocationContents(java.util.List<? extends java.lang.Object> revocationContents) {
            this.revocationContents = revocationContents;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrustStoreRevocationProps#getTrustStoreArn}
         * @param trustStoreArn The Amazon Resource Name (ARN) of the trust store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustStoreArn(java.lang.String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrustStoreRevocationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrustStoreRevocationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTrustStoreRevocationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrustStoreRevocationProps {
        private final java.lang.Object revocationContents;
        private final java.lang.String trustStoreArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.revocationContents = software.amazon.jsii.Kernel.get(this, "revocationContents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.trustStoreArn = software.amazon.jsii.Kernel.get(this, "trustStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.revocationContents = builder.revocationContents;
            this.trustStoreArn = builder.trustStoreArn;
        }

        @Override
        public final java.lang.Object getRevocationContents() {
            return this.revocationContents;
        }

        @Override
        public final java.lang.String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getRevocationContents() != null) {
                data.set("revocationContents", om.valueToTree(this.getRevocationContents()));
            }
            if (this.getTrustStoreArn() != null) {
                data.set("trustStoreArn", om.valueToTree(this.getTrustStoreArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnTrustStoreRevocationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrustStoreRevocationProps.Jsii$Proxy that = (CfnTrustStoreRevocationProps.Jsii$Proxy) o;

            if (this.revocationContents != null ? !this.revocationContents.equals(that.revocationContents) : that.revocationContents != null) return false;
            return this.trustStoreArn != null ? this.trustStoreArn.equals(that.trustStoreArn) : that.trustStoreArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.revocationContents != null ? this.revocationContents.hashCode() : 0;
            result = 31 * result + (this.trustStoreArn != null ? this.trustStoreArn.hashCode() : 0);
            return result;
        }
    }
}
