package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * The mutual authentication configuration information.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * Certificate certificate;
 * ApplicationLoadBalancer lb;
 * Bucket bucket;
 * TrustStore trustStore = TrustStore.Builder.create(this, "Store")
 *         .bucket(bucket)
 *         .key("rootCA_cert.pem")
 *         .build();
 * lb.addListener("Listener", BaseApplicationListenerProps.builder()
 *         .port(443)
 *         .protocol(ApplicationProtocol.HTTPS)
 *         .certificates(List.of(certificate))
 *         // mTLS settings
 *         .mutualAuthentication(MutualAuthentication.builder()
 *                 .advertiseTrustStoreCaNames(true)
 *                 .ignoreClientCertificateExpiry(false)
 *                 .mutualAuthenticationMode(MutualAuthenticationMode.VERIFY)
 *                 .trustStore(trustStore)
 *                 .build())
 *         .defaultAction(ListenerAction.fixedResponse(200, FixedResponseOptions.builder().contentType("text/plain").messageBody("Success mTLS").build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:07.211Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.MutualAuthentication")
@software.amazon.jsii.Jsii.Proxy(MutualAuthentication.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MutualAuthentication extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether trust store CA names are advertised.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAdvertiseTrustStoreCaNames() {
        return null;
    }

    /**
     * Indicates whether expired client certificates are ignored.
     * <p>
     * Cannot be used with MutualAuthenticationMode.OFF or MutualAuthenticationMode.PASS_THROUGH
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreClientCertificateExpiry() {
        return null;
    }

    /**
     * The client certificate handling method.
     * <p>
     * Default: MutualAuthenticationMode.OFF
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.MutualAuthenticationMode getMutualAuthenticationMode() {
        return null;
    }

    /**
     * The trust store.
     * <p>
     * Cannot be used with MutualAuthenticationMode.OFF or MutualAuthenticationMode.PASS_THROUGH
     * <p>
     * Default: - no trust store
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore getTrustStore() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MutualAuthentication}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MutualAuthentication}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MutualAuthentication> {
        java.lang.Boolean advertiseTrustStoreCaNames;
        java.lang.Boolean ignoreClientCertificateExpiry;
        software.amazon.awscdk.services.elasticloadbalancingv2.MutualAuthenticationMode mutualAuthenticationMode;
        software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore trustStore;

        /**
         * Sets the value of {@link MutualAuthentication#getAdvertiseTrustStoreCaNames}
         * @param advertiseTrustStoreCaNames Indicates whether trust store CA names are advertised.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertiseTrustStoreCaNames(java.lang.Boolean advertiseTrustStoreCaNames) {
            this.advertiseTrustStoreCaNames = advertiseTrustStoreCaNames;
            return this;
        }

        /**
         * Sets the value of {@link MutualAuthentication#getIgnoreClientCertificateExpiry}
         * @param ignoreClientCertificateExpiry Indicates whether expired client certificates are ignored.
         *                                      Cannot be used with MutualAuthenticationMode.OFF or MutualAuthenticationMode.PASS_THROUGH
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreClientCertificateExpiry(java.lang.Boolean ignoreClientCertificateExpiry) {
            this.ignoreClientCertificateExpiry = ignoreClientCertificateExpiry;
            return this;
        }

        /**
         * Sets the value of {@link MutualAuthentication#getMutualAuthenticationMode}
         * @param mutualAuthenticationMode The client certificate handling method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualAuthenticationMode(software.amazon.awscdk.services.elasticloadbalancingv2.MutualAuthenticationMode mutualAuthenticationMode) {
            this.mutualAuthenticationMode = mutualAuthenticationMode;
            return this;
        }

        /**
         * Sets the value of {@link MutualAuthentication#getTrustStore}
         * @param trustStore The trust store.
         *                   Cannot be used with MutualAuthenticationMode.OFF or MutualAuthenticationMode.PASS_THROUGH
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustStore(software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MutualAuthentication}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MutualAuthentication build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MutualAuthentication}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MutualAuthentication {
        private final java.lang.Boolean advertiseTrustStoreCaNames;
        private final java.lang.Boolean ignoreClientCertificateExpiry;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.MutualAuthenticationMode mutualAuthenticationMode;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore trustStore;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.advertiseTrustStoreCaNames = software.amazon.jsii.Kernel.get(this, "advertiseTrustStoreCaNames", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ignoreClientCertificateExpiry = software.amazon.jsii.Kernel.get(this, "ignoreClientCertificateExpiry", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.mutualAuthenticationMode = software.amazon.jsii.Kernel.get(this, "mutualAuthenticationMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.MutualAuthenticationMode.class));
            this.trustStore = software.amazon.jsii.Kernel.get(this, "trustStore", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.advertiseTrustStoreCaNames = builder.advertiseTrustStoreCaNames;
            this.ignoreClientCertificateExpiry = builder.ignoreClientCertificateExpiry;
            this.mutualAuthenticationMode = builder.mutualAuthenticationMode;
            this.trustStore = builder.trustStore;
        }

        @Override
        public final java.lang.Boolean getAdvertiseTrustStoreCaNames() {
            return this.advertiseTrustStoreCaNames;
        }

        @Override
        public final java.lang.Boolean getIgnoreClientCertificateExpiry() {
            return this.ignoreClientCertificateExpiry;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.MutualAuthenticationMode getMutualAuthenticationMode() {
            return this.mutualAuthenticationMode;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore getTrustStore() {
            return this.trustStore;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdvertiseTrustStoreCaNames() != null) {
                data.set("advertiseTrustStoreCaNames", om.valueToTree(this.getAdvertiseTrustStoreCaNames()));
            }
            if (this.getIgnoreClientCertificateExpiry() != null) {
                data.set("ignoreClientCertificateExpiry", om.valueToTree(this.getIgnoreClientCertificateExpiry()));
            }
            if (this.getMutualAuthenticationMode() != null) {
                data.set("mutualAuthenticationMode", om.valueToTree(this.getMutualAuthenticationMode()));
            }
            if (this.getTrustStore() != null) {
                data.set("trustStore", om.valueToTree(this.getTrustStore()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.MutualAuthentication"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MutualAuthentication.Jsii$Proxy that = (MutualAuthentication.Jsii$Proxy) o;

            if (this.advertiseTrustStoreCaNames != null ? !this.advertiseTrustStoreCaNames.equals(that.advertiseTrustStoreCaNames) : that.advertiseTrustStoreCaNames != null) return false;
            if (this.ignoreClientCertificateExpiry != null ? !this.ignoreClientCertificateExpiry.equals(that.ignoreClientCertificateExpiry) : that.ignoreClientCertificateExpiry != null) return false;
            if (this.mutualAuthenticationMode != null ? !this.mutualAuthenticationMode.equals(that.mutualAuthenticationMode) : that.mutualAuthenticationMode != null) return false;
            return this.trustStore != null ? this.trustStore.equals(that.trustStore) : that.trustStore == null;
        }

        @Override
        public final int hashCode() {
            int result = this.advertiseTrustStoreCaNames != null ? this.advertiseTrustStoreCaNames.hashCode() : 0;
            result = 31 * result + (this.ignoreClientCertificateExpiry != null ? this.ignoreClientCertificateExpiry.hashCode() : 0);
            result = 31 * result + (this.mutualAuthenticationMode != null ? this.mutualAuthenticationMode.hashCode() : 0);
            result = 31 * result + (this.trustStore != null ? this.trustStore.hashCode() : 0);
            return result;
        }
    }
}
