package software.amazon.awscdk.services.elasticloadbalancingv2.targets;

/**
 * A single Application Load Balancer as the target for load balancing.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.targets.*;
 * AlbArnTarget albArnTarget = new AlbArnTarget("albArn", 123);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:07.243Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2_targets.AlbArnTarget")
public class AlbArnTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget {

    protected AlbArnTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AlbArnTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a new alb target.
     * <p>
     * Note that the ALB must have a listener on the provided target port.
     * <p>
     * @param albArn The ARN of the application load balancer to load balance to. This parameter is required.
     * @param port The port on which the target is listening. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AlbArnTarget(final @org.jetbrains.annotations.NotNull java.lang.String albArn, final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(albArn, "albArn is required"), java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * Register this alb target with a load balancer.
     * <p>
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToNetworkTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }
}
