package software.amazon.awscdk.services.entityresolution;

/**
 * Creates a schema mapping, which defines the schema of the input customer records table.
 * <p>
 * The <code>SchemaMapping</code> also provides AWS Entity Resolution with some metadata about the table, such as the attribute types of the columns and which columns to match on.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.entityresolution.*;
 * CfnSchemaMapping cfnSchemaMapping = CfnSchemaMapping.Builder.create(this, "MyCfnSchemaMapping")
 *         .mappedInputFields(List.of(SchemaInputAttributeProperty.builder()
 *                 .fieldName("fieldName")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .groupName("groupName")
 *                 .hashed(false)
 *                 .matchKey("matchKey")
 *                 .subType("subType")
 *                 .build()))
 *         .schemaName("schemaName")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:07.425Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnSchemaMapping")
public class CfnSchemaMapping extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnSchemaMapping(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSchemaMapping(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.entityresolution.CfnSchemaMapping.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSchemaMapping(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.entityresolution.CfnSchemaMappingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time of this SchemaMapping got created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The boolean value that indicates whether or not a SchemaMapping has MatchingWorkflows that are associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrHasWorkflows() {
        return software.amazon.jsii.Kernel.get(this, "attrHasWorkflows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The SchemaMapping arn associated with the Schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSchemaArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSchemaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time of this SchemaMapping got last updated at.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of <code>MappedInputFields</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMappedInputFields() {
        return software.amazon.jsii.Kernel.get(this, "mappedInputFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of <code>MappedInputFields</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMappedInputFields(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mappedInputFields", java.util.Objects.requireNonNull(value, "mappedInputFields is required"));
    }

    /**
     * A list of <code>MappedInputFields</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMappedInputFields(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.entityresolution.CfnSchemaMapping.SchemaInputAttributeProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.entityresolution.CfnSchemaMapping.SchemaInputAttributeProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "mappedInputFields", java.util.Objects.requireNonNull(value, "mappedInputFields is required"));
    }

    /**
     * The name of the schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSchemaName() {
        return software.amazon.jsii.Kernel.get(this, "schemaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schemaName", java.util.Objects.requireNonNull(value, "schemaName is required"));
    }

    /**
     * A description of the schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * A configuration object for defining input data fields in AWS Entity Resolution .
     * <p>
     * The <code>SchemaInputAttribute</code> specifies how individual fields in your input data should be processed and matched.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * SchemaInputAttributeProperty schemaInputAttributeProperty = SchemaInputAttributeProperty.builder()
     *         .fieldName("fieldName")
     *         .type("type")
     *         // the properties below are optional
     *         .groupName("groupName")
     *         .hashed(false)
     *         .matchKey("matchKey")
     *         .subType("subType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnSchemaMapping.SchemaInputAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaInputAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaInputAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string containing the field name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-fieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldName();

        /**
         * The type of the attribute, selected from a list of values.
         * <p>
         * LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> | <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> | <code>ADDRESS_STREET2</code> | <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>PROVIDER_ID</code>
         * <p>
         * TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>IPV4</code> | <code>IPV6</code> | <code>MAID</code>
         * <p>
         * Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
         * <p>
         * <blockquote>
         * <p>
         * Normalization is only supported for <code>NAME</code> , <code>ADDRESS</code> , <code>PHONE</code> , and <code>EMAIL_ADDRESS</code> .
         * <p>
         * If you want to normalize <code>NAME_FIRST</code> , <code>NAME_MIDDLE</code> , and <code>NAME_LAST</code> , you must group them by assigning them to the <code>NAME</code> <code>groupName</code> .
         * <p>
         * If you want to normalize <code>ADDRESS_STREET1</code> , <code>ADDRESS_STREET2</code> , <code>ADDRESS_STREET3</code> , <code>ADDRESS_CITY</code> , <code>ADDRESS_STATE</code> , <code>ADDRESS_COUNTRY</code> , and <code>ADDRESS_POSTALCODE</code> , you must group them by assigning them to the <code>ADDRESS</code> <code>groupName</code> .
         * <p>
         * If you want to normalize <code>PHONE_NUMBER</code> and <code>PHONE_COUNTRYCODE</code> , you must group them by assigning them to the <code>PHONE</code> <code>groupName</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A string that instructs AWS Entity Resolution to combine several columns into a unified column with the identical attribute type.
         * <p>
         * For example, when working with columns such as <code>NAME_FIRST</code> , <code>NAME_MIDDLE</code> , and <code>NAME_LAST</code> , assigning them a common <code>groupName</code> will prompt AWS Entity Resolution to concatenate them into a single value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-groupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-groupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * Indicates if the column values are hashed in the schema input.
         * <p>
         * If the value is set to <code>TRUE</code> , the column values are hashed.
         * <p>
         * If the value is set to <code>FALSE</code> , the column values are cleartext.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-hashed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-hashed</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHashed() {
            return null;
        }

        /**
         * A key that allows grouping of multiple input attributes into a unified matching group.
         * <p>
         * For example, consider a scenario where the source table contains various addresses, such as <code>business_address</code> and <code>shipping_address</code> . By assigning a <code>matchKey</code> called <code>address</code> to both attributes, AWS Entity Resolution will match records across these fields to create a consolidated matching group.
         * <p>
         * If no <code>matchKey</code> is specified for a column, it won't be utilized for matching purposes but will still be included in the output table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-matchkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-matchkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMatchKey() {
            return null;
        }

        /**
         * The subtype of the attribute, selected from a list of values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-subtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-schemamapping-schemainputattribute.html#cfn-entityresolution-schemamapping-schemainputattribute-subtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaInputAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaInputAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaInputAttributeProperty> {
            java.lang.String fieldName;
            java.lang.String type;
            java.lang.String groupName;
            java.lang.Object hashed;
            java.lang.String matchKey;
            java.lang.String subType;

            /**
             * Sets the value of {@link SchemaInputAttributeProperty#getFieldName}
             * @param fieldName A string containing the field name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldName(java.lang.String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            /**
             * Sets the value of {@link SchemaInputAttributeProperty#getType}
             * @param type The type of the attribute, selected from a list of values. This parameter is required.
             *             LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> | <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> | <code>ADDRESS_STREET2</code> | <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>PROVIDER_ID</code>
             *             <p>
             *             TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>IPV4</code> | <code>IPV6</code> | <code>MAID</code>
             *             <p>
             *             Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
             *             <p>
             *             <blockquote>
             *             <p>
             *             Normalization is only supported for <code>NAME</code> , <code>ADDRESS</code> , <code>PHONE</code> , and <code>EMAIL_ADDRESS</code> .
             *             <p>
             *             If you want to normalize <code>NAME_FIRST</code> , <code>NAME_MIDDLE</code> , and <code>NAME_LAST</code> , you must group them by assigning them to the <code>NAME</code> <code>groupName</code> .
             *             <p>
             *             If you want to normalize <code>ADDRESS_STREET1</code> , <code>ADDRESS_STREET2</code> , <code>ADDRESS_STREET3</code> , <code>ADDRESS_CITY</code> , <code>ADDRESS_STATE</code> , <code>ADDRESS_COUNTRY</code> , and <code>ADDRESS_POSTALCODE</code> , you must group them by assigning them to the <code>ADDRESS</code> <code>groupName</code> .
             *             <p>
             *             If you want to normalize <code>PHONE_NUMBER</code> and <code>PHONE_COUNTRYCODE</code> , you must group them by assigning them to the <code>PHONE</code> <code>groupName</code> .
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SchemaInputAttributeProperty#getGroupName}
             * @param groupName A string that instructs AWS Entity Resolution to combine several columns into a unified column with the identical attribute type.
             *                  For example, when working with columns such as <code>NAME_FIRST</code> , <code>NAME_MIDDLE</code> , and <code>NAME_LAST</code> , assigning them a common <code>groupName</code> will prompt AWS Entity Resolution to concatenate them into a single value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link SchemaInputAttributeProperty#getHashed}
             * @param hashed Indicates if the column values are hashed in the schema input.
             *               If the value is set to <code>TRUE</code> , the column values are hashed.
             *               <p>
             *               If the value is set to <code>FALSE</code> , the column values are cleartext.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashed(java.lang.Boolean hashed) {
                this.hashed = hashed;
                return this;
            }

            /**
             * Sets the value of {@link SchemaInputAttributeProperty#getHashed}
             * @param hashed Indicates if the column values are hashed in the schema input.
             *               If the value is set to <code>TRUE</code> , the column values are hashed.
             *               <p>
             *               If the value is set to <code>FALSE</code> , the column values are cleartext.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashed(software.amazon.awscdk.IResolvable hashed) {
                this.hashed = hashed;
                return this;
            }

            /**
             * Sets the value of {@link SchemaInputAttributeProperty#getMatchKey}
             * @param matchKey A key that allows grouping of multiple input attributes into a unified matching group.
             *                 For example, consider a scenario where the source table contains various addresses, such as <code>business_address</code> and <code>shipping_address</code> . By assigning a <code>matchKey</code> called <code>address</code> to both attributes, AWS Entity Resolution will match records across these fields to create a consolidated matching group.
             *                 <p>
             *                 If no <code>matchKey</code> is specified for a column, it won't be utilized for matching purposes but will still be included in the output table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchKey(java.lang.String matchKey) {
                this.matchKey = matchKey;
                return this;
            }

            /**
             * Sets the value of {@link SchemaInputAttributeProperty#getSubType}
             * @param subType The subtype of the attribute, selected from a list of values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subType(java.lang.String subType) {
                this.subType = subType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaInputAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaInputAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaInputAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaInputAttributeProperty {
            private final java.lang.String fieldName;
            private final java.lang.String type;
            private final java.lang.String groupName;
            private final java.lang.Object hashed;
            private final java.lang.String matchKey;
            private final java.lang.String subType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hashed = software.amazon.jsii.Kernel.get(this, "hashed", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchKey = software.amazon.jsii.Kernel.get(this, "matchKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subType = software.amazon.jsii.Kernel.get(this, "subType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldName = java.util.Objects.requireNonNull(builder.fieldName, "fieldName is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.groupName = builder.groupName;
                this.hashed = builder.hashed;
                this.matchKey = builder.matchKey;
                this.subType = builder.subType;
            }

            @Override
            public final java.lang.String getFieldName() {
                return this.fieldName;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.Object getHashed() {
                return this.hashed;
            }

            @Override
            public final java.lang.String getMatchKey() {
                return this.matchKey;
            }

            @Override
            public final java.lang.String getSubType() {
                return this.subType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldName", om.valueToTree(this.getFieldName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getHashed() != null) {
                    data.set("hashed", om.valueToTree(this.getHashed()));
                }
                if (this.getMatchKey() != null) {
                    data.set("matchKey", om.valueToTree(this.getMatchKey()));
                }
                if (this.getSubType() != null) {
                    data.set("subType", om.valueToTree(this.getSubType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnSchemaMapping.SchemaInputAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaInputAttributeProperty.Jsii$Proxy that = (SchemaInputAttributeProperty.Jsii$Proxy) o;

                if (!fieldName.equals(that.fieldName)) return false;
                if (!type.equals(that.type)) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                if (this.hashed != null ? !this.hashed.equals(that.hashed) : that.hashed != null) return false;
                if (this.matchKey != null ? !this.matchKey.equals(that.matchKey) : that.matchKey != null) return false;
                return this.subType != null ? this.subType.equals(that.subType) : that.subType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.hashed != null ? this.hashed.hashCode() : 0);
                result = 31 * result + (this.matchKey != null ? this.matchKey.hashCode() : 0);
                result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.entityresolution.CfnSchemaMapping}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.entityresolution.CfnSchemaMapping> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.entityresolution.CfnSchemaMappingProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.entityresolution.CfnSchemaMappingProps.Builder();
        }

        /**
         * A list of <code>MappedInputFields</code> .
         * <p>
         * Each <code>MappedInputField</code> corresponds to a column the source data table, and contains column name plus additional information that AWS Entity Resolution uses for matching.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-mappedinputfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-mappedinputfields</a>
         * @param mappedInputFields A list of <code>MappedInputFields</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappedInputFields(final software.amazon.awscdk.IResolvable mappedInputFields) {
            this.props.mappedInputFields(mappedInputFields);
            return this;
        }
        /**
         * A list of <code>MappedInputFields</code> .
         * <p>
         * Each <code>MappedInputField</code> corresponds to a column the source data table, and contains column name plus additional information that AWS Entity Resolution uses for matching.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-mappedinputfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-mappedinputfields</a>
         * @param mappedInputFields A list of <code>MappedInputFields</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappedInputFields(final java.util.List<? extends java.lang.Object> mappedInputFields) {
            this.props.mappedInputFields(mappedInputFields);
            return this;
        }

        /**
         * The name of the schema.
         * <p>
         * There can't be multiple <code>SchemaMappings</code> with the same name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-schemaname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-schemaname</a>
         * @param schemaName The name of the schema. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaName(final java.lang.String schemaName) {
            this.props.schemaName(schemaName);
            return this;
        }

        /**
         * A description of the schema.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-description</a>
         * @param description A description of the schema. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-schemamapping.html#cfn-entityresolution-schemamapping-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.entityresolution.CfnSchemaMapping}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.entityresolution.CfnSchemaMapping build() {
            return new software.amazon.awscdk.services.entityresolution.CfnSchemaMapping(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
