package software.amazon.awscdk.services.fsx;

/**
 * The <code>AWS::FSx::FileSystem</code> resource is an Amazon FSx resource type that specifies an Amazon FSx file system.
 * <p>
 * You can create any of the following supported file system types:
 * <p>
 * <ul>
 * <li>Amazon FSx for Lustre</li>
 * <li>Amazon FSx for NetApp ONTAP</li>
 * <li>FSx for OpenZFS</li>
 * <li>Amazon FSx for Windows File Server</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnFileSystem cfnFileSystem = CfnFileSystem.Builder.create(this, "MyCfnFileSystem")
 *         .fileSystemType("fileSystemType")
 *         .subnetIds(List.of("subnetIds"))
 *         // the properties below are optional
 *         .backupId("backupId")
 *         .fileSystemTypeVersion("fileSystemTypeVersion")
 *         .kmsKeyId("kmsKeyId")
 *         .lustreConfiguration(LustreConfigurationProperty.builder()
 *                 .autoImportPolicy("autoImportPolicy")
 *                 .automaticBackupRetentionDays(123)
 *                 .copyTagsToBackups(false)
 *                 .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
 *                 .dataCompressionType("dataCompressionType")
 *                 .dataReadCacheConfiguration(DataReadCacheConfigurationProperty.builder()
 *                         .sizeGiB(123)
 *                         .sizingMode("sizingMode")
 *                         .build())
 *                 .deploymentType("deploymentType")
 *                 .driveCacheType("driveCacheType")
 *                 .efaEnabled(false)
 *                 .exportPath("exportPath")
 *                 .importedFileChunkSize(123)
 *                 .importPath("importPath")
 *                 .metadataConfiguration(MetadataConfigurationProperty.builder()
 *                         .iops(123)
 *                         .mode("mode")
 *                         .build())
 *                 .perUnitStorageThroughput(123)
 *                 .throughputCapacity(123)
 *                 .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
 *                 .build())
 *         .ontapConfiguration(OntapConfigurationProperty.builder()
 *                 .deploymentType("deploymentType")
 *                 // the properties below are optional
 *                 .automaticBackupRetentionDays(123)
 *                 .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
 *                 .diskIopsConfiguration(DiskIopsConfigurationProperty.builder()
 *                         .iops(123)
 *                         .mode("mode")
 *                         .build())
 *                 .endpointIpAddressRange("endpointIpAddressRange")
 *                 .fsxAdminPassword("fsxAdminPassword")
 *                 .haPairs(123)
 *                 .preferredSubnetId("preferredSubnetId")
 *                 .routeTableIds(List.of("routeTableIds"))
 *                 .throughputCapacity(123)
 *                 .throughputCapacityPerHaPair(123)
 *                 .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
 *                 .build())
 *         .openZfsConfiguration(OpenZFSConfigurationProperty.builder()
 *                 .deploymentType("deploymentType")
 *                 // the properties below are optional
 *                 .automaticBackupRetentionDays(123)
 *                 .copyTagsToBackups(false)
 *                 .copyTagsToVolumes(false)
 *                 .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
 *                 .diskIopsConfiguration(DiskIopsConfigurationProperty.builder()
 *                         .iops(123)
 *                         .mode("mode")
 *                         .build())
 *                 .endpointIpAddressRange("endpointIpAddressRange")
 *                 .options(List.of("options"))
 *                 .preferredSubnetId("preferredSubnetId")
 *                 .readCacheConfiguration(ReadCacheConfigurationProperty.builder()
 *                         .sizeGiB(123)
 *                         .sizingMode("sizingMode")
 *                         .build())
 *                 .rootVolumeConfiguration(RootVolumeConfigurationProperty.builder()
 *                         .copyTagsToSnapshots(false)
 *                         .dataCompressionType("dataCompressionType")
 *                         .nfsExports(List.of(NfsExportsProperty.builder()
 *                                 .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
 *                                         .clients("clients")
 *                                         .options(List.of("options"))
 *                                         .build()))
 *                                 .build()))
 *                         .readOnly(false)
 *                         .recordSizeKiB(123)
 *                         .userAndGroupQuotas(List.of(UserAndGroupQuotasProperty.builder()
 *                                 .id(123)
 *                                 .storageCapacityQuotaGiB(123)
 *                                 .type("type")
 *                                 .build()))
 *                         .build())
 *                 .routeTableIds(List.of("routeTableIds"))
 *                 .throughputCapacity(123)
 *                 .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
 *                 .build())
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .storageCapacity(123)
 *         .storageType("storageType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .windowsConfiguration(WindowsConfigurationProperty.builder()
 *                 .throughputCapacity(123)
 *                 // the properties below are optional
 *                 .activeDirectoryId("activeDirectoryId")
 *                 .aliases(List.of("aliases"))
 *                 .auditLogConfiguration(AuditLogConfigurationProperty.builder()
 *                         .fileAccessAuditLogLevel("fileAccessAuditLogLevel")
 *                         .fileShareAccessAuditLogLevel("fileShareAccessAuditLogLevel")
 *                         // the properties below are optional
 *                         .auditLogDestination("auditLogDestination")
 *                         .build())
 *                 .automaticBackupRetentionDays(123)
 *                 .copyTagsToBackups(false)
 *                 .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
 *                 .deploymentType("deploymentType")
 *                 .diskIopsConfiguration(DiskIopsConfigurationProperty.builder()
 *                         .iops(123)
 *                         .mode("mode")
 *                         .build())
 *                 .preferredSubnetId("preferredSubnetId")
 *                 .selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationProperty.builder()
 *                         .dnsIps(List.of("dnsIps"))
 *                         .domainName("domainName")
 *                         .fileSystemAdministratorsGroup("fileSystemAdministratorsGroup")
 *                         .organizationalUnitDistinguishedName("organizationalUnitDistinguishedName")
 *                         .password("password")
 *                         .userName("userName")
 *                         .build())
 *                 .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:07.718Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem")
public class CfnFileSystem extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnFileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fsx.CfnFileSystem.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFileSystem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.CfnFileSystemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the FSx for Windows file system's DNSName.
     * <p>
     * Example: <code>amznfsxp1honlek.corp.example.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDnsName() {
        return software.amazon.jsii.Kernel.get(this, "attrDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the Lustre file system's <code>LustreMountName</code> .
     * <p>
     * Example for <code>SCRATCH_1</code> deployment types: This value is always <code>fsx</code> .
     * <p>
     * Example for <code>SCRATCH_2</code> and <code>PERSISTENT</code> deployment types: <code>2p3fhbmv</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLustreMountName() {
        return software.amazon.jsii.Kernel.get(this, "attrLustreMountName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the Amazon Resource Name (ARN) for the Amazon FSx file system.
     * <p>
     * Example: <code>arn:aws:fsx:us-east-2:111122223333:file-system/fs-0123abcd56789ef0a</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the root volume ID of the FSx for OpenZFS file system.
     * <p>
     * Example: <code>fsvol-0123456789abcdefa</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRootVolumeId() {
        return software.amazon.jsii.Kernel.get(this, "attrRootVolumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The type of Amazon FSx file system, which can be <code>LUSTRE</code> , <code>WINDOWS</code> , <code>ONTAP</code> , or <code>OPENZFS</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemType() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of Amazon FSx file system, which can be <code>LUSTRE</code> , <code>WINDOWS</code> , <code>ONTAP</code> , or <code>OPENZFS</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemType", java.util.Objects.requireNonNull(value, "fileSystemType is required"));
    }

    /**
     * Specifies the IDs of the subnets that the file system will be accessible from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Specifies the IDs of the subnets that the file system will be accessible from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetIds", java.util.Objects.requireNonNull(value, "subnetIds is required"));
    }

    /**
     * The ID of the file system backup that you are using to create a file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBackupId() {
        return software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the file system backup that you are using to create a file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backupId", value);
    }

    /**
     * For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFileSystemTypeVersion() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemTypeVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemTypeVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemTypeVersion", value);
    }

    /**
     * The ID of the AWS Key Management Service ( AWS KMS ) key used to encrypt Amazon FSx file system data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS Key Management Service ( AWS KMS ) key used to encrypt Amazon FSx file system data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The Lustre configuration for the file system being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLustreConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "lustreConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Lustre configuration for the file system being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLustreConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lustreConfiguration", value);
    }

    /**
     * The Lustre configuration for the file system being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLustreConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnFileSystem.LustreConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "lustreConfiguration", value);
    }

    /**
     * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOntapConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "ontapConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOntapConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ontapConfiguration", value);
    }

    /**
     * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOntapConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnFileSystem.OntapConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "ontapConfiguration", value);
    }

    /**
     * The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpenZfsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "openZfsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenZfsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "openZfsConfiguration", value);
    }

    /**
     * The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenZfsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnFileSystem.OpenZFSConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "openZfsConfiguration", value);
    }

    /**
     * A list of IDs specifying the security groups to apply to all network interfaces created for file system access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of IDs specifying the security groups to apply to all network interfaces created for file system access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * Sets the storage capacity of the file system that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacity() {
        return software.amazon.jsii.Kernel.get(this, "storageCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Sets the storage capacity of the file system that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "storageCapacity", value);
    }

    /**
     * Sets the storage class for the file system that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Sets the storage class for the file system that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageType", value);
    }

    /**
     * The tags to associate with the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to associate with the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The configuration object for the Microsoft Windows file system you are creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWindowsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "windowsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration object for the Microsoft Windows file system you are creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWindowsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "windowsConfiguration", value);
    }

    /**
     * The configuration object for the Microsoft Windows file system you are creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWindowsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnFileSystem.WindowsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "windowsConfiguration", value);
    }
    /**
     * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * AuditLogConfigurationProperty auditLogConfigurationProperty = AuditLogConfigurationProperty.builder()
     *         .fileAccessAuditLogLevel("fileAccessAuditLogLevel")
     *         .fileShareAccessAuditLogLevel("fileShareAccessAuditLogLevel")
     *         // the properties below are optional
     *         .auditLogDestination("auditLogDestination")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-auditlogconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-auditlogconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.AuditLogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AuditLogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuditLogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets which attempt type is logged by Amazon FSx for file and folder accesses.
         * <p>
         * <ul>
         * <li><code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.</li>
         * <li><code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.</li>
         * <li><code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or folders are logged.</li>
         * <li><code>DISABLED</code> - access auditing of files and folders is turned off.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-auditlogconfiguration.html#cfn-fsx-filesystem-auditlogconfiguration-fileaccessauditloglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-auditlogconfiguration.html#cfn-fsx-filesystem-auditlogconfiguration-fileaccessauditloglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileAccessAuditLogLevel();

        /**
         * Sets which attempt type is logged by Amazon FSx for file share accesses.
         * <p>
         * <ul>
         * <li><code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.</li>
         * <li><code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.</li>
         * <li><code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are logged.</li>
         * <li><code>DISABLED</code> - access auditing of file shares is turned off.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-auditlogconfiguration.html#cfn-fsx-filesystem-auditlogconfiguration-fileshareaccessauditloglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-auditlogconfiguration.html#cfn-fsx-filesystem-auditlogconfiguration-fileshareaccessauditloglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileShareAccessAuditLogLevel();

        /**
         * The Amazon Resource Name (ARN) for the destination of the audit logs.
         * <p>
         * The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.
         * <p>
         * The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code> prefix.
         * <p>
         * The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in the same AWS partition, AWS Region , and AWS account as your Amazon FSx file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-auditlogconfiguration.html#cfn-fsx-filesystem-auditlogconfiguration-auditlogdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-auditlogconfiguration.html#cfn-fsx-filesystem-auditlogconfiguration-auditlogdestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuditLogDestination() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuditLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuditLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuditLogConfigurationProperty> {
            java.lang.String fileAccessAuditLogLevel;
            java.lang.String fileShareAccessAuditLogLevel;
            java.lang.String auditLogDestination;

            /**
             * Sets the value of {@link AuditLogConfigurationProperty#getFileAccessAuditLogLevel}
             * @param fileAccessAuditLogLevel Sets which attempt type is logged by Amazon FSx for file and folder accesses. This parameter is required.
             *                                <ul>
             *                                <li><code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.</li>
             *                                <li><code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.</li>
             *                                <li><code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or folders are logged.</li>
             *                                <li><code>DISABLED</code> - access auditing of files and folders is turned off.</li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileAccessAuditLogLevel(java.lang.String fileAccessAuditLogLevel) {
                this.fileAccessAuditLogLevel = fileAccessAuditLogLevel;
                return this;
            }

            /**
             * Sets the value of {@link AuditLogConfigurationProperty#getFileShareAccessAuditLogLevel}
             * @param fileShareAccessAuditLogLevel Sets which attempt type is logged by Amazon FSx for file share accesses. This parameter is required.
             *                                     <ul>
             *                                     <li><code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.</li>
             *                                     <li><code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.</li>
             *                                     <li><code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are logged.</li>
             *                                     <li><code>DISABLED</code> - access auditing of file shares is turned off.</li>
             *                                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileShareAccessAuditLogLevel(java.lang.String fileShareAccessAuditLogLevel) {
                this.fileShareAccessAuditLogLevel = fileShareAccessAuditLogLevel;
                return this;
            }

            /**
             * Sets the value of {@link AuditLogConfigurationProperty#getAuditLogDestination}
             * @param auditLogDestination The Amazon Resource Name (ARN) for the destination of the audit logs.
             *                            The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.
             *                            <p>
             *                            The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code> prefix.
             *                            <p>
             *                            The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in the same AWS partition, AWS Region , and AWS account as your Amazon FSx file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auditLogDestination(java.lang.String auditLogDestination) {
                this.auditLogDestination = auditLogDestination;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuditLogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuditLogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuditLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuditLogConfigurationProperty {
            private final java.lang.String fileAccessAuditLogLevel;
            private final java.lang.String fileShareAccessAuditLogLevel;
            private final java.lang.String auditLogDestination;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileAccessAuditLogLevel = software.amazon.jsii.Kernel.get(this, "fileAccessAuditLogLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileShareAccessAuditLogLevel = software.amazon.jsii.Kernel.get(this, "fileShareAccessAuditLogLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.auditLogDestination = software.amazon.jsii.Kernel.get(this, "auditLogDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileAccessAuditLogLevel = java.util.Objects.requireNonNull(builder.fileAccessAuditLogLevel, "fileAccessAuditLogLevel is required");
                this.fileShareAccessAuditLogLevel = java.util.Objects.requireNonNull(builder.fileShareAccessAuditLogLevel, "fileShareAccessAuditLogLevel is required");
                this.auditLogDestination = builder.auditLogDestination;
            }

            @Override
            public final java.lang.String getFileAccessAuditLogLevel() {
                return this.fileAccessAuditLogLevel;
            }

            @Override
            public final java.lang.String getFileShareAccessAuditLogLevel() {
                return this.fileShareAccessAuditLogLevel;
            }

            @Override
            public final java.lang.String getAuditLogDestination() {
                return this.auditLogDestination;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileAccessAuditLogLevel", om.valueToTree(this.getFileAccessAuditLogLevel()));
                data.set("fileShareAccessAuditLogLevel", om.valueToTree(this.getFileShareAccessAuditLogLevel()));
                if (this.getAuditLogDestination() != null) {
                    data.set("auditLogDestination", om.valueToTree(this.getAuditLogDestination()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.AuditLogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuditLogConfigurationProperty.Jsii$Proxy that = (AuditLogConfigurationProperty.Jsii$Proxy) o;

                if (!fileAccessAuditLogLevel.equals(that.fileAccessAuditLogLevel)) return false;
                if (!fileShareAccessAuditLogLevel.equals(that.fileShareAccessAuditLogLevel)) return false;
                return this.auditLogDestination != null ? this.auditLogDestination.equals(that.auditLogDestination) : that.auditLogDestination == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fileAccessAuditLogLevel.hashCode();
                result = 31 * result + (this.fileShareAccessAuditLogLevel.hashCode());
                result = 31 * result + (this.auditLogDestination != null ? this.auditLogDestination.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies who can mount an OpenZFS file system and the options available while mounting the file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * ClientConfigurationsProperty clientConfigurationsProperty = ClientConfigurationsProperty.builder()
     *         .clients("clients")
     *         .options(List.of("options"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-clientconfigurations.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-clientconfigurations.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.ClientConfigurationsProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientConfigurationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientConfigurationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that specifies who can mount the file system.
         * <p>
         * You can provide a wildcard character ( <code>*</code> ), an IP address ( <code>0.0.0.0</code> ), or a CIDR address ( <code>192.0.2.0/24</code> ). By default, Amazon FSx uses the wildcard character when specifying the client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-clientconfigurations.html#cfn-fsx-filesystem-clientconfigurations-clients">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-clientconfigurations.html#cfn-fsx-filesystem-clientconfigurations-clients</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClients() {
            return null;
        }

        /**
         * The options to use when mounting the file system.
         * <p>
         * For a list of options that you can use with Network File System (NFS), see the <a href="https://docs.aws.amazon.com/https://linux.die.net/man/5/exports">exports(5) - Linux man page</a> . When choosing your options, consider the following:
         * <p>
         * <ul>
         * <li><code>crossmnt</code> is used by default. If you don't specify <code>crossmnt</code> when changing the client configuration, you won't be able to see or access snapshots in your file system's snapshot directory.</li>
         * <li><code>sync</code> is used by default. If you instead specify <code>async</code> , the system acknowledges writes before writing to disk. If the system crashes before the writes are finished, you lose the unwritten data.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-clientconfigurations.html#cfn-fsx-filesystem-clientconfigurations-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-clientconfigurations.html#cfn-fsx-filesystem-clientconfigurations-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientConfigurationsProperty> {
            java.lang.String clients;
            java.util.List<java.lang.String> options;

            /**
             * Sets the value of {@link ClientConfigurationsProperty#getClients}
             * @param clients A value that specifies who can mount the file system.
             *                You can provide a wildcard character ( <code>*</code> ), an IP address ( <code>0.0.0.0</code> ), or a CIDR address ( <code>192.0.2.0/24</code> ). By default, Amazon FSx uses the wildcard character when specifying the client.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clients(java.lang.String clients) {
                this.clients = clients;
                return this;
            }

            /**
             * Sets the value of {@link ClientConfigurationsProperty#getOptions}
             * @param options The options to use when mounting the file system.
             *                For a list of options that you can use with Network File System (NFS), see the <a href="https://docs.aws.amazon.com/https://linux.die.net/man/5/exports">exports(5) - Linux man page</a> . When choosing your options, consider the following:
             *                <p>
             *                <ul>
             *                <li><code>crossmnt</code> is used by default. If you don't specify <code>crossmnt</code> when changing the client configuration, you won't be able to see or access snapshots in your file system's snapshot directory.</li>
             *                <li><code>sync</code> is used by default. If you instead specify <code>async</code> , the system acknowledges writes before writing to disk. If the system crashes before the writes are finished, you lose the unwritten data.</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<java.lang.String> options) {
                this.options = options;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientConfigurationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientConfigurationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientConfigurationsProperty {
            private final java.lang.String clients;
            private final java.util.List<java.lang.String> options;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clients = software.amazon.jsii.Kernel.get(this, "clients", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clients = builder.clients;
                this.options = builder.options;
            }

            @Override
            public final java.lang.String getClients() {
                return this.clients;
            }

            @Override
            public final java.util.List<java.lang.String> getOptions() {
                return this.options;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClients() != null) {
                    data.set("clients", om.valueToTree(this.getClients()));
                }
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.ClientConfigurationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientConfigurationsProperty.Jsii$Proxy that = (ClientConfigurationsProperty.Jsii$Proxy) o;

                if (this.clients != null ? !this.clients.equals(that.clients) : that.clients != null) return false;
                return this.options != null ? this.options.equals(that.options) : that.options == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clients != null ? this.clients.hashCode() : 0;
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * DataReadCacheConfigurationProperty dataReadCacheConfigurationProperty = DataReadCacheConfigurationProperty.builder()
     *         .sizeGiB(123)
     *         .sizingMode("sizingMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-datareadcacheconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-datareadcacheconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.DataReadCacheConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataReadCacheConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataReadCacheConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-datareadcacheconfiguration.html#cfn-fsx-filesystem-datareadcacheconfiguration-sizegib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-datareadcacheconfiguration.html#cfn-fsx-filesystem-datareadcacheconfiguration-sizegib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeGiB() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-datareadcacheconfiguration.html#cfn-fsx-filesystem-datareadcacheconfiguration-sizingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-datareadcacheconfiguration.html#cfn-fsx-filesystem-datareadcacheconfiguration-sizingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSizingMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataReadCacheConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataReadCacheConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataReadCacheConfigurationProperty> {
            java.lang.Number sizeGiB;
            java.lang.String sizingMode;

            /**
             * Sets the value of {@link DataReadCacheConfigurationProperty#getSizeGiB}
             * @param sizeGiB the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeGiB(java.lang.Number sizeGiB) {
                this.sizeGiB = sizeGiB;
                return this;
            }

            /**
             * Sets the value of {@link DataReadCacheConfigurationProperty#getSizingMode}
             * @param sizingMode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizingMode(java.lang.String sizingMode) {
                this.sizingMode = sizingMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataReadCacheConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataReadCacheConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataReadCacheConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataReadCacheConfigurationProperty {
            private final java.lang.Number sizeGiB;
            private final java.lang.String sizingMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sizeGiB = software.amazon.jsii.Kernel.get(this, "sizeGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizingMode = software.amazon.jsii.Kernel.get(this, "sizingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sizeGiB = builder.sizeGiB;
                this.sizingMode = builder.sizingMode;
            }

            @Override
            public final java.lang.Number getSizeGiB() {
                return this.sizeGiB;
            }

            @Override
            public final java.lang.String getSizingMode() {
                return this.sizingMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSizeGiB() != null) {
                    data.set("sizeGiB", om.valueToTree(this.getSizeGiB()));
                }
                if (this.getSizingMode() != null) {
                    data.set("sizingMode", om.valueToTree(this.getSizingMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.DataReadCacheConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataReadCacheConfigurationProperty.Jsii$Proxy that = (DataReadCacheConfigurationProperty.Jsii$Proxy) o;

                if (this.sizeGiB != null ? !this.sizeGiB.equals(that.sizeGiB) : that.sizeGiB != null) return false;
                return this.sizingMode != null ? this.sizingMode.equals(that.sizingMode) : that.sizingMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sizeGiB != null ? this.sizeGiB.hashCode() : 0;
                result = 31 * result + (this.sizingMode != null ? this.sizingMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS file system.
     * <p>
     * By default, Amazon FSx automatically provisions 3 IOPS per GB of storage capacity. You can provision additional IOPS per GB of storage. The configuration consists of the total number of provisioned SSD IOPS and how it is was provisioned, or the mode (by the customer or by Amazon FSx).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * DiskIopsConfigurationProperty diskIopsConfigurationProperty = DiskIopsConfigurationProperty.builder()
     *         .iops(123)
     *         .mode("mode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-diskiopsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-diskiopsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.DiskIopsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DiskIopsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DiskIopsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The total number of SSD IOPS provisioned for the file system.
         * <p>
         * The minimum and maximum values for this property depend on the value of <code>HAPairs</code> and <code>StorageCapacity</code> . The minimum value is calculated as <code>StorageCapacity</code> * 3 * <code>HAPairs</code> (3 IOPS per GB of <code>StorageCapacity</code> ). The maximum value is calculated as 200,000 * <code>HAPairs</code> .
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of <code>Iops</code> is outside of the minimum or maximum values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-diskiopsconfiguration.html#cfn-fsx-filesystem-diskiopsconfiguration-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-diskiopsconfiguration.html#cfn-fsx-filesystem-diskiopsconfiguration-iops</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS per GB of storage capacity, or if it using a <code>USER_PROVISIONED</code> value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-diskiopsconfiguration.html#cfn-fsx-filesystem-diskiopsconfiguration-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-diskiopsconfiguration.html#cfn-fsx-filesystem-diskiopsconfiguration-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DiskIopsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DiskIopsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DiskIopsConfigurationProperty> {
            java.lang.Number iops;
            java.lang.String mode;

            /**
             * Sets the value of {@link DiskIopsConfigurationProperty#getIops}
             * @param iops The total number of SSD IOPS provisioned for the file system.
             *             The minimum and maximum values for this property depend on the value of <code>HAPairs</code> and <code>StorageCapacity</code> . The minimum value is calculated as <code>StorageCapacity</code> * 3 * <code>HAPairs</code> (3 IOPS per GB of <code>StorageCapacity</code> ). The maximum value is calculated as 200,000 * <code>HAPairs</code> .
             *             <p>
             *             Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of <code>Iops</code> is outside of the minimum or maximum values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link DiskIopsConfigurationProperty#getMode}
             * @param mode Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS per GB of storage capacity, or if it using a <code>USER_PROVISIONED</code> value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DiskIopsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DiskIopsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DiskIopsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DiskIopsConfigurationProperty {
            private final java.lang.Number iops;
            private final java.lang.String mode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iops = builder.iops;
                this.mode = builder.mode;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.DiskIopsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DiskIopsConfigurationProperty.Jsii$Proxy that = (DiskIopsConfigurationProperty.Jsii$Proxy) o;

                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                return this.mode != null ? this.mode.equals(that.mode) : that.mode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.iops != null ? this.iops.hashCode() : 0;
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the Amazon FSx for Lustre file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * LustreConfigurationProperty lustreConfigurationProperty = LustreConfigurationProperty.builder()
     *         .autoImportPolicy("autoImportPolicy")
     *         .automaticBackupRetentionDays(123)
     *         .copyTagsToBackups(false)
     *         .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
     *         .dataCompressionType("dataCompressionType")
     *         .dataReadCacheConfiguration(DataReadCacheConfigurationProperty.builder()
     *                 .sizeGiB(123)
     *                 .sizingMode("sizingMode")
     *                 .build())
     *         .deploymentType("deploymentType")
     *         .driveCacheType("driveCacheType")
     *         .efaEnabled(false)
     *         .exportPath("exportPath")
     *         .importedFileChunkSize(123)
     *         .importPath("importPath")
     *         .metadataConfiguration(MetadataConfigurationProperty.builder()
     *                 .iops(123)
     *                 .mode("mode")
     *                 .build())
     *         .perUnitStorageThroughput(123)
     *         .throughputCapacity(123)
     *         .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.LustreConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LustreConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LustreConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
         * <p>
         * Use this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
         * <p>
         * <ul>
         * <li><code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or changed objects after choosing this option.</li>
         * <li><code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system.</li>
         * <li><code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.</li>
         * <li><code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Lustre file systems with a data repository association.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-autoimportpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-autoimportpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAutoImportPolicy() {
            return null;
        }

        /**
         * The number of days to retain automatic backups.
         * <p>
         * Setting this property to <code>0</code> disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is <code>0</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-automaticbackupretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-automaticbackupretentiondays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticBackupRetentionDays() {
            return null;
        }

        /**
         * (Optional) Not available for use with file systems that are linked to a data repository.
         * <p>
         * A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false. If <code>CopyTagsToBackups</code> is set to true, all file system tags are copied to all automatic and user-initiated backups when the user doesn't specify any backup-specific tags. If <code>CopyTagsToBackups</code> is set to true and you specify one or more backup tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
         * <p>
         * (Default = <code>false</code> )
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with backups</a> in the <em>Amazon FSx for Lustre User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-copytagstobackups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-copytagstobackups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToBackups() {
            return null;
        }

        /**
         * A recurring daily time, in the format <code>HH:MM</code> .
         * <p>
         * <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. For example, <code>05:00</code> specifies 5 AM daily.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-dailyautomaticbackupstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-dailyautomaticbackupstarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDailyAutomaticBackupStartTime() {
            return null;
        }

        /**
         * Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the following values:.
         * <p>
         * <ul>
         * <li><code>NONE</code> - (Default) Data compression is turned off when the file system is created.</li>
         * <li><code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a> in the <em>Amazon FSx for Lustre User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-datacompressiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-datacompressiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataCompressionType() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-datareadcacheconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-datareadcacheconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataReadCacheConfiguration() {
            return null;
        }

        /**
         * (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary storage and shorter-term processing of data.
         * <p>
         * The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code> .
         * <p>
         * Choose <code>PERSISTENT_1</code> for longer-term storage and for throughput-focused workloads that aren’t latency-sensitive. <code>PERSISTENT_1</code> supports encryption of data in transit, and is available in all AWS Regions in which FSx for Lustre is available.
         * <p>
         * Choose <code>PERSISTENT_2</code> for longer-term storage and for latency-sensitive workloads that require the highest levels of IOPS/throughput. <code>PERSISTENT_2</code> supports the SSD and Intelligent-Tiering storage classes. You can optionally specify a metadata configuration mode for <code>PERSISTENT_2</code> which supports increasing metadata performance. <code>PERSISTENT_2</code> is available in a limited number of AWS Regions . For more information, and an up-to-date list of AWS Regions in which <code>PERSISTENT_2</code> is available, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-fsx-lustre.html">Deployment and storage class options for FSx for Lustre file systems</a> in the <em>Amazon FSx for Lustre User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you choose <code>PERSISTENT_2</code> , and you set <code>FileSystemTypeVersion</code> to <code>2.10</code> , the <code>CreateFileSystem</code> operation fails.
         * <p>
         * </blockquote>
         * <p>
         * Encryption of data in transit is automatically turned on when you access <code>SCRATCH_2</code> , <code>PERSISTENT_1</code> , and <code>PERSISTENT_2</code> file systems from Amazon EC2 instances that support automatic encryption in the AWS Regions where they are available. For more information about encryption in transit for FSx for Lustre file systems, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting data in transit</a> in the <em>Amazon FSx for Lustre User Guide</em> .
         * <p>
         * (Default = <code>SCRATCH_1</code> )
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-deploymenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-deploymenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentType() {
            return null;
        }

        /**
         * The type of drive cache used by <code>PERSISTENT_1</code> file systems that are provisioned with HDD storage devices.
         * <p>
         * This parameter is required when storage type is HDD. Set this property to <code>READ</code> to improve the performance for frequently accessed files by caching up to 20% of the total storage capacity of the file system.
         * <p>
         * This parameter is required when <code>StorageType</code> is set to <code>HDD</code> and <code>DeploymentType</code> is <code>PERSISTENT_1</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-drivecachetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-drivecachetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDriveCacheType() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-efaenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-efaenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEfaEnabled() {
            return null;
        }

        /**
         * (Optional) Specifies the path in the Amazon S3 bucket where the root of your Amazon FSx file system is exported.
         * <p>
         * The path must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new and changed data is to be exported from your Amazon FSx for Lustre file system. If an <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path, <code>s3://import-bucket/FSxLustre[creation-timestamp]</code> . The timestamp is in UTC format, for example <code>s3://import-bucket/FSxLustre20181105T222312Z</code> .
         * <p>
         * The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code> . If you specify only a bucket name, such as <code>s3://import-bucket</code> , you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten on export. If you provide a custom prefix in the export path, such as <code>s3://import-bucket/[custom-optional-prefix]</code> , Amazon FSx exports the contents of your file system to that export prefix in the Amazon S3 bucket.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for file systems with a data repository association.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-exportpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-exportpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExportPath() {
            return null;
        }

        /**
         * (Optional) For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
         * <p>
         * The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
         * <p>
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Lustre file systems with a data repository association.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importedfilechunksize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importedfilechunksize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getImportedFileChunkSize() {
            return null;
        }

        /**
         * (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data repository for your Amazon FSx for Lustre file system.
         * <p>
         * The root of your FSx for Lustre file system will be mapped to the root of the Amazon S3 bucket you select. An example is <code>s3://import-bucket/optional-prefix</code> . If you specify a prefix after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Lustre file systems with a data repository association.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImportPath() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-metadataconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-metadataconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetadataConfiguration() {
            return null;
        }

        /**
         * Required with <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment types, provisions the amount of read and write throughput for each 1 tebibyte (TiB) of file system storage capacity, in MB/s/TiB.
         * <p>
         * File system throughput capacity is calculated by multiplying ﬁle system storage capacity (TiB) by the <code>PerUnitStorageThroughput</code> (MB/s/TiB). For a 2.4-TiB ﬁle system, provisioning 50 MB/s/TiB of <code>PerUnitStorageThroughput</code> yields 120 MB/s of ﬁle system throughput. You pay for the amount of throughput that you provision.
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li>For <code>PERSISTENT_1</code> SSD storage: 50, 100, 200 MB/s/TiB.</li>
         * <li>For <code>PERSISTENT_1</code> HDD storage: 12, 40 MB/s/TiB.</li>
         * <li>For <code>PERSISTENT_2</code> SSD storage: 125, 250, 500, 1000 MB/s/TiB.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-perunitstoragethroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-perunitstoragethroughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPerUnitStorageThroughput() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-throughputcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-throughputcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughputCapacity() {
            return null;
        }

        /**
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * <p>
         * For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-weeklymaintenancestarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-weeklymaintenancestarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWeeklyMaintenanceStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LustreConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LustreConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LustreConfigurationProperty> {
            java.lang.String autoImportPolicy;
            java.lang.Number automaticBackupRetentionDays;
            java.lang.Object copyTagsToBackups;
            java.lang.String dailyAutomaticBackupStartTime;
            java.lang.String dataCompressionType;
            java.lang.Object dataReadCacheConfiguration;
            java.lang.String deploymentType;
            java.lang.String driveCacheType;
            java.lang.Object efaEnabled;
            java.lang.String exportPath;
            java.lang.Number importedFileChunkSize;
            java.lang.String importPath;
            java.lang.Object metadataConfiguration;
            java.lang.Number perUnitStorageThroughput;
            java.lang.Number throughputCapacity;
            java.lang.String weeklyMaintenanceStartTime;

            /**
             * Sets the value of {@link LustreConfigurationProperty#getAutoImportPolicy}
             * @param autoImportPolicy (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
             *                         Use this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
             *                         <p>
             *                         <ul>
             *                         <li><code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or changed objects after choosing this option.</li>
             *                         <li><code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system.</li>
             *                         <li><code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.</li>
             *                         <li><code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.</li>
             *                         </ul>
             *                         <p>
             *                         For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a> .
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         This parameter is not supported for Lustre file systems with a data repository association.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoImportPolicy(java.lang.String autoImportPolicy) {
                this.autoImportPolicy = autoImportPolicy;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getAutomaticBackupRetentionDays}
             * @param automaticBackupRetentionDays The number of days to retain automatic backups.
             *                                     Setting this property to <code>0</code> disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticBackupRetentionDays(java.lang.Number automaticBackupRetentionDays) {
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups (Optional) Not available for use with file systems that are linked to a data repository.
             *                          A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false. If <code>CopyTagsToBackups</code> is set to true, all file system tags are copied to all automatic and user-initiated backups when the user doesn't specify any backup-specific tags. If <code>CopyTagsToBackups</code> is set to true and you specify one or more backup tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
             *                          <p>
             *                          (Default = <code>false</code> )
             *                          <p>
             *                          For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with backups</a> in the <em>Amazon FSx for Lustre User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(java.lang.Boolean copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups (Optional) Not available for use with file systems that are linked to a data repository.
             *                          A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false. If <code>CopyTagsToBackups</code> is set to true, all file system tags are copied to all automatic and user-initiated backups when the user doesn't specify any backup-specific tags. If <code>CopyTagsToBackups</code> is set to true and you specify one or more backup tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
             *                          <p>
             *                          (Default = <code>false</code> )
             *                          <p>
             *                          For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with backups</a> in the <em>Amazon FSx for Lustre User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(software.amazon.awscdk.IResolvable copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getDailyAutomaticBackupStartTime}
             * @param dailyAutomaticBackupStartTime A recurring daily time, in the format <code>HH:MM</code> .
             *                                      <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. For example, <code>05:00</code> specifies 5 AM daily.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyAutomaticBackupStartTime(java.lang.String dailyAutomaticBackupStartTime) {
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getDataCompressionType}
             * @param dataCompressionType Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the following values:.
             *                            <ul>
             *                            <li><code>NONE</code> - (Default) Data compression is turned off when the file system is created.</li>
             *                            <li><code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.</li>
             *                            </ul>
             *                            <p>
             *                            For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a> in the <em>Amazon FSx for Lustre User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCompressionType(java.lang.String dataCompressionType) {
                this.dataCompressionType = dataCompressionType;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getDataReadCacheConfiguration}
             * @param dataReadCacheConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataReadCacheConfiguration(software.amazon.awscdk.IResolvable dataReadCacheConfiguration) {
                this.dataReadCacheConfiguration = dataReadCacheConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getDataReadCacheConfiguration}
             * @param dataReadCacheConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataReadCacheConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.DataReadCacheConfigurationProperty dataReadCacheConfiguration) {
                this.dataReadCacheConfiguration = dataReadCacheConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getDeploymentType}
             * @param deploymentType (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary storage and shorter-term processing of data.
             *                       The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code> .
             *                       <p>
             *                       Choose <code>PERSISTENT_1</code> for longer-term storage and for throughput-focused workloads that aren’t latency-sensitive. <code>PERSISTENT_1</code> supports encryption of data in transit, and is available in all AWS Regions in which FSx for Lustre is available.
             *                       <p>
             *                       Choose <code>PERSISTENT_2</code> for longer-term storage and for latency-sensitive workloads that require the highest levels of IOPS/throughput. <code>PERSISTENT_2</code> supports the SSD and Intelligent-Tiering storage classes. You can optionally specify a metadata configuration mode for <code>PERSISTENT_2</code> which supports increasing metadata performance. <code>PERSISTENT_2</code> is available in a limited number of AWS Regions . For more information, and an up-to-date list of AWS Regions in which <code>PERSISTENT_2</code> is available, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-fsx-lustre.html">Deployment and storage class options for FSx for Lustre file systems</a> in the <em>Amazon FSx for Lustre User Guide</em> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       If you choose <code>PERSISTENT_2</code> , and you set <code>FileSystemTypeVersion</code> to <code>2.10</code> , the <code>CreateFileSystem</code> operation fails.
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       Encryption of data in transit is automatically turned on when you access <code>SCRATCH_2</code> , <code>PERSISTENT_1</code> , and <code>PERSISTENT_2</code> file systems from Amazon EC2 instances that support automatic encryption in the AWS Regions where they are available. For more information about encryption in transit for FSx for Lustre file systems, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting data in transit</a> in the <em>Amazon FSx for Lustre User Guide</em> .
             *                       <p>
             *                       (Default = <code>SCRATCH_1</code> )
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentType(java.lang.String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getDriveCacheType}
             * @param driveCacheType The type of drive cache used by <code>PERSISTENT_1</code> file systems that are provisioned with HDD storage devices.
             *                       This parameter is required when storage type is HDD. Set this property to <code>READ</code> to improve the performance for frequently accessed files by caching up to 20% of the total storage capacity of the file system.
             *                       <p>
             *                       This parameter is required when <code>StorageType</code> is set to <code>HDD</code> and <code>DeploymentType</code> is <code>PERSISTENT_1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder driveCacheType(java.lang.String driveCacheType) {
                this.driveCacheType = driveCacheType;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getEfaEnabled}
             * @param efaEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efaEnabled(java.lang.Boolean efaEnabled) {
                this.efaEnabled = efaEnabled;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getEfaEnabled}
             * @param efaEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efaEnabled(software.amazon.awscdk.IResolvable efaEnabled) {
                this.efaEnabled = efaEnabled;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getExportPath}
             * @param exportPath (Optional) Specifies the path in the Amazon S3 bucket where the root of your Amazon FSx file system is exported.
             *                   The path must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new and changed data is to be exported from your Amazon FSx for Lustre file system. If an <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path, <code>s3://import-bucket/FSxLustre[creation-timestamp]</code> . The timestamp is in UTC format, for example <code>s3://import-bucket/FSxLustre20181105T222312Z</code> .
             *                   <p>
             *                   The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code> . If you specify only a bucket name, such as <code>s3://import-bucket</code> , you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten on export. If you provide a custom prefix in the export path, such as <code>s3://import-bucket/[custom-optional-prefix]</code> , Amazon FSx exports the contents of your file system to that export prefix in the Amazon S3 bucket.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter is not supported for file systems with a data repository association.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportPath(java.lang.String exportPath) {
                this.exportPath = exportPath;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getImportedFileChunkSize}
             * @param importedFileChunkSize (Optional) For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
             *                              The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
             *                              <p>
             *                              The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
             *                              <p>
             *                              <blockquote>
             *                              <p>
             *                              This parameter is not supported for Lustre file systems with a data repository association.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder importedFileChunkSize(java.lang.Number importedFileChunkSize) {
                this.importedFileChunkSize = importedFileChunkSize;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getImportPath}
             * @param importPath (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data repository for your Amazon FSx for Lustre file system.
             *                   The root of your FSx for Lustre file system will be mapped to the root of the Amazon S3 bucket you select. An example is <code>s3://import-bucket/optional-prefix</code> . If you specify a prefix after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter is not supported for Lustre file systems with a data repository association.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder importPath(java.lang.String importPath) {
                this.importPath = importPath;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getMetadataConfiguration}
             * @param metadataConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataConfiguration(software.amazon.awscdk.IResolvable metadataConfiguration) {
                this.metadataConfiguration = metadataConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getMetadataConfiguration}
             * @param metadataConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.MetadataConfigurationProperty metadataConfiguration) {
                this.metadataConfiguration = metadataConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getPerUnitStorageThroughput}
             * @param perUnitStorageThroughput Required with <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment types, provisions the amount of read and write throughput for each 1 tebibyte (TiB) of file system storage capacity, in MB/s/TiB.
             *                                 File system throughput capacity is calculated by multiplying ﬁle system storage capacity (TiB) by the <code>PerUnitStorageThroughput</code> (MB/s/TiB). For a 2.4-TiB ﬁle system, provisioning 50 MB/s/TiB of <code>PerUnitStorageThroughput</code> yields 120 MB/s of ﬁle system throughput. You pay for the amount of throughput that you provision.
             *                                 <p>
             *                                 Valid values:
             *                                 <p>
             *                                 <ul>
             *                                 <li>For <code>PERSISTENT_1</code> SSD storage: 50, 100, 200 MB/s/TiB.</li>
             *                                 <li>For <code>PERSISTENT_1</code> HDD storage: 12, 40 MB/s/TiB.</li>
             *                                 <li>For <code>PERSISTENT_2</code> SSD storage: 125, 250, 500, 1000 MB/s/TiB.</li>
             *                                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perUnitStorageThroughput(java.lang.Number perUnitStorageThroughput) {
                this.perUnitStorageThroughput = perUnitStorageThroughput;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getThroughputCapacity}
             * @param throughputCapacity the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughputCapacity(java.lang.Number throughputCapacity) {
                this.throughputCapacity = throughputCapacity;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getWeeklyMaintenanceStartTime}
             * @param weeklyMaintenanceStartTime The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
             *                                   For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeklyMaintenanceStartTime(java.lang.String weeklyMaintenanceStartTime) {
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LustreConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LustreConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LustreConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LustreConfigurationProperty {
            private final java.lang.String autoImportPolicy;
            private final java.lang.Number automaticBackupRetentionDays;
            private final java.lang.Object copyTagsToBackups;
            private final java.lang.String dailyAutomaticBackupStartTime;
            private final java.lang.String dataCompressionType;
            private final java.lang.Object dataReadCacheConfiguration;
            private final java.lang.String deploymentType;
            private final java.lang.String driveCacheType;
            private final java.lang.Object efaEnabled;
            private final java.lang.String exportPath;
            private final java.lang.Number importedFileChunkSize;
            private final java.lang.String importPath;
            private final java.lang.Object metadataConfiguration;
            private final java.lang.Number perUnitStorageThroughput;
            private final java.lang.Number throughputCapacity;
            private final java.lang.String weeklyMaintenanceStartTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoImportPolicy = software.amazon.jsii.Kernel.get(this, "autoImportPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.automaticBackupRetentionDays = software.amazon.jsii.Kernel.get(this, "automaticBackupRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.copyTagsToBackups = software.amazon.jsii.Kernel.get(this, "copyTagsToBackups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dailyAutomaticBackupStartTime = software.amazon.jsii.Kernel.get(this, "dailyAutomaticBackupStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataCompressionType = software.amazon.jsii.Kernel.get(this, "dataCompressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataReadCacheConfiguration = software.amazon.jsii.Kernel.get(this, "dataReadCacheConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deploymentType = software.amazon.jsii.Kernel.get(this, "deploymentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.driveCacheType = software.amazon.jsii.Kernel.get(this, "driveCacheType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.efaEnabled = software.amazon.jsii.Kernel.get(this, "efaEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exportPath = software.amazon.jsii.Kernel.get(this, "exportPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.importedFileChunkSize = software.amazon.jsii.Kernel.get(this, "importedFileChunkSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.importPath = software.amazon.jsii.Kernel.get(this, "importPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metadataConfiguration = software.amazon.jsii.Kernel.get(this, "metadataConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.perUnitStorageThroughput = software.amazon.jsii.Kernel.get(this, "perUnitStorageThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throughputCapacity = software.amazon.jsii.Kernel.get(this, "throughputCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weeklyMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoImportPolicy = builder.autoImportPolicy;
                this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
                this.copyTagsToBackups = builder.copyTagsToBackups;
                this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
                this.dataCompressionType = builder.dataCompressionType;
                this.dataReadCacheConfiguration = builder.dataReadCacheConfiguration;
                this.deploymentType = builder.deploymentType;
                this.driveCacheType = builder.driveCacheType;
                this.efaEnabled = builder.efaEnabled;
                this.exportPath = builder.exportPath;
                this.importedFileChunkSize = builder.importedFileChunkSize;
                this.importPath = builder.importPath;
                this.metadataConfiguration = builder.metadataConfiguration;
                this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
                this.throughputCapacity = builder.throughputCapacity;
                this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
            }

            @Override
            public final java.lang.String getAutoImportPolicy() {
                return this.autoImportPolicy;
            }

            @Override
            public final java.lang.Number getAutomaticBackupRetentionDays() {
                return this.automaticBackupRetentionDays;
            }

            @Override
            public final java.lang.Object getCopyTagsToBackups() {
                return this.copyTagsToBackups;
            }

            @Override
            public final java.lang.String getDailyAutomaticBackupStartTime() {
                return this.dailyAutomaticBackupStartTime;
            }

            @Override
            public final java.lang.String getDataCompressionType() {
                return this.dataCompressionType;
            }

            @Override
            public final java.lang.Object getDataReadCacheConfiguration() {
                return this.dataReadCacheConfiguration;
            }

            @Override
            public final java.lang.String getDeploymentType() {
                return this.deploymentType;
            }

            @Override
            public final java.lang.String getDriveCacheType() {
                return this.driveCacheType;
            }

            @Override
            public final java.lang.Object getEfaEnabled() {
                return this.efaEnabled;
            }

            @Override
            public final java.lang.String getExportPath() {
                return this.exportPath;
            }

            @Override
            public final java.lang.Number getImportedFileChunkSize() {
                return this.importedFileChunkSize;
            }

            @Override
            public final java.lang.String getImportPath() {
                return this.importPath;
            }

            @Override
            public final java.lang.Object getMetadataConfiguration() {
                return this.metadataConfiguration;
            }

            @Override
            public final java.lang.Number getPerUnitStorageThroughput() {
                return this.perUnitStorageThroughput;
            }

            @Override
            public final java.lang.Number getThroughputCapacity() {
                return this.throughputCapacity;
            }

            @Override
            public final java.lang.String getWeeklyMaintenanceStartTime() {
                return this.weeklyMaintenanceStartTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoImportPolicy() != null) {
                    data.set("autoImportPolicy", om.valueToTree(this.getAutoImportPolicy()));
                }
                if (this.getAutomaticBackupRetentionDays() != null) {
                    data.set("automaticBackupRetentionDays", om.valueToTree(this.getAutomaticBackupRetentionDays()));
                }
                if (this.getCopyTagsToBackups() != null) {
                    data.set("copyTagsToBackups", om.valueToTree(this.getCopyTagsToBackups()));
                }
                if (this.getDailyAutomaticBackupStartTime() != null) {
                    data.set("dailyAutomaticBackupStartTime", om.valueToTree(this.getDailyAutomaticBackupStartTime()));
                }
                if (this.getDataCompressionType() != null) {
                    data.set("dataCompressionType", om.valueToTree(this.getDataCompressionType()));
                }
                if (this.getDataReadCacheConfiguration() != null) {
                    data.set("dataReadCacheConfiguration", om.valueToTree(this.getDataReadCacheConfiguration()));
                }
                if (this.getDeploymentType() != null) {
                    data.set("deploymentType", om.valueToTree(this.getDeploymentType()));
                }
                if (this.getDriveCacheType() != null) {
                    data.set("driveCacheType", om.valueToTree(this.getDriveCacheType()));
                }
                if (this.getEfaEnabled() != null) {
                    data.set("efaEnabled", om.valueToTree(this.getEfaEnabled()));
                }
                if (this.getExportPath() != null) {
                    data.set("exportPath", om.valueToTree(this.getExportPath()));
                }
                if (this.getImportedFileChunkSize() != null) {
                    data.set("importedFileChunkSize", om.valueToTree(this.getImportedFileChunkSize()));
                }
                if (this.getImportPath() != null) {
                    data.set("importPath", om.valueToTree(this.getImportPath()));
                }
                if (this.getMetadataConfiguration() != null) {
                    data.set("metadataConfiguration", om.valueToTree(this.getMetadataConfiguration()));
                }
                if (this.getPerUnitStorageThroughput() != null) {
                    data.set("perUnitStorageThroughput", om.valueToTree(this.getPerUnitStorageThroughput()));
                }
                if (this.getThroughputCapacity() != null) {
                    data.set("throughputCapacity", om.valueToTree(this.getThroughputCapacity()));
                }
                if (this.getWeeklyMaintenanceStartTime() != null) {
                    data.set("weeklyMaintenanceStartTime", om.valueToTree(this.getWeeklyMaintenanceStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.LustreConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LustreConfigurationProperty.Jsii$Proxy that = (LustreConfigurationProperty.Jsii$Proxy) o;

                if (this.autoImportPolicy != null ? !this.autoImportPolicy.equals(that.autoImportPolicy) : that.autoImportPolicy != null) return false;
                if (this.automaticBackupRetentionDays != null ? !this.automaticBackupRetentionDays.equals(that.automaticBackupRetentionDays) : that.automaticBackupRetentionDays != null) return false;
                if (this.copyTagsToBackups != null ? !this.copyTagsToBackups.equals(that.copyTagsToBackups) : that.copyTagsToBackups != null) return false;
                if (this.dailyAutomaticBackupStartTime != null ? !this.dailyAutomaticBackupStartTime.equals(that.dailyAutomaticBackupStartTime) : that.dailyAutomaticBackupStartTime != null) return false;
                if (this.dataCompressionType != null ? !this.dataCompressionType.equals(that.dataCompressionType) : that.dataCompressionType != null) return false;
                if (this.dataReadCacheConfiguration != null ? !this.dataReadCacheConfiguration.equals(that.dataReadCacheConfiguration) : that.dataReadCacheConfiguration != null) return false;
                if (this.deploymentType != null ? !this.deploymentType.equals(that.deploymentType) : that.deploymentType != null) return false;
                if (this.driveCacheType != null ? !this.driveCacheType.equals(that.driveCacheType) : that.driveCacheType != null) return false;
                if (this.efaEnabled != null ? !this.efaEnabled.equals(that.efaEnabled) : that.efaEnabled != null) return false;
                if (this.exportPath != null ? !this.exportPath.equals(that.exportPath) : that.exportPath != null) return false;
                if (this.importedFileChunkSize != null ? !this.importedFileChunkSize.equals(that.importedFileChunkSize) : that.importedFileChunkSize != null) return false;
                if (this.importPath != null ? !this.importPath.equals(that.importPath) : that.importPath != null) return false;
                if (this.metadataConfiguration != null ? !this.metadataConfiguration.equals(that.metadataConfiguration) : that.metadataConfiguration != null) return false;
                if (this.perUnitStorageThroughput != null ? !this.perUnitStorageThroughput.equals(that.perUnitStorageThroughput) : that.perUnitStorageThroughput != null) return false;
                if (this.throughputCapacity != null ? !this.throughputCapacity.equals(that.throughputCapacity) : that.throughputCapacity != null) return false;
                return this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.equals(that.weeklyMaintenanceStartTime) : that.weeklyMaintenanceStartTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoImportPolicy != null ? this.autoImportPolicy.hashCode() : 0;
                result = 31 * result + (this.automaticBackupRetentionDays != null ? this.automaticBackupRetentionDays.hashCode() : 0);
                result = 31 * result + (this.copyTagsToBackups != null ? this.copyTagsToBackups.hashCode() : 0);
                result = 31 * result + (this.dailyAutomaticBackupStartTime != null ? this.dailyAutomaticBackupStartTime.hashCode() : 0);
                result = 31 * result + (this.dataCompressionType != null ? this.dataCompressionType.hashCode() : 0);
                result = 31 * result + (this.dataReadCacheConfiguration != null ? this.dataReadCacheConfiguration.hashCode() : 0);
                result = 31 * result + (this.deploymentType != null ? this.deploymentType.hashCode() : 0);
                result = 31 * result + (this.driveCacheType != null ? this.driveCacheType.hashCode() : 0);
                result = 31 * result + (this.efaEnabled != null ? this.efaEnabled.hashCode() : 0);
                result = 31 * result + (this.exportPath != null ? this.exportPath.hashCode() : 0);
                result = 31 * result + (this.importedFileChunkSize != null ? this.importedFileChunkSize.hashCode() : 0);
                result = 31 * result + (this.importPath != null ? this.importPath.hashCode() : 0);
                result = 31 * result + (this.metadataConfiguration != null ? this.metadataConfiguration.hashCode() : 0);
                result = 31 * result + (this.perUnitStorageThroughput != null ? this.perUnitStorageThroughput.hashCode() : 0);
                result = 31 * result + (this.throughputCapacity != null ? this.throughputCapacity.hashCode() : 0);
                result = 31 * result + (this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * MetadataConfigurationProperty metadataConfigurationProperty = MetadataConfigurationProperty.builder()
     *         .iops(123)
     *         .mode("mode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-metadataconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-metadataconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.MetadataConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-metadataconfiguration.html#cfn-fsx-filesystem-metadataconfiguration-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-metadataconfiguration.html#cfn-fsx-filesystem-metadataconfiguration-iops</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-metadataconfiguration.html#cfn-fsx-filesystem-metadataconfiguration-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-metadataconfiguration.html#cfn-fsx-filesystem-metadataconfiguration-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataConfigurationProperty> {
            java.lang.Number iops;
            java.lang.String mode;

            /**
             * Sets the value of {@link MetadataConfigurationProperty#getIops}
             * @param iops the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link MetadataConfigurationProperty#getMode}
             * @param mode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataConfigurationProperty {
            private final java.lang.Number iops;
            private final java.lang.String mode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iops = builder.iops;
                this.mode = builder.mode;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.MetadataConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataConfigurationProperty.Jsii$Proxy that = (MetadataConfigurationProperty.Jsii$Proxy) o;

                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                return this.mode != null ? this.mode.equals(that.mode) : that.mode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.iops != null ? this.iops.hashCode() : 0;
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration object for mounting a file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * NfsExportsProperty nfsExportsProperty = NfsExportsProperty.builder()
     *         .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
     *                 .clients("clients")
     *                 .options(List.of("options"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-nfsexports.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-nfsexports.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.NfsExportsProperty")
    @software.amazon.jsii.Jsii.Proxy(NfsExportsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NfsExportsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-nfsexports.html#cfn-fsx-filesystem-nfsexports-clientconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-nfsexports.html#cfn-fsx-filesystem-nfsexports-clientconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClientConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NfsExportsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NfsExportsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NfsExportsProperty> {
            java.lang.Object clientConfigurations;

            /**
             * Sets the value of {@link NfsExportsProperty#getClientConfigurations}
             * @param clientConfigurations A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfigurations(software.amazon.awscdk.IResolvable clientConfigurations) {
                this.clientConfigurations = clientConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NfsExportsProperty#getClientConfigurations}
             * @param clientConfigurations A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfigurations(java.util.List<? extends java.lang.Object> clientConfigurations) {
                this.clientConfigurations = clientConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NfsExportsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NfsExportsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NfsExportsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NfsExportsProperty {
            private final java.lang.Object clientConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientConfigurations = software.amazon.jsii.Kernel.get(this, "clientConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientConfigurations = builder.clientConfigurations;
            }

            @Override
            public final java.lang.Object getClientConfigurations() {
                return this.clientConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientConfigurations() != null) {
                    data.set("clientConfigurations", om.valueToTree(this.getClientConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.NfsExportsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NfsExportsProperty.Jsii$Proxy that = (NfsExportsProperty.Jsii$Proxy) o;

                return this.clientConfigurations != null ? this.clientConfigurations.equals(that.clientConfigurations) : that.clientConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientConfigurations != null ? this.clientConfigurations.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration for this Amazon FSx for NetApp ONTAP file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * OntapConfigurationProperty ontapConfigurationProperty = OntapConfigurationProperty.builder()
     *         .deploymentType("deploymentType")
     *         // the properties below are optional
     *         .automaticBackupRetentionDays(123)
     *         .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
     *         .diskIopsConfiguration(DiskIopsConfigurationProperty.builder()
     *                 .iops(123)
     *                 .mode("mode")
     *                 .build())
     *         .endpointIpAddressRange("endpointIpAddressRange")
     *         .fsxAdminPassword("fsxAdminPassword")
     *         .haPairs(123)
     *         .preferredSubnetId("preferredSubnetId")
     *         .routeTableIds(List.of("routeTableIds"))
     *         .throughputCapacity(123)
     *         .throughputCapacityPerHaPair(123)
     *         .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.OntapConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OntapConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OntapConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the FSx for ONTAP file system deployment type to use in creating the file system.
         * <p>
         * <ul>
         * <li><code>MULTI_AZ_1</code> - A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. This is a first-generation FSx for ONTAP file system.</li>
         * <li><code>MULTI_AZ_2</code> - A high availability file system configured for Multi-AZ redundancy to tolerate temporary AZ unavailability. This is a second-generation FSx for ONTAP file system.</li>
         * <li><code>SINGLE_AZ_1</code> - A file system configured for Single-AZ redundancy. This is a first-generation FSx for ONTAP file system.</li>
         * <li><code>SINGLE_AZ_2</code> - A file system configured with multiple high-availability (HA) pairs for Single-AZ redundancy. This is a second-generation FSx for ONTAP file system.</li>
         * </ul>
         * <p>
         * For information about the use cases for Multi-AZ and Single-AZ deployments, refer to <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-AZ.html">Choosing a file system deployment type</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-deploymenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-deploymenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeploymentType();

        /**
         * The number of days to retain automatic backups.
         * <p>
         * Setting this property to <code>0</code> disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is <code>30</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-automaticbackupretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-automaticbackupretentiondays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticBackupRetentionDays() {
            return null;
        }

        /**
         * A recurring daily time, in the format <code>HH:MM</code> .
         * <p>
         * <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. For example, <code>05:00</code> specifies 5 AM daily.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-dailyautomaticbackupstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-dailyautomaticbackupstarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDailyAutomaticBackupStartTime() {
            return null;
        }

        /**
         * The SSD IOPS configuration for the FSx for ONTAP file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-diskiopsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-diskiopsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDiskIopsConfiguration() {
            return null;
        }

        /**
         * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
         * <p>
         * By default in the Amazon FSx API, Amazon FSx selects an unused IP address range for you from the 198.19.* range. By default in the Amazon FSx console, Amazon FSx chooses the last 64 IP addresses from the VPC’s primary CIDR range to use as the endpoint IP address range for the file system. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables, as long as they don't overlap with any subnet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-endpointipaddressrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-endpointipaddressrange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointIpAddressRange() {
            return null;
        }

        /**
         * The ONTAP administrative password for the <code>fsxadmin</code> user with which you administer your file system using the NetApp ONTAP CLI and REST API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-fsxadminpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-fsxadminpassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFsxAdminPassword() {
            return null;
        }

        /**
         * Specifies how many high-availability (HA) pairs of file servers will power your file system.
         * <p>
         * First-generation file systems are powered by 1 HA pair. Second-generation multi-AZ file systems are powered by 1 HA pair. Second generation single-AZ file systems are powered by up to 12 HA pairs. The default value is 1. The value of this property affects the values of <code>StorageCapacity</code> , <code>Iops</code> , and <code>ThroughputCapacity</code> . For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/administering-file-systems.html#HA-pairs">High-availability (HA) pairs</a> in the FSx for ONTAP user guide. Block storage protocol support (iSCSI and NVMe over TCP) is disabled on file systems with more than 6 HA pairs. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/supported-fsx-clients.html#using-block-storage">Using block storage protocols</a> .
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * <p>
         * <ul>
         * <li>The value of <code>HAPairs</code> is less than 1 or greater than 12.</li>
         * <li>The value of <code>HAPairs</code> is greater than 1 and the value of <code>DeploymentType</code> is <code>SINGLE_AZ_1</code> , <code>MULTI_AZ_1</code> , or <code>MULTI_AZ_2</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-hapairs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-hapairs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHaPairs() {
            return null;
        }

        /**
         * Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code> or <code>MULTI_AZ_2</code> .
         * <p>
         * This specifies the subnet in which you want the preferred file server to be located.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-preferredsubnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-preferredsubnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreferredSubnetId() {
            return null;
        }

        /**
         * (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server.
         * <p>
         * You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
         * <p>
         * <blockquote>
         * <p>
         * Amazon FSx manages these route tables for Multi-AZ file systems using tag-based authentication. These route tables are tagged with <code>Key: AmazonFSx; Value: ManagedByAmazonFSx</code> . When creating FSx for ONTAP Multi-AZ file systems using AWS CloudFormation we recommend that you add the <code>Key: AmazonFSx; Value: ManagedByAmazonFSx</code> tag manually.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-routetableids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-routetableids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRouteTableIds() {
            return null;
        }

        /**
         * Sets the throughput capacity for the file system that you're creating in megabytes per second (MBps).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html">Managing throughput capacity</a> in the FSx for ONTAP User Guide.
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * <p>
         * <ul>
         * <li>The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the same value.</li>
         * <li>The value of <code>ThroughputCapacity</code> when divided by the value of <code>HAPairs</code> is outside of the valid range for <code>ThroughputCapacity</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-throughputcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-throughputcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughputCapacity() {
            return null;
        }

        /**
         * Use to choose the throughput capacity per HA pair, rather than the total throughput for the file system.
         * <p>
         * You can define either the <code>ThroughputCapacityPerHAPair</code> or the <code>ThroughputCapacity</code> when creating a file system, but not both.
         * <p>
         * This field and <code>ThroughputCapacity</code> are the same for file systems powered by one HA pair.
         * <p>
         * <ul>
         * <li>For <code>SINGLE_AZ_1</code> and <code>MULTI_AZ_1</code> file systems, valid values are 128, 256, 512, 1024, 2048, or 4096 MBps.</li>
         * <li>For <code>SINGLE_AZ_2</code> , valid values are 1536, 3072, or 6144 MBps.</li>
         * <li>For <code>MULTI_AZ_2</code> , valid values are 384, 768, 1536, 3072, or 6144 MBps.</li>
         * </ul>
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * <p>
         * <ul>
         * <li>The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the same value for file systems with one HA pair.</li>
         * <li>The value of deployment type is <code>SINGLE_AZ_2</code> and <code>ThroughputCapacity</code> / <code>ThroughputCapacityPerHAPair</code> is not a valid HA pair (a value between 1 and 12).</li>
         * <li>The value of <code>ThroughputCapacityPerHAPair</code> is not a valid value.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-throughputcapacityperhapair">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-throughputcapacityperhapair</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughputCapacityPerHaPair() {
            return null;
        }

        /**
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * <p>
         * For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-weeklymaintenancestarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html#cfn-fsx-filesystem-ontapconfiguration-weeklymaintenancestarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWeeklyMaintenanceStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OntapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OntapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OntapConfigurationProperty> {
            java.lang.String deploymentType;
            java.lang.Number automaticBackupRetentionDays;
            java.lang.String dailyAutomaticBackupStartTime;
            java.lang.Object diskIopsConfiguration;
            java.lang.String endpointIpAddressRange;
            java.lang.String fsxAdminPassword;
            java.lang.Number haPairs;
            java.lang.String preferredSubnetId;
            java.util.List<java.lang.String> routeTableIds;
            java.lang.Number throughputCapacity;
            java.lang.Number throughputCapacityPerHaPair;
            java.lang.String weeklyMaintenanceStartTime;

            /**
             * Sets the value of {@link OntapConfigurationProperty#getDeploymentType}
             * @param deploymentType Specifies the FSx for ONTAP file system deployment type to use in creating the file system. This parameter is required.
             *                       <ul>
             *                       <li><code>MULTI_AZ_1</code> - A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. This is a first-generation FSx for ONTAP file system.</li>
             *                       <li><code>MULTI_AZ_2</code> - A high availability file system configured for Multi-AZ redundancy to tolerate temporary AZ unavailability. This is a second-generation FSx for ONTAP file system.</li>
             *                       <li><code>SINGLE_AZ_1</code> - A file system configured for Single-AZ redundancy. This is a first-generation FSx for ONTAP file system.</li>
             *                       <li><code>SINGLE_AZ_2</code> - A file system configured with multiple high-availability (HA) pairs for Single-AZ redundancy. This is a second-generation FSx for ONTAP file system.</li>
             *                       </ul>
             *                       <p>
             *                       For information about the use cases for Multi-AZ and Single-AZ deployments, refer to <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-AZ.html">Choosing a file system deployment type</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentType(java.lang.String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getAutomaticBackupRetentionDays}
             * @param automaticBackupRetentionDays The number of days to retain automatic backups.
             *                                     Setting this property to <code>0</code> disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is <code>30</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticBackupRetentionDays(java.lang.Number automaticBackupRetentionDays) {
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getDailyAutomaticBackupStartTime}
             * @param dailyAutomaticBackupStartTime A recurring daily time, in the format <code>HH:MM</code> .
             *                                      <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. For example, <code>05:00</code> specifies 5 AM daily.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyAutomaticBackupStartTime(java.lang.String dailyAutomaticBackupStartTime) {
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getDiskIopsConfiguration}
             * @param diskIopsConfiguration The SSD IOPS configuration for the FSx for ONTAP file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder diskIopsConfiguration(software.amazon.awscdk.IResolvable diskIopsConfiguration) {
                this.diskIopsConfiguration = diskIopsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getDiskIopsConfiguration}
             * @param diskIopsConfiguration The SSD IOPS configuration for the FSx for ONTAP file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder diskIopsConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.DiskIopsConfigurationProperty diskIopsConfiguration) {
                this.diskIopsConfiguration = diskIopsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getEndpointIpAddressRange}
             * @param endpointIpAddressRange (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
             *                               By default in the Amazon FSx API, Amazon FSx selects an unused IP address range for you from the 198.19.* range. By default in the Amazon FSx console, Amazon FSx chooses the last 64 IP addresses from the VPC’s primary CIDR range to use as the endpoint IP address range for the file system. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables, as long as they don't overlap with any subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointIpAddressRange(java.lang.String endpointIpAddressRange) {
                this.endpointIpAddressRange = endpointIpAddressRange;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getFsxAdminPassword}
             * @param fsxAdminPassword The ONTAP administrative password for the <code>fsxadmin</code> user with which you administer your file system using the NetApp ONTAP CLI and REST API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fsxAdminPassword(java.lang.String fsxAdminPassword) {
                this.fsxAdminPassword = fsxAdminPassword;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getHaPairs}
             * @param haPairs Specifies how many high-availability (HA) pairs of file servers will power your file system.
             *                First-generation file systems are powered by 1 HA pair. Second-generation multi-AZ file systems are powered by 1 HA pair. Second generation single-AZ file systems are powered by up to 12 HA pairs. The default value is 1. The value of this property affects the values of <code>StorageCapacity</code> , <code>Iops</code> , and <code>ThroughputCapacity</code> . For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/administering-file-systems.html#HA-pairs">High-availability (HA) pairs</a> in the FSx for ONTAP user guide. Block storage protocol support (iSCSI and NVMe over TCP) is disabled on file systems with more than 6 HA pairs. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/supported-fsx-clients.html#using-block-storage">Using block storage protocols</a> .
             *                <p>
             *                Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
             *                <p>
             *                <ul>
             *                <li>The value of <code>HAPairs</code> is less than 1 or greater than 12.</li>
             *                <li>The value of <code>HAPairs</code> is greater than 1 and the value of <code>DeploymentType</code> is <code>SINGLE_AZ_1</code> , <code>MULTI_AZ_1</code> , or <code>MULTI_AZ_2</code> .</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder haPairs(java.lang.Number haPairs) {
                this.haPairs = haPairs;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getPreferredSubnetId}
             * @param preferredSubnetId Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code> or <code>MULTI_AZ_2</code> .
             *                          This specifies the subnet in which you want the preferred file server to be located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredSubnetId(java.lang.String preferredSubnetId) {
                this.preferredSubnetId = preferredSubnetId;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getRouteTableIds}
             * @param routeTableIds (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server.
             *                      You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      Amazon FSx manages these route tables for Multi-AZ file systems using tag-based authentication. These route tables are tagged with <code>Key: AmazonFSx; Value: ManagedByAmazonFSx</code> . When creating FSx for ONTAP Multi-AZ file systems using AWS CloudFormation we recommend that you add the <code>Key: AmazonFSx; Value: ManagedByAmazonFSx</code> tag manually.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeTableIds(java.util.List<java.lang.String> routeTableIds) {
                this.routeTableIds = routeTableIds;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getThroughputCapacity}
             * @param throughputCapacity Sets the throughput capacity for the file system that you're creating in megabytes per second (MBps).
             *                           For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html">Managing throughput capacity</a> in the FSx for ONTAP User Guide.
             *                           <p>
             *                           Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
             *                           <p>
             *                           <ul>
             *                           <li>The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the same value.</li>
             *                           <li>The value of <code>ThroughputCapacity</code> when divided by the value of <code>HAPairs</code> is outside of the valid range for <code>ThroughputCapacity</code> .</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughputCapacity(java.lang.Number throughputCapacity) {
                this.throughputCapacity = throughputCapacity;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getThroughputCapacityPerHaPair}
             * @param throughputCapacityPerHaPair Use to choose the throughput capacity per HA pair, rather than the total throughput for the file system.
             *                                    You can define either the <code>ThroughputCapacityPerHAPair</code> or the <code>ThroughputCapacity</code> when creating a file system, but not both.
             *                                    <p>
             *                                    This field and <code>ThroughputCapacity</code> are the same for file systems powered by one HA pair.
             *                                    <p>
             *                                    <ul>
             *                                    <li>For <code>SINGLE_AZ_1</code> and <code>MULTI_AZ_1</code> file systems, valid values are 128, 256, 512, 1024, 2048, or 4096 MBps.</li>
             *                                    <li>For <code>SINGLE_AZ_2</code> , valid values are 1536, 3072, or 6144 MBps.</li>
             *                                    <li>For <code>MULTI_AZ_2</code> , valid values are 384, 768, 1536, 3072, or 6144 MBps.</li>
             *                                    </ul>
             *                                    <p>
             *                                    Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
             *                                    <p>
             *                                    <ul>
             *                                    <li>The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the same value for file systems with one HA pair.</li>
             *                                    <li>The value of deployment type is <code>SINGLE_AZ_2</code> and <code>ThroughputCapacity</code> / <code>ThroughputCapacityPerHAPair</code> is not a valid HA pair (a value between 1 and 12).</li>
             *                                    <li>The value of <code>ThroughputCapacityPerHAPair</code> is not a valid value.</li>
             *                                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughputCapacityPerHaPair(java.lang.Number throughputCapacityPerHaPair) {
                this.throughputCapacityPerHaPair = throughputCapacityPerHaPair;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getWeeklyMaintenanceStartTime}
             * @param weeklyMaintenanceStartTime The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
             *                                   For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeklyMaintenanceStartTime(java.lang.String weeklyMaintenanceStartTime) {
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OntapConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OntapConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OntapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OntapConfigurationProperty {
            private final java.lang.String deploymentType;
            private final java.lang.Number automaticBackupRetentionDays;
            private final java.lang.String dailyAutomaticBackupStartTime;
            private final java.lang.Object diskIopsConfiguration;
            private final java.lang.String endpointIpAddressRange;
            private final java.lang.String fsxAdminPassword;
            private final java.lang.Number haPairs;
            private final java.lang.String preferredSubnetId;
            private final java.util.List<java.lang.String> routeTableIds;
            private final java.lang.Number throughputCapacity;
            private final java.lang.Number throughputCapacityPerHaPair;
            private final java.lang.String weeklyMaintenanceStartTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deploymentType = software.amazon.jsii.Kernel.get(this, "deploymentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.automaticBackupRetentionDays = software.amazon.jsii.Kernel.get(this, "automaticBackupRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dailyAutomaticBackupStartTime = software.amazon.jsii.Kernel.get(this, "dailyAutomaticBackupStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.diskIopsConfiguration = software.amazon.jsii.Kernel.get(this, "diskIopsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.endpointIpAddressRange = software.amazon.jsii.Kernel.get(this, "endpointIpAddressRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fsxAdminPassword = software.amazon.jsii.Kernel.get(this, "fsxAdminPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.haPairs = software.amazon.jsii.Kernel.get(this, "haPairs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.preferredSubnetId = software.amazon.jsii.Kernel.get(this, "preferredSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.routeTableIds = software.amazon.jsii.Kernel.get(this, "routeTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.throughputCapacity = software.amazon.jsii.Kernel.get(this, "throughputCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throughputCapacityPerHaPair = software.amazon.jsii.Kernel.get(this, "throughputCapacityPerHaPair", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weeklyMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deploymentType = java.util.Objects.requireNonNull(builder.deploymentType, "deploymentType is required");
                this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
                this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
                this.diskIopsConfiguration = builder.diskIopsConfiguration;
                this.endpointIpAddressRange = builder.endpointIpAddressRange;
                this.fsxAdminPassword = builder.fsxAdminPassword;
                this.haPairs = builder.haPairs;
                this.preferredSubnetId = builder.preferredSubnetId;
                this.routeTableIds = builder.routeTableIds;
                this.throughputCapacity = builder.throughputCapacity;
                this.throughputCapacityPerHaPair = builder.throughputCapacityPerHaPair;
                this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
            }

            @Override
            public final java.lang.String getDeploymentType() {
                return this.deploymentType;
            }

            @Override
            public final java.lang.Number getAutomaticBackupRetentionDays() {
                return this.automaticBackupRetentionDays;
            }

            @Override
            public final java.lang.String getDailyAutomaticBackupStartTime() {
                return this.dailyAutomaticBackupStartTime;
            }

            @Override
            public final java.lang.Object getDiskIopsConfiguration() {
                return this.diskIopsConfiguration;
            }

            @Override
            public final java.lang.String getEndpointIpAddressRange() {
                return this.endpointIpAddressRange;
            }

            @Override
            public final java.lang.String getFsxAdminPassword() {
                return this.fsxAdminPassword;
            }

            @Override
            public final java.lang.Number getHaPairs() {
                return this.haPairs;
            }

            @Override
            public final java.lang.String getPreferredSubnetId() {
                return this.preferredSubnetId;
            }

            @Override
            public final java.util.List<java.lang.String> getRouteTableIds() {
                return this.routeTableIds;
            }

            @Override
            public final java.lang.Number getThroughputCapacity() {
                return this.throughputCapacity;
            }

            @Override
            public final java.lang.Number getThroughputCapacityPerHaPair() {
                return this.throughputCapacityPerHaPair;
            }

            @Override
            public final java.lang.String getWeeklyMaintenanceStartTime() {
                return this.weeklyMaintenanceStartTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deploymentType", om.valueToTree(this.getDeploymentType()));
                if (this.getAutomaticBackupRetentionDays() != null) {
                    data.set("automaticBackupRetentionDays", om.valueToTree(this.getAutomaticBackupRetentionDays()));
                }
                if (this.getDailyAutomaticBackupStartTime() != null) {
                    data.set("dailyAutomaticBackupStartTime", om.valueToTree(this.getDailyAutomaticBackupStartTime()));
                }
                if (this.getDiskIopsConfiguration() != null) {
                    data.set("diskIopsConfiguration", om.valueToTree(this.getDiskIopsConfiguration()));
                }
                if (this.getEndpointIpAddressRange() != null) {
                    data.set("endpointIpAddressRange", om.valueToTree(this.getEndpointIpAddressRange()));
                }
                if (this.getFsxAdminPassword() != null) {
                    data.set("fsxAdminPassword", om.valueToTree(this.getFsxAdminPassword()));
                }
                if (this.getHaPairs() != null) {
                    data.set("haPairs", om.valueToTree(this.getHaPairs()));
                }
                if (this.getPreferredSubnetId() != null) {
                    data.set("preferredSubnetId", om.valueToTree(this.getPreferredSubnetId()));
                }
                if (this.getRouteTableIds() != null) {
                    data.set("routeTableIds", om.valueToTree(this.getRouteTableIds()));
                }
                if (this.getThroughputCapacity() != null) {
                    data.set("throughputCapacity", om.valueToTree(this.getThroughputCapacity()));
                }
                if (this.getThroughputCapacityPerHaPair() != null) {
                    data.set("throughputCapacityPerHaPair", om.valueToTree(this.getThroughputCapacityPerHaPair()));
                }
                if (this.getWeeklyMaintenanceStartTime() != null) {
                    data.set("weeklyMaintenanceStartTime", om.valueToTree(this.getWeeklyMaintenanceStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.OntapConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OntapConfigurationProperty.Jsii$Proxy that = (OntapConfigurationProperty.Jsii$Proxy) o;

                if (!deploymentType.equals(that.deploymentType)) return false;
                if (this.automaticBackupRetentionDays != null ? !this.automaticBackupRetentionDays.equals(that.automaticBackupRetentionDays) : that.automaticBackupRetentionDays != null) return false;
                if (this.dailyAutomaticBackupStartTime != null ? !this.dailyAutomaticBackupStartTime.equals(that.dailyAutomaticBackupStartTime) : that.dailyAutomaticBackupStartTime != null) return false;
                if (this.diskIopsConfiguration != null ? !this.diskIopsConfiguration.equals(that.diskIopsConfiguration) : that.diskIopsConfiguration != null) return false;
                if (this.endpointIpAddressRange != null ? !this.endpointIpAddressRange.equals(that.endpointIpAddressRange) : that.endpointIpAddressRange != null) return false;
                if (this.fsxAdminPassword != null ? !this.fsxAdminPassword.equals(that.fsxAdminPassword) : that.fsxAdminPassword != null) return false;
                if (this.haPairs != null ? !this.haPairs.equals(that.haPairs) : that.haPairs != null) return false;
                if (this.preferredSubnetId != null ? !this.preferredSubnetId.equals(that.preferredSubnetId) : that.preferredSubnetId != null) return false;
                if (this.routeTableIds != null ? !this.routeTableIds.equals(that.routeTableIds) : that.routeTableIds != null) return false;
                if (this.throughputCapacity != null ? !this.throughputCapacity.equals(that.throughputCapacity) : that.throughputCapacity != null) return false;
                if (this.throughputCapacityPerHaPair != null ? !this.throughputCapacityPerHaPair.equals(that.throughputCapacityPerHaPair) : that.throughputCapacityPerHaPair != null) return false;
                return this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.equals(that.weeklyMaintenanceStartTime) : that.weeklyMaintenanceStartTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deploymentType.hashCode();
                result = 31 * result + (this.automaticBackupRetentionDays != null ? this.automaticBackupRetentionDays.hashCode() : 0);
                result = 31 * result + (this.dailyAutomaticBackupStartTime != null ? this.dailyAutomaticBackupStartTime.hashCode() : 0);
                result = 31 * result + (this.diskIopsConfiguration != null ? this.diskIopsConfiguration.hashCode() : 0);
                result = 31 * result + (this.endpointIpAddressRange != null ? this.endpointIpAddressRange.hashCode() : 0);
                result = 31 * result + (this.fsxAdminPassword != null ? this.fsxAdminPassword.hashCode() : 0);
                result = 31 * result + (this.haPairs != null ? this.haPairs.hashCode() : 0);
                result = 31 * result + (this.preferredSubnetId != null ? this.preferredSubnetId.hashCode() : 0);
                result = 31 * result + (this.routeTableIds != null ? this.routeTableIds.hashCode() : 0);
                result = 31 * result + (this.throughputCapacity != null ? this.throughputCapacity.hashCode() : 0);
                result = 31 * result + (this.throughputCapacityPerHaPair != null ? this.throughputCapacityPerHaPair.hashCode() : 0);
                result = 31 * result + (this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The OpenZFS configuration for the file system that's being created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * OpenZFSConfigurationProperty openZFSConfigurationProperty = OpenZFSConfigurationProperty.builder()
     *         .deploymentType("deploymentType")
     *         // the properties below are optional
     *         .automaticBackupRetentionDays(123)
     *         .copyTagsToBackups(false)
     *         .copyTagsToVolumes(false)
     *         .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
     *         .diskIopsConfiguration(DiskIopsConfigurationProperty.builder()
     *                 .iops(123)
     *                 .mode("mode")
     *                 .build())
     *         .endpointIpAddressRange("endpointIpAddressRange")
     *         .options(List.of("options"))
     *         .preferredSubnetId("preferredSubnetId")
     *         .readCacheConfiguration(ReadCacheConfigurationProperty.builder()
     *                 .sizeGiB(123)
     *                 .sizingMode("sizingMode")
     *                 .build())
     *         .rootVolumeConfiguration(RootVolumeConfigurationProperty.builder()
     *                 .copyTagsToSnapshots(false)
     *                 .dataCompressionType("dataCompressionType")
     *                 .nfsExports(List.of(NfsExportsProperty.builder()
     *                         .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
     *                                 .clients("clients")
     *                                 .options(List.of("options"))
     *                                 .build()))
     *                         .build()))
     *                 .readOnly(false)
     *                 .recordSizeKiB(123)
     *                 .userAndGroupQuotas(List.of(UserAndGroupQuotasProperty.builder()
     *                         .id(123)
     *                         .storageCapacityQuotaGiB(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .routeTableIds(List.of("routeTableIds"))
     *         .throughputCapacity(123)
     *         .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.OpenZFSConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenZFSConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenZFSConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the file system deployment type. Valid values are the following:.
         * <p>
         * <ul>
         * <li><code>MULTI_AZ_1</code> - Creates file systems with high availability and durability by replicating your data and supporting failover across multiple Availability Zones in the same AWS Region .</li>
         * <li><code>SINGLE_AZ_HA_2</code> - Creates file systems with high availability and throughput capacities of 160 - 10,240 MB/s using an NVMe L2ARC cache by deploying a primary and standby file system within the same Availability Zone.</li>
         * <li><code>SINGLE_AZ_HA_1</code> - Creates file systems with high availability and throughput capacities of 64 - 4,096 MB/s by deploying a primary and standby file system within the same Availability Zone.</li>
         * <li><code>SINGLE_AZ_2</code> - Creates file systems with throughput capacities of 160 - 10,240 MB/s using an NVMe L2ARC cache that automatically recover within a single Availability Zone.</li>
         * <li><code>SINGLE_AZ_1</code> - Creates file systems with throughput capacities of 64 - 4,096 MBs that automatically recover within a single Availability Zone.</li>
         * </ul>
         * <p>
         * For a list of which AWS Regions each deployment type is available in, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions">Deployment type availability</a> . For more information on the differences in performance between deployment types, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File system performance</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-deploymenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-deploymenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeploymentType();

        /**
         * The number of days to retain automatic backups.
         * <p>
         * Setting this property to <code>0</code> disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is <code>30</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-automaticbackupretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-automaticbackupretentiondays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticBackupRetentionDays() {
            return null;
        }

        /**
         * A Boolean value indicating whether tags for the file system should be copied to backups.
         * <p>
         * This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the file system are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-copytagstobackups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-copytagstobackups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToBackups() {
            return null;
        }

        /**
         * A Boolean value indicating whether tags for the file system should be copied to volumes.
         * <p>
         * This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the file system are copied to volumes where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to volumes. If you specify one or more tags when creating the volume, no tags are copied from the file system, regardless of this value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-copytagstovolumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-copytagstovolumes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToVolumes() {
            return null;
        }

        /**
         * A recurring daily time, in the format <code>HH:MM</code> .
         * <p>
         * <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. For example, <code>05:00</code> specifies 5 AM daily.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-dailyautomaticbackupstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-dailyautomaticbackupstarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDailyAutomaticBackupStartTime() {
            return null;
        }

        /**
         * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS file system.
         * <p>
         * By default, Amazon FSx automatically provisions 3 IOPS per GB of storage capacity. You can provision additional IOPS per GB of storage. The configuration consists of the total number of provisioned SSD IOPS and how it is was provisioned, or the mode (by the customer or by Amazon FSx).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-diskiopsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-diskiopsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDiskIopsConfiguration() {
            return null;
        }

        /**
         * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
         * <p>
         * By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /28 IP address range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables, as long as they don't overlap with any subnet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-endpointipaddressrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-endpointipaddressrange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointIpAddressRange() {
            return null;
        }

        /**
         * To delete a file system if there are child volumes present below the root volume, use the string <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code> .
         * <p>
         * If your file system has child volumes and you don't use this option, the delete request will fail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOptions() {
            return null;
        }

        /**
         * Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code> .
         * <p>
         * This specifies the subnet in which you want the preferred file server to be located.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-preferredsubnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-preferredsubnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreferredSubnetId() {
            return null;
        }

        /**
         * Specifies the optional provisioned SSD read cache on file systems that use the Intelligent-Tiering storage class.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-readcacheconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-readcacheconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadCacheConfiguration() {
            return null;
        }

        /**
         * The configuration Amazon FSx uses when creating the root value of the Amazon FSx for OpenZFS file system.
         * <p>
         * All volumes are children of the root volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRootVolumeConfiguration() {
            return null;
        }

        /**
         * (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server.
         * <p>
         * You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-routetableids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-routetableids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRouteTableIds() {
            return null;
        }

        /**
         * Specifies the throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second (MBps).
         * <p>
         * Valid values depend on the <code>DeploymentType</code> that you choose, as follows:
         * <p>
         * <ul>
         * <li>For <code>MULTI_AZ_1</code> and <code>SINGLE_AZ_2</code> , valid values are 160, 320, 640, 1280, 2560, 3840, 5120, 7680, or 10240 MBps.</li>
         * <li>For <code>SINGLE_AZ_1</code> , valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MBps.</li>
         * </ul>
         * <p>
         * You pay for additional throughput capacity that you provision.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-throughputcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-throughputcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughputCapacity() {
            return null;
        }

        /**
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * <p>
         * For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-weeklymaintenancestarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html#cfn-fsx-filesystem-openzfsconfiguration-weeklymaintenancestarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWeeklyMaintenanceStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenZFSConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenZFSConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenZFSConfigurationProperty> {
            java.lang.String deploymentType;
            java.lang.Number automaticBackupRetentionDays;
            java.lang.Object copyTagsToBackups;
            java.lang.Object copyTagsToVolumes;
            java.lang.String dailyAutomaticBackupStartTime;
            java.lang.Object diskIopsConfiguration;
            java.lang.String endpointIpAddressRange;
            java.util.List<java.lang.String> options;
            java.lang.String preferredSubnetId;
            java.lang.Object readCacheConfiguration;
            java.lang.Object rootVolumeConfiguration;
            java.util.List<java.lang.String> routeTableIds;
            java.lang.Number throughputCapacity;
            java.lang.String weeklyMaintenanceStartTime;

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getDeploymentType}
             * @param deploymentType Specifies the file system deployment type. Valid values are the following:. This parameter is required.
             *                       <ul>
             *                       <li><code>MULTI_AZ_1</code> - Creates file systems with high availability and durability by replicating your data and supporting failover across multiple Availability Zones in the same AWS Region .</li>
             *                       <li><code>SINGLE_AZ_HA_2</code> - Creates file systems with high availability and throughput capacities of 160 - 10,240 MB/s using an NVMe L2ARC cache by deploying a primary and standby file system within the same Availability Zone.</li>
             *                       <li><code>SINGLE_AZ_HA_1</code> - Creates file systems with high availability and throughput capacities of 64 - 4,096 MB/s by deploying a primary and standby file system within the same Availability Zone.</li>
             *                       <li><code>SINGLE_AZ_2</code> - Creates file systems with throughput capacities of 160 - 10,240 MB/s using an NVMe L2ARC cache that automatically recover within a single Availability Zone.</li>
             *                       <li><code>SINGLE_AZ_1</code> - Creates file systems with throughput capacities of 64 - 4,096 MBs that automatically recover within a single Availability Zone.</li>
             *                       </ul>
             *                       <p>
             *                       For a list of which AWS Regions each deployment type is available in, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions">Deployment type availability</a> . For more information on the differences in performance between deployment types, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File system performance</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentType(java.lang.String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getAutomaticBackupRetentionDays}
             * @param automaticBackupRetentionDays The number of days to retain automatic backups.
             *                                     Setting this property to <code>0</code> disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is <code>30</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticBackupRetentionDays(java.lang.Number automaticBackupRetentionDays) {
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups A Boolean value indicating whether tags for the file system should be copied to backups.
             *                          This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the file system are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(java.lang.Boolean copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups A Boolean value indicating whether tags for the file system should be copied to backups.
             *                          This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the file system are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(software.amazon.awscdk.IResolvable copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getCopyTagsToVolumes}
             * @param copyTagsToVolumes A Boolean value indicating whether tags for the file system should be copied to volumes.
             *                          This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the file system are copied to volumes where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to volumes. If you specify one or more tags when creating the volume, no tags are copied from the file system, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToVolumes(java.lang.Boolean copyTagsToVolumes) {
                this.copyTagsToVolumes = copyTagsToVolumes;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getCopyTagsToVolumes}
             * @param copyTagsToVolumes A Boolean value indicating whether tags for the file system should be copied to volumes.
             *                          This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the file system are copied to volumes where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to volumes. If you specify one or more tags when creating the volume, no tags are copied from the file system, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToVolumes(software.amazon.awscdk.IResolvable copyTagsToVolumes) {
                this.copyTagsToVolumes = copyTagsToVolumes;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getDailyAutomaticBackupStartTime}
             * @param dailyAutomaticBackupStartTime A recurring daily time, in the format <code>HH:MM</code> .
             *                                      <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. For example, <code>05:00</code> specifies 5 AM daily.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyAutomaticBackupStartTime(java.lang.String dailyAutomaticBackupStartTime) {
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getDiskIopsConfiguration}
             * @param diskIopsConfiguration The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS file system.
             *                              By default, Amazon FSx automatically provisions 3 IOPS per GB of storage capacity. You can provision additional IOPS per GB of storage. The configuration consists of the total number of provisioned SSD IOPS and how it is was provisioned, or the mode (by the customer or by Amazon FSx).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder diskIopsConfiguration(software.amazon.awscdk.IResolvable diskIopsConfiguration) {
                this.diskIopsConfiguration = diskIopsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getDiskIopsConfiguration}
             * @param diskIopsConfiguration The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS file system.
             *                              By default, Amazon FSx automatically provisions 3 IOPS per GB of storage capacity. You can provision additional IOPS per GB of storage. The configuration consists of the total number of provisioned SSD IOPS and how it is was provisioned, or the mode (by the customer or by Amazon FSx).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder diskIopsConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.DiskIopsConfigurationProperty diskIopsConfiguration) {
                this.diskIopsConfiguration = diskIopsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getEndpointIpAddressRange}
             * @param endpointIpAddressRange (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
             *                               By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /28 IP address range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables, as long as they don't overlap with any subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointIpAddressRange(java.lang.String endpointIpAddressRange) {
                this.endpointIpAddressRange = endpointIpAddressRange;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getOptions}
             * @param options To delete a file system if there are child volumes present below the root volume, use the string <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code> .
             *                If your file system has child volumes and you don't use this option, the delete request will fail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<java.lang.String> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getPreferredSubnetId}
             * @param preferredSubnetId Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code> .
             *                          This specifies the subnet in which you want the preferred file server to be located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredSubnetId(java.lang.String preferredSubnetId) {
                this.preferredSubnetId = preferredSubnetId;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getReadCacheConfiguration}
             * @param readCacheConfiguration Specifies the optional provisioned SSD read cache on file systems that use the Intelligent-Tiering storage class.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCacheConfiguration(software.amazon.awscdk.IResolvable readCacheConfiguration) {
                this.readCacheConfiguration = readCacheConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getReadCacheConfiguration}
             * @param readCacheConfiguration Specifies the optional provisioned SSD read cache on file systems that use the Intelligent-Tiering storage class.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCacheConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.ReadCacheConfigurationProperty readCacheConfiguration) {
                this.readCacheConfiguration = readCacheConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getRootVolumeConfiguration}
             * @param rootVolumeConfiguration The configuration Amazon FSx uses when creating the root value of the Amazon FSx for OpenZFS file system.
             *                                All volumes are children of the root volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootVolumeConfiguration(software.amazon.awscdk.IResolvable rootVolumeConfiguration) {
                this.rootVolumeConfiguration = rootVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getRootVolumeConfiguration}
             * @param rootVolumeConfiguration The configuration Amazon FSx uses when creating the root value of the Amazon FSx for OpenZFS file system.
             *                                All volumes are children of the root volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootVolumeConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.RootVolumeConfigurationProperty rootVolumeConfiguration) {
                this.rootVolumeConfiguration = rootVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getRouteTableIds}
             * @param routeTableIds (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server.
             *                      You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeTableIds(java.util.List<java.lang.String> routeTableIds) {
                this.routeTableIds = routeTableIds;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getThroughputCapacity}
             * @param throughputCapacity Specifies the throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second (MBps).
             *                           Valid values depend on the <code>DeploymentType</code> that you choose, as follows:
             *                           <p>
             *                           <ul>
             *                           <li>For <code>MULTI_AZ_1</code> and <code>SINGLE_AZ_2</code> , valid values are 160, 320, 640, 1280, 2560, 3840, 5120, 7680, or 10240 MBps.</li>
             *                           <li>For <code>SINGLE_AZ_1</code> , valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MBps.</li>
             *                           </ul>
             *                           <p>
             *                           You pay for additional throughput capacity that you provision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughputCapacity(java.lang.Number throughputCapacity) {
                this.throughputCapacity = throughputCapacity;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getWeeklyMaintenanceStartTime}
             * @param weeklyMaintenanceStartTime The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
             *                                   For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeklyMaintenanceStartTime(java.lang.String weeklyMaintenanceStartTime) {
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenZFSConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenZFSConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenZFSConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenZFSConfigurationProperty {
            private final java.lang.String deploymentType;
            private final java.lang.Number automaticBackupRetentionDays;
            private final java.lang.Object copyTagsToBackups;
            private final java.lang.Object copyTagsToVolumes;
            private final java.lang.String dailyAutomaticBackupStartTime;
            private final java.lang.Object diskIopsConfiguration;
            private final java.lang.String endpointIpAddressRange;
            private final java.util.List<java.lang.String> options;
            private final java.lang.String preferredSubnetId;
            private final java.lang.Object readCacheConfiguration;
            private final java.lang.Object rootVolumeConfiguration;
            private final java.util.List<java.lang.String> routeTableIds;
            private final java.lang.Number throughputCapacity;
            private final java.lang.String weeklyMaintenanceStartTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deploymentType = software.amazon.jsii.Kernel.get(this, "deploymentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.automaticBackupRetentionDays = software.amazon.jsii.Kernel.get(this, "automaticBackupRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.copyTagsToBackups = software.amazon.jsii.Kernel.get(this, "copyTagsToBackups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.copyTagsToVolumes = software.amazon.jsii.Kernel.get(this, "copyTagsToVolumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dailyAutomaticBackupStartTime = software.amazon.jsii.Kernel.get(this, "dailyAutomaticBackupStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.diskIopsConfiguration = software.amazon.jsii.Kernel.get(this, "diskIopsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.endpointIpAddressRange = software.amazon.jsii.Kernel.get(this, "endpointIpAddressRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.preferredSubnetId = software.amazon.jsii.Kernel.get(this, "preferredSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readCacheConfiguration = software.amazon.jsii.Kernel.get(this, "readCacheConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rootVolumeConfiguration = software.amazon.jsii.Kernel.get(this, "rootVolumeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.routeTableIds = software.amazon.jsii.Kernel.get(this, "routeTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.throughputCapacity = software.amazon.jsii.Kernel.get(this, "throughputCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weeklyMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deploymentType = java.util.Objects.requireNonNull(builder.deploymentType, "deploymentType is required");
                this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
                this.copyTagsToBackups = builder.copyTagsToBackups;
                this.copyTagsToVolumes = builder.copyTagsToVolumes;
                this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
                this.diskIopsConfiguration = builder.diskIopsConfiguration;
                this.endpointIpAddressRange = builder.endpointIpAddressRange;
                this.options = builder.options;
                this.preferredSubnetId = builder.preferredSubnetId;
                this.readCacheConfiguration = builder.readCacheConfiguration;
                this.rootVolumeConfiguration = builder.rootVolumeConfiguration;
                this.routeTableIds = builder.routeTableIds;
                this.throughputCapacity = builder.throughputCapacity;
                this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
            }

            @Override
            public final java.lang.String getDeploymentType() {
                return this.deploymentType;
            }

            @Override
            public final java.lang.Number getAutomaticBackupRetentionDays() {
                return this.automaticBackupRetentionDays;
            }

            @Override
            public final java.lang.Object getCopyTagsToBackups() {
                return this.copyTagsToBackups;
            }

            @Override
            public final java.lang.Object getCopyTagsToVolumes() {
                return this.copyTagsToVolumes;
            }

            @Override
            public final java.lang.String getDailyAutomaticBackupStartTime() {
                return this.dailyAutomaticBackupStartTime;
            }

            @Override
            public final java.lang.Object getDiskIopsConfiguration() {
                return this.diskIopsConfiguration;
            }

            @Override
            public final java.lang.String getEndpointIpAddressRange() {
                return this.endpointIpAddressRange;
            }

            @Override
            public final java.util.List<java.lang.String> getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.String getPreferredSubnetId() {
                return this.preferredSubnetId;
            }

            @Override
            public final java.lang.Object getReadCacheConfiguration() {
                return this.readCacheConfiguration;
            }

            @Override
            public final java.lang.Object getRootVolumeConfiguration() {
                return this.rootVolumeConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getRouteTableIds() {
                return this.routeTableIds;
            }

            @Override
            public final java.lang.Number getThroughputCapacity() {
                return this.throughputCapacity;
            }

            @Override
            public final java.lang.String getWeeklyMaintenanceStartTime() {
                return this.weeklyMaintenanceStartTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deploymentType", om.valueToTree(this.getDeploymentType()));
                if (this.getAutomaticBackupRetentionDays() != null) {
                    data.set("automaticBackupRetentionDays", om.valueToTree(this.getAutomaticBackupRetentionDays()));
                }
                if (this.getCopyTagsToBackups() != null) {
                    data.set("copyTagsToBackups", om.valueToTree(this.getCopyTagsToBackups()));
                }
                if (this.getCopyTagsToVolumes() != null) {
                    data.set("copyTagsToVolumes", om.valueToTree(this.getCopyTagsToVolumes()));
                }
                if (this.getDailyAutomaticBackupStartTime() != null) {
                    data.set("dailyAutomaticBackupStartTime", om.valueToTree(this.getDailyAutomaticBackupStartTime()));
                }
                if (this.getDiskIopsConfiguration() != null) {
                    data.set("diskIopsConfiguration", om.valueToTree(this.getDiskIopsConfiguration()));
                }
                if (this.getEndpointIpAddressRange() != null) {
                    data.set("endpointIpAddressRange", om.valueToTree(this.getEndpointIpAddressRange()));
                }
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }
                if (this.getPreferredSubnetId() != null) {
                    data.set("preferredSubnetId", om.valueToTree(this.getPreferredSubnetId()));
                }
                if (this.getReadCacheConfiguration() != null) {
                    data.set("readCacheConfiguration", om.valueToTree(this.getReadCacheConfiguration()));
                }
                if (this.getRootVolumeConfiguration() != null) {
                    data.set("rootVolumeConfiguration", om.valueToTree(this.getRootVolumeConfiguration()));
                }
                if (this.getRouteTableIds() != null) {
                    data.set("routeTableIds", om.valueToTree(this.getRouteTableIds()));
                }
                if (this.getThroughputCapacity() != null) {
                    data.set("throughputCapacity", om.valueToTree(this.getThroughputCapacity()));
                }
                if (this.getWeeklyMaintenanceStartTime() != null) {
                    data.set("weeklyMaintenanceStartTime", om.valueToTree(this.getWeeklyMaintenanceStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.OpenZFSConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenZFSConfigurationProperty.Jsii$Proxy that = (OpenZFSConfigurationProperty.Jsii$Proxy) o;

                if (!deploymentType.equals(that.deploymentType)) return false;
                if (this.automaticBackupRetentionDays != null ? !this.automaticBackupRetentionDays.equals(that.automaticBackupRetentionDays) : that.automaticBackupRetentionDays != null) return false;
                if (this.copyTagsToBackups != null ? !this.copyTagsToBackups.equals(that.copyTagsToBackups) : that.copyTagsToBackups != null) return false;
                if (this.copyTagsToVolumes != null ? !this.copyTagsToVolumes.equals(that.copyTagsToVolumes) : that.copyTagsToVolumes != null) return false;
                if (this.dailyAutomaticBackupStartTime != null ? !this.dailyAutomaticBackupStartTime.equals(that.dailyAutomaticBackupStartTime) : that.dailyAutomaticBackupStartTime != null) return false;
                if (this.diskIopsConfiguration != null ? !this.diskIopsConfiguration.equals(that.diskIopsConfiguration) : that.diskIopsConfiguration != null) return false;
                if (this.endpointIpAddressRange != null ? !this.endpointIpAddressRange.equals(that.endpointIpAddressRange) : that.endpointIpAddressRange != null) return false;
                if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
                if (this.preferredSubnetId != null ? !this.preferredSubnetId.equals(that.preferredSubnetId) : that.preferredSubnetId != null) return false;
                if (this.readCacheConfiguration != null ? !this.readCacheConfiguration.equals(that.readCacheConfiguration) : that.readCacheConfiguration != null) return false;
                if (this.rootVolumeConfiguration != null ? !this.rootVolumeConfiguration.equals(that.rootVolumeConfiguration) : that.rootVolumeConfiguration != null) return false;
                if (this.routeTableIds != null ? !this.routeTableIds.equals(that.routeTableIds) : that.routeTableIds != null) return false;
                if (this.throughputCapacity != null ? !this.throughputCapacity.equals(that.throughputCapacity) : that.throughputCapacity != null) return false;
                return this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.equals(that.weeklyMaintenanceStartTime) : that.weeklyMaintenanceStartTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deploymentType.hashCode();
                result = 31 * result + (this.automaticBackupRetentionDays != null ? this.automaticBackupRetentionDays.hashCode() : 0);
                result = 31 * result + (this.copyTagsToBackups != null ? this.copyTagsToBackups.hashCode() : 0);
                result = 31 * result + (this.copyTagsToVolumes != null ? this.copyTagsToVolumes.hashCode() : 0);
                result = 31 * result + (this.dailyAutomaticBackupStartTime != null ? this.dailyAutomaticBackupStartTime.hashCode() : 0);
                result = 31 * result + (this.diskIopsConfiguration != null ? this.diskIopsConfiguration.hashCode() : 0);
                result = 31 * result + (this.endpointIpAddressRange != null ? this.endpointIpAddressRange.hashCode() : 0);
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                result = 31 * result + (this.preferredSubnetId != null ? this.preferredSubnetId.hashCode() : 0);
                result = 31 * result + (this.readCacheConfiguration != null ? this.readCacheConfiguration.hashCode() : 0);
                result = 31 * result + (this.rootVolumeConfiguration != null ? this.rootVolumeConfiguration.hashCode() : 0);
                result = 31 * result + (this.routeTableIds != null ? this.routeTableIds.hashCode() : 0);
                result = 31 * result + (this.throughputCapacity != null ? this.throughputCapacity.hashCode() : 0);
                result = 31 * result + (this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the optional provisioned SSD read cache on Amazon FSx for OpenZFS file systems that use the Intelligent-Tiering storage class.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * ReadCacheConfigurationProperty readCacheConfigurationProperty = ReadCacheConfigurationProperty.builder()
     *         .sizeGiB(123)
     *         .sizingMode("sizingMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-readcacheconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-readcacheconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.ReadCacheConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReadCacheConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReadCacheConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Required if <code>SizingMode</code> is set to <code>USER_PROVISIONED</code> .
         * <p>
         * Specifies the size of the file system's SSD read cache, in gibibytes (GiB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-readcacheconfiguration.html#cfn-fsx-filesystem-readcacheconfiguration-sizegib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-readcacheconfiguration.html#cfn-fsx-filesystem-readcacheconfiguration-sizegib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeGiB() {
            return null;
        }

        /**
         * Specifies how the provisioned SSD read cache is sized, as follows:.
         * <p>
         * <ul>
         * <li>Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering file system.</li>
         * <li>Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.</li>
         * <li>Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically sized based on your throughput capacity.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-readcacheconfiguration.html#cfn-fsx-filesystem-readcacheconfiguration-sizingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-readcacheconfiguration.html#cfn-fsx-filesystem-readcacheconfiguration-sizingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSizingMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReadCacheConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReadCacheConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReadCacheConfigurationProperty> {
            java.lang.Number sizeGiB;
            java.lang.String sizingMode;

            /**
             * Sets the value of {@link ReadCacheConfigurationProperty#getSizeGiB}
             * @param sizeGiB Required if <code>SizingMode</code> is set to <code>USER_PROVISIONED</code> .
             *                Specifies the size of the file system's SSD read cache, in gibibytes (GiB).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeGiB(java.lang.Number sizeGiB) {
                this.sizeGiB = sizeGiB;
                return this;
            }

            /**
             * Sets the value of {@link ReadCacheConfigurationProperty#getSizingMode}
             * @param sizingMode Specifies how the provisioned SSD read cache is sized, as follows:.
             *                   <ul>
             *                   <li>Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering file system.</li>
             *                   <li>Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.</li>
             *                   <li>Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically sized based on your throughput capacity.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizingMode(java.lang.String sizingMode) {
                this.sizingMode = sizingMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReadCacheConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReadCacheConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReadCacheConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReadCacheConfigurationProperty {
            private final java.lang.Number sizeGiB;
            private final java.lang.String sizingMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sizeGiB = software.amazon.jsii.Kernel.get(this, "sizeGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizingMode = software.amazon.jsii.Kernel.get(this, "sizingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sizeGiB = builder.sizeGiB;
                this.sizingMode = builder.sizingMode;
            }

            @Override
            public final java.lang.Number getSizeGiB() {
                return this.sizeGiB;
            }

            @Override
            public final java.lang.String getSizingMode() {
                return this.sizingMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSizeGiB() != null) {
                    data.set("sizeGiB", om.valueToTree(this.getSizeGiB()));
                }
                if (this.getSizingMode() != null) {
                    data.set("sizingMode", om.valueToTree(this.getSizingMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.ReadCacheConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReadCacheConfigurationProperty.Jsii$Proxy that = (ReadCacheConfigurationProperty.Jsii$Proxy) o;

                if (this.sizeGiB != null ? !this.sizeGiB.equals(that.sizeGiB) : that.sizeGiB != null) return false;
                return this.sizingMode != null ? this.sizingMode.equals(that.sizingMode) : that.sizingMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sizeGiB != null ? this.sizeGiB.hashCode() : 0;
                result = 31 * result + (this.sizingMode != null ? this.sizingMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of an Amazon FSx for OpenZFS root volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * RootVolumeConfigurationProperty rootVolumeConfigurationProperty = RootVolumeConfigurationProperty.builder()
     *         .copyTagsToSnapshots(false)
     *         .dataCompressionType("dataCompressionType")
     *         .nfsExports(List.of(NfsExportsProperty.builder()
     *                 .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
     *                         .clients("clients")
     *                         .options(List.of("options"))
     *                         .build()))
     *                 .build()))
     *         .readOnly(false)
     *         .recordSizeKiB(123)
     *         .userAndGroupQuotas(List.of(UserAndGroupQuotasProperty.builder()
     *                 .id(123)
     *                 .storageCapacityQuotaGiB(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.RootVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RootVolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RootVolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean value indicating whether tags for the volume should be copied to snapshots of the volume.
         * <p>
         * This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is <code>true</code> and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-copytagstosnapshots">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-copytagstosnapshots</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshots() {
            return null;
        }

        /**
         * Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by default.
         * <p>
         * <ul>
         * <li><code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.</li>
         * <li><code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.</li>
         * <li><code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-datacompressiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-datacompressiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataCompressionType() {
            return null;
        }

        /**
         * The configuration object for mounting a file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-nfsexports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-nfsexports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNfsExports() {
            return null;
        }

        /**
         * A Boolean value indicating whether the volume is read-only.
         * <p>
         * Setting this value to <code>true</code> can be useful after you have completed changes to a volume and no longer want changes to occur.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-readonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-readonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * Specifies the record size of an OpenZFS root volume, in kibibytes (KiB).
         * <p>
         * Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database workflows can benefit from a smaller record size, while streaming workflows can benefit from a larger record size. For additional guidance on setting a custom record size, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs">Tips for maximizing performance</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-recordsizekib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-recordsizekib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRecordSizeKiB() {
            return null;
        }

        /**
         * An object specifying how much storage users or groups can use on the volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-userandgroupquotas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-rootvolumeconfiguration.html#cfn-fsx-filesystem-rootvolumeconfiguration-userandgroupquotas</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserAndGroupQuotas() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RootVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RootVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RootVolumeConfigurationProperty> {
            java.lang.Object copyTagsToSnapshots;
            java.lang.String dataCompressionType;
            java.lang.Object nfsExports;
            java.lang.Object readOnly;
            java.lang.Number recordSizeKiB;
            java.lang.Object userAndGroupQuotas;

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getCopyTagsToSnapshots}
             * @param copyTagsToSnapshots A Boolean value indicating whether tags for the volume should be copied to snapshots of the volume.
             *                            This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is <code>true</code> and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToSnapshots(java.lang.Boolean copyTagsToSnapshots) {
                this.copyTagsToSnapshots = copyTagsToSnapshots;
                return this;
            }

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getCopyTagsToSnapshots}
             * @param copyTagsToSnapshots A Boolean value indicating whether tags for the volume should be copied to snapshots of the volume.
             *                            This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is <code>true</code> and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToSnapshots(software.amazon.awscdk.IResolvable copyTagsToSnapshots) {
                this.copyTagsToSnapshots = copyTagsToSnapshots;
                return this;
            }

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getDataCompressionType}
             * @param dataCompressionType Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by default.
             *                            <ul>
             *                            <li><code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.</li>
             *                            <li><code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.</li>
             *                            <li><code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCompressionType(java.lang.String dataCompressionType) {
                this.dataCompressionType = dataCompressionType;
                return this;
            }

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getNfsExports}
             * @param nfsExports The configuration object for mounting a file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nfsExports(software.amazon.awscdk.IResolvable nfsExports) {
                this.nfsExports = nfsExports;
                return this;
            }

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getNfsExports}
             * @param nfsExports The configuration object for mounting a file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nfsExports(java.util.List<? extends java.lang.Object> nfsExports) {
                this.nfsExports = nfsExports;
                return this;
            }

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getReadOnly}
             * @param readOnly A Boolean value indicating whether the volume is read-only.
             *                 Setting this value to <code>true</code> can be useful after you have completed changes to a volume and no longer want changes to occur.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getReadOnly}
             * @param readOnly A Boolean value indicating whether the volume is read-only.
             *                 Setting this value to <code>true</code> can be useful after you have completed changes to a volume and no longer want changes to occur.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getRecordSizeKiB}
             * @param recordSizeKiB Specifies the record size of an OpenZFS root volume, in kibibytes (KiB).
             *                      Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database workflows can benefit from a smaller record size, while streaming workflows can benefit from a larger record size. For additional guidance on setting a custom record size, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs">Tips for maximizing performance</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordSizeKiB(java.lang.Number recordSizeKiB) {
                this.recordSizeKiB = recordSizeKiB;
                return this;
            }

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getUserAndGroupQuotas}
             * @param userAndGroupQuotas An object specifying how much storage users or groups can use on the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userAndGroupQuotas(software.amazon.awscdk.IResolvable userAndGroupQuotas) {
                this.userAndGroupQuotas = userAndGroupQuotas;
                return this;
            }

            /**
             * Sets the value of {@link RootVolumeConfigurationProperty#getUserAndGroupQuotas}
             * @param userAndGroupQuotas An object specifying how much storage users or groups can use on the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userAndGroupQuotas(java.util.List<? extends java.lang.Object> userAndGroupQuotas) {
                this.userAndGroupQuotas = userAndGroupQuotas;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RootVolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RootVolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RootVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RootVolumeConfigurationProperty {
            private final java.lang.Object copyTagsToSnapshots;
            private final java.lang.String dataCompressionType;
            private final java.lang.Object nfsExports;
            private final java.lang.Object readOnly;
            private final java.lang.Number recordSizeKiB;
            private final java.lang.Object userAndGroupQuotas;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyTagsToSnapshots = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshots", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataCompressionType = software.amazon.jsii.Kernel.get(this, "dataCompressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nfsExports = software.amazon.jsii.Kernel.get(this, "nfsExports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordSizeKiB = software.amazon.jsii.Kernel.get(this, "recordSizeKiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.userAndGroupQuotas = software.amazon.jsii.Kernel.get(this, "userAndGroupQuotas", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyTagsToSnapshots = builder.copyTagsToSnapshots;
                this.dataCompressionType = builder.dataCompressionType;
                this.nfsExports = builder.nfsExports;
                this.readOnly = builder.readOnly;
                this.recordSizeKiB = builder.recordSizeKiB;
                this.userAndGroupQuotas = builder.userAndGroupQuotas;
            }

            @Override
            public final java.lang.Object getCopyTagsToSnapshots() {
                return this.copyTagsToSnapshots;
            }

            @Override
            public final java.lang.String getDataCompressionType() {
                return this.dataCompressionType;
            }

            @Override
            public final java.lang.Object getNfsExports() {
                return this.nfsExports;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.Number getRecordSizeKiB() {
                return this.recordSizeKiB;
            }

            @Override
            public final java.lang.Object getUserAndGroupQuotas() {
                return this.userAndGroupQuotas;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCopyTagsToSnapshots() != null) {
                    data.set("copyTagsToSnapshots", om.valueToTree(this.getCopyTagsToSnapshots()));
                }
                if (this.getDataCompressionType() != null) {
                    data.set("dataCompressionType", om.valueToTree(this.getDataCompressionType()));
                }
                if (this.getNfsExports() != null) {
                    data.set("nfsExports", om.valueToTree(this.getNfsExports()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getRecordSizeKiB() != null) {
                    data.set("recordSizeKiB", om.valueToTree(this.getRecordSizeKiB()));
                }
                if (this.getUserAndGroupQuotas() != null) {
                    data.set("userAndGroupQuotas", om.valueToTree(this.getUserAndGroupQuotas()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.RootVolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RootVolumeConfigurationProperty.Jsii$Proxy that = (RootVolumeConfigurationProperty.Jsii$Proxy) o;

                if (this.copyTagsToSnapshots != null ? !this.copyTagsToSnapshots.equals(that.copyTagsToSnapshots) : that.copyTagsToSnapshots != null) return false;
                if (this.dataCompressionType != null ? !this.dataCompressionType.equals(that.dataCompressionType) : that.dataCompressionType != null) return false;
                if (this.nfsExports != null ? !this.nfsExports.equals(that.nfsExports) : that.nfsExports != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                if (this.recordSizeKiB != null ? !this.recordSizeKiB.equals(that.recordSizeKiB) : that.recordSizeKiB != null) return false;
                return this.userAndGroupQuotas != null ? this.userAndGroupQuotas.equals(that.userAndGroupQuotas) : that.userAndGroupQuotas == null;
            }

            @Override
            public final int hashCode() {
                int result = this.copyTagsToSnapshots != null ? this.copyTagsToSnapshots.hashCode() : 0;
                result = 31 * result + (this.dataCompressionType != null ? this.dataCompressionType.hashCode() : 0);
                result = 31 * result + (this.nfsExports != null ? this.nfsExports.hashCode() : 0);
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.recordSizeKiB != null ? this.recordSizeKiB.hashCode() : 0);
                result = 31 * result + (this.userAndGroupQuotas != null ? this.userAndGroupQuotas.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an FSx for ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">Using Amazon FSx for Windows with your self-managed Microsoft Active Directory</a> or <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP SVMs</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * SelfManagedActiveDirectoryConfigurationProperty selfManagedActiveDirectoryConfigurationProperty = SelfManagedActiveDirectoryConfigurationProperty.builder()
     *         .dnsIps(List.of("dnsIps"))
     *         .domainName("domainName")
     *         .fileSystemAdministratorsGroup("fileSystemAdministratorsGroup")
     *         .organizationalUnitDistinguishedName("organizationalUnitDistinguishedName")
     *         .password("password")
     *         .userName("userName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SelfManagedActiveDirectoryConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SelfManagedActiveDirectoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-dnsips">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-dnsips</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsIps() {
            return null;
        }

        /**
         * The fully qualified domain name of the self-managed AD directory, such as <code>corp.example.com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-domainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
            return null;
        }

        /**
         * (Optional) The name of the domain group whose members are granted administrative privileges for the file system.
         * <p>
         * Administrative privileges include taking ownership of files and folders, setting audit controls (audit ACLs) on files and folders, and administering the file system remotely by using the FSx Remote PowerShell. The group that you specify must already exist in your domain. If you don't provide one, your AD domain's Domain Admins group is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-filesystemadministratorsgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-filesystemadministratorsgroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemAdministratorsGroup() {
            return null;
        }

        /**
         * (Optional) The fully qualified distinguished name of the organizational unit within your self-managed AD directory.
         * <p>
         * Amazon FSx only accepts OU as the direct parent of the file system. An example is <code>OU=FSx,DC=yourdomain,DC=corp,DC=com</code> . To learn more, see <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc2253">RFC 2253</a> . If none is provided, the FSx file system is created in the default location of your self-managed AD directory.
         * <p>
         * <blockquote>
         * <p>
         * Only Organizational Unit (OU) objects can be the direct parent of the file system that you're creating.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-organizationalunitdistinguishedname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-organizationalunitdistinguishedname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationalUnitDistinguishedName() {
            return null;
        }

        /**
         * The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
         * <p>
         * This account must have the permission to join computers to the domain in the organizational unit provided in <code>OrganizationalUnitDistinguishedName</code> , or in the default location of your AD domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-selfmanagedactivedirectoryconfiguration-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SelfManagedActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SelfManagedActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SelfManagedActiveDirectoryConfigurationProperty> {
            java.util.List<java.lang.String> dnsIps;
            java.lang.String domainName;
            java.lang.String fileSystemAdministratorsGroup;
            java.lang.String organizationalUnitDistinguishedName;
            java.lang.String password;
            java.lang.String userName;

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getDnsIps}
             * @param dnsIps A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsIps(java.util.List<java.lang.String> dnsIps) {
                this.dnsIps = dnsIps;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getDomainName}
             * @param domainName The fully qualified domain name of the self-managed AD directory, such as <code>corp.example.com</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getFileSystemAdministratorsGroup}
             * @param fileSystemAdministratorsGroup (Optional) The name of the domain group whose members are granted administrative privileges for the file system.
             *                                      Administrative privileges include taking ownership of files and folders, setting audit controls (audit ACLs) on files and folders, and administering the file system remotely by using the FSx Remote PowerShell. The group that you specify must already exist in your domain. If you don't provide one, your AD domain's Domain Admins group is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemAdministratorsGroup(java.lang.String fileSystemAdministratorsGroup) {
                this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getOrganizationalUnitDistinguishedName}
             * @param organizationalUnitDistinguishedName (Optional) The fully qualified distinguished name of the organizational unit within your self-managed AD directory.
             *                                            Amazon FSx only accepts OU as the direct parent of the file system. An example is <code>OU=FSx,DC=yourdomain,DC=corp,DC=com</code> . To learn more, see <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc2253">RFC 2253</a> . If none is provided, the FSx file system is created in the default location of your self-managed AD directory.
             *                                            <p>
             *                                            <blockquote>
             *                                            <p>
             *                                            Only Organizational Unit (OU) objects can be the direct parent of the file system that you're creating.
             *                                            <p>
             *                                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationalUnitDistinguishedName(java.lang.String organizationalUnitDistinguishedName) {
                this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getPassword}
             * @param password The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getUserName}
             * @param userName The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
             *                 This account must have the permission to join computers to the domain in the organizational unit provided in <code>OrganizationalUnitDistinguishedName</code> , or in the default location of your AD domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userName(java.lang.String userName) {
                this.userName = userName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SelfManagedActiveDirectoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SelfManagedActiveDirectoryConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SelfManagedActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelfManagedActiveDirectoryConfigurationProperty {
            private final java.util.List<java.lang.String> dnsIps;
            private final java.lang.String domainName;
            private final java.lang.String fileSystemAdministratorsGroup;
            private final java.lang.String organizationalUnitDistinguishedName;
            private final java.lang.String password;
            private final java.lang.String userName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsIps = software.amazon.jsii.Kernel.get(this, "dnsIps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileSystemAdministratorsGroup = software.amazon.jsii.Kernel.get(this, "fileSystemAdministratorsGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationalUnitDistinguishedName = software.amazon.jsii.Kernel.get(this, "organizationalUnitDistinguishedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userName = software.amazon.jsii.Kernel.get(this, "userName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsIps = builder.dnsIps;
                this.domainName = builder.domainName;
                this.fileSystemAdministratorsGroup = builder.fileSystemAdministratorsGroup;
                this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
                this.password = builder.password;
                this.userName = builder.userName;
            }

            @Override
            public final java.util.List<java.lang.String> getDnsIps() {
                return this.dnsIps;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getFileSystemAdministratorsGroup() {
                return this.fileSystemAdministratorsGroup;
            }

            @Override
            public final java.lang.String getOrganizationalUnitDistinguishedName() {
                return this.organizationalUnitDistinguishedName;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUserName() {
                return this.userName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDnsIps() != null) {
                    data.set("dnsIps", om.valueToTree(this.getDnsIps()));
                }
                if (this.getDomainName() != null) {
                    data.set("domainName", om.valueToTree(this.getDomainName()));
                }
                if (this.getFileSystemAdministratorsGroup() != null) {
                    data.set("fileSystemAdministratorsGroup", om.valueToTree(this.getFileSystemAdministratorsGroup()));
                }
                if (this.getOrganizationalUnitDistinguishedName() != null) {
                    data.set("organizationalUnitDistinguishedName", om.valueToTree(this.getOrganizationalUnitDistinguishedName()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getUserName() != null) {
                    data.set("userName", om.valueToTree(this.getUserName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SelfManagedActiveDirectoryConfigurationProperty.Jsii$Proxy that = (SelfManagedActiveDirectoryConfigurationProperty.Jsii$Proxy) o;

                if (this.dnsIps != null ? !this.dnsIps.equals(that.dnsIps) : that.dnsIps != null) return false;
                if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
                if (this.fileSystemAdministratorsGroup != null ? !this.fileSystemAdministratorsGroup.equals(that.fileSystemAdministratorsGroup) : that.fileSystemAdministratorsGroup != null) return false;
                if (this.organizationalUnitDistinguishedName != null ? !this.organizationalUnitDistinguishedName.equals(that.organizationalUnitDistinguishedName) : that.organizationalUnitDistinguishedName != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                return this.userName != null ? this.userName.equals(that.userName) : that.userName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dnsIps != null ? this.dnsIps.hashCode() : 0;
                result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
                result = 31 * result + (this.fileSystemAdministratorsGroup != null ? this.fileSystemAdministratorsGroup.hashCode() : 0);
                result = 31 * result + (this.organizationalUnitDistinguishedName != null ? this.organizationalUnitDistinguishedName.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Used to configure quotas that define how much storage a user or group can use on an FSx for OpenZFS volume.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the FSx for OpenZFS User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * UserAndGroupQuotasProperty userAndGroupQuotasProperty = UserAndGroupQuotasProperty.builder()
     *         .id(123)
     *         .storageCapacityQuotaGiB(123)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-userandgroupquotas.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-userandgroupquotas.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.UserAndGroupQuotasProperty")
    @software.amazon.jsii.Jsii.Proxy(UserAndGroupQuotasProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserAndGroupQuotasProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the user or group that the quota applies to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-userandgroupquotas.html#cfn-fsx-filesystem-userandgroupquotas-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-userandgroupquotas.html#cfn-fsx-filesystem-userandgroupquotas-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getId() {
            return null;
        }

        /**
         * The user or group's storage quota, in gibibytes (GiB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-userandgroupquotas.html#cfn-fsx-filesystem-userandgroupquotas-storagecapacityquotagib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-userandgroupquotas.html#cfn-fsx-filesystem-userandgroupquotas-storagecapacityquotagib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacityQuotaGiB() {
            return null;
        }

        /**
         * Specifies whether the quota applies to a user or group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-userandgroupquotas.html#cfn-fsx-filesystem-userandgroupquotas-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-userandgroupquotas.html#cfn-fsx-filesystem-userandgroupquotas-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserAndGroupQuotasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserAndGroupQuotasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserAndGroupQuotasProperty> {
            java.lang.Number id;
            java.lang.Number storageCapacityQuotaGiB;
            java.lang.String type;

            /**
             * Sets the value of {@link UserAndGroupQuotasProperty#getId}
             * @param id The ID of the user or group that the quota applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.Number id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link UserAndGroupQuotasProperty#getStorageCapacityQuotaGiB}
             * @param storageCapacityQuotaGiB The user or group's storage quota, in gibibytes (GiB).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageCapacityQuotaGiB(java.lang.Number storageCapacityQuotaGiB) {
                this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
                return this;
            }

            /**
             * Sets the value of {@link UserAndGroupQuotasProperty#getType}
             * @param type Specifies whether the quota applies to a user or group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserAndGroupQuotasProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserAndGroupQuotasProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserAndGroupQuotasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserAndGroupQuotasProperty {
            private final java.lang.Number id;
            private final java.lang.Number storageCapacityQuotaGiB;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storageCapacityQuotaGiB = software.amazon.jsii.Kernel.get(this, "storageCapacityQuotaGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = builder.id;
                this.storageCapacityQuotaGiB = builder.storageCapacityQuotaGiB;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Number getId() {
                return this.id;
            }

            @Override
            public final java.lang.Number getStorageCapacityQuotaGiB() {
                return this.storageCapacityQuotaGiB;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getStorageCapacityQuotaGiB() != null) {
                    data.set("storageCapacityQuotaGiB", om.valueToTree(this.getStorageCapacityQuotaGiB()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.UserAndGroupQuotasProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserAndGroupQuotasProperty.Jsii$Proxy that = (UserAndGroupQuotasProperty.Jsii$Proxy) o;

                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.storageCapacityQuotaGiB != null ? !this.storageCapacityQuotaGiB.equals(that.storageCapacityQuotaGiB) : that.storageCapacityQuotaGiB != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id != null ? this.id.hashCode() : 0;
                result = 31 * result + (this.storageCapacityQuotaGiB != null ? this.storageCapacityQuotaGiB.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Microsoft Windows configuration for the file system that's being created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * WindowsConfigurationProperty windowsConfigurationProperty = WindowsConfigurationProperty.builder()
     *         .throughputCapacity(123)
     *         // the properties below are optional
     *         .activeDirectoryId("activeDirectoryId")
     *         .aliases(List.of("aliases"))
     *         .auditLogConfiguration(AuditLogConfigurationProperty.builder()
     *                 .fileAccessAuditLogLevel("fileAccessAuditLogLevel")
     *                 .fileShareAccessAuditLogLevel("fileShareAccessAuditLogLevel")
     *                 // the properties below are optional
     *                 .auditLogDestination("auditLogDestination")
     *                 .build())
     *         .automaticBackupRetentionDays(123)
     *         .copyTagsToBackups(false)
     *         .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
     *         .deploymentType("deploymentType")
     *         .diskIopsConfiguration(DiskIopsConfigurationProperty.builder()
     *                 .iops(123)
     *                 .mode("mode")
     *                 .build())
     *         .preferredSubnetId("preferredSubnetId")
     *         .selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationProperty.builder()
     *                 .dnsIps(List.of("dnsIps"))
     *                 .domainName("domainName")
     *                 .fileSystemAdministratorsGroup("fileSystemAdministratorsGroup")
     *                 .organizationalUnitDistinguishedName("organizationalUnitDistinguishedName")
     *                 .password("password")
     *                 .userName("userName")
     *                 .build())
     *         .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.WindowsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WindowsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WindowsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets the throughput capacity of an Amazon FSx file system, measured in megabytes per second (MB/s), in 2 to the <em>n</em> th increments, between 2^3 (8) and 2^11 (2048).
         * <p>
         * <blockquote>
         * <p>
         * To increase storage capacity, a file system must have a minimum throughput capacity of 16 MB/s.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-throughputcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-throughputcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThroughputCapacity();

        /**
         * The ID for an existing AWS Managed Microsoft Active Directory (AD) instance that the file system should join when it's created.
         * <p>
         * Required if you are joining the file system to an existing AWS Managed Microsoft AD.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-activedirectoryid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-activedirectoryid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActiveDirectoryId() {
            return null;
        }

        /**
         * An array of one or more DNS alias names that you want to associate with the Amazon FSx file system.
         * <p>
         * Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system. You can associate up to 50 aliases with a file system at any time.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a> and <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">Walkthrough 5: Using DNS aliases to access your file system</a> , including additional steps you must take to be able to access your file system using a DNS alias.
         * <p>
         * An alias name has to meet the following requirements:
         * <p>
         * <ul>
         * <li>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code> , for example, <code>accounting.example.com</code> .</li>
         * <li>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</li>
         * <li>Cannot start or end with a hyphen.</li>
         * <li>Can start with a numeric.</li>
         * </ul>
         * <p>
         * For DNS alias names, Amazon FSx stores alphabetical characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-aliases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-aliases</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliases() {
            return null;
        }

        /**
         * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-auditlogconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-auditlogconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuditLogConfiguration() {
            return null;
        }

        /**
         * The number of days to retain automatic backups.
         * <p>
         * Setting this property to <code>0</code> disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is <code>30</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-automaticbackupretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-automaticbackupretentiondays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticBackupRetentionDays() {
            return null;
        }

        /**
         * A boolean flag indicating whether tags for the file system should be copied to backups.
         * <p>
         * This value defaults to false. If it's set to true, all tags for the file system are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-copytagstobackups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-copytagstobackups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToBackups() {
            return null;
        }

        /**
         * A recurring daily time, in the format <code>HH:MM</code> .
         * <p>
         * <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. For example, <code>05:00</code> specifies 5 AM daily.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-dailyautomaticbackupstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-dailyautomaticbackupstarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDailyAutomaticBackupStartTime() {
            return null;
        }

        /**
         * Specifies the file system deployment type, valid values are the following:.
         * <p>
         * <ul>
         * <li><code>MULTI_AZ_1</code> - Deploys a high availability file system that is configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in AWS Regions that have a minimum of three Availability Zones. Also supports HDD storage type</li>
         * <li><code>SINGLE_AZ_1</code> - (Default) Choose to deploy a file system that is configured for single AZ redundancy.</li>
         * <li><code>SINGLE_AZ_2</code> - The latest generation Single AZ file system. Specifies a file system that is configured for single AZ redundancy and supports HDD storage type.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Availability and Durability: Single-AZ and Multi-AZ File Systems</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-deploymenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-deploymenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentType() {
            return null;
        }

        /**
         * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for Windows file system.
         * <p>
         * By default, Amazon FSx automatically provisions 3 IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of storage, up to the maximum limit associated with your chosen throughput capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-diskiopsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-diskiopsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDiskIopsConfiguration() {
            return null;
        }

        /**
         * Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code> .
         * <p>
         * This specifies the subnet in which you want the preferred file server to be located. For in- AWS applications, we recommend that you launch your clients in the same availability zone as your preferred file server to reduce cross-availability zone data transfer costs and minimize latency.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-preferredsubnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-preferredsubnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreferredSubnetId() {
            return null;
        }

        /**
         * The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an FSx for ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">Using Amazon FSx for Windows with your self-managed Microsoft Active Directory</a> or <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP SVMs</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedActiveDirectoryConfiguration() {
            return null;
        }

        /**
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-weeklymaintenancestarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-weeklymaintenancestarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWeeklyMaintenanceStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WindowsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WindowsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WindowsConfigurationProperty> {
            java.lang.Number throughputCapacity;
            java.lang.String activeDirectoryId;
            java.util.List<java.lang.String> aliases;
            java.lang.Object auditLogConfiguration;
            java.lang.Number automaticBackupRetentionDays;
            java.lang.Object copyTagsToBackups;
            java.lang.String dailyAutomaticBackupStartTime;
            java.lang.String deploymentType;
            java.lang.Object diskIopsConfiguration;
            java.lang.String preferredSubnetId;
            java.lang.Object selfManagedActiveDirectoryConfiguration;
            java.lang.String weeklyMaintenanceStartTime;

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getThroughputCapacity}
             * @param throughputCapacity Sets the throughput capacity of an Amazon FSx file system, measured in megabytes per second (MB/s), in 2 to the <em>n</em> th increments, between 2^3 (8) and 2^11 (2048). This parameter is required.
             *                           <blockquote>
             *                           <p>
             *                           To increase storage capacity, a file system must have a minimum throughput capacity of 16 MB/s.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughputCapacity(java.lang.Number throughputCapacity) {
                this.throughputCapacity = throughputCapacity;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getActiveDirectoryId}
             * @param activeDirectoryId The ID for an existing AWS Managed Microsoft Active Directory (AD) instance that the file system should join when it's created.
             *                          Required if you are joining the file system to an existing AWS Managed Microsoft AD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeDirectoryId(java.lang.String activeDirectoryId) {
                this.activeDirectoryId = activeDirectoryId;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getAliases}
             * @param aliases An array of one or more DNS alias names that you want to associate with the Amazon FSx file system.
             *                Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system. You can associate up to 50 aliases with a file system at any time.
             *                <p>
             *                For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a> and <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">Walkthrough 5: Using DNS aliases to access your file system</a> , including additional steps you must take to be able to access your file system using a DNS alias.
             *                <p>
             *                An alias name has to meet the following requirements:
             *                <p>
             *                <ul>
             *                <li>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code> , for example, <code>accounting.example.com</code> .</li>
             *                <li>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</li>
             *                <li>Cannot start or end with a hyphen.</li>
             *                <li>Can start with a numeric.</li>
             *                </ul>
             *                <p>
             *                For DNS alias names, Amazon FSx stores alphabetical characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aliases(java.util.List<java.lang.String> aliases) {
                this.aliases = aliases;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getAuditLogConfiguration}
             * @param auditLogConfiguration The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auditLogConfiguration(software.amazon.awscdk.IResolvable auditLogConfiguration) {
                this.auditLogConfiguration = auditLogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getAuditLogConfiguration}
             * @param auditLogConfiguration The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auditLogConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.AuditLogConfigurationProperty auditLogConfiguration) {
                this.auditLogConfiguration = auditLogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getAutomaticBackupRetentionDays}
             * @param automaticBackupRetentionDays The number of days to retain automatic backups.
             *                                     Setting this property to <code>0</code> disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is <code>30</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticBackupRetentionDays(java.lang.Number automaticBackupRetentionDays) {
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups A boolean flag indicating whether tags for the file system should be copied to backups.
             *                          This value defaults to false. If it's set to true, all tags for the file system are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(java.lang.Boolean copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups A boolean flag indicating whether tags for the file system should be copied to backups.
             *                          This value defaults to false. If it's set to true, all tags for the file system are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(software.amazon.awscdk.IResolvable copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getDailyAutomaticBackupStartTime}
             * @param dailyAutomaticBackupStartTime A recurring daily time, in the format <code>HH:MM</code> .
             *                                      <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. For example, <code>05:00</code> specifies 5 AM daily.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyAutomaticBackupStartTime(java.lang.String dailyAutomaticBackupStartTime) {
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getDeploymentType}
             * @param deploymentType Specifies the file system deployment type, valid values are the following:.
             *                       <ul>
             *                       <li><code>MULTI_AZ_1</code> - Deploys a high availability file system that is configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in AWS Regions that have a minimum of three Availability Zones. Also supports HDD storage type</li>
             *                       <li><code>SINGLE_AZ_1</code> - (Default) Choose to deploy a file system that is configured for single AZ redundancy.</li>
             *                       <li><code>SINGLE_AZ_2</code> - The latest generation Single AZ file system. Specifies a file system that is configured for single AZ redundancy and supports HDD storage type.</li>
             *                       </ul>
             *                       <p>
             *                       For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Availability and Durability: Single-AZ and Multi-AZ File Systems</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentType(java.lang.String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getDiskIopsConfiguration}
             * @param diskIopsConfiguration The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for Windows file system.
             *                              By default, Amazon FSx automatically provisions 3 IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of storage, up to the maximum limit associated with your chosen throughput capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder diskIopsConfiguration(software.amazon.awscdk.IResolvable diskIopsConfiguration) {
                this.diskIopsConfiguration = diskIopsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getDiskIopsConfiguration}
             * @param diskIopsConfiguration The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for Windows file system.
             *                              By default, Amazon FSx automatically provisions 3 IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of storage, up to the maximum limit associated with your chosen throughput capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder diskIopsConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.DiskIopsConfigurationProperty diskIopsConfiguration) {
                this.diskIopsConfiguration = diskIopsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getPreferredSubnetId}
             * @param preferredSubnetId Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code> .
             *                          This specifies the subnet in which you want the preferred file server to be located. For in- AWS applications, we recommend that you launch your clients in the same availability zone as your preferred file server to reduce cross-availability zone data transfer costs and minimize latency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredSubnetId(java.lang.String preferredSubnetId) {
                this.preferredSubnetId = preferredSubnetId;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getSelfManagedActiveDirectoryConfiguration}
             * @param selfManagedActiveDirectoryConfiguration The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an FSx for ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory.
             *                                                For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">Using Amazon FSx for Windows with your self-managed Microsoft Active Directory</a> or <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP SVMs</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedActiveDirectoryConfiguration(software.amazon.awscdk.IResolvable selfManagedActiveDirectoryConfiguration) {
                this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getSelfManagedActiveDirectoryConfiguration}
             * @param selfManagedActiveDirectoryConfiguration The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an FSx for ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory.
             *                                                For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">Using Amazon FSx for Windows with your self-managed Microsoft Active Directory</a> or <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP SVMs</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedActiveDirectoryConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty selfManagedActiveDirectoryConfiguration) {
                this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getWeeklyMaintenanceStartTime}
             * @param weeklyMaintenanceStartTime The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeklyMaintenanceStartTime(java.lang.String weeklyMaintenanceStartTime) {
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WindowsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WindowsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WindowsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WindowsConfigurationProperty {
            private final java.lang.Number throughputCapacity;
            private final java.lang.String activeDirectoryId;
            private final java.util.List<java.lang.String> aliases;
            private final java.lang.Object auditLogConfiguration;
            private final java.lang.Number automaticBackupRetentionDays;
            private final java.lang.Object copyTagsToBackups;
            private final java.lang.String dailyAutomaticBackupStartTime;
            private final java.lang.String deploymentType;
            private final java.lang.Object diskIopsConfiguration;
            private final java.lang.String preferredSubnetId;
            private final java.lang.Object selfManagedActiveDirectoryConfiguration;
            private final java.lang.String weeklyMaintenanceStartTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.throughputCapacity = software.amazon.jsii.Kernel.get(this, "throughputCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.activeDirectoryId = software.amazon.jsii.Kernel.get(this, "activeDirectoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.aliases = software.amazon.jsii.Kernel.get(this, "aliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.auditLogConfiguration = software.amazon.jsii.Kernel.get(this, "auditLogConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.automaticBackupRetentionDays = software.amazon.jsii.Kernel.get(this, "automaticBackupRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.copyTagsToBackups = software.amazon.jsii.Kernel.get(this, "copyTagsToBackups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dailyAutomaticBackupStartTime = software.amazon.jsii.Kernel.get(this, "dailyAutomaticBackupStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deploymentType = software.amazon.jsii.Kernel.get(this, "deploymentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.diskIopsConfiguration = software.amazon.jsii.Kernel.get(this, "diskIopsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preferredSubnetId = software.amazon.jsii.Kernel.get(this, "preferredSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selfManagedActiveDirectoryConfiguration = software.amazon.jsii.Kernel.get(this, "selfManagedActiveDirectoryConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.weeklyMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.throughputCapacity = java.util.Objects.requireNonNull(builder.throughputCapacity, "throughputCapacity is required");
                this.activeDirectoryId = builder.activeDirectoryId;
                this.aliases = builder.aliases;
                this.auditLogConfiguration = builder.auditLogConfiguration;
                this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
                this.copyTagsToBackups = builder.copyTagsToBackups;
                this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
                this.deploymentType = builder.deploymentType;
                this.diskIopsConfiguration = builder.diskIopsConfiguration;
                this.preferredSubnetId = builder.preferredSubnetId;
                this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
                this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
            }

            @Override
            public final java.lang.Number getThroughputCapacity() {
                return this.throughputCapacity;
            }

            @Override
            public final java.lang.String getActiveDirectoryId() {
                return this.activeDirectoryId;
            }

            @Override
            public final java.util.List<java.lang.String> getAliases() {
                return this.aliases;
            }

            @Override
            public final java.lang.Object getAuditLogConfiguration() {
                return this.auditLogConfiguration;
            }

            @Override
            public final java.lang.Number getAutomaticBackupRetentionDays() {
                return this.automaticBackupRetentionDays;
            }

            @Override
            public final java.lang.Object getCopyTagsToBackups() {
                return this.copyTagsToBackups;
            }

            @Override
            public final java.lang.String getDailyAutomaticBackupStartTime() {
                return this.dailyAutomaticBackupStartTime;
            }

            @Override
            public final java.lang.String getDeploymentType() {
                return this.deploymentType;
            }

            @Override
            public final java.lang.Object getDiskIopsConfiguration() {
                return this.diskIopsConfiguration;
            }

            @Override
            public final java.lang.String getPreferredSubnetId() {
                return this.preferredSubnetId;
            }

            @Override
            public final java.lang.Object getSelfManagedActiveDirectoryConfiguration() {
                return this.selfManagedActiveDirectoryConfiguration;
            }

            @Override
            public final java.lang.String getWeeklyMaintenanceStartTime() {
                return this.weeklyMaintenanceStartTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("throughputCapacity", om.valueToTree(this.getThroughputCapacity()));
                if (this.getActiveDirectoryId() != null) {
                    data.set("activeDirectoryId", om.valueToTree(this.getActiveDirectoryId()));
                }
                if (this.getAliases() != null) {
                    data.set("aliases", om.valueToTree(this.getAliases()));
                }
                if (this.getAuditLogConfiguration() != null) {
                    data.set("auditLogConfiguration", om.valueToTree(this.getAuditLogConfiguration()));
                }
                if (this.getAutomaticBackupRetentionDays() != null) {
                    data.set("automaticBackupRetentionDays", om.valueToTree(this.getAutomaticBackupRetentionDays()));
                }
                if (this.getCopyTagsToBackups() != null) {
                    data.set("copyTagsToBackups", om.valueToTree(this.getCopyTagsToBackups()));
                }
                if (this.getDailyAutomaticBackupStartTime() != null) {
                    data.set("dailyAutomaticBackupStartTime", om.valueToTree(this.getDailyAutomaticBackupStartTime()));
                }
                if (this.getDeploymentType() != null) {
                    data.set("deploymentType", om.valueToTree(this.getDeploymentType()));
                }
                if (this.getDiskIopsConfiguration() != null) {
                    data.set("diskIopsConfiguration", om.valueToTree(this.getDiskIopsConfiguration()));
                }
                if (this.getPreferredSubnetId() != null) {
                    data.set("preferredSubnetId", om.valueToTree(this.getPreferredSubnetId()));
                }
                if (this.getSelfManagedActiveDirectoryConfiguration() != null) {
                    data.set("selfManagedActiveDirectoryConfiguration", om.valueToTree(this.getSelfManagedActiveDirectoryConfiguration()));
                }
                if (this.getWeeklyMaintenanceStartTime() != null) {
                    data.set("weeklyMaintenanceStartTime", om.valueToTree(this.getWeeklyMaintenanceStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.WindowsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WindowsConfigurationProperty.Jsii$Proxy that = (WindowsConfigurationProperty.Jsii$Proxy) o;

                if (!throughputCapacity.equals(that.throughputCapacity)) return false;
                if (this.activeDirectoryId != null ? !this.activeDirectoryId.equals(that.activeDirectoryId) : that.activeDirectoryId != null) return false;
                if (this.aliases != null ? !this.aliases.equals(that.aliases) : that.aliases != null) return false;
                if (this.auditLogConfiguration != null ? !this.auditLogConfiguration.equals(that.auditLogConfiguration) : that.auditLogConfiguration != null) return false;
                if (this.automaticBackupRetentionDays != null ? !this.automaticBackupRetentionDays.equals(that.automaticBackupRetentionDays) : that.automaticBackupRetentionDays != null) return false;
                if (this.copyTagsToBackups != null ? !this.copyTagsToBackups.equals(that.copyTagsToBackups) : that.copyTagsToBackups != null) return false;
                if (this.dailyAutomaticBackupStartTime != null ? !this.dailyAutomaticBackupStartTime.equals(that.dailyAutomaticBackupStartTime) : that.dailyAutomaticBackupStartTime != null) return false;
                if (this.deploymentType != null ? !this.deploymentType.equals(that.deploymentType) : that.deploymentType != null) return false;
                if (this.diskIopsConfiguration != null ? !this.diskIopsConfiguration.equals(that.diskIopsConfiguration) : that.diskIopsConfiguration != null) return false;
                if (this.preferredSubnetId != null ? !this.preferredSubnetId.equals(that.preferredSubnetId) : that.preferredSubnetId != null) return false;
                if (this.selfManagedActiveDirectoryConfiguration != null ? !this.selfManagedActiveDirectoryConfiguration.equals(that.selfManagedActiveDirectoryConfiguration) : that.selfManagedActiveDirectoryConfiguration != null) return false;
                return this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.equals(that.weeklyMaintenanceStartTime) : that.weeklyMaintenanceStartTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.throughputCapacity.hashCode();
                result = 31 * result + (this.activeDirectoryId != null ? this.activeDirectoryId.hashCode() : 0);
                result = 31 * result + (this.aliases != null ? this.aliases.hashCode() : 0);
                result = 31 * result + (this.auditLogConfiguration != null ? this.auditLogConfiguration.hashCode() : 0);
                result = 31 * result + (this.automaticBackupRetentionDays != null ? this.automaticBackupRetentionDays.hashCode() : 0);
                result = 31 * result + (this.copyTagsToBackups != null ? this.copyTagsToBackups.hashCode() : 0);
                result = 31 * result + (this.dailyAutomaticBackupStartTime != null ? this.dailyAutomaticBackupStartTime.hashCode() : 0);
                result = 31 * result + (this.deploymentType != null ? this.deploymentType.hashCode() : 0);
                result = 31 * result + (this.diskIopsConfiguration != null ? this.diskIopsConfiguration.hashCode() : 0);
                result = 31 * result + (this.preferredSubnetId != null ? this.preferredSubnetId.hashCode() : 0);
                result = 31 * result + (this.selfManagedActiveDirectoryConfiguration != null ? this.selfManagedActiveDirectoryConfiguration.hashCode() : 0);
                result = 31 * result + (this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.CfnFileSystem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.CfnFileSystem> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fsx.CfnFileSystemProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fsx.CfnFileSystemProps.Builder();
        }

        /**
         * The type of Amazon FSx file system, which can be <code>LUSTRE</code> , <code>WINDOWS</code> , <code>ONTAP</code> , or <code>OPENZFS</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype</a>
         * @param fileSystemType The type of Amazon FSx file system, which can be <code>LUSTRE</code> , <code>WINDOWS</code> , <code>ONTAP</code> , or <code>OPENZFS</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemType(final java.lang.String fileSystemType) {
            this.props.fileSystemType(fileSystemType);
            return this;
        }

        /**
         * Specifies the IDs of the subnets that the file system will be accessible from.
         * <p>
         * For Windows and ONTAP <code>MULTI_AZ_1</code> deployment types,provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> or <code>OntapConfiguration &gt; PreferredSubnetID</code> properties. For more information about Multi-AZ file system configuration, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Availability and durability: Single-AZ and Multi-AZ file systems</a> in the <em>Amazon FSx for Windows User Guide</em> and <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html">Availability and durability</a> in the <em>Amazon FSx for ONTAP User Guide</em> .
         * <p>
         * For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> and all Lustre deployment types, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids</a>
         * @param subnetIds Specifies the IDs of the subnets that the file system will be accessible from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(final java.util.List<java.lang.String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        /**
         * The ID of the file system backup that you are using to create a file system.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemFromBackup.html">CreateFileSystemFromBackup</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid</a>
         * @param backupId The ID of the file system backup that you are using to create a file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(final java.lang.String backupId) {
            this.props.backupId(backupId);
            return this;
        }

        /**
         * For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating.
         * <p>
         * Valid values are <code>2.10</code> , <code>2.12</code> , and <code>2.15</code> :
         * <p>
         * <ul>
         * <li><code>2.10</code> is supported by the Scratch and Persistent_1 Lustre deployment types.</li>
         * <li><code>2.12</code> is supported by all Lustre deployment types, except for <code>PERSISTENT_2</code> with a metadata configuration mode.</li>
         * <li><code>2.15</code> is supported by all Lustre deployment types and is recommended for all new file systems.</li>
         * </ul>
         * <p>
         * Default value is <code>2.10</code> , except for the following deployments:
         * <p>
         * <ul>
         * <li>Default value is <code>2.12</code> when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code> without a metadata configuration mode.</li>
         * <li>Default value is <code>2.15</code> when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code> with a metadata configuration mode.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtypeversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtypeversion</a>
         * @param fileSystemTypeVersion For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemTypeVersion(final java.lang.String fileSystemTypeVersion) {
            this.props.fileSystemTypeVersion(fileSystemTypeVersion);
            return this;
        }

        /**
         * The ID of the AWS Key Management Service ( AWS KMS ) key used to encrypt Amazon FSx file system data.
         * <p>
         * Used as follows with Amazon FSx file system types:
         * <p>
         * <ul>
         * <li>Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment types only.</li>
         * </ul>
         * <p>
         * <code>SCRATCH_1</code> and <code>SCRATCH_2</code> types are encrypted using the Amazon FSx service AWS KMS key for your account.
         * <p>
         * <ul>
         * <li>Amazon FSx for NetApp ONTAP</li>
         * <li>Amazon FSx for OpenZFS</li>
         * <li>Amazon FSx for Windows File Server</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid</a>
         * @param kmsKeyId The ID of the AWS Key Management Service ( AWS KMS ) key used to encrypt Amazon FSx file system data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The Lustre configuration for the file system being created.
         * <p>
         * <blockquote>
         * <p>
         * The following parameters are not supported when creating Lustre file systems with a data repository association.
         * <p>
         * <ul>
         * <li><code>AutoImportPolicy</code></li>
         * <li><code>ExportPath</code></li>
         * <li><code>ImportedChunkSize</code></li>
         * <li><code>ImportPath</code></li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration</a>
         * @param lustreConfiguration The Lustre configuration for the file system being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lustreConfiguration(final software.amazon.awscdk.IResolvable lustreConfiguration) {
            this.props.lustreConfiguration(lustreConfiguration);
            return this;
        }
        /**
         * The Lustre configuration for the file system being created.
         * <p>
         * <blockquote>
         * <p>
         * The following parameters are not supported when creating Lustre file systems with a data repository association.
         * <p>
         * <ul>
         * <li><code>AutoImportPolicy</code></li>
         * <li><code>ExportPath</code></li>
         * <li><code>ImportedChunkSize</code></li>
         * <li><code>ImportPath</code></li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration</a>
         * @param lustreConfiguration The Lustre configuration for the file system being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lustreConfiguration(final software.amazon.awscdk.services.fsx.CfnFileSystem.LustreConfigurationProperty lustreConfiguration) {
            this.props.lustreConfiguration(lustreConfiguration);
            return this;
        }

        /**
         * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-ontapconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-ontapconfiguration</a>
         * @param ontapConfiguration The ONTAP configuration properties of the FSx for ONTAP file system that you are creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(final software.amazon.awscdk.IResolvable ontapConfiguration) {
            this.props.ontapConfiguration(ontapConfiguration);
            return this;
        }
        /**
         * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-ontapconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-ontapconfiguration</a>
         * @param ontapConfiguration The ONTAP configuration properties of the FSx for ONTAP file system that you are creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(final software.amazon.awscdk.services.fsx.CfnFileSystem.OntapConfigurationProperty ontapConfiguration) {
            this.props.ontapConfiguration(ontapConfiguration);
            return this;
        }

        /**
         * The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-openzfsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-openzfsconfiguration</a>
         * @param openZfsConfiguration The Amazon FSx for OpenZFS configuration properties for the file system that you are creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(final software.amazon.awscdk.IResolvable openZfsConfiguration) {
            this.props.openZfsConfiguration(openZfsConfiguration);
            return this;
        }
        /**
         * The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-openzfsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-openzfsconfiguration</a>
         * @param openZfsConfiguration The Amazon FSx for OpenZFS configuration properties for the file system that you are creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(final software.amazon.awscdk.services.fsx.CfnFileSystem.OpenZFSConfigurationProperty openZfsConfiguration) {
            this.props.openZfsConfiguration(openZfsConfiguration);
            return this;
        }

        /**
         * A list of IDs specifying the security groups to apply to all network interfaces created for file system access.
         * <p>
         * This list isn't returned in later requests to describe the file system.
         * <p>
         * <blockquote>
         * <p>
         * You must specify a security group if you are creating a Multi-AZ FSx for ONTAP file system in a VPC subnet that has been shared with you.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids</a>
         * @param securityGroupIds A list of IDs specifying the security groups to apply to all network interfaces created for file system access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * Sets the storage capacity of the file system that you're creating.
         * <p>
         * <code>StorageCapacity</code> is required if you are creating a new file system. It is not required if you are creating a file system by restoring a backup.
         * <p>
         * <em>FSx for Lustre file systems</em> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> and the Lustre <code>DeploymentType</code> , as follows:
         * <p>
         * <ul>
         * <li>For <code>SCRATCH_2</code> , <code>PERSISTENT_2</code> and <code>PERSISTENT_1</code> deployment types using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.</li>
         * <li>For <code>PERSISTENT_1</code> HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</li>
         * <li>For <code>SCRATCH_1</code> deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.</li>
         * </ul>
         * <p>
         * <em>FSx for ONTAP file systems</em> - The amount of SSD storage capacity that you can configure depends on the value of the <code>HAPairs</code> property. The minimum value is calculated as 1,024 GiB * HAPairs and the maximum is calculated as 524,288 GiB * HAPairs, up to a maximum amount of SSD storage capacity of 1,048,576 GiB (1 pebibyte).
         * <p>
         * <em>FSx for OpenZFS file systems</em> - The amount of storage capacity that you can configure is from 64 GiB up to 524,288 GiB (512 TiB). If you are creating a file system from a backup, you can specify a storage capacity equal to or greater than the original file system's storage capacity.
         * <p>
         * <em>FSx for Windows File Server file systems</em> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> as follows:
         * <p>
         * <ul>
         * <li>For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).</li>
         * <li>For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity</a>
         * @param storageCapacity Sets the storage capacity of the file system that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCapacity(final java.lang.Number storageCapacity) {
            this.props.storageCapacity(storageCapacity);
            return this;
        }

        /**
         * Sets the storage class for the file system that you're creating.
         * <p>
         * Valid values are <code>SSD</code> , <code>HDD</code> , and <code>INTELLIGENT_TIERING</code> .
         * <p>
         * <ul>
         * <li>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows, Lustre, ONTAP, and OpenZFS deployment types.</li>
         * <li>Set to <code>HDD</code> to use hard disk drive storage, which is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types, and on <code>PERSISTENT_1</code> Lustre file system deployment types.</li>
         * <li>Set to <code>INTELLIGENT_TIERING</code> to use fully elastic, intelligently-tiered storage. Intelligent-Tiering is only available for OpenZFS file systems with the Multi-AZ deployment type and for Lustre file systems with the Persistent_2 deployment type.</li>
         * </ul>
         * <p>
         * Default value is <code>SSD</code> . For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options">Storage type options</a> in the <em>FSx for Windows File Server User Guide</em> , <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-fsx-lustre.html#lustre-storage-classes">FSx for Lustre storage classes</a> in the <em>FSx for Lustre User Guide</em> , and <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance-intelligent-tiering">Working with Intelligent-Tiering</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype</a>
         * @param storageType Sets the storage class for the file system that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final java.lang.String storageType) {
            this.props.storageType(storageType);
            return this;
        }

        /**
         * The tags to associate with the file system.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/tag-resources.html">Tagging your Amazon FSx resources</a> in the <em>Amazon FSx for Lustre User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags</a>
         * @param tags The tags to associate with the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The configuration object for the Microsoft Windows file system you are creating.
         * <p>
         * This value is required if <code>FileSystemType</code> is set to <code>WINDOWS</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration</a>
         * @param windowsConfiguration The configuration object for the Microsoft Windows file system you are creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windowsConfiguration(final software.amazon.awscdk.IResolvable windowsConfiguration) {
            this.props.windowsConfiguration(windowsConfiguration);
            return this;
        }
        /**
         * The configuration object for the Microsoft Windows file system you are creating.
         * <p>
         * This value is required if <code>FileSystemType</code> is set to <code>WINDOWS</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration</a>
         * @param windowsConfiguration The configuration object for the Microsoft Windows file system you are creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windowsConfiguration(final software.amazon.awscdk.services.fsx.CfnFileSystem.WindowsConfigurationProperty windowsConfiguration) {
            this.props.windowsConfiguration(windowsConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.fsx.CfnFileSystem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.CfnFileSystem build() {
            return new software.amazon.awscdk.services.fsx.CfnFileSystem(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
