package software.amazon.awscdk.services.fsx;

/**
 * The Lustre version for the file system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LustreFileSystem fileSystem = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .lustreConfiguration(LustreConfiguration.builder().deploymentType(LustreDeploymentType.SCRATCH_2).build())
 *         .storageCapacityGiB(1200)
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .fileSystemTypeVersion(FileSystemTypeVersion.V_2_15)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:07.777Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.FileSystemTypeVersion")
public enum FileSystemTypeVersion {
    /**
     * Version 2.10.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V_2_10,
    /**
     * Version 2.12.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V_2_12,
    /**
     * Version 2.15.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V_2_15,
}
